/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.planner.physical.collector;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprDateValue;
import org.opensearch.sql.data.model.ExprDatetimeValue;
import org.opensearch.sql.data.model.ExprTimeValue;
import org.opensearch.sql.data.model.ExprTimestampValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.exception.ExpressionEvaluationException;
import org.opensearch.sql.expression.span.SpanExpression;
import org.opensearch.sql.utils.DateTimeUtils;

public abstract class Rounding<T> {
    public static Rounding<?> createRounding(SpanExpression span) {
        ExprValue interval = span.getValue().valueOf();
        ExprType type = span.type();
        if (ExprCoreType.LONG.isCompatible(type)) {
            return new LongRounding(interval);
        }
        if (ExprCoreType.DOUBLE.isCompatible(type)) {
            return new DoubleRounding(interval);
        }
        if (type.equals(ExprCoreType.DATETIME)) {
            return new DatetimeRounding(interval, span.getUnit().getName());
        }
        if (type.equals(ExprCoreType.TIMESTAMP)) {
            return new TimestampRounding(interval, span.getUnit().getName());
        }
        if (type.equals(ExprCoreType.DATE)) {
            return new DateRounding(interval, span.getUnit().getName());
        }
        if (type.equals(ExprCoreType.TIME)) {
            return new TimeRounding(interval, span.getUnit().getName());
        }
        return new UnknownRounding();
    }

    public abstract ExprValue round(ExprValue var1);

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Rounding)) {
            return false;
        }
        Rounding other = (Rounding)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Rounding;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public static enum DateTimeUnit {
        MILLISECOND(1, "ms", true, ChronoField.MILLI_OF_SECOND.getBaseUnit().getDuration().toMillis()){

            @Override
            long round(long utcMillis, int interval) {
                return DateTimeUtils.roundFloor(utcMillis, this.ratio * (long)interval);
            }
        }
        ,
        SECOND(2, "s", true, ChronoField.SECOND_OF_MINUTE.getBaseUnit().getDuration().toMillis()){

            @Override
            long round(long utcMillis, int interval) {
                return DateTimeUtils.roundFloor(utcMillis, this.ratio * (long)interval);
            }
        }
        ,
        MINUTE(3, "m", true, ChronoField.MINUTE_OF_HOUR.getBaseUnit().getDuration().toMillis()){

            @Override
            long round(long utcMillis, int interval) {
                return DateTimeUtils.roundFloor(utcMillis, this.ratio * (long)interval);
            }
        }
        ,
        HOUR(4, "h", true, ChronoField.HOUR_OF_DAY.getBaseUnit().getDuration().toMillis()){

            @Override
            long round(long utcMillis, int interval) {
                return DateTimeUtils.roundFloor(utcMillis, this.ratio * (long)interval);
            }
        }
        ,
        DAY(5, "d", true, ChronoField.DAY_OF_MONTH.getBaseUnit().getDuration().toMillis()){

            @Override
            long round(long utcMillis, int interval) {
                return DateTimeUtils.roundFloor(utcMillis, this.ratio * (long)interval);
            }
        }
        ,
        WEEK(6, "w", true, TimeUnit.DAYS.toMillis(7L)){

            @Override
            long round(long utcMillis, int interval) {
                return DateTimeUtils.roundWeek(utcMillis, interval);
            }
        }
        ,
        MONTH(7, "M", false, 1L){

            @Override
            long round(long utcMillis, int interval) {
                return DateTimeUtils.roundMonth(utcMillis, interval);
            }
        }
        ,
        QUARTER(8, "q", false, 3L){

            @Override
            long round(long utcMillis, int interval) {
                return DateTimeUtils.roundQuarter(utcMillis, interval);
            }
        }
        ,
        YEAR(9, "y", false, 12L){

            @Override
            long round(long utcMillis, int interval) {
                return DateTimeUtils.roundYear(utcMillis, interval);
            }
        };

        private final int id;
        private final String name;
        protected final boolean isMillisBased;
        protected final long ratio;

        abstract long round(long var1, int var3);

        public static DateTimeUnit resolve(String name) {
            switch (name) {
                case "M": {
                    return MONTH;
                }
                case "m": {
                    return MINUTE;
                }
            }
            return Arrays.stream(DateTimeUnit.values()).filter(v -> v.getName().equalsIgnoreCase(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unable to resolve unit " + name));
        }

        @Generated
        private DateTimeUnit(int id, String name, boolean isMillisBased, long ratio) {
            this.id = id;
            this.name = name;
            this.isMillisBased = isMillisBased;
            this.ratio = ratio;
        }

        @Generated
        public int getId() {
            return this.id;
        }

        @Generated
        public String getName() {
            return this.name;
        }
    }

    static class UnknownRounding
    extends Rounding<Object> {
        @Override
        public ExprValue round(ExprValue var) {
            return null;
        }

        @Generated
        public UnknownRounding() {
        }
    }

    static class DoubleRounding
    extends Rounding<Double> {
        private final Double doubleInterval;

        protected DoubleRounding(ExprValue interval) {
            this.doubleInterval = interval.doubleValue();
        }

        @Override
        public ExprValue round(ExprValue value) {
            double rounded = (double)Double.valueOf(value.doubleValue() / this.doubleInterval).intValue() * this.doubleInterval;
            return ExprValueUtils.doubleValue(rounded);
        }
    }

    static class LongRounding
    extends Rounding<Long> {
        private final Long longInterval;

        protected LongRounding(ExprValue interval) {
            this.longInterval = interval.longValue();
        }

        @Override
        public ExprValue round(ExprValue value) {
            long rounded = Math.floorDiv((long)value.longValue(), this.longInterval) * this.longInterval;
            return ExprValueUtils.longValue(rounded);
        }
    }

    static class TimeRounding
    extends Rounding<LocalTime> {
        private final ExprValue interval;
        private final DateTimeUnit dateTimeUnit;

        public TimeRounding(ExprValue interval, String unit) {
            this.interval = interval;
            this.dateTimeUnit = DateTimeUnit.resolve(unit);
        }

        @Override
        public ExprValue round(ExprValue var) {
            if (this.dateTimeUnit.id > 4) {
                throw new ExpressionEvaluationException(String.format("Unable to set span unit %s for TIME type", this.dateTimeUnit.getName()));
            }
            Instant instant = Instant.ofEpochMilli(this.dateTimeUnit.round(var.timeValue().getLong(ChronoField.MILLI_OF_DAY), this.interval.integerValue()));
            return new ExprTimeValue(instant.atZone(ZoneId.of("UTC")).toLocalTime());
        }
    }

    static class DateRounding
    extends Rounding<LocalDate> {
        private final ExprValue interval;
        private final DateTimeUnit dateTimeUnit;

        public DateRounding(ExprValue interval, String unit) {
            this.interval = interval;
            this.dateTimeUnit = DateTimeUnit.resolve(unit);
        }

        @Override
        public ExprValue round(ExprValue var) {
            Instant instant = Instant.ofEpochMilli(this.dateTimeUnit.round(var.dateValue().atStartOfDay().atZone(ZoneId.of("UTC")).toInstant().toEpochMilli(), this.interval.integerValue()));
            return new ExprDateValue(instant.atZone(ZoneId.of("UTC")).toLocalDate());
        }
    }

    static class DatetimeRounding
    extends Rounding<LocalDateTime> {
        private final ExprValue interval;
        private final DateTimeUnit dateTimeUnit;

        public DatetimeRounding(ExprValue interval, String unit) {
            this.interval = interval;
            this.dateTimeUnit = DateTimeUnit.resolve(unit);
        }

        @Override
        public ExprValue round(ExprValue var) {
            Instant instant = Instant.ofEpochMilli(this.dateTimeUnit.round(var.datetimeValue().atZone(ZoneId.of("UTC")).toInstant().toEpochMilli(), this.interval.integerValue()));
            return new ExprDatetimeValue(instant.atZone(ZoneId.of("UTC")).toLocalDateTime());
        }
    }

    static class TimestampRounding
    extends Rounding<Instant> {
        private final ExprValue interval;
        private final DateTimeUnit dateTimeUnit;

        public TimestampRounding(ExprValue interval, String unit) {
            this.interval = interval;
            this.dateTimeUnit = DateTimeUnit.resolve(unit);
        }

        @Override
        public ExprValue round(ExprValue var) {
            Instant instant = Instant.ofEpochMilli(this.dateTimeUnit.round(var.timestampValue().toEpochMilli(), this.interval.integerValue()));
            return new ExprTimestampValue(instant);
        }
    }
}

