/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.plugins.wifi101.flashers;

import cc.arduino.packages.BoardPort;
import cc.arduino.plugins.wifi101.flashers.java.FlasherSerialClient;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JProgressBar;
import org.apache.commons.lang3.StringUtils;
import processing.app.Base;
import processing.app.BaseNoGui;
import processing.app.packages.LibraryList;
import processing.app.packages.UserLibrary;

public class Flasher {
    public String modulename;
    public String version;
    public File file;
    public JProgressBar progressBar;
    public String name;
    public String filename;
    public List<String> compatibleBoards;
    public boolean certavail;
    protected int baudrate;

    public Flasher() {
    }

    public Flasher(String string, String string2, String string3, boolean bl, int n, List<String> list) {
        this.modulename = string;
        this.compatibleBoards = new ArrayList<String>(list);
        this.version = string2;
        this.file = null;
        this.name = "NINA";
        this.certavail = bl;
        this.filename = string3;
        this.baudrate = n;
    }

    public void progress(int n, String string) {
        if (string.length() > 60) {
            string = string.substring(0, 60) + "...";
        }
        this.progressBar.setValue(n);
        this.progressBar.setStringPainted(true);
        this.progressBar.setString(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnection(String string, int n) throws Exception {
        try (FlasherSerialClient flasherSerialClient = null;){
            this.progress(50, "Testing programmer...");
            flasherSerialClient = new FlasherSerialClient();
            flasherSerialClient.open(string, n);
            flasherSerialClient.hello();
            this.progress(100, "Done!");
        }
    }

    public void openFirmwareUpdaterSketch(BoardPort boardPort) throws Exception {
        LibraryList libraryList = BaseNoGui.librariesIndexer.getInstalledLibraries();
        String string = "";
        String string2 = "";
        String string3 = "";
        if (this.modulename.contains("NINA")) {
            string2 = "WiFiNINA";
            string3 = "examples/Tools/FirmwareUpdater/FirmwareUpdater.ino";
        }
        if (this.modulename.contains("WINC")) {
            string2 = "WiFi101";
            string3 = "examples/FirmwareUpdater/FirmwareUpdater.ino";
        }
        for (UserLibrary userLibrary : libraryList) {
            if (!userLibrary.getName().equals(string2)) continue;
            string = userLibrary.getInstalledFolder().getAbsolutePath() + "/" + string3;
        }
        if (string == "") {
            Object object = string2 + "library";
            if (boardPort.getBoardName() != "") {
                object = (String)object + " for " + boardPort.getBoardName();
            }
            object = (String)object + " is not installed.\nUse the library manager to install it.";
            throw new Exception((String)object);
        }
        if (string != "" && boardPort != null) {
            BaseNoGui.selectSerialPort((String)boardPort.getAddress());
            Base.INSTANCE.onBoardOrPortChange();
            Base.INSTANCE.handleOpen(new File(string));
        }
    }

    public void updateFirmware(String string) throws Exception {
    }

    public void uploadCertificates(String string, List<String> list) throws Exception {
    }

    public void setProgressBar(JProgressBar jProgressBar) {
        this.progressBar = jProgressBar;
    }

    public String getName() {
        return this.name;
    }

    public int getBaudrate() {
        return this.baudrate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getData() throws IOException {
        try (FileInputStream fileInputStream = null;){
            int n;
            fileInputStream = new FileInputStream(this.file);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[4096];
            while (((InputStream)fileInputStream).available() > 0 && (n = ((InputStream)fileInputStream).read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setFileName(String string) {
        this.filename = string;
    }

    public boolean isCompatible(String string) {
        if (string == null) {
            return false;
        }
        for (String string2 : this.compatibleBoards) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public boolean certificatesAvailable() {
        return this.certavail;
    }

    public File openFirmwareFile() throws Exception {
        try {
            String string = Flasher.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            File file = new File(string).getParentFile();
            File file2 = new File(file, this.filename);
            return file2;
        }
        catch (URISyntaxException uRISyntaxException) {
            String string = "File not found ";
            throw new Exception(string.concat(this.filename));
        }
    }

    public String toString() {
        String string = this.modulename + " (" + this.version + ") (";
        for (String string2 : this.compatibleBoards) {
            string = string.concat(string2).concat(", ");
        }
        string = string.substring(0, string.length() - 2).concat(")");
        string = StringUtils.abbreviate((String)string, (int)75);
        return string;
    }
}

