"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.assertNever = exports.escapeIdentifierText = exports.syntaxNodeToRange = exports.syntaxNodesToRanges = exports.getStart = void 0;
const types_js_1 = require("../types.js");
const scanner_js_1 = require("../scanner.js");
function getStart(sourceFile, node) {
    return getTokenPosOfNode(sourceFile, node);
}
exports.getStart = getStart;
function getTokenPosOfNode(sourceFile, node) {
    if (nodeIsMissing(node))
        return node.pos;
    return (0, scanner_js_1.skipTrivia)(sourceFile.content, node.pos);
}
function nodeIsMissing(node) {
    return node === undefined
        ? true
        : node.pos === node.end && node.pos >= 0 && node.kind !== types_js_1.SyntaxKind.EndOfFileToken;
}
function syntaxNodesToRanges(doc, sourceFile, nodes) {
    return nodes.map(node => syntaxNodeToRange(doc, sourceFile, node));
}
exports.syntaxNodesToRanges = syntaxNodesToRanges;
function syntaxNodeToRange(doc, sourceFile, node) {
    const start = getStart(sourceFile, node);
    return {
        start: doc.positionAt(start),
        end: doc.positionAt(node.end),
    };
}
exports.syntaxNodeToRange = syntaxNodeToRange;
function escapeIdentifierText(text) {
    if (text === "")
        return quote("");
    if (text.includes("\"") || text.includes("\n")) {
        const esc = text
            .replace(/"/, "\\\"")
            .replace(/\n/, "\\\n");
        return quote(esc);
    }
    const ch = text.charCodeAt(0);
    if (!(0, scanner_js_1.isIdentifierStart)(ch) || text.includes(" "))
        return quote(text);
    return text;
}
exports.escapeIdentifierText = escapeIdentifierText;
const quote = (s) => "\"" + s + "\"";
function assertNever(v) {
    throw new Error("Should not have reached this. Value: " + (v !== null && v !== void 0 ? v : ""));
}
exports.assertNever = assertNever;
//# sourceMappingURL=util.js.map