/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.correlate;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.cmd.Command;
import tim.prune.cmd.CorrelateMediaCmd;
import tim.prune.cmd.MediaLinkType;
import tim.prune.cmd.PointAndMedia;
import tim.prune.config.TimezoneHelper;
import tim.prune.correlate.AudioTimestampSelector;
import tim.prune.correlate.Correlator;
import tim.prune.correlate.MediaPreviewTableModel;
import tim.prune.correlate.MediaPreviewTableRow;
import tim.prune.correlate.PointMediaPair;
import tim.prune.data.AudioClip;
import tim.prune.data.DataPoint;
import tim.prune.data.MediaList;
import tim.prune.data.MediaObject;
import tim.prune.data.TimeDifference;
import tim.prune.data.Timestamp;
import tim.prune.data.TimestampUtc;

public class AudioCorrelator
extends Correlator {
    private AudioTimestampSelector _fileTimesSelector = null;
    private AudioTimestampSelector _correlTimesSelector = null;

    public AudioCorrelator(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.correlateaudios";
    }

    @Override
    protected String getMediaTypeKey() {
        return "audio";
    }

    @Override
    protected MediaList<?> getMediaList() {
        return this._app.getTrackInfo().getAudioList();
    }

    @Override
    protected JPanel makeFirstPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 1));
        this._fileTimesSelector = new AudioTimestampSelector("dialog.correlate.filetimes", "dialog.correlate.filetimes2");
        jPanel2.add(this._fileTimesSelector);
        this._correlTimesSelector = new AudioTimestampSelector("dialog.correlate.correltimes", null);
        jPanel2.add(this._correlTimesSelector);
        jPanel.add(jPanel2);
        return jPanel;
    }

    @Override
    protected boolean[] getCardEnabledFlags() {
        boolean[] blArray = super.getCardEnabledFlags();
        blArray[0] = AudioCorrelator.getAudioLengthAvailability(this._app.getTrackInfo().getAudioList());
        return blArray;
    }

    private static boolean getAudioLengthAvailability(MediaList<AudioClip> mediaList) {
        int n = 0;
        while (n < mediaList.getCount()) {
            AudioClip audioClip = mediaList.get(n);
            if (audioClip.getLengthInSeconds() > 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    protected void createPreview(TimeDifference timeDifference, boolean bl) {
        TimeDifference timeDifference2 = this.parseTimeLimit();
        double d = this.parseDistanceLimit();
        MediaPreviewTableModel mediaPreviewTableModel = new MediaPreviewTableModel("dialog.correlate.select.audioname");
        MediaList<AudioClip> mediaList = this._app.getTrackInfo().getAudioList();
        int n = mediaList.getCount();
        int n2 = 0;
        while (n2 < n) {
            AudioClip audioClip = mediaList.get(n2);
            PointMediaPair pointMediaPair = this.getPointPairForMedia(this._app.getTrackInfo().getTrack(), audioClip, timeDifference);
            MediaPreviewTableRow mediaPreviewTableRow = new MediaPreviewTableRow(pointMediaPair);
            boolean bl2 = pointMediaPair.isValid();
            if (audioClip.getCurrentStatus() != MediaObject.Status.NOT_CONNECTED) {
                bl2 = false;
            }
            if (timeDifference2 != null && bl2) {
                long l = pointMediaPair.getMinSeconds();
                boolean bl3 = bl2 = l <= timeDifference2.getTotalSeconds();
            }
            if (d > 0.0 && bl2) {
                double d2;
                double d3 = DataPoint.calculateRadiansBetween(pointMediaPair.getPointBefore(), pointMediaPair.getPointAfter());
                double d4 = pointMediaPair.getFraction();
                if (d4 > 0.5) {
                    d4 = 1.0 - d4;
                }
                boolean bl4 = bl2 = (d2 = d3 * d4) < d;
            }
            if (pointMediaPair.getSecondsBefore() == 0L && pointMediaPair.getPointBefore().isDuplicate(audioClip.getDataPoint())) {
                bl2 = false;
            }
            mediaPreviewTableRow.setCorrelateFlag(bl2);
            mediaPreviewTableModel.addRow(mediaPreviewTableRow);
            ++n2;
        }
        this._previewTable.setModel(mediaPreviewTableModel);
        mediaPreviewTableModel.setDistanceUnits(this.getSelectedDistanceUnits());
        this._previewTable.setAutoResizeMode(4);
        int[] nArray = new int[]{150, 160, 100, 100, 50};
        int n3 = 0;
        while (n3 < mediaPreviewTableModel.getColumnCount()) {
            this._previewTable.getColumnModel().getColumn(n3).setPreferredWidth(nArray[n3]);
            ++n3;
        }
        this._okButton.setEnabled(mediaPreviewTableModel.hasAnySelected());
        if (bl && !mediaPreviewTableModel.hasAnySelected()) {
            JOptionPane.showMessageDialog(this._dialog, I18nManager.getText("dialog.correlate.alloutsiderange"), this.getName(), 0);
        }
    }

    @Override
    protected Timestamp getMediaTimestamp(MediaObject mediaObject) {
        Timestamp timestamp = super.getMediaTimestamp(mediaObject);
        long l = timestamp.getMilliseconds(TimezoneHelper.getSelectedTimezone());
        try {
            AudioClip audioClip = (AudioClip)mediaObject;
            int n = audioClip.getLengthInSeconds();
            int n2 = n * (this._correlTimesSelector.getSelectedOption() - this._fileTimesSelector.getSelectedOption()) / 2;
            if (n > 0 && n2 != 0) {
                timestamp = new TimestampUtc(l += (long)n2 * 1000L);
            }
        }
        catch (ClassCastException classCastException) {}
        return timestamp;
    }

    @Override
    protected void finishCorrelation() {
        Object object;
        PointMediaPair[] pointMediaPairArray = this.getPointPairs();
        if (pointMediaPairArray == null || pointMediaPairArray.length <= 0) {
            return;
        }
        ArrayList<DataPoint> arrayList = new ArrayList<DataPoint>();
        ArrayList<PointAndMedia> arrayList2 = new ArrayList<PointAndMedia>();
        PointMediaPair[] pointMediaPairArray2 = pointMediaPairArray;
        int n = pointMediaPairArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = pointMediaPairArray2[n2];
            if (object != null && ((PointMediaPair)object).isValid()) {
                Object object2;
                AudioClip audioClip = (AudioClip)((PointMediaPair)object).getMedia();
                if (((PointMediaPair)object).getMinSeconds() == 0L) {
                    DataPoint dataPoint;
                    object2 = ((PointMediaPair)object).getPointBefore().getAudio();
                    if (object2 == null) {
                        dataPoint = ((PointMediaPair)object).getPointBefore();
                        arrayList2.add(new PointAndMedia(dataPoint, null, audioClip));
                    } else if (!((MediaObject)object2).equals(((PointMediaPair)object).getMedia())) {
                        dataPoint = ((PointMediaPair)object).getPointBefore().clonePoint();
                        arrayList.add(dataPoint);
                        arrayList2.add(new PointAndMedia(dataPoint, null, audioClip));
                    }
                } else {
                    object2 = DataPoint.interpolate(((PointMediaPair)object).getPointBefore(), ((PointMediaPair)object).getPointAfter(), ((PointMediaPair)object).getFraction());
                    ((DataPoint)object2).setSegmentStart(true);
                    arrayList.add((DataPoint)object2);
                    arrayList2.add(new PointAndMedia((DataPoint)object2, null, audioClip));
                }
            }
            ++n2;
        }
        object = new CorrelateMediaCmd(MediaLinkType.LINK_AUDIOS, arrayList, arrayList2);
        ((Command)object).setDescription(this.makeUndoText(arrayList2.size()));
        ((Command)object).setConfirmText(this.makeConfirmText(arrayList2.size()));
        this._app.execute((Command)object);
    }
}

