/*******************************************************************************
 * Copyright (c) 2015 - 2020 Intel Corporation.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Intel Corporation - Implementation for Function Call History View
 *******************************************************************************/
package org.eclipse.cdt.dsf.iss.ui.commands;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;

import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.iss.ui.IssGdbUIPlugin;
import org.eclipse.cdt.dsf.iss.ui.fch.FCHUserEvent;
import org.eclipse.cdt.dsf.iss.ui.fch.command.IFastNextFCHRecordHandler;
import org.eclipse.cdt.dsf.iss.ui.fch.command.IFastPrevFCHRecordHandler;
import org.eclipse.cdt.dsf.iss.ui.fch.command.INextFCHRecordHandler;
import org.eclipse.cdt.dsf.iss.ui.fch.command.IPrevFCHRecordHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IRequest;
import org.eclipse.debug.core.commands.AbstractDebugCommand;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IEnabledStateRequest;

public class GdbFCHNavigateCommand extends AbstractDebugCommand implements
        IPrevFCHRecordHandler, INextFCHRecordHandler,
        IFastPrevFCHRecordHandler, IFastNextFCHRecordHandler {

    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fTracker;
    private final DsfSession fSession;

    private List<DebugEvent> eventList;

    public GdbFCHNavigateCommand(DsfSession session) {
        fExecutor = session.getExecutor();
        fTracker = new DsfServicesTracker(IssGdbUIPlugin.getBundleContext(),
                session.getId());
        fSession = session;
        eventList = new LinkedList<DebugEvent>();
        try {
            fExecutor.execute(new DsfRunnable() {
                @Override
                public void run() {
                    fSession.addServiceEventListener(
                            GdbFCHNavigateCommand.this, null);
                }
            });
        } catch (RejectedExecutionException e) {
        }
    }

    public void dispose() {
        try {
            fExecutor.execute(new DsfRunnable() {
                @Override
                public void run() {
                    fSession.removeServiceEventListener(GdbFCHNavigateCommand.this);
                }
            });
        } catch (RejectedExecutionException e) {
            // Session already gone.
        }
        fTracker.dispose();
    }

    @Override
    protected void doExecute(Object[] targets, IProgressMonitor monitor,
            IRequest request) throws CoreException {
        for (int i = 0; i < eventList.size(); i++) {
            DebugPlugin.getDefault().fireDebugEventSet(
                    new DebugEvent[] { eventList.get(i) });
        }
        eventList.clear();
    }

    @Override
    protected boolean isExecutable(Object[] targets, IProgressMonitor monitor,
            IEnabledStateRequest request) throws CoreException {
        // TODO Auto-generated method stub
        return true;
    }

    @Override
    protected Object getTarget(Object element) {
        return element;
    }

    @Override
    public void triggerShowPrevEvent() {
        Object temp = new Object();
        DebugEvent event = new DebugEvent(temp,
                (DebugEvent.MODEL_SPECIFIC | FCHUserEvent.COLLAPSE));
        eventList.add(event);

        Object temp2 = new Object();
        DebugEvent event2 = new DebugEvent(temp2,
                (DebugEvent.MODEL_SPECIFIC | FCHUserEvent.SHOWPREV));
        eventList.add(event2);

    }

    @Override
    public void triggerShowNextEvent() {
        Object temp = new Object();
        DebugEvent event = new DebugEvent(temp,
                (DebugEvent.MODEL_SPECIFIC | FCHUserEvent.COLLAPSE));
        eventList.add(event);

        Object temp2 = new Object();
        DebugEvent event2 = new DebugEvent(temp2,
                (DebugEvent.MODEL_SPECIFIC | FCHUserEvent.SHOWNEXT));
        eventList.add(event2);
    }

    @Override
    public void triggerShowFastPrevEvent() {
        Object temp = new Object();
        DebugEvent event = new DebugEvent(temp,
                (DebugEvent.MODEL_SPECIFIC | FCHUserEvent.COLLAPSE));
        eventList.add(event);

        Object temp2 = new Object();
        DebugEvent event2 = new DebugEvent(temp2,
                (DebugEvent.MODEL_SPECIFIC | FCHUserEvent.SHOWFASTPREV));
        eventList.add(event2);

    }

    @Override
    public void triggerShowFastNextEvent() {
        Object temp = new Object();
        DebugEvent event = new DebugEvent(temp,
                (DebugEvent.MODEL_SPECIFIC | FCHUserEvent.COLLAPSE));
        eventList.add(event);

        Object temp2 = new Object();
        DebugEvent event2 = new DebugEvent(temp2,
                (DebugEvent.MODEL_SPECIFIC | FCHUserEvent.SHOWFASTNEXT));
        eventList.add(event2);
    }

    @Override
    protected boolean isRemainEnabled(IDebugCommandRequest request) {
        return true;
    }

}
