/*******************************************************************************
 * Copyright (c) 2015 - 2020 Intel Corporation.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Intel Corporation - Implementation for Function Call History View
 *******************************************************************************/
package org.eclipse.cdt.dsf.iss.ui.viewmodel.launch;

import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMAdapter;
import org.eclipse.cdt.dsf.ui.viewmodel.IRootVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.RootDMVMNode;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;

@SuppressWarnings("restriction")
public class FCHVMProvider extends AbstractDMVMProvider implements
        IDebugEventSetListener {

    public FCHVMProvider(AbstractVMAdapter adapter,
            IPresentationContext presentationContext, DsfSession session) {
        super(adapter, presentationContext, session);

        IRootVMNode launchNode = new RootDMVMNode(this);
        setRootNode(launchNode);

        IVMNode functionRecordNode = new FunctionRecordVMNode(this,
                getSession());
        addChildNodes(launchNode, new IVMNode[] { functionRecordNode });

        DebugPlugin.getDefault().addDebugEventListener(this);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void handleDebugEvents(final DebugEvent[] events) {
        if (isDisposed())
            return;

        // We're in session's executor thread. Re-dispatch to our executor
        // thread
        // and then call root layout node.
        try {
            getExecutor().execute(new Runnable() {
                @Override
                public void run() {
                    if (isDisposed())
                        return;

                    for (final DebugEvent event : events) {
                        handleEvent(event);
                    }
                }
            });
        } catch (RejectedExecutionException e) {
            // Ignore. This exception could be thrown if the provider is being
            // shut down.
        }

    }

}
