/*******************************************************************************
 * Copyright (c) 2016 - 2020 Intel Corporation and others.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0l
 *
 * Contributors:
 *     Michael Sturm (Intel Corporation) - initial implementation.
 *     Intel Corporation - OneAPI Debugger enhancements
 *******************************************************************************/
package org.eclipse.cdt.dsf.iss.launching;

import org.eclipse.cdt.dsf.iss.IssGdbPlugin;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

/**
 * Initialize the preferences.
 */
public class IssPreferenceInitializer extends AbstractPreferenceInitializer {

	@Override
	public void initializeDefaultPreferences() {
		IEclipsePreferences node = DefaultScope.INSTANCE.getNode(IssGdbPlugin.PLUGIN_ID);

		// The logic here is that either resolving the path to gdb-oneapi works, or the
		// error pane of the debug launch configuration dialog displays an error
		// message. Debugger env should already be source before running eclipse.
		node.put(IIssDebugPreferenceConstants.PREF_DEFAULT_ONEAPI_GDB_COMMAND, "gdb-oneapi");
		node.putInt(IIssDebugPreferenceConstants.PREF_SELECTED_LANE_ID, 0);
	}
}
