/*******************************************************************************
 * Copyright (c) 2015 - 2020 Intel Corporation.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Intel Corporation - Implementation for Function Call History View
 *******************************************************************************/
package org.eclipse.cdt.dsf.iss.mi.service.command.commands;

import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.iss.mi.service.command.output.MIFunctionRecordLengthInfo;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.command.commands.MICommand;

/**
 *
 * -function-call-history [function index begin] [function index end] /ilc
 *
 * Reports information about the function call history
 *
 * @since 1.1
 *
 */
public class MIFunctionRecordLength extends
        MICommand<MIFunctionRecordLengthInfo> {
	public MIFunctionRecordLength(IMIExecutionDMContext execDmc) {
		super(execDmc, "-function-call-history-length"); //$NON-NLS-1$
    }

    @Override
    public MIFunctionRecordLengthInfo getResult(MIOutput out) {
        return new MIFunctionRecordLengthInfo(out);
    }
}
