/*******************************************************************************
 * Copyright (c) 2015 - 2020 Intel Corporation.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Intel Corporation - Implementation for Function Call History View
 *******************************************************************************/
package org.eclipse.cdt.dsf.iss.mi.service.command.output;

import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIList;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResultRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MITuple;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;

public class MIFunctionRecordLengthInfo extends MIInfo {

    private int funcRecordLength = 0;

    public MIFunctionRecordLengthInfo(MIOutput out) {
        super(out);
        parse();
    }

    private void parse() {
        if (isDone()) {
            MIOutput out = getMIOutput();
            MIResultRecord rr = out.getMIResultRecord();
            if (rr != null) {
                MIResult[] results = rr.getMIResults();
                for (int i = 0; i < results.length; i++) {
                    String var = results[i].getVariable();
                    if (var.equals("func history length")) { //$NON-NLS-1$
                        MIValue val = results[i].getMIValue();
                        if (val instanceof MIList) {
                            parseThreads((MIList) val);
                        }
                    }
                }
            }
        }
    }

    public int getFuncRecordLength() {
        return funcRecordLength;
    }

    private void parseThreads(MIList list) {
        MITuple value = (MITuple) list.getMIValues()[0];

        MIResult[] results = value.getMIResults();

        MIResult result = results[0];
        String var = result.getVariable();

        if (var.equals("end")) { //$NON-NLS-1$
            MIValue val = result.getMIValue();
            if (val instanceof MIConst) {
                funcRecordLength = Integer.parseInt(((MIConst) val)
                        .getCString().trim());
            }
        }
    }

}
