/*******************************************************************************
 * Copyright (c) 2020-2022 Intel Corporation and others.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Intel Corporation - OneAPI Debugger enhancements
 *******************************************************************************/
package org.eclipse.cdt.dsf.iss.service;

import java.util.Hashtable;

import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.gdb.service.GdbDebugServicesFactory;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.gdb.service.extensions.GDBProcesses_HEAD;
import org.eclipse.cdt.dsf.iss.mi.service.command.IssCommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.service.DsfSession;

public class GDBProcesses_10_0 extends GDBProcesses_HEAD {

	private IGDBControl fCommandControl;

	private IssCommandFactory fCommandFactory;

	public GDBProcesses_10_0(DsfSession session) {
		super(session);
		validateGdbVersion(session);
	}

	@Override
	protected String getMinGDBVersionSupported() {
		return "10.0";
	}

	@Override
	protected void validateGdbVersion(DsfSession session) {
		GdbDebugServicesFactory.validateGdbVersion(session, getMinGDBVersionSupported(), this);
	}

	@Override
	public void initialize(final RequestMonitor requestMonitor) {
		super.initialize(new ImmediateRequestMonitor(requestMonitor) {
			@Override
			protected void handleSuccess() {
				doInitialize(requestMonitor);
			}
		});
	}

	/**
	 * This method initializes this service after our superclass's initialize()
	 * method succeeds.
	 *
	 * @param requestMonitor The call-back object to notify when this service's
	 *                       initialization is done.
	 */
	private void doInitialize(RequestMonitor requestMonitor) {

		fCommandControl = getServicesTracker().getService(IGDBControl.class);
		fCommandFactory = (IssCommandFactory) fCommandControl.getCommandFactory();

		// Register this service.
		register(new String[] { GDBProcesses_10_0.class.getName() }, new Hashtable<String, String>());

		fCommandControl.queueCommand(fCommandFactory.createMIGDBSetEnv(fCommandControl.getContext(), "ECLIPSE", "1"),
				new ImmediateDataRequestMonitor<MIInfo>());

		requestMonitor.done();
	}
}
