/*******************************************************************************
 * Copyright (c) 2016 - 2022 Intel Corporation and others.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Michael Sturm (Intel Corporation) - initial implementation.
 *******************************************************************************/
package org.eclipse.cdt.dsf.iss.service;

import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.gdb.service.GdbDebugServicesFactory;
import org.eclipse.cdt.dsf.iss.mi.service.command.IssCommandFactory;
import org.eclipse.cdt.dsf.iss.mi.service.command.IssGDBControl;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.debug.core.ILaunchConfiguration;

public class IssGdbDebugServicesFactory extends GdbDebugServicesFactory {

	public IssGdbDebugServicesFactory(String version, ILaunchConfiguration config) {
		super(version, config);
	}

	@Override
	protected ICommandControl createCommandControl(DsfSession session, ILaunchConfiguration config) {
		return new IssGDBControl(session, config, new IssCommandFactory());
	}

	@Override
	protected IRunControl createRunControlService(DsfSession session) {
		return new IssGDBRunControl(session);
	}

	@Override
	protected IProcesses createProcessesService(DsfSession session) {
		return new GDBProcesses_10_0(session);
	}

}
