/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.cache.JCSCacheManager;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.io.ChangesetUpdater;
import org.openstreetmap.josm.io.MessageNotifier;
import org.openstreetmap.josm.io.remotecontrol.RemoteControl;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class MainTermination
implements Runnable {
    @Override
    public void run() {
        ChangesetUpdater.stop();
        MessageNotifier.stop();
        RemoteControl.stop();
        try {
            MainApplication.worker.shutdown();
        }
        catch (SecurityException e) {
            Logging.log(Logging.LEVEL_ERROR, "Unable to shutdown worker", e);
        }
        JCSCacheManager.shutdown();
        if (MainApplication.getMainFrame() != null) {
            MainApplication.getMainFrame().storeState();
        }
        if (MainApplication.getMap() != null) {
            MainApplication.getMap().rememberToggleDialogWidth();
        }
        MainApplication.getLayerManager().resetState();
        ImageProvider.shutdown(false);
        try {
            Preferences.main().saveDefaults();
        }
        catch (IOException | InvalidPathException ex) {
            Logging.log(Logging.LEVEL_WARN, I18n.tr("Failed to save default preferences.", new Object[0]), ex);
        }
        ImageProvider.shutdown(true);
        try {
            MainApplication.worker.shutdownNow();
        }
        catch (SecurityException e) {
            Logging.log(Logging.LEVEL_ERROR, "Unable to shutdown worker", e);
        }
    }
}

