/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.callsite;

import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubySymbol;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.callsite.MonomorphicCallSite;
import org.jruby.util.TypeConverter;

public class RespondToCallSite
extends MonomorphicCallSite {
    private volatile RespondToTuple respondToTuple = RespondToTuple.NULL_CACHE;
    private final String respondToName;
    private RubySymbol respondToNameSym;

    public RespondToCallSite() {
        super("respond_to?");
        this.respondToName = null;
    }

    public RespondToCallSite(String name2) {
        super("respond_to?");
        this.respondToName = name2;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject name2) {
        String id2;
        RespondToTuple tuple = this.respondToTuple;
        RubyClass klass = RubyBasicObject.getMetaClass(self2);
        if (tuple.cacheOk(klass) && (id2 = TypeConverter.checkID(name2).idString()).equals(tuple.name) && tuple.checkVisibility) {
            return tuple.respondsTo;
        }
        return super.call(context, caller2, self2, name2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject name2, IRubyObject bool2) {
        String id2;
        RespondToTuple tuple = this.respondToTuple;
        RubyClass klass = RubyBasicObject.getMetaClass(self2);
        if (tuple.cacheOk(klass) && (id2 = TypeConverter.checkID(name2).idString()).equals(tuple.name) && !bool2.isTrue() == tuple.checkVisibility) {
            return tuple.respondsTo;
        }
        return super.call(context, caller2, self2, name2, bool2);
    }

    public boolean respondsTo(ThreadContext context, IRubyObject caller2, IRubyObject self2) {
        String strName;
        RespondToTuple tuple = this.respondToTuple;
        RubyClass klass = RubyBasicObject.getMetaClass(self2);
        if (tuple.cacheOk(klass) && (strName = this.respondToName).equals(tuple.name) && tuple.checkVisibility) {
            return tuple.respondsToBoolean;
        }
        return super.call(context, caller2, self2, (IRubyObject)this.getRespondToNameSym(context)).isTrue();
    }

    public boolean respondsTo(ThreadContext context, IRubyObject caller2, IRubyObject self2, boolean includePrivate) {
        String strName;
        RespondToTuple tuple = this.respondToTuple;
        RubyClass klass = RubyBasicObject.getMetaClass(self2);
        if (tuple.cacheOk(klass) && (strName = this.respondToName).equals(tuple.name) && !includePrivate == tuple.checkVisibility) {
            return tuple.respondsToBoolean;
        }
        return super.call(context, caller2, self2, (IRubyObject)this.getRespondToNameSym(context), (IRubyObject)RubyBoolean.newBoolean(context, includePrivate)).isTrue();
    }

    private RubySymbol getRespondToNameSym(ThreadContext context) {
        RubySymbol sym = this.respondToNameSym;
        if (sym == null) {
            this.respondToNameSym = sym = context.runtime.newSymbol(this.respondToName);
        }
        return sym;
    }

    @Override
    protected IRubyObject cacheAndCall(ThreadContext context, IRubyObject caller2, IRubyObject self2, RubyClass selfType, IRubyObject arg2) {
        IRubyObject tuple;
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            entry = Helpers.createMethodMissingEntry(context, selfType, this.callType, method2.getVisibility(), entry.token, this.methodName);
            method2 = entry.method;
        }
        if (method2.isBuiltin() && (tuple = this.fastRespondTo(arg2, entry, selfType, true, context)) != null) {
            return tuple;
        }
        entry = this.setCache(entry, self2);
        return method2.call(context, self2, entry.sourceModule, this.methodName, arg2);
    }

    @Override
    protected IRubyObject cacheAndCall(ThreadContext context, IRubyObject caller2, IRubyObject self2, RubyClass selfType, IRubyObject arg0, IRubyObject arg1) {
        IRubyObject tuple;
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            entry = Helpers.createMethodMissingEntry(context, selfType, this.callType, method2.getVisibility(), entry.token, this.methodName);
            method2 = entry.method;
        }
        if (method2.equals(context.runtime.getRespondToMethod()) && (tuple = this.fastRespondTo(arg0, entry, selfType, !arg1.isTrue(), context)) != null) {
            return tuple;
        }
        entry = this.setCache(entry, self2);
        return method2.call(context, self2, entry.sourceModule, this.methodName, arg0, arg1);
    }

    private IRubyObject fastRespondTo(IRubyObject arg2, CacheEntry entry, RubyClass selfType, boolean checkVisibility, ThreadContext context) {
        String id2 = TypeConverter.checkID(arg2).idString();
        RespondToTuple tuple = RespondToCallSite.recacheRespondsTo(entry, id2, selfType, checkVisibility, context);
        if (tuple.respondsTo.isTrue() || selfType.searchWithCache((String)"respond_to_missing?").method == context.runtime.getRespondToMissingMethod()) {
            this.respondToTuple = tuple;
            return tuple.respondsTo;
        }
        return null;
    }

    private static RespondToTuple recacheRespondsTo(CacheEntry respondToMethod, String newString, RubyClass klass, boolean checkVisibility, ThreadContext context) {
        CacheEntry respondToLookupResult = klass.searchWithCache(newString);
        boolean respondsTo = Helpers.respondsToMethod(respondToLookupResult.method, checkVisibility);
        return new RespondToTuple(newString, checkVisibility, respondToMethod, respondToLookupResult, RubyBoolean.newBoolean(context, respondsTo));
    }

    private static class RespondToTuple {
        static final RespondToTuple NULL_CACHE = new RespondToTuple("", true, CacheEntry.NULL_CACHE, CacheEntry.NULL_CACHE);
        public final String name;
        public final boolean checkVisibility;
        public final CacheEntry respondToMethod;
        public final CacheEntry entry;
        public final IRubyObject respondsTo;
        public final boolean respondsToBoolean;

        public RespondToTuple(String name2, boolean checkVisibility, CacheEntry respondToMethod, CacheEntry entry, IRubyObject respondsTo) {
            this.name = name2;
            this.checkVisibility = checkVisibility;
            this.respondToMethod = respondToMethod;
            this.entry = entry;
            this.respondsTo = respondsTo;
            this.respondsToBoolean = respondsTo.isTrue();
        }

        public RespondToTuple(String name2, boolean checkVisibility, CacheEntry respondToMethod, CacheEntry entry) {
            this.name = name2;
            this.checkVisibility = checkVisibility;
            this.respondToMethod = respondToMethod;
            this.entry = entry;
            this.respondsTo = null;
            this.respondsToBoolean = false;
        }

        public boolean cacheOk(RubyClass klass) {
            return this.respondToMethod.typeOk(klass) && this.entry.typeOk(klass);
        }
    }
}

