
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was LibAlkimiaConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

# Use original install prefix when loaded through a "/usr move"
# cross-prefix symbolic link such as /lib -> /usr/lib.
get_filename_component(_realCurr "${CMAKE_CURRENT_LIST_DIR}" REALPATH)
get_filename_component(_realOrig "/usr/lib/cmake/LibAlkimia5-8.1" REALPATH)
if(_realCurr STREQUAL _realOrig)
  set(PACKAGE_PREFIX_DIR "/usr")
endif()
unset(_realOrig)
unset(_realCurr)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

list(APPEND CMAKE_MODULE_PATH "${CMAKE_CURRENT_LIST_DIR}")

include(CMakeFindDependencyMacro)

if("OFF" STREQUAL "ON" OR "OFF" STREQUAL "1")
    find_package(Qt4 COMPONENTS QtCore QtDBus Qt5::)
else()
    find_dependency(Qt5Core)
    find_dependency(Qt5DBus)
    if (Qt5::WebEngineWidgets)
        find_dependency(Qt5::WebEngineWidgets)
    endif()
    if (Qt5::)
        find_dependency(Qt5::)
    endif()
endif()
find_dependency(GMP)

if (NOT ON)
    find_dependency(KF5Completion)
    find_dependency(KF5I18n)
    find_dependency(KF5NewStuff)
    find_dependency(KF5IconThemes)
    find_dependency(KF5TextWidgets)
    if(NOT OFF)
        find_dependency(KF5KIO)
    endif()
endif()

include("${CMAKE_CURRENT_LIST_DIR}/LibAlkimia5Targets.cmake")

set_and_check(LIBALKIMIA_INCLUDE_DIR "${PACKAGE_PREFIX_DIR}/include/alkimia/Qt5")
set_property(TARGET Alkimia::alkimia PROPERTY INTERFACE_INCLUDE_DIRECTORIES "${PACKAGE_PREFIX_DIR}/include/alkimia/Qt5" ${GMP_INCLUDE_DIR})
set_property(TARGET Alkimia::alkimia PROPERTY INTERFACE_COMPILE_OPTIONS "")
message(STATUS "Found LibAlkimia: ${CMAKE_CURRENT_LIST_DIR}/LibAlkimia5Config.cmake (found version \"8.1.1\")")
