/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.w2lcommon.filter;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertyAccess;
import com.sun.star.frame.XController;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XStorable;
import com.sun.star.io.XInputStream;
import com.sun.star.task.XStatusIndicator;
import com.sun.star.task.XStatusIndicatorFactory;
import com.sun.star.ucb.XSimpleFileAccess2;
import com.sun.star.ui.dialogs.XExecutableDialog;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.XModifiable;
import java.io.IOException;
import java.util.regex.Pattern;
import org.openoffice.da.comp.w2lcommon.filter.Messages;
import org.openoffice.da.comp.w2lcommon.filter.UNOConverter;
import org.openoffice.da.comp.w2lcommon.helper.MessageBox;
import writer2latex.util.Misc;

public class UNOPublisher {
    private String sAppName;
    protected XComponentContext xContext;
    protected XFrame xFrame;
    private XModel xModel = null;
    private PropertyValue[] mediaProps = null;

    public UNOPublisher(XComponentContext xContext, XFrame xFrame, String sAppName) {
        this.xContext = xContext;
        this.xFrame = xFrame;
        this.sAppName = sAppName;
        XController xController = xFrame.getController();
        if (xController != null) {
            this.xModel = xController.getModel();
        }
    }

    public boolean publish(TargetFormat format) {
        if (this.documentSaved() && this.updateMediaProperties(format)) {
            XStatusIndicatorFactory xFactory = (XStatusIndicatorFactory)UnoRuntime.queryInterface(XStatusIndicatorFactory.class, (Object)this.xFrame);
            XStatusIndicator xStatus = xFactory.createStatusIndicator();
            xStatus.start(this.sAppName, 10);
            xStatus.setValue(1);
            try {
                this.saveDocument();
                xStatus.setValue(4);
                UNOConverter converter = new UNOConverter(this.mediaProps, this.xContext);
                XSimpleFileAccess2 sfa2 = null;
                try {
                    Object sfaObject = this.xContext.getServiceManager().createInstanceWithContext("com.sun.star.ucb.SimpleFileAccess", this.xContext);
                    sfa2 = (XSimpleFileAccess2)UnoRuntime.queryInterface(XSimpleFileAccess2.class, (Object)sfaObject);
                }
                catch (Exception sfaObject) {
                    // empty catch block
                }
                XInputStream xis = sfa2.openFileRead(this.xModel.getURL());
                converter.convert(xis);
                xis.closeInput();
            }
            catch (IOException e) {
                xStatus.end();
                MessageBox msgBox = new MessageBox(this.xContext, this.xFrame);
                msgBox.showMessage(this.sAppName, Messages.getString("UNOPublisher.failexport"));
                return false;
            }
            catch (Exception e) {
                xStatus.end();
                MessageBox msgBox = new MessageBox(this.xContext, this.xFrame);
                msgBox.showMessage(this.sAppName, Messages.getString("UNOPublisher.failexport"));
                return false;
            }
            xStatus.setValue(7);
            this.postProcess(this.getTargetURL(format), format);
            xStatus.setValue(10);
            xStatus.end();
            return true;
        }
        return false;
    }

    protected String filterFileName(String sFileName) {
        return sFileName;
    }

    protected PropertyValue[] postProcessMediaProps(PropertyValue[] mediaProps) {
        return mediaProps;
    }

    protected void postProcess(String sTargetURL, TargetFormat format) {
    }

    public boolean documentSaved() {
        Pattern windowsPattern;
        String sDocumentUrl = this.xModel.getURL();
        if (sDocumentUrl.length() == 0) {
            MessageBox msgBox = new MessageBox(this.xContext, this.xFrame);
            msgBox.showMessage(this.sAppName, Messages.getString("UNOPublisher.savedocument"));
            return false;
        }
        if (!(".odt".equals(Misc.getFileExtension(sDocumentUrl)) || ".fodt".equals(Misc.getFileExtension(sDocumentUrl)) || ".ods".equals(Misc.getFileExtension(sDocumentUrl)) || ".fods".equals(Misc.getFileExtension(sDocumentUrl)))) {
            MessageBox msgBox = new MessageBox(this.xContext, this.xFrame);
            msgBox.showMessage(this.sAppName, Messages.getString("UNOPublisher.saveodt"));
            return false;
        }
        if (!sDocumentUrl.startsWith("file:")) {
            MessageBox msgBox = new MessageBox(this.xContext, this.xFrame);
            msgBox.showMessage(this.sAppName, Messages.getString("UNOPublisher.savefilesystem"));
            return false;
        }
        if (System.getProperty("os.name").startsWith("Windows") && !(windowsPattern = Pattern.compile("^file:///[A-Za-z][|:].*")).matcher(sDocumentUrl).matches()) {
            MessageBox msgBox = new MessageBox(this.xContext, this.xFrame);
            msgBox.showMessage(this.sAppName, Messages.getString("UNOPublisher.savedrivename"));
            return false;
        }
        return true;
    }

    private boolean saveDocument() {
        XModifiable xModifiable = (XModifiable)UnoRuntime.queryInterface(XModifiable.class, (Object)this.xModel);
        if (xModifiable.isModified()) {
            XStorable xStorable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)this.xModel);
            try {
                xStorable.store();
            }
            catch (com.sun.star.io.IOException e) {
                return false;
            }
        }
        return true;
    }

    public String getTargetPath() {
        if (this.xModel.getURL().length() > 0) {
            String sBaseURL = Misc.removeExtension(this.xModel.getURL());
            return Misc.getPath(sBaseURL);
        }
        return null;
    }

    public String getTargetFileName() {
        if (this.xModel.getURL().length() > 0) {
            String sBaseURL = Misc.removeExtension(this.xModel.getURL());
            return this.filterFileName(Misc.getFileName(sBaseURL));
        }
        return null;
    }

    protected String getTargetURL(TargetFormat format) {
        return this.getTargetPath() + this.getTargetFileName() + UNOPublisher.getTargetExtension(format);
    }

    private void prepareMediaProperties(TargetFormat format) {
        this.mediaProps = new PropertyValue[2];
        this.mediaProps[0] = new PropertyValue();
        this.mediaProps[0].Name = "FilterName";
        this.mediaProps[0].Value = UNOPublisher.getFilterName(format);
        this.mediaProps[1] = new PropertyValue();
        this.mediaProps[1].Name = "URL";
        this.mediaProps[1].Value = this.getTargetURL(format);
    }

    private boolean updateMediaProperties(TargetFormat format) {
        String sDialogName;
        this.prepareMediaProperties(format);
        String string = sDialogName = this.xModel.getURL().endsWith(".odt") || this.xModel.getURL().endsWith(".fodt") ? UNOPublisher.getDialogName(format) : UNOPublisher.getDialogNameCalc(format);
        if (sDialogName != null) {
            try {
                Object dialog = this.xContext.getServiceManager().createInstanceWithContext(sDialogName, this.xContext);
                XPropertyAccess xPropertyAccess = (XPropertyAccess)UnoRuntime.queryInterface(XPropertyAccess.class, (Object)dialog);
                xPropertyAccess.setPropertyValues(this.mediaProps);
                XExecutableDialog xDialog = (XExecutableDialog)UnoRuntime.queryInterface(XExecutableDialog.class, (Object)dialog);
                if (xDialog.execute() == 1) {
                    this.mediaProps = this.postProcessMediaProps(xPropertyAccess.getPropertyValues());
                    return true;
                }
            }
            catch (UnknownPropertyException unknownPropertyException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mediaProps = null;
        return false;
    }

    private static String getTargetExtension(TargetFormat format) {
        switch (format) {
            case xhtml: {
                return ".html";
            }
            case xhtml11: {
                return ".xhtml";
            }
            case xhtml_mathml: {
                return ".xhtml";
            }
            case html5: {
                return ".html";
            }
            case epub: {
                return ".epub";
            }
            case epub3: {
                return ".epub";
            }
            case latex: {
                return ".tex";
            }
        }
        return "";
    }

    private static String getDialogName(TargetFormat format) {
        switch (format) {
            case xhtml: 
            case xhtml11: {
                return "org.openoffice.da.comp.writer2xhtml.XhtmlOptionsDialog";
            }
            case xhtml_mathml: 
            case html5: {
                return "org.openoffice.da.comp.writer2xhtml.XhtmlOptionsDialogMath";
            }
            case epub: {
                return "org.openoffice.da.comp.writer2xhtml.EpubOptionsDialog";
            }
            case epub3: {
                return "org.openoffice.da.comp.writer2xhtml.Epub3OptionsDialog";
            }
            case latex: {
                return "org.openoffice.da.comp.writer2latex.LaTeXOptionsDialog";
            }
        }
        return null;
    }

    private static String getDialogNameCalc(TargetFormat format) {
        switch (format) {
            case xhtml: 
            case xhtml11: 
            case xhtml_mathml: 
            case html5: {
                return "org.openoffice.da.comp.writer2xhtml.XhtmlOptionsDialogCalc";
            }
        }
        return null;
    }

    private static String getFilterName(TargetFormat format) {
        switch (format) {
            case xhtml: {
                return "org.openoffice.da.writer2xhtml";
            }
            case xhtml11: {
                return "org.openoffice.da.writer2xhtml11";
            }
            case xhtml_mathml: {
                return "org.openoffice.da.writer2xhtml.mathml";
            }
            case html5: {
                return "org.openoffice.da.writer2xhtml5";
            }
            case epub: {
                return "org.openoffice.da.writer2xhtml.epub";
            }
            case epub3: {
                return "org.openoffice.da.writer2xhtml.epub3";
            }
            case latex: {
                return "org.openoffice.da.writer2latex";
            }
        }
        return "";
    }

    public static enum TargetFormat {
        xhtml,
        xhtml11,
        xhtml_mathml,
        html5,
        epub,
        epub3,
        latex;

    }
}

