/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.NoSuchElementException;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.LongLookup;

public final class DoubleLongIndex
implements LongLookup {
    private int count = 0;
    private int capacity;
    private boolean sorted = true;
    private long[] keys;
    private long[] values;
    private long targetSearchValue;

    public DoubleLongIndex(int n) {
        this.capacity = n;
        this.keys = new long[n];
        this.values = new long[n];
    }

    @Override
    public long getLongKey(int n) {
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        return this.keys[n] & 0xFFFFFFFFL;
    }

    @Override
    public long getLongValue(int n) {
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        return this.values[n];
    }

    @Override
    public void setLongValue(int n, long l) {
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        this.values[n] = l;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean addUnsorted(long l, long l2) {
        if (this.count == this.capacity) {
            this.doubleCapacity();
        }
        if (this.sorted && this.count != 0 && l < this.keys[this.count - 1]) {
            this.sorted = false;
        }
        this.keys[this.count] = l;
        this.values[this.count] = l2;
        ++this.count;
        return true;
    }

    @Override
    public int add(long l, long l2) {
        if (this.count == this.capacity) {
            this.doubleCapacity();
        }
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = l;
        int n = this.binarySlotSearch(true);
        if (this.count != n) {
            this.moveRows(n, n + 1, this.count - n);
        }
        this.keys[n] = l;
        this.values[n] = l2;
        ++this.count;
        return n;
    }

    @Override
    public long lookup(long l) throws NoSuchElementException {
        int n = this.findFirstEqualKeyIndex(l);
        if (n == -1) {
            throw new NoSuchElementException();
        }
        return this.getLongValue(n);
    }

    @Override
    public long lookup(long l, long l2) {
        int n = this.findFirstEqualKeyIndex(l);
        if (n == -1) {
            return l2;
        }
        return this.getLongValue(n);
    }

    @Override
    public void clear() {
        ArrayUtil.clearArray(74, this.keys, 0, this.count);
        ArrayUtil.clearArray(74, this.values, 0, this.count);
        this.count = 0;
        this.sorted = true;
    }

    public int findFirstGreaterEqualKeyIndex(long l) {
        int n = this.findFirstGreaterEqualSlotIndex(l);
        return n == this.count ? -1 : n;
    }

    public int findFirstEqualKeyIndex(long l) {
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = l;
        return this.binaryFirstSearch();
    }

    public int findFirstGreaterEqualSlotIndex(long l) {
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = l;
        return this.binarySlotSearch(false);
    }

    private int binaryFirstSearch() {
        int n = 0;
        int n2 = this.count;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.count;
        while (n < n2) {
            n3 = n + n2 >>> 1;
            n4 = this.compare(n3);
            if (n4 < 0) {
                n2 = n3;
                continue;
            }
            if (n4 > 0) {
                n = n3 + 1;
                continue;
            }
            n2 = n3;
            n5 = n3;
        }
        return n5 == this.count ? -1 : n5;
    }

    private int binarySlotSearch(boolean bl) {
        int n = 0;
        int n2 = this.count;
        int n3 = 0;
        int n4 = 0;
        while (n < n2) {
            n3 = n + n2 >>> 1;
            n4 = this.compare(n3);
            if (n4 <= 0) {
                n2 = n3;
                continue;
            }
            n = n3 + 1;
        }
        return n;
    }

    @Override
    public void sort() {
        this.fastQuickSort();
    }

    private void fastQuickSort() {
        if (this.count <= 16384) {
            this.fastQuickSortRecursive();
            return;
        }
        DoubleIntIndex doubleIntIndex = new DoubleIntIndex(32);
        int n = 16;
        doubleIntIndex.push(0, this.count - 1);
        while (doubleIntIndex.size() > 0) {
            int n2 = doubleIntIndex.peekKey();
            int n3 = doubleIntIndex.peekValue();
            doubleIntIndex.pop();
            if (n3 - n2 < n) continue;
            int n4 = this.partition(n2, n3);
            doubleIntIndex.push(n2, n4 - 1);
            doubleIntIndex.push(n4 + 1, n3);
        }
        this.insertionSort(0, this.count - 1);
        this.sorted = true;
    }

    private int partition(int n, int n2) {
        int n3 = n + n2 >>> 1;
        if (this.keys[n3] < this.keys[n + n3 >>> 1]) {
            this.swap(n3, n + n3 >>> 1);
        }
        if (this.keys[n2 + n3 >>> 1] < this.keys[n + n3 >>> 1]) {
            this.swap(n2 + n3 >>> 1, n + n3 >>> 1);
        }
        if (this.keys[n2 + n3 >>> 1] < this.keys[n3]) {
            this.swap(n2 + n3 >>> 1, n3);
        }
        long l = this.keys[n3];
        int n4 = n - 1;
        int n5 = n2;
        this.swap(n3, n2);
        while (true) {
            if (this.keys[++n4] < l) {
                continue;
            }
            while (l < this.keys[--n5]) {
            }
            if (n5 < n4) break;
            this.swap(n4, n5);
        }
        this.swap(n4, n2);
        return n4;
    }

    private void fastQuickSortRecursive() {
        this.quickSort(0, this.count - 1);
        this.insertionSort(0, this.count - 1);
        this.sorted = true;
    }

    private void quickSort(int n, int n2) {
        int n3 = 16;
        if (n2 - n > n3) {
            int n4 = n2 + n >>> 1;
            if (this.lessThan(n4, n)) {
                this.swap(n, n4);
            }
            if (this.lessThan(n2, n)) {
                this.swap(n, n2);
            }
            if (this.lessThan(n2, n4)) {
                this.swap(n4, n2);
            }
            int n5 = n2 - 1;
            this.swap(n4, n5);
            n4 = n;
            int n6 = n5;
            while (true) {
                if (this.lessThan(++n4, n6)) {
                    continue;
                }
                while (this.lessThan(n6, --n5)) {
                }
                if (n5 < n4) break;
                this.swap(n4, n5);
            }
            this.swap(n4, n2 - 1);
            this.quickSort(n, n5);
            this.quickSort(n4 + 1, n2);
        }
    }

    private void insertionSort(int n, int n2) {
        for (int i = n + 1; i <= n2; ++i) {
            int n3;
            for (n3 = i; n3 > n && this.lessThan(i, n3 - 1); --n3) {
            }
            if (i == n3) continue;
            this.moveAndInsertRow(i, n3);
        }
    }

    private void moveAndInsertRow(int n, int n2) {
        long l = this.keys[n];
        long l2 = this.values[n];
        this.moveRows(n2, n2 + 1, n - n2);
        this.keys[n2] = l;
        this.values[n2] = l2;
    }

    private void swap(int n, int n2) {
        long l = this.keys[n];
        long l2 = this.values[n];
        this.keys[n] = this.keys[n2];
        this.values[n] = this.values[n2];
        this.keys[n2] = l;
        this.values[n2] = l2;
    }

    private int compare(int n) {
        if (this.targetSearchValue > this.keys[n]) {
            return 1;
        }
        if (this.targetSearchValue < this.keys[n]) {
            return -1;
        }
        return 0;
    }

    private boolean lessThan(int n, int n2) {
        return this.keys[n] < this.keys[n2];
    }

    private void moveRows(int n, int n2, int n3) {
        System.arraycopy(this.keys, n, this.keys, n2, n3);
        System.arraycopy(this.values, n, this.values, n2, n3);
    }

    private void doubleCapacity() {
        this.keys = (long[])ArrayUtil.resizeArray(this.keys, this.capacity * 2);
        this.values = (long[])ArrayUtil.resizeArray(this.values, this.capacity * 2);
        this.capacity *= 2;
    }

    @Override
    public boolean addUnsorted(LongLookup longLookup) {
        if (!this.ensureCapacityToAdd(longLookup.size())) {
            return false;
        }
        this.sorted = false;
        for (int i = 0; i < longLookup.size(); ++i) {
            long l = longLookup.getLongKey(i);
            long l2 = longLookup.getLongValue(i);
            this.addUnsorted(l, l2);
        }
        return true;
    }

    private boolean ensureCapacityToAdd(int n) {
        if (this.count + n > this.capacity) {
            while (this.count + n > this.capacity) {
                this.doubleCapacity();
            }
        }
        return true;
    }
}

