/*
 * Copyright (c) 2012, 2019, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_az extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "M\u0259rk\u0259zi Afrika Vaxt\u0131",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Moskva Standart Vaxt\u0131",
               "MSK",
               "Moskva Yay vaxt\u0131",
               "MSD",
               "Moskva Vaxt\u0131",
               "MT",
            };
        final String[] Japan = new String[] {
               "Yaponiya Standart Vaxt\u0131",
               "JST",
               "Yaponiya Yay Vaxt\u0131",
               "JDT",
               "Yaponiya Vaxt\u0131",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "Pakistan Standart vaxt\u0131",
               "PKT",
               "Pakistan Yay Vaxt\u0131",
               "PKST",
               "Pakistan Vaxt\u0131",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "Taybey Standart Vaxt\u0131",
               "CST",
               "Taybey Yay Vaxt\u0131",
               "CDT",
               "Taybey Vaxt\u0131",
               "CT",
            };
        final String[] Hovd = new String[] {
               "Hovd Standart Vaxt\u0131",
               "HOVT",
               "Hovd Yay Vaxt\u0131",
               "HOVST",
               "Hovd Vaxt\u0131",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "Maqadan Standart Vaxt\u0131",
               "MAGT",
               "Maqadan Yay Vaxt\u0131",
               "MAGST",
               "Maqadan Vaxt\u0131",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "M\u0259rk\u0259zi Q\u0259rbi Avstraliya Standart Vaxt\u0131",
               "ACWST",
               "M\u0259rk\u0259zi Q\u0259rbi Avstraliya Yay Vaxt\u0131",
               "ACWDT",
               "M\u0259rk\u0259zi Q\u0259rbi Avstraliya Vaxt\u0131",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "M\u0259rk\u0259zi Avropa Standart Vaxt\u0131",
               "CET",
               "M\u0259rk\u0259zi Avropa Yay Vaxt\u0131",
               "CEST",
               "M\u0259rk\u0259zi Avropa Vaxt\u0131",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Saxalin Standart Vaxt\u0131",
               "SAKT",
               "Saxalin Yay Vaxt\u0131",
               "SAKST",
               "Saxalin Vaxt\u0131",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "Paraqvay Standart Vaxt\u0131",
               "PYT",
               "Paraqvay Yay Vaxt\u0131",
               "PYST",
               "Paraqvay Vaxt\u0131",
               "PYT",
            };
        final String[] Malaysia = new String[] {
               "Malayziya Vaxt\u0131",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "\u015eimali \u015e\u0259rqi Amerika Standart Vaxt\u0131",
               "EST",
               "\u015eimali \u015e\u0259rqi Amerika Yay Vaxt\u0131",
               "EDT",
               "\u015eimali \u015e\u0259rqi Amerika Vaxt\u0131",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Hau Standart Vaxt\u0131",
               "LHST",
               "Lord Hau Yay vaxt\u0131",
               "LHDT",
               "Lord Hau Vaxt\u0131",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "Yeni Zelandiya Standart Vaxt\u0131",
               "NZST",
               "Yeni Zelandiya Yay Vaxt\u0131",
               "NZDT",
               "Yeni Zelandiya Vaxt\u0131",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "Hind Okean\u0131 Vaxt\u0131",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Yakutsk Standart Vaxt\u0131",
               "YAKT",
               "Yakutsk Yay Vaxt\u0131",
               "YAKST",
               "Yakutsk Vaxt\u0131",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "Mavriki Standart Vaxt\u0131",
               "MUT",
               "Mavriki Yay Vaxt\u0131",
               "MUST",
               "Mavriki Vaxt\u0131",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "\u015e\u0259rqi Afrika Vaxt\u0131",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "\u015e\u0259rqi Timor Vaxt\u0131",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "Solomon Adalar\u0131 Vaxt\u0131",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "Korse Vaxt\u0131",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "Mar\u015fal Adalar\u0131 Vaxt\u0131",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "\u015e\u0259rqi Avropa Standart Vaxt\u0131",
               "EET",
               "\u015e\u0259rqi Avropa Yay Vaxt\u0131",
               "EEST",
               "\u015e\u0259rqi Avropa Vaxt\u0131",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Nyufaundlend Standart Vaxt\u0131",
               "NST",
               "Nyufaundlend Yay Vaxt\u0131",
               "NDT",
               "Nyufaundlend Vaxt\u0131",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "\u018ffqan\u0131stan Vaxt\u0131",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "Honq Konq Standart Vaxt\u0131",
               "HKT",
               "Honq Konq Yay Vaxt\u0131",
               "HKST",
               "Honq Konq Vaxt\u0131",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "Q\u0259rbi Argentina Standart Vaxt\u0131",
               "ART",
               "Q\u0259rbi Argentina Yay Vaxt\u0131",
               "ARST",
               "Q\u0259rbi Argentina Vaxt\u0131",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "Atlantik Standart Vaxt",
               "AST",
               "Atlantik Yay Vaxt\u0131",
               "ADT",
               "Atlantik Vaxt",
               "AT",
            };
        final String[] Ponape = new String[] {
               "Ponape Vaxt\u0131",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "Boliviya Vaxt\u0131",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "San Pier v\u0259 Mikelon Standart Vaxt\u0131",
               "PMST",
               "San Pier v\u0259 Mikelon Yay Vaxt\u0131",
               "PMDT",
               "San Pier v\u0259 Mikelon Vaxt\u0131",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "Hind\u00e7in Vaxt\u0131",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "Yekaterinburq Standart Vaxt\u0131",
               "YEKT",
               "Yekaterinburq Yay Vaxt\u0131",
               "YEKST",
               "Yekaterinburq Vaxt\u0131",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "Maldiv Vaxt\u0131",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "Tahiti Vaxt\u0131",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "\u0130srail Standart Vaxt\u0131",
               "IST",
               "\u0130srail Yay Vaxt\u0131",
               "IDT",
               "\u0130srail Vaxt\u0131",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "M\u0259rk\u0259zi \u0130ndoneziya Vaxt\u0131",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "Uollis v\u0259 Futuna Vaxt\u0131",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "C\u0259nubi Afrika Vaxt\u0131",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "Syova Vaxt\u0131",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "Layn Adalar\u0131 Vaxt\u0131",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "\u00d6zb\u0259kistan Standart Vaxt\u0131",
               "UZT",
               "\u00d6zb\u0259kistan Yay Vaxt\u0131",
               "UZST",
               "\u00d6zb\u0259kistan Vaxt\u0131",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "Omsk Standart Vaxt\u0131",
               "OMST",
               "Omsk Yay Vaxt\u0131",
               "OMSST",
               "Omsk Vaxt\u0131",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "Sey\u015fel Adalar\u0131 Vaxt\u0131",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "Uruqvay Standart Vaxt\u0131",
               "UYT",
               "Uruqvay Yay Vaxt\u0131",
               "UYST",
               "Uruqvay Vaxt\u0131",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "Nepal vaxt\u0131",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "Ulanbator Standart Vaxt\u0131",
               "ULAT",
               "Ulanbator Yay Vaxt\u0131",
               "ULAST",
               "Ulanbator Vaxt\u0131",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "\u015eimali M\u0259rk\u0259zi Amerika Standart Vaxt\u0131",
               "CST",
               "\u015eimali M\u0259rk\u0259zi Amerika Yay Vaxt\u0131",
               "CDT",
               "\u015eimali M\u0259rk\u0259zi Amerika Vaxt\u0131",
               "CT",
            };
        final String[] Truk = new String[] {
               "\u00c7uuk Vaxt\u0131",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "Niue Vaxt\u0131",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "Ueyk Vaxt\u0131",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "Folklend Adalar\u0131 Standart Vaxt\u0131",
               "FKT",
               "Folklend Adalar\u0131 Yay Vaxt\u0131",
               "FKST",
               "Folklend Adalar\u0131 Vaxt\u0131",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu Standart Vaxt\u0131",
               "VUT",
               "Vaunatu Yay Vaxt\u0131",
               "VUST",
               "Vanuatu Vaxt\u0131",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsk Standart Vaxt\u0131",
               "NOVT",
               "Novosibirsk Yay Vaxt\u0131",
               "NOVST",
               "Novosibirsk Vaxt\u0131",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "Sinqapur Vaxt\u0131",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "Azor Standart Vaxt\u0131",
               "AZOT",
               "Azor Yay Vaxt\u0131",
               "AZOST",
               "Azor Vaxt\u0131",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "Apia Standart Vaxt\u0131",
               "WSST",
               "Apia Yay Vaxt\u0131",
               "WSDT",
               "Apia Vaxt\u0131",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "Butan Vaxt\u0131",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "Surinam Vaxt\u0131",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "Nauru Vaxt\u0131",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnoyarsk Standart Vaxt\u0131",
               "KRAT",
               "Krasnoyarsk Yay Vaxt\u0131",
               "KRAST",
               "Krasnoyarsk Vaxt\u0131",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Q\u0259rbi Qazax\u0131stan Vaxt\u0131",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "Myanma Vaxt\u0131",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "Milad Adas\u0131 Vaxt\u0131",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "Amazon Standart Vaxt\u0131",
               "AMT",
               "Amazon Yay Vaxt\u0131",
               "AMST",
               "Amazon Vaxt\u0131",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "\u015e\u0259rqi Qazax\u0131stan Vaxt\u0131",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "Fici Standart Vaxt\u0131",
               "FJT",
               "Fici Yay Vaxt\u0131",
               "FJST",
               "Fici Vaxt\u0131",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "Reunion Vaxt\u0131",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "Kokos Adalar\u0131 Vaxt\u0131",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "\u00c7atham Standart Vaxt\u0131",
               "CHAST",
               "\u00c7atham Yay Vaxt\u0131",
               "CHADT",
               "\u00c7atham Vaxt\u0131",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "Vostok Vaxt\u0131",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "Argentina Standart Vaxt\u0131",
               "ART",
               "Argentina Yay Vaxt\u0131",
               "ARST",
               "Argentina Vaxt\u0131",
               "ART",
            };
        final String[] Gambier = new String[] {
               "Qambier Vaxt\u0131",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu Vaxt\u0131",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "Qalapaqos Vaxt\u0131",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "Makari Adas\u0131 Vaxt\u0131",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "Venesuela Vaxt\u0131",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Havay-Aleut Standart Vaxt\u0131",
               "HAST",
               "Havay-Aleut Yay Vaxt\u0131",
               "HADT",
               "Havay-Aleut Vaxt\u0131",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "M\u0259rk\u0259zi Avstraliya Standart Vaxt\u0131",
               "ACST",
               "M\u0259rk\u0259zi Avstraliya Yay Vaxt\u0131",
               "ACDT",
               "M\u0259rk\u0259zi Avstraliya Vaxt\u0131",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "\u015eimali Amerika Sakit Okean Standart Vaxt\u0131",
               "PST",
               "\u015eimali Amerika Sakit Okean Yay Vaxt\u0131",
               "PDT",
               "\u015eimali Amerika Sakit Okean Vaxt\u0131",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Feniks Adalar\u0131 Vaxt\u0131",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "T\u00fcrkm\u0259nistan Standart Vaxt\u0131",
               "TMT",
               "T\u00fcrkm\u0259nistan Yay Vaxt\u0131",
               "TMST",
               "T\u00fcrkm\u0259nistan Vaxt\u0131",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "Q\u0259rbi Avropa Standart Vaxt\u0131",
               "WET",
               "Q\u0259rbi Avropa Yay Vaxt\u0131",
               "WEST",
               "Q\u0259rbi Avropa Vaxt\u0131",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "Kape Verde Standart Vaxt\u0131",
               "CVT",
               "Kape Verde Yay Vaxt\u0131",
               "CVST",
               "Kape Verde Vaxt\u0131",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "Norfolk Adas\u0131 Vaxt\u0131",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "Qayana Vaxt\u0131",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "Pitkern Vaxt\u0131",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "Rotera Vaxt\u0131",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "Samoa Standart Vaxt\u0131",
               "SST",
               "Samoa Yay Vaxt\u0131",
               "SDT",
               "Samoa Vaxt\u0131",
               "ST",
            };
        final String[] Palau = new String[] {
               "Palau Vaxt\u0131",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "K\u0259nar \u015e\u0259rqi Avropa Vaxt\u0131",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "Az\u0259rbaycan Standart Vaxt\u0131",
               "AZT",
               "Az\u0259rbaycan Yay Vaxt\u0131",
               "AZST",
               "Az\u0259rbaycan Vaxt\u0131",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "Mouson Vaxt\u0131",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "Meksika Sakit Okean Standart Vaxt\u0131",
               "MST",
               "Meksika Sakit Okean Yay Vaxt\u0131",
               "MDT",
               "Meksika Sakit Okean Vaxt\u0131",
               "MT",
            };
        final String[] Davis = new String[] {
               "Devis Vaxt\u0131",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "Kuba Standart Vaxt\u0131",
               "CST",
               "Kuba Yay Vaxt\u0131",
               "CDT",
               "Kuba Vaxt\u0131",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Q\u0259rbi Afrika Standart Vaxt\u0131",
               "CAT",
               "Q\u0259rbi Afrika Yay Vaxt\u0131",
               "CAST",
               "Q\u0259rbi Afrika Vaxt\u0131",
               "CAT",
            };
        final String[] GMT = new String[] {
               "Qrinvi\u00e7 Orta Vaxt\u0131",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "Filippin Standart Vaxt\u0131",
               "PHT",
               "Filippin Yay Vaxt\u0131",
               "PHST",
               "Filippin Vaxt\u0131",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "Frans\u0131z C\u0259nubi v\u0259 Antarktik Vaxt\u0131",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "C\u0259nubi Corciya Vaxt\u0131",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "Yeni Kaledoniya Standart Vaxt\u0131",
               "NCT",
               "Yeni Kaledoniya Yay Vaxt\u0131",
               "NCST",
               "Yeni Kaledoniya Vaxt\u0131",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "Brunei Darussalam vaxt\u0131",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "\u0130ran Standart Vaxt\u0131",
               "IRST",
               "\u0130ran Yay Vaxt\u0131",
               "IRDT",
               "\u0130ran Vaxt\u0131",
               "IRT",
            };
        final String[] Easter = new String[] {
               "Pasxa Adas\u0131 Standart Vaxt\u0131",
               "EAST",
               "Pasxa Adas\u0131 Yay Vaxt\u0131",
               "EASST",
               "Pasxa Adas\u0131 Vaxt\u0131",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "\u015eimal-Q\u0259rbi Meksika Standart Vaxt\u0131",
               "PST",
               "\u015eimal-Q\u0259rbi Meksika Yay Vaxt\u0131",
               "PDT",
               "\u015eimal-Q\u0259rbi Meksika Vaxt\u0131",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "D\u00fcmon-d\u2019\u00dcrvil Vaxt\u0131",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "Tacikistan Vaxt\u0131",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "Tonqa Standart Vaxt\u0131",
               "TOT",
               "Tonqa Yay Vaxt\u0131",
               "TOST",
               "Tonqa Vaxt\u0131",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "Banqlade\u015f Standart Vaxt\u0131",
               "BDT",
               "Banqlade\u015f Yay Vaxt\u0131",
               "BDST",
               "Banqlade\u015f Vaxt\u0131",
               "BDT",
            };
        final String[] Peru = new String[] {
               "Peru Standart Vaxt\u0131",
               "PET",
               "Peru Yay Vaxt\u0131",
               "PEST",
               "Peru Vaxt\u0131",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "Q\u0259rbi Qrenlandiya Standart Vaxt\u0131",
               "WGT",
               "Q\u0259rbi Qrenlandiya Yay Vaxt\u0131",
               "WGST",
               "Q\u0259rbi Qrenlandiya Vaxt\u0131",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "Ekvador Vaxt\u0131",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "\u015e\u0259rqi Qrenlandiya Standart Vaxt\u0131",
               "EGT",
               "\u015e\u0259rqi Qrenlandiya Yay Vaxt\u0131",
               "EGST",
               "\u015e\u0259rqi Qrenlandiya Vaxt\u0131",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "K\u00f6rf\u0259z Vaxt\u0131",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "\u015e\u0259rqi \u0130ndoneziya Vaxt\u0131",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "Koreya Standart Vaxt\u0131",
               "KST",
               "Koreya Yay Vaxt\u0131",
               "KDT",
               "Koreya Vaxt\u0131",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "Q\u0259rbi Avstraliya Standart Vaxt\u0131",
               "AWST",
               "Q\u0259rbi Avstraliya Yay Vaxt\u0131",
               "AWDT",
               "Q\u0259rbi Avstraliya Vaxt\u0131",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "Q\u0131r\u011f\u0131z\u0131stan Vaxt\u0131",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "Q\u0259rbi \u0130ndoneziya Vaxt\u0131",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "\u015e\u0259rqi Avstraliya Standart Vaxt\u0131",
               "AEST",
               "\u015e\u0259rqi Avstraliya Yay Vaxt\u0131",
               "AEDT",
               "\u015e\u0259rqi Avstraliya Vaxt\u0131",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "Frans\u0131z Qvianas\u0131 Vaxt\u0131",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "Kolumbiya Standart Vaxt\u0131",
               "COT",
               "Kolumbiya Yay Vaxt\u0131",
               "COST",
               "Kolumbiya Vaxt\u0131",
               "COT",
            };
        final String[] Chile = new String[] {
               "\u00c7ili Standart Vaxt\u0131",
               "CLT",
               "\u00c7ili Yay Vaxt\u0131",
               "CLST",
               "\u00c7ili Vaxt\u0131",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilbert Adalar\u0131 Vaxt\u0131",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "\u015eimali Da\u011fl\u0131q Amerika Standart Vaxt\u0131",
               "MST",
               "\u015eimali Da\u011fl\u0131q Amerika Yay Vaxt\u0131",
               "MDT",
               "\u015eimali Da\u011fl\u0131q Amerika Vaxt\u0131",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "Markesas Vaxt\u0131",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "\u018fr\u0259bistan Standart Vaxt\u0131",
               "AST",
               "\u018fr\u0259bistan Yay Vaxt\u0131",
               "ADT",
               "\u018fr\u0259bistan Vaxt\u0131",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Alyaska Standart Vaxt\u0131",
               "AKST",
               "Alyaska Yay Vaxt\u0131",
               "AKDT",
               "Alyaska Vaxt\u0131",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostok Standart Vaxt\u0131",
               "VLAT",
               "Vladivostok Yay Vaxt\u0131",
               "VLAST",
               "Vladivostok Vaxt\u0131",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "\u00c7amorro Vaxt\u0131",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "\u0130rkutsk Standart Vaxt\u0131",
               "IRKT",
               "\u0130rkutsk Yay Vaxt\u0131",
               "IRKST",
               "\u0130rkutsk Vaxt\u0131",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "Gurc\u00fcstan Standart Vaxt\u0131",
               "GET",
               "Gurc\u00fcstan Yay Vaxt\u0131",
               "GEST",
               "Gurc\u00fcstan Vaxt\u0131",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "Tokelau Vaxt\u0131",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua Yeni Qvineya Vaxt\u0131",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronya Standart Vaxt\u0131",
               "FNT",
               "Fernando de Noronya Yay Vaxt\u0131",
               "FNST",
               "Fernando de Noronya Vaxt\u0131",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "\u00c7oybalsan Standart Vaxt\u0131",
               "CHOT",
               "\u00c7oybalsan Yay Vaxt\u0131",
               "CHOST",
               "\u00c7oybalsan Vaxt\u0131",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "Braziliya Standart Vaxt\u0131",
               "BRT",
               "Braziliya Yay Vaxt\u0131",
               "BRST",
               "Braziliya Vaxt\u0131",
               "BRT",
            };
        final String[] China = new String[] {
               "\u00c7in Standart Vaxt\u0131",
               "CST",
               "\u00c7in Yay Vaxt\u0131",
               "CDT",
               "\u00c7in Vaxt\u0131",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Erm\u0259nistan Standart Vaxt\u0131",
               "AMT",
               "Erm\u0259nistan Yay Vaxt\u0131",
               "AMST",
               "Erm\u0259nistan Vaxt\u0131",
               "AMT",
            };
        final String[] Samara = new String[] {
               "Samara standart vaxt\u0131",
               "SAMT",
               "Samara yay vaxt\u0131",
               "SAMST",
               "Samara vaxt\u0131",
               "SAMT",
            };
        final String[] India = new String[] {
               "Hindistan Vaxt\u0131",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "Kuk Adalar\u0131 Standart Vaxt\u0131",
               "CKT",
               "Kuk Adalar\u0131 Yar\u0131m Yay Vaxt\u0131",
               "CKHST",
               "Kuk Adalar\u0131 Vaxt\u0131",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Qrinvi\u00e7 Orta Vaxt\u0131",
                    "GMT",
                    "Britaniya Yay Vaxt\u0131",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Qrinvi\u00e7 Orta Vaxt\u0131",
                    "GMT",
                    "\u0130rlandiya Yay Vaxt\u0131",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
