/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_af extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_NR = "Nauru";
        final String metaValue_TV = "Tuvalu";
        final String metaValue_ar = "Arabies";
        final String metaValue_bn = "Bengaals";
        final String metaValue_bo = "Tibettaans";
        final String metaValue_el = "Grieks";
        final String metaValue_he = "Hebreeus";
        final String metaValue_hy = "Armeens";
        final String metaValue_ja = "Japannees";
        final String metaValue_ka = "Georgies";
        final String metaValue_km = "Khmer";
        final String metaValue_kn = "Kannada";
        final String metaValue_ko = "Koreaans";
        final String metaValue_la = "Latyn";
        final String metaValue_lo = "Lao";
        final String metaValue_ml = "Malabaars";
        final String metaValue_mn = "Mongools";
        final String metaValue_or = "Oriya";
        final String metaValue_si = "Sinhala";
        final String metaValue_ta = "Tamil";
        final String metaValue_te = "Teloegoe";
        final String metaValue_th = "Thai";
        final Object[][] data = new Object[][] {
            { "ksh", "Keuls" },
            { "mwl", "Mirandees" },
            { "Zsym", "Simbole" },
            { "Zsye", "Emoji" },
            { "egy", "Antieke Egipties" },
            { "tem", "Timne" },
            { "teo", "Teso" },
            { "rap", "Rapanui" },
            { "AC", "Ascensioneiland" },
            { "rar", "Rarotongaans" },
            { "tet", "Tetoem" },
            { "AD", "Andorra" },
            { "AE", "Verenigde Arabiese Emirate" },
            { "nl_BE", "Vlaams" },
            { "AF", "Afganistan" },
            { "AG", "Antigua en Barbuda" },
            { "type.ca.ethiopic", "Ethiopiese kalender" },
            { "AI", "Anguilla" },
            { "key.tz", "Tydsone" },
            { "AL", "Albani\u00eb" },
            { "AM", "Armeni\u00eb" },
            { "AO", "Angola" },
            { "AQ", "Antarktika" },
            { "AR", "Argentini\u00eb" },
            { "AS", "Amerikaanse Samoa" },
            { "AT", "Oostenryk" },
            { "AU", "Australi\u00eb" },
            { "AW", "Aruba" },
            { "en_US", "Engels (VSA)" },
            { "AX", "\u00c5landeilande" },
            { "AZ", "Azerbeidjan" },
            { "BA", "Bosni\u00eb en Herzegowina" },
            { "BB", "Barbados" },
            { "ceb", "Cebuano" },
            { "BD", "Bangladesj" },
            { "kum", "Kumyk" },
            { "BE", "Belgi\u00eb" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgarye" },
            { "BH", "Bahrein" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Sint Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "myv", "Erzya" },
            { "BN", "Broenei" },
            { "BO", "Bolivi\u00eb" },
            { "BQ", "Karibiese Nederland" },
            { "BR", "Brasili\u00eb" },
            { "BS", "Bahamas" },
            { "xog", "Soga" },
            { "BT", "Bhoetan" },
            { "BV", "Bouvet-eiland" },
            { "BW", "Botswana" },
            { "BY", "Belarus" },
            { "BZ", "Belize" },
            { "type.ca.persian", "Persiese kalender" },
            { "type.nu.hebr", "Hebreeuse syfers" },
            { "CA", "Kanada" },
            { "CC", "Kokoseilande" },
            { "mzn", "Masanderani" },
            { "CD", "Demokratiese Republiek van die Kongo" },
            { "CF", "Sentraal-Afrikaanse Republiek" },
            { "CG", "Kongo - Brazzaville" },
            { "CH", "Switserland" },
            { "CI", "Ivoorkus" },
            { "CK", "Cookeilande" },
            { "CL", "Chili" },
            { "CM", "Kameroen" },
            { "CN", "Sjina" },
            { "CO", "Colombi\u00eb" },
            { "CP", "Clippertoneiland" },
            { "CR", "Costa Rica" },
            { "CU", "Kuba" },
            { "CV", "Kaap Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Kerseiland" },
            { "CY", "Siprus" },
            { "CZ", "Tsjeggi\u00eb" },
            { "eka", "Ekajuk" },
            { "DE", "Duitsland" },
            { "ace", "Atsjenees" },
            { "cgg", "Kiga" },
            { "DG", "Diego Garcia" },
            { "type.nu.deva", "Devanagari-syfers" },
            { "DJ", "Djiboeti" },
            { "DK", "Denemarke" },
            { "ach", "Akoli" },
            { "Brai", "Braille" },
            { "DM", "Dominica" },
            { "type.nu.armnlow", "Armeense kleinletter-syfers" },
            { "DO", "Dominikaanse Republiek" },
            { "gor", "Gorontalo" },
            { "got", "Goties" },
            { "zun", "Zuni" },
            { "tig", "Tigre" },
            { "DZ", "Algeri\u00eb" },
            { "pag", "Pangasinan" },
            { "type.d0.hwidth", "halfwydte" },
            { "EA", "Ceuta en Melilla" },
            { "pam", "Pampanga" },
            { "EC", "Ecuador" },
            { "pap", "Papiamento" },
            { "ada", "Adangme" },
            { "EE", "Estland" },
            { "EG", "Egipte" },
            { "EH", "Wes-Sahara" },
            { "pau", "Palauaans" },
            { "chk", "Chuukees" },
            { "chm", "Mari" },
            { "cho", "Choctaw" },
            { "chr", "Cherokees" },
            { "ER", "Eritrea" },
            { "ES", "Spanje" },
            { "ET", "Ethiopi\u00eb" },
            { "EU", "Europese Unie" },
            { "type.ca.gregorian", "Gregoriese kalender" },
            { "EZ", "Eurosone" },
            { "chy", "Cheyennees" },
            { "type.nu.gujr", "Goedjarati-syfers" },
            { "ady", "Adyghe" },
            { "FI", "Finland" },
            { "FJ", "Fidji" },
            { "FK", "Falklandeilande" },
            { "FM", "Mikronesi\u00eb" },
            { "key.va", "Lokaalvariant" },
            { "FO", "Faro\u00ebreilande" },
            { "Taml", metaValue_ta },
            { "FR", "Frankryk" },
            { "root", "Root" },
            { "type.ca.indian", "Indiese nasionale kalender" },
            { "grc", "Antieke Grieks" },
            { "GA", "Gaboen" },
            { "GB", "Verenigde Koninkryk" },
            { "pcm", "Nigeriese Pidgin" },
            { "GD", "Grenada" },
            { "GE", "Georgi\u00eb" },
            { "GF", "Frans-Guyana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Groenland" },
            { "GM", "Gambi\u00eb" },
            { "GN", "Guinee" },
            { "GP", "Guadeloupe" },
            { "GQ", "Ekwatoriaal-Guinee" },
            { "GR", "Griekeland" },
            { "GS", "Suid-Georgi\u00eb en die Suidelike Sandwicheilande" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinee-Bissau" },
            { "tlh", "Klingon" },
            { "GY", "Guyana" },
            { "ckb", "Sorani" },
            { "zxx", "Geen taalinhoud nie" },
            { "HK", "Hongkong SAS Sjina" },
            { "HM", "Heardeiland en McDonaldeilande" },
            { "HN", "Honduras" },
            { "HR", "Kroasi\u00eb" },
            { "agq", "Aghem" },
            { "gsw", "Switserse Duits" },
            { "HT", "Ha\u00efti" },
            { "HU", "Hongarye" },
            { "IC", "Kanariese Eilande" },
            { "nan", "Min Nan-Sjinees" },
            { "ID", "Indonesi\u00eb" },
            { "IE", "Ierland" },
            { "nap", "Neapolitaans" },
            { "naq", "Nama" },
            { "zza", "Zaza" },
            { "IL", "Israel" },
            { "IM", "Eiland Man" },
            { "IN", "Indi\u00eb" },
            { "IO", "Brits-Indiese Oseaangebied" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Ysland" },
            { "IT", "Itali\u00eb" },
            { "Zmth", "Wiskundige notasie" },
            { "type.nu.thai", "Thaise syfers" },
            { "type.nu.beng", "Bengaalse syfers" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "Islamitiese kalender" },
            { "Beng", metaValue_bn },
            { "JM", "Jamaika" },
            { "JO", "Jordani\u00eb" },
            { "JP", "Japan" },
            { "ain", "Ainu" },
            { "guz", "Gusii" },
            { "type.nu.knda", "Kannada-syfers" },
            { "de_CH", "Switserse hoog-Duits" },
            { "type.co.phonetic", "Fonetiese sorteerorde" },
            { "type.ca.buddhist", "Boeddhistiese kalender" },
            { "KE", "Kenia" },
            { "419", "Latyns-Amerika" },
            { "KG", "Kirgistan" },
            { "KH", "Kambodja" },
            { "KI", "Kiribati" },
            { "KM", "Comore" },
            { "Knda", metaValue_kn },
            { "KN", "Sint Kitts en Nevis" },
            { "KP", "Noord-Korea" },
            { "KR", "Suid-Korea" },
            { "KW", "Koeweit" },
            { "tpi", "Tok Pisin" },
            { "KY", "Kaaimanseilande" },
            { "KZ", "Kazakstan" },
            { "Cyrl", "Sirillies" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "LC", "Sint Lucia" },
            { "phn", "Fenisies" },
            { "gwi", "Gwich\u02bcin" },
            { "nds", "Lae Duits" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "cop", "Kopties" },
            { "LR", "Liberi\u00eb" },
            { "LS", "Lesotho" },
            { "LT", "Litaue" },
            { "LU", "Luxemburg" },
            { "LV", "Letland" },
            { "Kana", "Katakana" },
            { "LY", "Libi\u00eb" },
            { "lad", "Ladino" },
            { "vun", "Vunjo" },
            { "lag", "Langi" },
            { "Thaa", "Thaana" },
            { "MA", "Marokko" },
            { "MC", "Monaco" },
            { "MD", "Moldowa" },
            { "ME", "Montenegro" },
            { "MF", "Sint Martin" },
            { "MG", "Madagaskar" },
            { "Thai", metaValue_th },
            { "MH", "Marshalleilande" },
            { "ale", "Aleut" },
            { "type.nu.vaii", "Vai-syfers" },
            { "MK", "Macedoni\u00eb" },
            { "ML", "Mali" },
            { "MM", "Mianmar (Birma)" },
            { "MN", "Mongoli\u00eb" },
            { "new", "Newari" },
            { "MO", "Macau SAS Sjina" },
            { "MP", "Noord-Mariane-eilande" },
            { "MQ", "Martinique" },
            { "MR", "Mauritani\u00eb" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "type.m0.ungegn", "UNGEGN" },
            { "MU", "Mauritius" },
            { "alt", "Suid-Altai" },
            { "MV", "Maledive" },
            { "MW", "Malawi" },
            { "MX", "Meksiko" },
            { "type.ca.japanese", "Japannese kalender" },
            { "MY", "Maleisi\u00eb" },
            { "MZ", "Mosambiek" },
            { "NA", "Namibi\u00eb" },
            { "202", "Afrika suid van die Sahara" },
            { "type.ca.hebrew", "Hebreeuse kalender" },
            { "type.co.dictionary", "Woordeboek-sorteervolgorde" },
            { "NC", "Nieu-Kaledoni\u00eb" },
            { "NE", "Niger" },
            { "NF", "Norfolkeiland" },
            { "NG", "Nigeri\u00eb" },
            { "trv", "Taroko" },
            { "NI", "Nicaragua" },
            { "NL", "Nederland" },
            { "NO", "Noorwe\u00eb" },
            { "NP", "Nepal" },
            { "NR", metaValue_NR },
            { "NU", "Niue" },
            { "rof", "Rombo" },
            { "NZ", "Nieu-Seeland" },
            { "OM", "Oman" },
            { "anp", "Angika" },
            { "crs", "Seselwa Franskreools" },
            { "PA", "Panama" },
            { "type.ca.islamic-civil", "Islamitiese siviele kalender" },
            { "en_GB", "Engels (VK)" },
            { "PE", "Peru" },
            { "PF", "Frans-Polinesi\u00eb" },
            { "PG", "Papoea-Nieu-Guinee" },
            { "PH", "Filippyne" },
            { "PK", "Pakistan" },
            { "PL", "Pole" },
            { "ewo", "Ewondo" },
            { "PM", "Sint Pierre en Miquelon" },
            { "PN", "Pitcairneilande" },
            { "PR", "Puerto Rico" },
            { "PS", "Palestynse gebiede" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "nia", "Nias" },
            { "type.nu.greklow", "Griekse kleinletter-syfers" },
            { "PY", "Paraguay" },
            { "tum", "Toemboeka" },
            { "Hebr", metaValue_he },
            { "QA", "Katar" },
            { "niu", "Niueaans" },
            { "QO", "Omliggende Oseani\u00eb" },
            { "lez", "Lezghies" },
            { "tvl", metaValue_TV },
            { "001", "W\u00eareld" },
            { "002", "Afrika" },
            { "003", "Noord-Amerika" },
            { "RE", "R\u00e9union" },
            { "005", "Suid-Amerika" },
            { "jbo", "Lojban" },
            { "009", "Oseani\u00eb" },
            { "RO", "Roemeni\u00eb" },
            { "RS", "Serwi\u00eb" },
            { "RU", "Rusland" },
            { "RW", "Rwanda" },
            { "SA", "Saoedi-Arabi\u00eb" },
            { "SB", "Salomonseilande" },
            { "twq", "Tasawaq" },
            { "011", "Wes-Afrika" },
            { "SC", "Seychelle" },
            { "SD", "Soedan" },
            { "013", "Sentraal-Amerika" },
            { "SE", "Swede" },
            { "014", "Oos-Afrika" },
            { "arc", "Aramees" },
            { "015", "Noord-Afrika" },
            { "SG", "Singapoer" },
            { "SH", "Sint Helena" },
            { "type.lb.strict", "Streng re\u00eblbreek-styl" },
            { "017", "Midde-Afrika" },
            { "SI", "Sloweni\u00eb" },
            { "018", "Suider-Afrika" },
            { "SJ", "Svalbard en Jan Mayen" },
            { "019", "Amerikas" },
            { "SK", "Slowakye" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somali\u00eb" },
            { "arn", "Mapuche" },
            { "arp", "Arapaho" },
            { "type.nu.taml", "Tradisionele Tamil-syfers" },
            { "SR", "Suriname" },
            { "SS", "Suid-Soedan" },
            { "ST", "S\u00e3o Tom\u00e9 en Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Siri\u00eb" },
            { "SZ", "Swaziland" },
            { "TA", "Tristan da Cunha" },
            { "asa", "Asu" },
            { "type.ms.ussystem", "VS-meetstelsel" },
            { "021", "Noordelike Amerika" },
            { "TC", "Turks- en Caicoseilande" },
            { "yav", "Yangben" },
            { "TD", "Tsjad" },
            { "TF", "Franse Suidelike Gebiede" },
            { "TG", "Togo" },
            { "TH", "Thailand" },
            { "TJ", "Tadjikistan" },
            { "029", "Karibies" },
            { "TK", "Tokelau" },
            { "TL", "Oos-Timor" },
            { "ybb", "Yemba" },
            { "type.co.searchjl", "Soek volgens Hangul-beginkonsonant" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisi\u00eb" },
            { "TO", "Tonga" },
            { "TR", "Turkye" },
            { "TT", "Trinidad en Tobago" },
            { "TV", metaValue_TV },
            { "TW", "Taiwan" },
            { "ast", "Asturies" },
            { "TZ", "Tanzani\u00eb" },
            { "nmg", "Kwasio" },
            { "Zzzz", "Onbekende skryfstelsel" },
            { "UA", "Oekra\u00efne" },
            { "rup", "Aromanies" },
            { "030", "Oos-Asi\u00eb" },
            { "tyv", "Tuvinees" },
            { "sw_CD", "Swahili (Kongo)" },
            { "034", "Suid-Asi\u00eb" },
            { "035", "Suidoos-Asi\u00eb" },
            { "UG", "Uganda" },
            { "hak", "Hakka-Sjinees" },
            { "type.co.pinyin", "Pinyin-sorteervolgorde" },
            { "039", "Suid-Europa" },
            { "Sinh", metaValue_si },
            { "UM", "Klein afgele\u00eb eilande van die VSA" },
            { "UN", "Verenigde Nasies" },
            { "US", "Verenigde State van Amerika" },
            { "haw", "Hawaiies" },
            { "type.co.gb2312han", "Vereenvoudigde Chinese sorteervolgorde - GB2312" },
            { "UY", "Uruguay" },
            { "prg", "Pruisies" },
            { "UZ", "Oesbekistan" },
            { "tzm", "Sentraal-Atlas-Tamazight" },
            { "type.co.stroke", "Slag-sorteervolgorde" },
            { "nnh", "Ngiemboon" },
            { "VA", "Vatikaanstad" },
            { "VC", "Sint Vincent en die Grenadine" },
            { "VE", "Venezuela" },
            { "VG", "Britse Maagde-eilande" },
            { "VI", "VSA se Maagde-eilande" },
            { "VN", "Vi\u00ebtnam" },
            { "VU", "Vanuatu" },
            { "nog", "Nogai" },
            { "rwk", "Rwa" },
            { "053", "Australasi\u00eb" },
            { "054", "Melanesi\u00eb" },
            { "WF", "Wallis en Futuna" },
            { "type.co.traditional", "Tradisionele sorteervolgorde" },
            { "057", "Mikronesiese streek" },
            { "jgo", "Ngomba" },
            { "lkt", "Lakota" },
            { "type.nu.finance", "Finansi\u00eble syfers" },
            { "wae", "Walser" },
            { "WS", "Samoa" },
            { "wal", "Wolaytta" },
            { "war", "Waray" },
            { "awa", "Awadhi" },
            { "061", "Polinesi\u00eb" },
            { "XK", "Kosovo" },
            { "Gujr", "Gudjarati" },
            { "Zxxx", "Ongeskrewe" },
            { "wbp", "Warlpiri" },
            { "YE", "Jemen" },
            { "nqo", "N\u2019Ko" },
            { "type.co.standard", "Standaard sorteervolgorde" },
            { "YT", "Mayotte" },
            { "ZA", "Suid-Afrika" },
            { "type.lb.loose", "Los re\u00eblbreek-styl" },
            { "Deva", "Devanagari" },
            { "type.nu.geor", "Georgiese syfers" },
            { "Hira", "Hiragana" },
            { "ZM", "Zambi\u00eb" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Onbekende gebied" },
            { "type.ms.metric", "Metrieke stelsel" },
            { "type.ca.iso8601", "ISO-8601-kalender" },
            { "nso", "Noord-Sotho" },
            { "type.nu.telu", "Teloegoe-syfers" },
            { "loz", "Lozi" },
            { "jmc", "Machame" },
            { "type.nu.hansfin", "Vereenvoudigde Sjinese finansi\u00eble syfers" },
            { "hil", "Hiligaynon" },
            { "type.nu.arabext", "Uitgebreide Arabies-Indiese syfers" },
            { "nus", "Nuer" },
            { "dak", "Dakotaans" },
            { "type.nu.fullwide", "Vollewydte-syfers" },
            { "hit", "Hetities" },
            { "dar", "Dakota" },
            { "dav", "Taita" },
            { "lrc", "Noord-Luri" },
            { "udm", "Udmurt" },
            { "Khmr", metaValue_km },
            { "sad", "Sandawees" },
            { "type.nu.roman", "Romeinse syfers" },
            { "sah", "Sakhaans" },
            { "saq", "Samburu" },
            { "sat", "Santalies" },
            { "type.d0.npinyin", "Numeries" },
            { "type.nu.native", "Inheemse syfers" },
            { "sba", "Ngambay" },
            { "Guru", "Gurmukhi" },
            { "lua", "Luba-Lulua" },
            { "type.d0.fwidth", "Vollewydte" },
            { "sbp", "Sangu" },
            { "nyn", "Nyankole" },
            { "lun", "Lunda" },
            { "luo", "Luo" },
            { "fil", "Filippyns" },
            { "hmn", "Hmong" },
            { "lus", "Mizo" },
            { "ban", "Balinees" },
            { "luy", "Luyia" },
            { "bas", "Basaa" },
            { "sco", "Skots" },
            { "scn", "Sisiliaans" },
            { "aa", "Afar" },
            { "ab", "Abkasies" },
            { "af", "Afrikaans" },
            { "ak", "Akan" },
            { "am", "Amharies" },
            { "Arab", metaValue_ar },
            { "an", "Aragonees" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "Japannese lettergreepskrif" },
            { "as", "Assamees" },
            { "av", "Avaries" },
            { "sdh", "Suid-Koerdies" },
            { "ay", "Aymara" },
            { "az", "Azerbeidjans" },
            { "ba", "Baskir" },
            { "type.co.unihan", "Radikale-slag-sorteervolgorde" },
            { "be", "Belarussies" },
            { "bg", "Bulgaars" },
            { "bi", "Bislama" },
            { "bm", "Bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "Dogrib" },
            { "br", "Bretons" },
            { "bs", "Bosnies" },
            { "Mymr", "Mianmar" },
            { "type.nu.laoo", "Lao-syfers" },
            { "seh", "Sena" },
            { "ca", "Katalaans" },
            { "ses", "Koyraboro Senni" },
            { "ce", "Tsjetsjeens" },
            { "ch", "Chamorro" },
            { "co", "Korsikaans" },
            { "Orya", metaValue_or },
            { "cs", "Tsjeggies" },
            { "cu", "Kerkslawies" },
            { "cv", "Chuvash" },
            { "cy", "Wallies" },
            { "type.nu.ethi", "Ethiopiese syfers" },
            { "da", "Deens" },
            { "de", "Duits" },
            { "type.cf.standard", "Standaard Geldeenheidformaat" },
            { "bem", "Bemba" },
            { "type.nu.mong", "Mongoliese syfers" },
            { "dv", "Divehi" },
            { "dz", "Dzongkha" },
            { "bez", "Bena" },
            { "type.ca.chinese", "Sjinese kalender" },
            { "dje", "Zarma" },
            { "type.nu.grek", "Griekse syfers" },
            { "ee", "Ewe" },
            { "type.lb.normal", "Normale re\u00eblbreek-styl" },
            { "ro_MD", "Moldawies" },
            { "el", metaValue_el },
            { "en", "Engels" },
            { "eo", "Esperanto" },
            { "type.co.big5han", "Tradisionele Chinese sorteervolgorde - Groot5" },
            { "es", "Spaans" },
            { "et", "Estnies" },
            { "Hanb", "Hanb" },
            { "eu", "Baskies" },
            { "Hang", "Hangul" },
            { "shi", "Tachelhit" },
            { "hsb", "Oppersorbies" },
            { "Hani", "Han" },
            { "shn", "Shan" },
            { "fa", "Persies" },
            { "Hans", "Vereenvoudig" },
            { "type.nu.latn", "Westerse syfers" },
            { "Hant", "Tradisioneel" },
            { "ff", "Fulah" },
            { "hsn", "Xiang-Sjinees" },
            { "fi", "Fins" },
            { "fj", "Fidjiaans" },
            { "fon", "Fon" },
            { "bgn", "Wes-Balochi" },
            { "yue", "Kantonees" },
            { "fo", "Faro\u00ebes" },
            { "type.m0.bgn", "BGN" },
            { "umb", "Umbundu" },
            { "fr", "Frans" },
            { "fy", "Fries" },
            { "ga", "Iers" },
            { "gd", "Skotse Gallies" },
            { "gl", "Galisies" },
            { "gn", "Guarani" },
            { "bho", "Bhojpuri" },
            { "und", "Onbekende of ongeldige taal" },
            { "type.ca.ethiopic-amete-alem", "Etiopiese Amete Alem-kalender" },
            { "gu", "Goedjarati" },
            { "gv", "Manx" },
            { "ha", "Hausa" },
            { "he", metaValue_he },
            { "hi", "Hindi" },
            { "hup", "Hupa" },
            { "bin", "Bini" },
            { "hr", "Kroaties" },
            { "ht", "Ha\u00eftiaans" },
            { "hu", "Hongaars" },
            { "hy", metaValue_hy },
            { "hz", "Herero" },
            { "ia", "Interlingua" },
            { "Jamo", "Jamo" },
            { "id", "Indonesies" },
            { "type.nu.tibt", "Tibettaanse syfers" },
            { "ie", "Interlingue" },
            { "ig", "Igbo" },
            { "ii", "Sichuan Yi" },
            { "io", "Ido" },
            { "is", "Yslands" },
            { "it", "Italiaans" },
            { "iu", "Inu\u00efties" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "sma", "Suid-Sami" },
            { "jv", "Javaans" },
            { "mad", "Madurees" },
            { "smj", "Lule Sami" },
            { "mag", "Magahi" },
            { "mai", "Maithili" },
            { "smn", "Inari Sami" },
            { "ka", metaValue_ka },
            { "bla", "Siksika" },
            { "mak", "Makasar" },
            { "wuu", "Wu-Sjinees" },
            { "sms", "Skolt Sami" },
            { "kg", "Kongolees" },
            { "ki", "Kikuyu" },
            { "mas", "Masai" },
            { "kj", "Kuanyama" },
            { "kk", "Kazaks" },
            { "kl", "Kalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "Kanuri" },
            { "ks", "Kasjmirs" },
            { "ku", "Koerdies" },
            { "kv", "Komi" },
            { "kw", "Kornies" },
            { "ky", "Kirgisies" },
            { "snk", "Soninke" },
            { "la", metaValue_la },
            { "lb", "Luxemburgs" },
            { "type.nu.mlym", "Malabaarse syfers" },
            { "lg", "Ganda" },
            { "li", "Limburgs" },
            { "Tibt", metaValue_bo },
            { "ln", "Lingaals" },
            { "fur", "Friuliaans" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "Imperiale meetstelsel" },
            { "lt", "Litaus" },
            { "lu", "Luba-Katanga" },
            { "lv", "Letties" },
            { "mg", "Malgassies" },
            { "mh", "Marshallees" },
            { "type.co.ducet", "Verstek Unicode-sorteervolgorde" },
            { "mi", "Maori" },
            { "mk", "Masedonies" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "Marathi" },
            { "ms", "Maleis" },
            { "mt", "Maltees" },
            { "my", "Birmaans" },
            { "Armn", metaValue_hy },
            { "mdf", "Moksha" },
            { "dsb", "Lae Sorbies" },
            { "na", metaValue_NR },
            { "type.co.search", "Algemenedoel-soektog" },
            { "nb", "Noorse Bokm\u00e5l" },
            { "nd", "Noord-Ndebele" },
            { "ne", "Nepalees" },
            { "ng", "Ndonga" },
            { "nl", "Nederlands" },
            { "nn", "Noorweegse Nynorsk" },
            { "no", "Noors" },
            { "nr", "Suid-Ndebele" },
            { "nv", "Navajo" },
            { "ny", "Nyanja" },
            { "kac", "Kachin" },
            { "kab", "Kabyle" },
            { "oc", "Oksitaans" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "men", "Mende" },
            { "mer", "Meru" },
            { "type.nu.armn", "Armeense syfers" },
            { "om", "Oromo" },
            { "or", metaValue_or },
            { "os", "Osseties" },
            { "kbd", "Kabardiaans" },
            { "mfe", "Morisjen" },
            { "srn", "Sranan Tongo" },
            { "pa", "Pandjabi" },
            { "dua", "Duala" },
            { "pl", "Pools" },
            { "type.ca.dangi", "Dangi-kalender" },
            { "ps", "Pasjto" },
            { "pt", "Portugees" },
            { "key.co", "Sorteervolgorde" },
            { "kcg", "Tyap" },
            { "mgh", "Makhuwa-Meetto" },
            { "key.cf", "Geldeenheidformaat" },
            { "key.ca", "Kalender" },
            { "Laoo", metaValue_lo },
            { "mgo", "Meta\u2019" },
            { "type.hc.h23", "24-uur-stelsel (0-23)" },
            { "type.hc.h24", "24-uur-stelsel (1-24)" },
            { "ssy", "Saho" },
            { "type.nu.mymr", "Mianmar-syfers" },
            { "qu", "Quechua" },
            { "brx", "Bodo" },
            { "kde", "Makonde" },
            { "Ethi", "Etiopies" },
            { "type.hc.h12", "12-uur-stelsel (1-12)" },
            { "type.hc.h11", "12-uur-stelsel (0-11)" },
            { "rm", "Reto-Romaans" },
            { "rn", "Rundi" },
            { "key.cu", "Geldeenheid" },
            { "ro", "Roemeens" },
            { "type.nu.orya", "Odia-syfers" },
            { "type.nu.hanidec", "Sjinese desimale syfers" },
            { "ru", "Russies" },
            { "rw", "Rwandees" },
            { "kea", "Kabuverdianu" },
            { "mic", "Micmac" },
            { "suk", "Sukuma" },
            { "sa", "Sanskrit" },
            { "sc", "Sardinies" },
            { "sd", "Sindhi" },
            { "se", "Noord-Sami" },
            { "min", "Minangkabaus" },
            { "sg", "Sango" },
            { "sh", "Serwo-Kroaties" },
            { "si", metaValue_si },
            { "sk", "Slowaaks" },
            { "sl", "Sloweens" },
            { "sm", "Samoaans" },
            { "sn", "Shona" },
            { "so", "Somalies" },
            { "type.nu.arab", "Arabies-Indiese syfers" },
            { "sq", "Albanees" },
            { "sr", "Serwies" },
            { "ss", "Swazi" },
            { "type.cf.account", "Rekeningkundige geldeenheidformaat" },
            { "st", "Suid-Sotho" },
            { "su", "Sundanees" },
            { "sv", "Sweeds" },
            { "sw", "Swahili" },
            { "type.nu.hantfin", "Tradisionele Sjinese finansi\u00eble syfers" },
            { "ibb", "Ibibio" },
            { "iba", "Ibanees" },
            { "ta", metaValue_ta },
            { "142", "Asi\u00eb" },
            { "143", "Sentraal-Asi\u00eb" },
            { "te", metaValue_te },
            { "145", "Wes-Asi\u00eb" },
            { "tg", "Tadzjieks" },
            { "th", metaValue_th },
            { "ti", "Tigrinya" },
            { "bug", "Buginees" },
            { "kfo", "Koro" },
            { "tk", "Turkmeens" },
            { "tn", "Tswana" },
            { "to", "Tongaans" },
            { "dyo", "Jola-Fonyi" },
            { "type.nu.jpan", "Japannese syfers" },
            { "tr", "Turks" },
            { "ts", "Tsonga" },
            { "swb", "Comoraans" },
            { "tt", "Tataars" },
            { "tw", "Twi" },
            { "ty", "Tahities" },
            { "150", "Europa" },
            { "151", "Oos-Europa" },
            { "154", "Noord-Europa" },
            { "dzg", "Dazaga" },
            { "155", "Wes-Europa" },
            { "ug", "Uighur" },
            { "Kore", metaValue_ko },
            { "Zyyy", "Algemeen" },
            { "uk", "Oekra\u00efens" },
            { "type.ca.coptic", "Koptiese kalender" },
            { "ur", "Oerdoe" },
            { "xal", "Kalmyk" },
            { "uz", "Oezbeeks" },
            { "kha", "Khasi" },
            { "nds_NL", "Nedersaksies" },
            { "ve", "Venda" },
            { "type.ca.roc", "Minguo-kalender" },
            { "vi", "Vi\u00ebtnamees" },
            { "khq", "Koyra Chiini" },
            { "key.hc", "Uursiklus (12 vs 24)" },
            { "vo", "Volap\u00fck" },
            { "quc", "K\u2019iche\u2019" },
            { "gaa", "Gaa" },
            { "wa", "Walloon" },
            { "gag", "Gagauz" },
            { "syr", "Siries" },
            { "Grek", metaValue_el },
            { "gan", "Gan-Sjinees" },
            { "wo", "Wolof" },
            { "zgh", "Standaard Marokkaanse Tamazight" },
            { "ar_001", "Moderne Standaardarabies" },
            { "Mong", metaValue_mn },
            { "mni", "Manipuri" },
            { "Latn", metaValue_la },
            { "type.nu.hans", "Vereenvoudigde Sjinese syfers" },
            { "type.nu.hant", "Tradisionele Sjinese syfers" },
            { "xh", "Xhosa" },
            { "type.nu.romanlow", "Romeinse kleinletter-syfers" },
            { "byn", "Blin" },
            { "moh", "Mohawk" },
            { "kkj", "Kako" },
            { "yi", "Jiddisj" },
            { "mos", "Mossi" },
            { "yo", "Yoruba" },
            { "type.nu.traditional", "Tradisionele syfers" },
            { "vai", "Vai" },
            { "kln", "Kalenjin" },
            { "zh", "Sjinees" },
            { "Bopo", "Bopomofo" },
            { "key.lb", "Re\u00eblbreek-styl" },
            { "zu", "Zoeloe" },
            { "type.co.phonebook", "Foonboek-sorteervolgorde" },
            { "Geor", metaValue_ka },
            { "kmb", "Kimbundu" },
            { "type.nu.jpanfin", "Japannese finansi\u00eble syfers" },
            { "gez", "Geez" },
            { "type.co.reformed", "Gereformeerde sorteervolgorde" },
            { "ebu", "Embu" },
            { "zh_Hans", "Chinees (Vereenvoudig)" },
            { "koi", "Komi-Permyaks" },
            { "kok", "Konkani" },
            { "zh_Hant", "Chinees (Tradisioneel)" },
            { "kpe", "Kpellees" },
            { "type.nu.khmr", "Khmer-syfers" },
            { "ilo", "Iloko" },
            { "mua", "Mundang" },
            { "type.nu.guru", "Gurmukhi-syfers" },
            { "mul", "Veelvuldige tale" },
            { "key.ms", "Meetstelsel" },
            { "mus", "Kreek" },
            { "gil", "Gilbertees" },
            { "type.nu.tamldec", "Tamil-syfers" },
            { "krc", "Karachay-Balkar" },
            { "inh", "Ingush" },
            { "krl", "Karelies" },
            { "efi", "Efik" },
            { "key.nu", "Syfers" },
            { "kru", "Kurukh" },
            { "ksb", "Shambala" },
            { "Telu", metaValue_te },
            { "ksf", "Bafia" },
        };
        return data;
    }
}
