/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.acearth;

import ext.plantuml.com.ctreber.acearth.plugins.markers.Marker;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.acearth.PSystemXearth;
import net.sourceforge.plantuml.command.PSystemBasicFactory;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.regex.Matcher2;
import net.sourceforge.plantuml.regex.MyPattern;
import net.sourceforge.plantuml.regex.Pattern2;

public class PSystemXearthFactory
extends PSystemBasicFactory<PSystemXearth> {
    private final Map<String, String> config = new LinkedHashMap<String, String>();
    private final List<Marker> markers = new ArrayList<Marker>();
    private int width;
    private int height;

    @Override
    public PSystemXearth initDiagram(UmlSource source, String startLine) {
        this.width = 512;
        this.height = 512;
        this.config.clear();
        this.markers.clear();
        return null;
    }

    private void extractDimension(String startLine) {
        Pattern2 p = MyPattern.cmpile("\\((\\d+),(\\d+)\\)");
        Matcher2 m = p.matcher(startLine);
        boolean ok = m.find();
        if (ok) {
            this.width = Integer.parseInt(m.group(1));
            this.height = Integer.parseInt(m.group(2));
        }
    }

    @Override
    public PSystemXearth executeLine(UmlSource source, PSystemXearth system, String line) {
        if (system == null && line.startsWith("xearth")) {
            this.extractDimension(line);
            system = new PSystemXearth(source, this.width, this.height, this.config, this.markers);
            return system;
        }
        if (system == null) {
            return null;
        }
        if (line.startsWith("#") || line.startsWith("'")) {
            return system;
        }
        Pattern2 p = MyPattern.cmpile("(\\w+)[%s]*=[%s]*(.*)");
        Matcher2 m = p.matcher(line);
        if (m.find()) {
            this.config.put(m.group(1), m.group(2));
            return system;
        }
        try {
            Marker marker = Marker.loadMarkerFile(line);
            if (marker != null) {
                this.markers.add(marker);
                return system;
            }
        }
        catch (Exception e) {
            Logme.error(e);
            return null;
        }
        return null;
    }
}

