/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.util.Collection;
import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.decoration.symbol.USymbol;
import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.LimitFinder;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.drawing.UGraphicInterceptorUDrawable;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.MinMax;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.skin.AlignmentParam;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.UGraphicForSnake;
import net.sourceforge.plantuml.utils.MathUtils;

public class FtileGroup
extends AbstractFtile {
    private final double diffYY2 = 20.0;
    private final Ftile inner;
    private final TextBlock name;
    private final TextBlock headerNote;
    private final HColor borderColor;
    private final HColor backColor;
    private final double shadowing;
    private final UStroke stroke;
    private final USymbol type;
    private final double roundCorner;
    private FtileGeometry cachedInnerDimension;

    public final StyleSignatureBasic getStyleSignature() {
        return FtileGroup.getStyleSignature(this.type);
    }

    public static final StyleSignatureBasic getStyleSignature(USymbol symbol) {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, symbol.getSName(), SName.composite);
    }

    public FtileGroup(Ftile inner, Display title, HColor backColor, ISkinParam skinParam, USymbol type, Style style) {
        super(inner.skinParam());
        this.type = type;
        this.inner = FtileUtils.addHorizontalMargin(inner, 10.0);
        FontConfiguration fc = style.getFontConfiguration(this.getIHtmlColorSet());
        this.shadowing = style.value(PName.Shadowing).asDouble();
        this.backColor = backColor == null ? style.value(PName.BackGroundColor).asColor(this.getIHtmlColorSet()) : backColor;
        this.borderColor = style.value(PName.LineColor).asColor(skinParam.getIHtmlColorSet());
        this.roundCorner = style.value(PName.RoundCorner).asDouble();
        this.name = title == null ? TextBlockUtils.empty(0.0, 0.0) : title.create(fc, HorizontalAlignment.LEFT, skinParam);
        this.headerNote = TextBlockUtils.empty(0.0, 0.0);
        this.stroke = style.getStroke();
    }

    @Override
    public Collection<Ftile> getMyChildren() {
        return this.inner.getMyChildren();
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.inner.getInLinkRendering();
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.inner.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.inner.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.inner.getSwimlaneOut();
    }

    private double diffHeightTitle(StringBounder stringBounder) {
        XDimension2D dimTitle = this.name.calculateDimension(stringBounder);
        return Math.max(25.0, dimTitle.getHeight() + 20.0);
    }

    private UTranslate getTranslate(StringBounder stringBounder) {
        double suppWidth = this.suppWidth(stringBounder);
        return new UTranslate(suppWidth / 2.0, this.diffHeightTitle(stringBounder) + this.headerNoteHeight(stringBounder));
    }

    private MinMax getInnerMinMax(StringBounder stringBounder) {
        LimitFinder limitFinder = LimitFinder.create(stringBounder, false);
        UGraphicForSnake interceptor = new UGraphicForSnake(limitFinder);
        UGraphicInterceptorUDrawable interceptor2 = new UGraphicInterceptorUDrawable(interceptor);
        this.inner.drawU(interceptor2);
        interceptor2.flushUg();
        return limitFinder.getMinMax();
    }

    public double suppWidth(StringBounder stringBounder) {
        FtileGeometry orig = this.getInnerDimension(stringBounder);
        XDimension2D dimTitle = this.name.calculateDimension(stringBounder);
        XDimension2D dimHeaderNote = this.headerNote.calculateDimension(stringBounder);
        double suppWidth = MathUtils.max(orig.getWidth(), dimTitle.getWidth() + 20.0, dimHeaderNote.getWidth() + 20.0) - orig.getWidth();
        return suppWidth;
    }

    private FtileGeometry getInnerDimension(StringBounder stringBounder) {
        if (this.cachedInnerDimension == null) {
            this.cachedInnerDimension = this.getInnerDimensionSlow(stringBounder);
        }
        return this.cachedInnerDimension;
    }

    private FtileGeometry getInnerDimensionSlow(StringBounder stringBounder) {
        FtileGeometry orig = this.inner.calculateDimension(stringBounder);
        MinMax minMax = this.getInnerMinMax(stringBounder);
        double missingWidth = minMax.getMaxX() - orig.getWidth();
        if (missingWidth > 0.0) {
            return orig.addDim(missingWidth + 5.0, 0.0);
        }
        return orig;
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        FtileGeometry orig = this.getInnerDimension(stringBounder);
        double suppWidth = this.suppWidth(stringBounder);
        double width = orig.getWidth() + suppWidth;
        double height = orig.getHeight() + this.diffHeightTitle(stringBounder) + 20.0 + this.headerNoteHeight(stringBounder);
        double titleAndHeaderNoteHeight = this.diffHeightTitle(stringBounder) + this.headerNoteHeight(stringBounder);
        if (orig.hasPointOut()) {
            return new FtileGeometry(width, height, orig.getLeft() + suppWidth / 2.0, orig.getInY() + titleAndHeaderNoteHeight, orig.getOutY() + titleAndHeaderNoteHeight);
        }
        return new FtileGeometry(width, height, orig.getLeft() + suppWidth / 2.0, orig.getInY() + titleAndHeaderNoteHeight);
    }

    private double headerNoteHeight(StringBounder stringBounder) {
        return this.headerNote.calculateDimension(stringBounder).getHeight();
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        FtileGeometry dimTotal = this.calculateDimension(stringBounder);
        Fashion symbolContext = new Fashion(this.backColor, this.borderColor).withShadow(this.shadowing).withStroke(this.stroke).withCorner(this.roundCorner, 0.0);
        HorizontalAlignment align = this.inner.skinParam().getHorizontalAlignment(AlignmentParam.packageTitleAlignment, null, false, null);
        this.type.asBig(this.name, align, TextBlockUtils.empty(0.0, 0.0), ((XDimension2D)dimTotal).getWidth(), ((XDimension2D)dimTotal).getHeight(), symbolContext, this.skinParam().getStereotypeAlignment()).drawU(ug);
        XDimension2D dimHeaderNote = this.headerNote.calculateDimension(stringBounder);
        this.headerNote.drawU(ug.apply(new UTranslate(((XDimension2D)dimTotal).getWidth() - dimHeaderNote.getWidth() - 10.0, this.diffHeightTitle(ug.getStringBounder()) - 10.0)));
        ug.apply(this.getTranslate(stringBounder)).draw(this.inner);
    }
}

