/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.bpm;

import net.sourceforge.plantuml.bpm.Chain;
import net.sourceforge.plantuml.bpm.Navigator;

public final class Navigators {
    private Navigators() {
    }

    public static <O> Navigator<O> iterate(Chain<O> orig, O from, O to) {
        if (orig.compare(from, to) <= 0) {
            return orig.navigator(from);
        }
        return Navigators.reverse(orig.navigator(from));
    }

    public static <O> Navigator<O> reverse(final Navigator<O> orig) {
        return new Navigator<O>(){

            @Override
            public O next() {
                return orig.previous();
            }

            @Override
            public O previous() {
                return orig.next();
            }

            @Override
            public O get() {
                return orig.get();
            }

            @Override
            public void set(O data) {
                orig.set(data);
            }

            @Override
            public void insertBefore(O data) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void insertAfter(O data) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

