/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.AbstractIterable;
import scala.collection.AbstractIterator;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeqOps;
import scala.collection.IndexedSeqView;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.Seq;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StrictOptimizedSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.AbstractSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Range$;
import scala.collection.immutable.RangeIterator;
import scala.collection.mutable.Builder;
import scala.math.Ordering;
import scala.math.Ordering$Int$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.hashing.MurmurHash3$;

public abstract class Range
extends AbstractSeq<Object>
implements Serializable,
scala.collection.immutable.IndexedSeq<Object>,
scala.collection.immutable.StrictOptimizedSeqOps<Object, scala.collection.immutable.IndexedSeq, scala.collection.immutable.IndexedSeq<Object>> {
    private final int start;
    private final int end;
    private final int step;
    private final boolean isEmpty;
    public final int scala$collection$immutable$Range$$numRangeElements;
    public final int scala$collection$immutable$Range$$lastElement;

    /*
     * WARNING - void declaration
     */
    @Override
    public /* synthetic */ Object scala$collection$immutable$StrictOptimizedSeqOps$$super$sorted(Ordering ord) {
        void var1_1;
        return SeqOps.sorted$(this, (Ordering)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object distinctBy(Function1 f) {
        void var1_1;
        return scala.collection.immutable.StrictOptimizedSeqOps.distinctBy$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object updated(int index, Object elem) {
        void var2_2;
        void var1_1;
        return scala.collection.immutable.StrictOptimizedSeqOps.updated$(this, (int)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object prepended(Object elem) {
        void var1_1;
        return StrictOptimizedSeqOps.prepended$(this, (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object appended(Object elem) {
        void var1_1;
        return StrictOptimizedSeqOps.appended$(this, (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object appendedAll(IterableOnce suffix) {
        void var1_1;
        return StrictOptimizedSeqOps.appendedAll$(this, (IterableOnce)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tuple2<scala.collection.immutable.IndexedSeq<Object>, scala.collection.immutable.IndexedSeq<Object>> partition(Function1<Object, Object> p) {
        void var1_1;
        return StrictOptimizedIterableOps.partition$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <A1, A2> Tuple2<scala.collection.immutable.IndexedSeq<A1>, scala.collection.immutable.IndexedSeq<A2>> unzip(Function1<Object, Tuple2<A1, A2>> asPair) {
        void var1_1;
        return StrictOptimizedIterableOps.unzip$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object flatMap(Function1 f) {
        void var1_1;
        return StrictOptimizedIterableOps.flatMap$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object collect(PartialFunction pf) {
        void var1_1;
        return StrictOptimizedIterableOps.collect$(this, (PartialFunction)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object flatten(Function1 toIterableOnce) {
        void var1_1;
        return StrictOptimizedIterableOps.flatten$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object zip(IterableOnce that) {
        void var1_1;
        return StrictOptimizedIterableOps.zip$(this, (IterableOnce)var1_1);
    }

    @Override
    public Object zipWithIndex() {
        return StrictOptimizedIterableOps.zipWithIndex$(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object filter(Function1 pred) {
        void var1_1;
        return StrictOptimizedIterableOps.filter$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object filterNot(Function1 pred) {
        void var1_1;
        return StrictOptimizedIterableOps.filterNot$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object filterImpl(Function1 pred, boolean isFlipped) {
        void var2_2;
        void var1_1;
        return StrictOptimizedIterableOps.filterImpl$(this, (Function1)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public /* synthetic */ boolean scala$collection$immutable$IndexedSeq$$super$canEqual(Object that) {
        void var1_1;
        return Seq.canEqual$(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public /* synthetic */ boolean scala$collection$immutable$IndexedSeq$$super$sameElements(IterableOnce that) {
        void var1_1;
        return SeqOps.sameElements$(this, (IterableOnce)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean canEqual(Object that) {
        void var1_1;
        return scala.collection.immutable.IndexedSeq.canEqual$(this, (Object)var1_1);
    }

    @Override
    public SeqFactory<scala.collection.immutable.IndexedSeq> iterableFactory() {
        return scala.collection.immutable.IndexedSeq.iterableFactory$(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public /* synthetic */ Object scala$collection$immutable$IndexedSeqOps$$super$slice(int from, int until) {
        void var2_2;
        void var1_1;
        return IndexedSeqOps.slice$(this, (int)var1_1, (int)var2_2);
    }

    @Override
    public String stringPrefix() {
        return IndexedSeq.stringPrefix$(this);
    }

    @Override
    public Iterator<Object> reverseIterator() {
        return IndexedSeqOps.reverseIterator$(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <B$> B$ foldRight(B$ z, Function2<Object, B$, B$> op) {
        void var2_2;
        void var1_1;
        return (B$)IndexedSeqOps.foldRight$(this, (Object)var1_1, (Function2)var2_2);
    }

    @Override
    public IndexedSeqView<Object> view() {
        return IndexedSeqOps.view$(this);
    }

    @Override
    public Iterable<Object> reversed() {
        return IndexedSeqOps.reversed$(this);
    }

    @Override
    public Option<Object> headOption() {
        return IndexedSeqOps.headOption$(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int lengthCompare(int len) {
        void var1_1;
        return IndexedSeqOps.lengthCompare$(this, (int)var1_1);
    }

    @Override
    public int knownSize() {
        return IndexedSeqOps.knownSize$(this);
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public int step() {
        return this.step;
    }

    @Override
    public final Iterator<Object> iterator() {
        return new RangeIterator(this.start(), this.step(), this.scala$collection$immutable$Range$$lastElement, this.isEmpty());
    }

    private long gap() {
        return (long)this.end() - (long)this.start();
    }

    private boolean isExact() {
        return this.gap() % (long)this.step() == 0L;
    }

    private boolean hasStub() {
        return this.isInclusive() || !this.isExact();
    }

    private long longLength() {
        return this.gap() / (long)this.step() + (long)(this.hasStub() ? 1 : 0);
    }

    public abstract boolean isInclusive();

    @Override
    public final boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    public final int length() {
        if (this.scala$collection$immutable$Range$$numRangeElements < 0) {
            throw this.fail();
        }
        return this.scala$collection$immutable$Range$$numRangeElements;
    }

    @Override
    public final int last() {
        if (this.isEmpty()) {
            throw Range$.MODULE$.scala$collection$immutable$Range$$emptyRangeError("last");
        }
        return this.scala$collection$immutable$Range$$lastElement;
    }

    @Override
    public final int head() {
        if (this.isEmpty()) {
            throw Range$.MODULE$.scala$collection$immutable$Range$$emptyRangeError("head");
        }
        return this.start();
    }

    @Override
    public final Range tail() {
        if (this.isEmpty()) {
            throw Range$.MODULE$.scala$collection$immutable$Range$$emptyRangeError("tail");
        }
        if (this.scala$collection$immutable$Range$$numRangeElements == 1) {
            Range range = this;
            return range.newEmptyRange(range.end());
        }
        if (this.isInclusive()) {
            return new Inclusive(this.start() + this.step(), this.end(), this.step());
        }
        return new Exclusive(this.start() + this.step(), this.end(), this.step());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <B> scala.collection.immutable.IndexedSeq<B> map(Function1<Object, B> f) {
        void var2_2;
        this.scala$collection$immutable$Range$$validateMaxLength();
        Builder strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        Iterator strictOptimizedMap_it = this.iterator();
        while (strictOptimizedMap_it.hasNext()) {
            void strictOptimizedMap_$plus$eq_elem;
            B b = f.apply(strictOptimizedMap_it.next());
            if (strictOptimizedMap_b == null) {
                throw null;
            }
            strictOptimizedMap_b.addOne(strictOptimizedMap_$plus$eq_elem);
        }
        return (scala.collection.immutable.IndexedSeq)var2_2.result();
    }

    /*
     * WARNING - void declaration
     */
    public final Range copy(int start, int end, int step, boolean isInclusive) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (isInclusive) {
            return new Inclusive(start, end, step);
        }
        return new Exclusive((int)var1_1, (int)var2_2, (int)var3_3);
    }

    public void scala$collection$immutable$Range$$validateMaxLength() {
        if (this.scala$collection$immutable$Range$$numRangeElements < 0) {
            throw this.fail();
        }
    }

    private String description() {
        return StringOps$.MODULE$.format$extension("%d %s %d by %s", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{this.start(), this.isInclusive() ? "to" : "until", this.end(), this.step()}));
    }

    private Nothing$ fail() {
        throw new IllegalArgumentException(new StringBuilder(54).append(this.description()).append(": seqs cannot contain more than Int.MaxValue elements.").toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int apply(int idx) throws IndexOutOfBoundsException {
        void var1_1;
        return this.apply$mcII$sp((int)var1_1);
    }

    @Override
    public final <U> void foreach(Function1<Object, U> f) {
        if (!this.isEmpty()) {
            int i = this.start();
            while (true) {
                f.apply(i);
                if (i == this.scala$collection$immutable$Range$$lastElement) {
                    return;
                }
                i += this.step();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <B> int indexOf(B elem, int from) {
        void var2_3;
        void var1_1;
        int n;
        int pos;
        n = elem instanceof Integer ? ((pos = this.scala$collection$immutable$Range$$posOf(elem = BoxesRunTime.unboxToInt(elem))) >= from ? n : -1) : SeqOps.indexOf$(this, var1_1, (int)var2_3);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public int scala$collection$immutable$Range$$posOf(int i) {
        if (this.contains(i)) {
            void var1_1;
            return (int)((var1_1 - this.start()) / this.step());
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <B> boolean sameElements(IterableOnce<B> that2) {
        boolean bl;
        if (that2 instanceof Range) {
            boolean bl2;
            that2 = that2;
            int n = this.length();
            switch (n) {
                case 0: {
                    bl2 = that2.isEmpty();
                    break;
                }
                case 1: {
                    if (that2.length() == 1 && this.start() == that2.start()) {
                        bl2 = true;
                        break;
                    }
                    bl2 = false;
                    break;
                }
                default: {
                    bl2 = that2.length() == n && this.start() == that2.start() && this.step() == that2.step();
                }
            }
            boolean that2 = bl2;
        } else {
            void var1_1;
            bl = scala.collection.immutable.IndexedSeq.sameElements$(this, (IterableOnce)var1_1);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Range take(int n) {
        void var1_1;
        if (n <= 0 || this.isEmpty()) {
            Range range = this;
            return range.newEmptyRange(range.start());
        }
        if (n >= this.scala$collection$immutable$Range$$numRangeElements && this.scala$collection$immutable$Range$$numRangeElements >= 0) {
            return this;
        }
        return new Inclusive(this.start(), this.locationAfterN((int)(var1_1 - true)), this.step());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Range drop(int n) {
        void var1_1;
        if (n <= 0 || this.isEmpty()) {
            return this;
        }
        if (n >= this.scala$collection$immutable$Range$$numRangeElements && this.scala$collection$immutable$Range$$numRangeElements >= 0) {
            Range range = this;
            return range.newEmptyRange(range.end());
        }
        Range range = this;
        return range.copy(range.locationAfterN((int)var1_1), this.end(), this.step(), this.isInclusive());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Range takeRight(int n) {
        void var3_4;
        void var2_2;
        void var1_1;
        if (n <= 0) {
            Range range = this;
            return range.newEmptyRange(range.start());
        }
        if (this.scala$collection$immutable$Range$$numRangeElements >= 0) {
            Range range = this;
            return range.drop(range.scala$collection$immutable$Range$$numRangeElements - n);
        }
        int y = this.last();
        long x = (long)y - (long)this.step() * (long)(n - 1);
        if (this.step() > 0 && x < (long)this.start() || this.step() < 0 && x > (long)this.start()) {
            return this;
        }
        int inclusive_step = this.step();
        int inclusive_start = (int)x;
        return new Inclusive((int)var1_1, (int)var2_2, (int)var3_4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Range takeWhile(Function1<Object, Object> p) {
        void var3_4;
        void var1_2;
        void var2_3;
        long l;
        long l2;
        if (this.isEmpty()) {
            l2 = this.start();
        } else {
            int argTakeWhile_current;
            int argTakeWhile_stop = this.last();
            for (argTakeWhile_current = this.start(); argTakeWhile_current != argTakeWhile_stop && p.apply$mcZI$sp(argTakeWhile_current); argTakeWhile_current += this.step()) {
            }
            l2 = l = argTakeWhile_current != argTakeWhile_stop || !p.apply$mcZI$sp(argTakeWhile_current) ? (long)argTakeWhile_current : (long)argTakeWhile_current + (long)this.step();
        }
        if (l2 == (long)this.start()) {
            Range range = this;
            return range.newEmptyRange(range.start());
        }
        int x = (int)(l - (long)this.step());
        if (x == this.last()) {
            return this;
        }
        int inclusive_step = this.step();
        int inclusive_start = this.start();
        return new Inclusive((int)var2_3, (int)var1_2, (int)var3_4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Range dropWhile(Function1<Object, Object> p) {
        void var3_4;
        void var2_3;
        void var1_2;
        long l;
        int argTakeWhile_stop;
        long l2;
        if (this.isEmpty()) {
            l2 = this.start();
        } else {
            int argTakeWhile_current;
            argTakeWhile_stop = this.last();
            for (argTakeWhile_current = this.start(); argTakeWhile_current != argTakeWhile_stop && p.apply$mcZI$sp(argTakeWhile_current); argTakeWhile_current += this.step()) {
            }
            l2 = l = argTakeWhile_current != argTakeWhile_stop || !p.apply$mcZI$sp(argTakeWhile_current) ? (long)argTakeWhile_current : (long)argTakeWhile_current + (long)this.step();
        }
        if (l2 == (long)this.start()) {
            return this;
        }
        int x = (int)(l - (long)this.step());
        if (x == this.last()) {
            Range range = this;
            return range.newEmptyRange(range.last());
        }
        argTakeWhile_stop = this.step();
        int inclusive_end = this.last();
        int inclusive_start = x + this.step();
        return new Inclusive((int)var1_2, (int)var2_3, (int)var3_4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Range slice(int from, int until) {
        void var2_2;
        void var1_1;
        void var3_3;
        if (from <= 0) {
            return this.take(until);
        }
        if (until >= this.scala$collection$immutable$Range$$numRangeElements && this.scala$collection$immutable$Range$$numRangeElements >= 0) {
            return this.drop(from);
        }
        int fromValue = this.locationAfterN(from);
        if (from >= until) {
            return this.newEmptyRange(fromValue);
        }
        int inclusive_step = this.step();
        int inclusive_end = this.locationAfterN(until - 1);
        return new Inclusive((int)var3_3, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Tuple2<Range, Range> splitAt(int n) {
        void var1_1;
        return new Tuple2<Range, Range>(this.take(n), this.drop((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private int locationAfterN(int n) {
        void var1_1;
        return this.start() + this.step() * var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Exclusive newEmptyRange(int value) {
        void var1_1;
        void v0 = var1_1;
        return new Exclusive((int)v0, (int)v0, this.step());
    }

    @Override
    public final Range reverse() {
        if (this.isEmpty()) {
            return this;
        }
        return new Inclusive(this.last(), this.start(), -this.step());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean contains(int x) {
        void var1_1;
        if (x == this.end() && !this.isInclusive()) {
            return false;
        }
        if (this.step() > 0) {
            if (x < this.start() || x > this.end()) {
                return false;
            }
            return this.step() == 1 || (x - this.start()) % this.step() == 0;
        }
        if (x < this.end() || x > this.start()) {
            return false;
        }
        return this.step() == -1 || (var1_1 - this.start()) % this.step() == false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <B> boolean contains(B elem2) {
        boolean bl;
        if (elem2 instanceof Integer) {
            int elem2 = BoxesRunTime.unboxToInt(elem2);
            elem2 = this.contains(elem2) ? 1 : 0;
        } else {
            void var1_1;
            bl = SeqOps.contains$(this, var1_1);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <A1> int min(Ordering<A1> ord) {
        void var1_1;
        if (ord == Ordering$Int$.MODULE$) {
            if (this.step() > 0) {
                return this.head();
            }
            return this.last();
        }
        if (Ordering.CachedReverse.isReverseOf$(Ordering$Int$.MODULE$, ord)) {
            if (this.step() > 0) {
                return this.last();
            }
            return this.head();
        }
        return BoxesRunTime.unboxToInt(IterableOnceOps.min$(this, (Ordering)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <A1> int max(Ordering<A1> ord) {
        void var1_1;
        if (ord == Ordering$Int$.MODULE$) {
            if (this.step() > 0) {
                return this.last();
            }
            return this.head();
        }
        if (Ordering.CachedReverse.isReverseOf$(Ordering$Int$.MODULE$, ord)) {
            if (this.step() > 0) {
                return this.head();
            }
            return this.last();
        }
        return BoxesRunTime.unboxToInt(IterableOnceOps.max$(this, (Ordering)var1_1));
    }

    @Override
    public final int applyPreferredMaxLength() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(Object other2) {
        boolean bl;
        if (other2 instanceof Range) {
            void var2_3;
            int l0;
            other2 = (Range)other2;
            boolean other2 = this.isEmpty() ? ((Range)other2).isEmpty() : ((AbstractIterable)other2).nonEmpty() && this.start() == ((Range)other2).start() && (l0 = this.last()) == ((Range)other2).last() && (this.start() == var2_3 || this.step() == ((Range)other2).step());
        } else {
            void var1_1;
            bl = Seq.equals$(this, var1_1);
        }
        return bl;
    }

    @Override
    public final int hashCode() {
        if (this.length() >= 2) {
            return MurmurHash3$.MODULE$.rangeHash(this.start(), this.step(), this.scala$collection$immutable$Range$$lastElement);
        }
        return Seq.hashCode$(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String toString() {
        void var2_2;
        void var1_1;
        void var3_3;
        String stepped;
        String preposition = this.isInclusive() ? "to" : "until";
        String string = stepped = this.step() == 1 ? "" : new StringBuilder(4).append(" by ").append(this.step()).toString();
        String prefix = this.isEmpty() ? "empty " : (!this.isExact() ? "inexact " : "");
        return new StringBuilder(8).append((String)var3_3).append("Range ").append(this.start()).append(" ").append((String)var1_1).append(" ").append(this.end()).append((String)var2_2).toString();
    }

    @Override
    public String className() {
        return "Range";
    }

    @Override
    public Range distinct() {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Iterator<Range> grouped(int size) {
        void var1_1;
        if (!(size > 0)) {
            throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)Range.$anonfun$grouped$1(size)).toString());
        }
        if (this.isEmpty()) {
            return Iterator$.scala$collection$Iterator$$_empty;
        }
        return new AbstractIterator<Range>(this, (int)var1_1){
            private int i;
            private final /* synthetic */ Range $outer;
            private final int s$1;

            public final boolean hasNext() {
                return this.$outer.length() > this.i;
            }

            /*
             * WARNING - void declaration
             */
            public final Range next() {
                if (this.hasNext()) {
                    void var1_1;
                    Range x = this.$outer.slice(this.i, this.i + this.s$1);
                    this.i += this.s$1;
                    return var1_1;
                }
                return (Range)((Object)Iterator$.scala$collection$Iterator$$_empty.next());
            }
            {
                void var2_2;
                void var1_1;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = var1_1;
                this.s$1 = var2_2;
                this.i = 0;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <B> scala.collection.immutable.IndexedSeq<Object> sorted(Ordering<B> ord) {
        void var1_1;
        if (ord == Ordering$Int$.MODULE$) {
            if (this.step() > 0) {
                return this;
            }
            return this.reverse();
        }
        return (scala.collection.immutable.IndexedSeq)SeqOps.sorted$(this, (Ordering)var1_1);
    }

    public final void foreach$mVc$sp(Function1<Object, BoxedUnit> f) {
        if (!this.isEmpty()) {
            int i = this.start();
            while (true) {
                f.apply$mcVI$sp(i);
                if (i == this.scala$collection$immutable$Range$$lastElement) {
                    return;
                }
                i += this.step();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int apply$mcII$sp(int idx) {
        void var1_1;
        this.scala$collection$immutable$Range$$validateMaxLength();
        if (idx < 0 || idx >= this.scala$collection$immutable$Range$$numRangeElements) {
            throw new IndexOutOfBoundsException(new StringBuilder(31).append(idx).append(" is out of bounds (min 0, max ").append(this.scala$collection$immutable$Range$$numRangeElements - 1).append(")").toString());
        }
        return this.start() + this.step() * var1_1;
    }

    public static final /* synthetic */ String $anonfun$grouped$1(int size$1) {
        int n;
        return StringOps$.MODULE$.format$extension("size=%d, but size must be positive", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{n}));
    }

    /*
     * WARNING - void declaration
     */
    public Range(int start, int end, int step) {
        int n;
        long len;
        this.start = start;
        this.end = end;
        this.step = step;
        boolean bl = this.isEmpty = start > end && step > 0 || start < end && step < 0 || start == end && !this.isInclusive();
        if (step == 0) {
            throw new IllegalArgumentException("step cannot be 0.");
        }
        this.scala$collection$immutable$Range$$numRangeElements = this.isEmpty() ? 0 : ((len = this.longLength()) > Integer.MAX_VALUE ? -1 : (int)len);
        switch (step) {
            case 1: {
                if (this.isInclusive()) {
                    n = end;
                    break;
                }
                n = end - 1;
                break;
            }
            case -1: {
                if (this.isInclusive()) {
                    n = end;
                    break;
                }
                n = end + 1;
                break;
            }
            default: {
                void var3_3;
                void var2_2;
                void var1_1;
                int remainder = (int)(this.gap() % (long)step);
                n = remainder != 0 ? end - var1_1 : (this.isInclusive() ? end : var2_2 - var3_3);
            }
        }
        this.scala$collection$immutable$Range$$lastElement = n;
    }

    public static final class Exclusive
    extends Range {
        @Override
        public final boolean isInclusive() {
            return false;
        }

        /*
         * WARNING - void declaration
         */
        public Exclusive(int start, int end, int step) {
            super((int)var1_1, (int)var2_2, (int)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }
    }

    public static final class Inclusive
    extends Range {
        @Override
        public final boolean isInclusive() {
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public Inclusive(int start, int end, int step) {
            super((int)var1_1, (int)var2_2, (int)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }
    }
}

