/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.descriptor.tld;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.descriptor.Constants;
import org.apache.tomcat.util.descriptor.DigesterFactory;
import org.apache.tomcat.util.descriptor.XmlErrorHandler;
import org.apache.tomcat.util.descriptor.tld.TaglibXml;
import org.apache.tomcat.util.descriptor.tld.TldResourcePath;
import org.apache.tomcat.util.descriptor.tld.TldRuleSet;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.RuleSet;
import org.apache.tomcat.util.security.PrivilegedGetTccl;
import org.apache.tomcat.util.security.PrivilegedSetTccl;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TldParser {
    private final Log log = LogFactory.getLog(TldParser.class);
    private final Digester digester;

    public TldParser(boolean bl, boolean bl2, boolean bl3) {
        this(bl, bl2, new TldRuleSet(), bl3);
    }

    public TldParser(boolean bl, boolean bl2, RuleSet ruleSet, boolean bl3) {
        this.digester = DigesterFactory.newDigester(bl2, bl, ruleSet, bl3);
    }

    public TaglibXml parse(TldResourcePath tldResourcePath) throws IOException, SAXException {
        ClassLoader classLoader;
        Object object;
        Thread thread = Thread.currentThread();
        if (Constants.IS_SECURITY_ENABLED) {
            object = new PrivilegedGetTccl(thread);
            classLoader = (ClassLoader)AccessController.doPrivileged(object);
        } else {
            classLoader = thread.getContextClassLoader();
        }
        try {
            TaglibXml taglibXml;
            block17: {
                object = tldResourcePath.openStream();
                try {
                    Object object2;
                    if (Constants.IS_SECURITY_ENABLED) {
                        object2 = new PrivilegedSetTccl(thread, TldParser.class.getClassLoader());
                        AccessController.doPrivileged(object2);
                    } else {
                        thread.setContextClassLoader(TldParser.class.getClassLoader());
                    }
                    object2 = new XmlErrorHandler();
                    this.digester.setErrorHandler((ErrorHandler)object2);
                    TaglibXml taglibXml2 = new TaglibXml();
                    this.digester.push(taglibXml2);
                    InputSource inputSource = new InputSource(tldResourcePath.toExternalForm());
                    inputSource.setByteStream((InputStream)object);
                    this.digester.parse(inputSource);
                    if (!((XmlErrorHandler)object2).getWarnings().isEmpty() || !((XmlErrorHandler)object2).getErrors().isEmpty()) {
                        ((XmlErrorHandler)object2).logFindings(this.log, inputSource.getSystemId());
                        if (!((XmlErrorHandler)object2).getErrors().isEmpty()) {
                            throw ((XmlErrorHandler)object2).getErrors().iterator().next();
                        }
                    }
                    taglibXml = taglibXml2;
                    if (object == null) break block17;
                }
                catch (Throwable throwable) {
                    if (object != null) {
                        try {
                            ((InputStream)object).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ((InputStream)object).close();
            }
            return taglibXml;
        }
        finally {
            this.digester.reset();
            if (Constants.IS_SECURITY_ENABLED) {
                PrivilegedSetTccl privilegedSetTccl = new PrivilegedSetTccl(thread, classLoader);
                AccessController.doPrivileged(privilegedSetTccl);
            } else {
                thread.setContextClassLoader(classLoader);
            }
        }
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.digester.setClassLoader(classLoader);
    }
}

