/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.pool2.impl;

import java.security.AccessControlException;
import org.apache.tomcat.dbcp.pool2.impl.CallStack;
import org.apache.tomcat.dbcp.pool2.impl.SecurityManagerCallStack;
import org.apache.tomcat.dbcp.pool2.impl.ThrowableCallStack;

public final class CallStackUtils {
    private static boolean canCreateSecurityManager() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return true;
        }
        try {
            securityManager.checkPermission(new RuntimePermission("createSecurityManager"));
            return true;
        }
        catch (AccessControlException accessControlException) {
            return false;
        }
    }

    @Deprecated
    public static CallStack newCallStack(String string, boolean bl) {
        return CallStackUtils.newCallStack(string, bl, false);
    }

    public static CallStack newCallStack(String string, boolean bl, boolean bl2) {
        return CallStackUtils.canCreateSecurityManager() && !bl2 ? new SecurityManagerCallStack(string, bl) : new ThrowableCallStack(string, bl);
    }

    private CallStackUtils() {
    }
}

