/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletSecurityElement;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Wrapper;
import org.apache.catalina.util.ParameterMap;
import org.apache.tomcat.util.buf.UDecoder;
import org.apache.tomcat.util.res.StringManager;

public class ApplicationServletRegistration
implements ServletRegistration.Dynamic {
    private static final StringManager sm = StringManager.getManager(ApplicationServletRegistration.class);
    private final Wrapper wrapper;
    private final Context context;
    private ServletSecurityElement constraint;

    public ApplicationServletRegistration(Wrapper wrapper, Context context) {
        this.wrapper = wrapper;
        this.context = context;
    }

    public String getClassName() {
        return this.wrapper.getServletClass();
    }

    public String getInitParameter(String string) {
        return this.wrapper.findInitParameter(string);
    }

    public Map<String, String> getInitParameters() {
        String[] stringArray;
        ParameterMap<String, String> parameterMap = new ParameterMap<String, String>();
        for (String string : stringArray = this.wrapper.findInitParameters()) {
            parameterMap.put(string, this.wrapper.findInitParameter(string));
        }
        parameterMap.setLocked(true);
        return parameterMap;
    }

    public String getName() {
        return this.wrapper.getName();
    }

    public boolean setInitParameter(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException(sm.getString("applicationFilterRegistration.nullInitParam", new Object[]{string, string2}));
        }
        if (this.getInitParameter(string) != null) {
            return false;
        }
        this.wrapper.addInitParameter(string, string2);
        return true;
    }

    public Set<String> setInitParameters(Map<String, String> map) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) {
                throw new IllegalArgumentException(sm.getString("applicationFilterRegistration.nullInitParams", new Object[]{entry.getKey(), entry.getValue()}));
            }
            if (this.getInitParameter(entry.getKey()) == null) continue;
            hashSet.add(entry.getKey());
        }
        if (hashSet.isEmpty()) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.setInitParameter(entry.getKey(), entry.getValue());
            }
        }
        return hashSet;
    }

    public void setAsyncSupported(boolean bl) {
        this.wrapper.setAsyncSupported(bl);
    }

    public void setLoadOnStartup(int n) {
        this.wrapper.setLoadOnStartup(n);
    }

    public void setMultipartConfig(MultipartConfigElement multipartConfigElement) {
        this.wrapper.setMultipartConfigElement(multipartConfigElement);
    }

    public void setRunAsRole(String string) {
        this.wrapper.setRunAs(string);
    }

    public Set<String> setServletSecurity(ServletSecurityElement servletSecurityElement) {
        if (servletSecurityElement == null) {
            throw new IllegalArgumentException(sm.getString("applicationServletRegistration.setServletSecurity.iae", new Object[]{this.getName(), this.context.getName()}));
        }
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationServletRegistration.setServletSecurity.ise", new Object[]{this.getName(), this.context.getName()}));
        }
        this.constraint = servletSecurityElement;
        return this.context.addServletSecurity(this, servletSecurityElement);
    }

    public Set<String> addMapping(String ... stringArray) {
        if (stringArray == null) {
            return Collections.emptySet();
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : stringArray) {
            String string2 = this.context.findServletMapping(string);
            if (string2 == null) continue;
            Wrapper wrapper = (Wrapper)this.context.findChild(string2);
            if (wrapper.isOverridable()) {
                this.context.removeServletMapping(string);
                continue;
            }
            hashSet.add(string);
        }
        if (!hashSet.isEmpty()) {
            return hashSet;
        }
        for (String string : stringArray) {
            this.context.addServletMappingDecoded(UDecoder.URLDecode((String)string, (Charset)StandardCharsets.UTF_8), this.wrapper.getName());
        }
        if (this.constraint != null) {
            this.context.addServletSecurity(this, this.constraint);
        }
        return Collections.emptySet();
    }

    public Collection<String> getMappings() {
        String[] stringArray;
        HashSet<String> hashSet = new HashSet<String>();
        String string = this.wrapper.getName();
        for (String string2 : stringArray = this.context.findServletMappings()) {
            String string3 = this.context.findServletMapping(string2);
            if (!string3.equals(string)) continue;
            hashSet.add(string2);
        }
        return hashSet;
    }

    public String getRunAsRole() {
        return this.wrapper.getRunAs();
    }
}

