/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.servlets;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.util.IOTools;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.compat.JrePlatform;
import org.apache.tomcat.util.res.StringManager;

public final class CGIServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(CGIServlet.class);
    private static final StringManager sm = StringManager.getManager(CGIServlet.class);
    private static final long serialVersionUID = 1L;
    private static final Set<String> DEFAULT_SUPER_METHODS = new HashSet<String>();
    private static final Pattern DEFAULT_CMD_LINE_ARGUMENTS_DECODED_PATTERN;
    private static final String ALLOW_ANY_PATTERN = ".*";
    private String cgiPathPrefix = null;
    private String cgiExecutable = "perl";
    private List<String> cgiExecutableArgs = null;
    private String parameterEncoding = System.getProperty("file.encoding", "UTF-8");
    private Set<String> cgiMethods = new HashSet<String>();
    private boolean cgiMethodsAll = false;
    private long stderrTimeout = 2000L;
    private Pattern envHttpHeadersPattern = Pattern.compile("ACCEPT[-0-9A-Z]*|CACHE-CONTROL|COOKIE|HOST|IF-[-0-9A-Z]*|REFERER|USER-AGENT");
    private static final Object expandFileLock;
    private final Hashtable<String, String> shellEnv = new Hashtable();
    private boolean enableCmdLineArguments = false;
    private Pattern cmdLineArgumentsEncodedPattern = Pattern.compile("[\\w\\Q%;/?:@&,$-.!~*'()\\E]+");
    private Pattern cmdLineArgumentsDecodedPattern = DEFAULT_CMD_LINE_ARGUMENTS_DECODED_PATTERN;

    public void init(ServletConfig servletConfig) throws ServletException {
        Object object;
        super.init(servletConfig);
        this.cgiPathPrefix = this.getServletConfig().getInitParameter("cgiPathPrefix");
        boolean bl = Boolean.parseBoolean(this.getServletConfig().getInitParameter("passShellEnvironment"));
        if (bl) {
            this.shellEnv.putAll(System.getenv());
        }
        Enumeration enumeration = servletConfig.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!((String)object).startsWith("environment-variable-")) continue;
            if (((String)object).length() == 21) {
                throw new ServletException(sm.getString("cgiServlet.emptyEnvVarName"));
            }
            this.shellEnv.put(((String)object).substring(21), servletConfig.getInitParameter((String)object));
        }
        if (this.getServletConfig().getInitParameter("executable") != null) {
            this.cgiExecutable = this.getServletConfig().getInitParameter("executable");
        }
        if (this.getServletConfig().getInitParameter("executable-arg-1") != null) {
            String[] stringArray;
            object = new ArrayList();
            int n = 1;
            while ((stringArray = this.getServletConfig().getInitParameter("executable-arg-" + n)) != null) {
                object.add(stringArray);
                ++n;
            }
            this.cgiExecutableArgs = object;
        }
        if (this.getServletConfig().getInitParameter("parameterEncoding") != null) {
            this.parameterEncoding = this.getServletConfig().getInitParameter("parameterEncoding");
        }
        if (this.getServletConfig().getInitParameter("stderrTimeout") != null) {
            this.stderrTimeout = Long.parseLong(this.getServletConfig().getInitParameter("stderrTimeout"));
        }
        if (this.getServletConfig().getInitParameter("envHttpHeaders") != null) {
            this.envHttpHeadersPattern = Pattern.compile(this.getServletConfig().getInitParameter("envHttpHeaders"));
        }
        if (this.getServletConfig().getInitParameter("enableCmdLineArguments") != null) {
            this.enableCmdLineArguments = Boolean.parseBoolean(servletConfig.getInitParameter("enableCmdLineArguments"));
        }
        if (this.getServletConfig().getInitParameter("cgiMethods") != null) {
            object = this.getServletConfig().getInitParameter("cgiMethods");
            if ("*".equals(object = ((String)object).trim())) {
                this.cgiMethodsAll = true;
            } else {
                String[] stringArray;
                for (String string : stringArray = ((String)object).split(",")) {
                    String string2 = string.trim();
                    this.cgiMethods.add(string2);
                }
            }
        } else {
            this.cgiMethods.add("GET");
            this.cgiMethods.add("POST");
        }
        if (this.getServletConfig().getInitParameter("cmdLineArgumentsEncoded") != null) {
            this.cmdLineArgumentsEncodedPattern = Pattern.compile(this.getServletConfig().getInitParameter("cmdLineArgumentsEncoded"));
        }
        if (ALLOW_ANY_PATTERN.equals(object = this.getServletConfig().getInitParameter("cmdLineArgumentsDecoded"))) {
            this.cmdLineArgumentsDecodedPattern = null;
        } else if (object != null) {
            this.cmdLineArgumentsDecodedPattern = Pattern.compile((String)object);
        }
    }

    private void printServletEnvironment(HttpServletRequest httpServletRequest) throws IOException {
        Cookie[] cookieArray;
        Object object2;
        Object object3;
        log.trace((Object)"ServletRequest Properties");
        Enumeration enumeration = httpServletRequest.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            object3 = (String)enumeration.nextElement();
            log.trace((Object)("Request Attribute: " + (String)object3 + ": [ " + httpServletRequest.getAttribute((String)object3) + "]"));
        }
        log.trace((Object)("Character Encoding: [" + httpServletRequest.getCharacterEncoding() + "]"));
        log.trace((Object)("Content Length: [" + httpServletRequest.getContentLengthLong() + "]"));
        log.trace((Object)("Content Type: [" + httpServletRequest.getContentType() + "]"));
        object3 = httpServletRequest.getLocales();
        while (object3.hasMoreElements()) {
            object2 = (Locale)object3.nextElement();
            log.trace((Object)("Locale: [" + object2 + "]"));
        }
        object2 = httpServletRequest.getParameterNames();
        while (object2.hasMoreElements()) {
            cookieArray = (Cookie[])object2.nextElement();
            for (String object4 : httpServletRequest.getParameterValues((String)cookieArray)) {
                log.trace((Object)("Request Parameter: " + (String)cookieArray + ":  [" + object4 + "]"));
            }
        }
        log.trace((Object)("Protocol: [" + httpServletRequest.getProtocol() + "]"));
        log.trace((Object)("Remote Address: [" + httpServletRequest.getRemoteAddr() + "]"));
        log.trace((Object)("Remote Host: [" + httpServletRequest.getRemoteHost() + "]"));
        log.trace((Object)("Scheme: [" + httpServletRequest.getScheme() + "]"));
        log.trace((Object)("Secure: [" + httpServletRequest.isSecure() + "]"));
        log.trace((Object)("Server Name: [" + httpServletRequest.getServerName() + "]"));
        log.trace((Object)("Server Port: [" + httpServletRequest.getServerPort() + "]"));
        log.trace((Object)"HttpServletRequest Properties");
        log.trace((Object)("Auth Type: [" + httpServletRequest.getAuthType() + "]"));
        log.trace((Object)("Context Path: [" + httpServletRequest.getContextPath() + "]"));
        cookieArray = httpServletRequest.getCookies();
        if (cookieArray != null) {
            for (Cookie cookie : cookieArray) {
                log.trace((Object)("Cookie: " + cookie.getName() + ": [" + cookie.getValue() + "]"));
            }
        }
        Enumeration enumeration2 = httpServletRequest.getHeaderNames();
        while (enumeration2.hasMoreElements()) {
            String string = (String)enumeration2.nextElement();
            log.trace((Object)("HTTP Header: " + string + ": [" + httpServletRequest.getHeader(string) + "]"));
        }
        log.trace((Object)("Method: [" + httpServletRequest.getMethod() + "]"));
        log.trace((Object)("Path Info: [" + httpServletRequest.getPathInfo() + "]"));
        log.trace((Object)("Path Translated: [" + httpServletRequest.getPathTranslated() + "]"));
        log.trace((Object)("Query String: [" + httpServletRequest.getQueryString() + "]"));
        log.trace((Object)("Remote User: [" + httpServletRequest.getRemoteUser() + "]"));
        log.trace((Object)("Requested Session ID: [" + httpServletRequest.getRequestedSessionId() + "]"));
        log.trace((Object)("Requested Session ID From Cookie: [" + httpServletRequest.isRequestedSessionIdFromCookie() + "]"));
        log.trace((Object)("Requested Session ID From URL: [" + httpServletRequest.isRequestedSessionIdFromURL() + "]"));
        log.trace((Object)("Requested Session ID Valid: [" + httpServletRequest.isRequestedSessionIdValid() + "]"));
        log.trace((Object)("Request URI: [" + httpServletRequest.getRequestURI() + "]"));
        log.trace((Object)("Servlet Path: [" + httpServletRequest.getServletPath() + "]"));
        log.trace((Object)("User Principal: [" + httpServletRequest.getUserPrincipal() + "]"));
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            log.trace((Object)"HttpSession Properties");
            log.trace((Object)("ID: [" + httpSession.getId() + "]"));
            log.trace((Object)("Creation Time: [" + new Date(httpSession.getCreationTime()) + "]"));
            log.trace((Object)("Last Accessed Time: [" + new Date(httpSession.getLastAccessedTime()) + "]"));
            log.trace((Object)("Max Inactive Interval: [" + httpSession.getMaxInactiveInterval() + "]"));
            enumeration = httpSession.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                log.trace((Object)("Session Attribute: " + string + ": [" + httpSession.getAttribute(string) + "]"));
            }
        }
        log.trace((Object)"ServletConfig Properties");
        log.trace((Object)("Servlet Name: [" + this.getServletConfig().getServletName() + "]"));
        object2 = this.getServletConfig().getInitParameterNames();
        while (object2.hasMoreElements()) {
            String string = (String)object2.nextElement();
            String string2 = this.getServletConfig().getInitParameter(string);
            log.trace((Object)("Servlet Init Param: " + string + ": [" + string2 + "]"));
        }
        log.trace((Object)"ServletContext Properties");
        log.trace((Object)("Major Version: [" + this.getServletContext().getMajorVersion() + "]"));
        log.trace((Object)("Minor Version: [" + this.getServletContext().getMinorVersion() + "]"));
        log.trace((Object)("Real Path for '/': [" + this.getServletContext().getRealPath("/") + "]"));
        log.trace((Object)("Server Info: [" + this.getServletContext().getServerInfo() + "]"));
        log.trace((Object)"ServletContext Initialization Parameters");
        object2 = this.getServletContext().getInitParameterNames();
        while (object2.hasMoreElements()) {
            String string = (String)object2.nextElement();
            String string3 = this.getServletContext().getInitParameter(string);
            log.trace((Object)("Servlet Context Init Param: " + string + ": [" + string3 + "]"));
        }
        log.trace((Object)"ServletContext Attributes");
        enumeration = this.getServletContext().getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            log.trace((Object)("Servlet Context Attribute: " + string + ": [" + this.getServletContext().getAttribute(string) + "]"));
        }
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getMethod();
        if (this.cgiMethodsAll || this.cgiMethods.contains(string)) {
            this.doGet(httpServletRequest, httpServletResponse);
        } else if (DEFAULT_SUPER_METHODS.contains(string)) {
            super.service(httpServletRequest, httpServletResponse);
        } else {
            httpServletResponse.sendError(405);
        }
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        CGIEnvironment cGIEnvironment = new CGIEnvironment(httpServletRequest, this.getServletContext());
        if (cGIEnvironment.isValid()) {
            object = new CGIRunner(cGIEnvironment.getCommand(), cGIEnvironment.getEnvironment(), cGIEnvironment.getWorkingDirectory(), cGIEnvironment.getParameters());
            if ("POST".equals(httpServletRequest.getMethod())) {
                ((CGIRunner)object).setInput((InputStream)httpServletRequest.getInputStream());
            }
            ((CGIRunner)object).setResponse(httpServletResponse);
            ((CGIRunner)object).run();
        } else {
            httpServletResponse.sendError(404);
        }
        if (log.isTraceEnabled()) {
            object = cGIEnvironment.toString().split(System.lineSeparator());
            for (String string : object) {
                log.trace((Object)string);
            }
            this.printServletEnvironment(httpServletRequest);
        }
    }

    protected void doOptions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.cgiMethods);
        hashSet.addAll(DEFAULT_SUPER_METHODS);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : hashSet) {
            stringBuilder.append(string);
            stringBuilder.append(',');
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        httpServletResponse.setHeader("allow", stringBuilder.toString());
    }

    private boolean setStatus(HttpServletResponse httpServletResponse, int n) throws IOException {
        if (n >= 400) {
            httpServletResponse.sendError(n);
            return true;
        }
        httpServletResponse.setStatus(n);
        return false;
    }

    static {
        DEFAULT_SUPER_METHODS.add("HEAD");
        DEFAULT_SUPER_METHODS.add("OPTIONS");
        DEFAULT_SUPER_METHODS.add("TRACE");
        DEFAULT_CMD_LINE_ARGUMENTS_DECODED_PATTERN = JrePlatform.IS_WINDOWS ? Pattern.compile("[\\w\\Q-.\\/:\\E]+") : null;
        expandFileLock = new Object();
    }

    protected static class HTTPHeaderInputStream
    extends InputStream {
        private static final int STATE_CHARACTER = 0;
        private static final int STATE_FIRST_CR = 1;
        private static final int STATE_FIRST_LF = 2;
        private static final int STATE_SECOND_CR = 3;
        private static final int STATE_HEADER_END = 4;
        private final InputStream input;
        private int state;

        HTTPHeaderInputStream(InputStream inputStream) {
            this.input = inputStream;
            this.state = 0;
        }

        @Override
        public int read() throws IOException {
            if (this.state == 4) {
                return -1;
            }
            int n = this.input.read();
            if (n == 10) {
                switch (this.state) {
                    case 0: {
                        this.state = 2;
                        break;
                    }
                    case 1: {
                        this.state = 2;
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.state = 4;
                    }
                }
            } else if (n == 13) {
                switch (this.state) {
                    case 0: {
                        this.state = 1;
                        break;
                    }
                    case 1: {
                        this.state = 4;
                        break;
                    }
                    case 2: {
                        this.state = 3;
                    }
                }
            } else {
                this.state = 0;
            }
            return n;
        }
    }

    protected class CGIRunner {
        private final String command;
        private final Hashtable<String, String> env;
        private final File wd;
        private final ArrayList<String> params;
        private InputStream stdin = null;
        private HttpServletResponse response = null;
        private boolean readyToRun = false;

        protected CGIRunner(String string, Hashtable<String, String> hashtable, File file, ArrayList<String> arrayList) {
            this.command = string;
            this.env = hashtable;
            this.wd = file;
            this.params = arrayList;
            this.updateReadyStatus();
        }

        protected void updateReadyStatus() {
            this.readyToRun = this.command != null && this.env != null && this.wd != null && this.params != null && this.response != null;
        }

        protected boolean isReady() {
            return this.readyToRun;
        }

        protected void setResponse(HttpServletResponse httpServletResponse) {
            this.response = httpServletResponse;
            this.updateReadyStatus();
        }

        protected void setInput(InputStream inputStream) {
            this.stdin = inputStream;
            this.updateReadyStatus();
        }

        protected String[] hashToStringArray(Hashtable<String, ?> hashtable) throws NullPointerException {
            ArrayList<String> arrayList = new ArrayList<String>(hashtable.size());
            Enumeration<String> enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                arrayList.add(string + "=" + hashtable.get(string).toString());
            }
            return arrayList.toArray(new String[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void run() throws IOException {
            if (!this.isReady()) {
                throw new IOException(this.getClass().getName() + ": not ready to run.");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("envp: [" + this.env + "], command: [" + this.command + "]"));
            }
            if (this.command.contains(File.separator + "." + File.separator) || this.command.contains(File.separator + "..") || this.command.contains(".." + File.separator)) {
                throw new IOException(this.getClass().getName() + "Illegal Character in CGI command path ('.' or '..') detected.  Not running CGI [" + this.command + "].");
            }
            Runtime runtime = null;
            BufferedReader bufferedReader = null;
            InputStream inputStream = null;
            BufferedReader bufferedReader2 = null;
            Thread thread = null;
            BufferedOutputStream bufferedOutputStream = null;
            Process process = null;
            int n = -1;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (CGIServlet.this.cgiExecutable.length() != 0) {
                arrayList.add(CGIServlet.this.cgiExecutable);
            }
            if (CGIServlet.this.cgiExecutableArgs != null) {
                arrayList.addAll(CGIServlet.this.cgiExecutableArgs);
            }
            arrayList.add(this.command);
            arrayList.addAll(this.params);
            try {
                runtime = Runtime.getRuntime();
                process = runtime.exec(arrayList.toArray(new String[0]), this.hashToStringArray(this.env), this.wd);
                String string = this.env.get("CONTENT_LENGTH");
                if (!"".equals(string)) {
                    bufferedOutputStream = new BufferedOutputStream(process.getOutputStream());
                    IOTools.flow(this.stdin, bufferedOutputStream);
                    bufferedOutputStream.flush();
                    bufferedOutputStream.close();
                }
                boolean bl = true;
                BufferedReader bufferedReader3 = bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                thread = new Thread(() -> this.sendToLog(bufferedReader3));
                thread.start();
                HTTPHeaderInputStream hTTPHeaderInputStream = new HTTPHeaderInputStream(process.getInputStream());
                bufferedReader = new BufferedReader(new InputStreamReader(hTTPHeaderInputStream));
                boolean bl2 = false;
                while (bl) {
                    try {
                        Object object;
                        Object object2;
                        String string2 = null;
                        while ((string2 = bufferedReader.readLine()) != null && !string2.isEmpty()) {
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("addHeader(\"" + string2 + "\")"));
                            }
                            if (string2.startsWith("HTTP")) {
                                bl2 = CGIServlet.this.setStatus(this.response, this.getSCFromHttpStatusLine(string2));
                                continue;
                            }
                            if (string2.indexOf(58) >= 0) {
                                object2 = string2.substring(0, string2.indexOf(58)).trim();
                                object = string2.substring(string2.indexOf(58) + 1).trim();
                                if (((String)object2).equalsIgnoreCase("status")) {
                                    bl2 = CGIServlet.this.setStatus(this.response, this.getSCFromCGIStatusHeader((String)object));
                                    continue;
                                }
                                this.response.addHeader((String)object2, (String)object);
                                continue;
                            }
                            log.info((Object)sm.getString("cgiServlet.runBadHeader", new Object[]{string2}));
                        }
                        object2 = new byte[2048];
                        object = this.response.getOutputStream();
                        inputStream = process.getInputStream();
                        try {
                            while (!bl2 && (n = inputStream.read((byte[])object2)) != -1) {
                                if (log.isTraceEnabled()) {
                                    log.trace((Object)("output " + n + " bytes of data"));
                                }
                                object.write((byte[])object2, 0, n);
                            }
                        }
                        finally {
                            if (n != -1) {
                                while ((n = inputStream.read((byte[])object2)) != -1) {
                                }
                            }
                        }
                        process.exitValue();
                        bl = false;
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            catch (IOException iOException) {
                log.warn((Object)sm.getString("cgiServlet.runFail"), (Throwable)iOException);
                throw iOException;
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        log.warn((Object)sm.getString("cgiServlet.runHeaderReaderFail"), (Throwable)iOException);
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        log.warn((Object)sm.getString("cgiServlet.runOutputStreamFail"), (Throwable)iOException);
                    }
                }
                if (thread != null) {
                    try {
                        thread.join(CGIServlet.this.stderrTimeout);
                    }
                    catch (InterruptedException interruptedException) {
                        log.warn((Object)sm.getString("cgiServlet.runReaderInterrupt"));
                    }
                }
                if (process != null) {
                    process.destroy();
                    process = null;
                }
            }
        }

        private int getSCFromHttpStatusLine(String string) {
            int n;
            int n2 = string.indexOf(32) + 1;
            if (n2 < 1 || string.length() < n2 + 3) {
                log.warn((Object)sm.getString("cgiServlet.runInvalidStatus", new Object[]{string}));
                return 500;
            }
            String string2 = string.substring(n2, n2 + 3);
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                log.warn((Object)sm.getString("cgiServlet.runInvalidStatus", new Object[]{string2}));
                return 500;
            }
            return n;
        }

        private int getSCFromCGIStatusHeader(String string) {
            int n;
            if (string.length() < 3) {
                log.warn((Object)sm.getString("cgiServlet.runInvalidStatus", new Object[]{string}));
                return 500;
            }
            String string2 = string.substring(0, 3);
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                log.warn((Object)sm.getString("cgiServlet.runInvalidStatus", new Object[]{string2}));
                return 500;
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendToLog(BufferedReader bufferedReader) {
            String string = null;
            int n = 0;
            try {
                while ((string = bufferedReader.readLine()) != null) {
                    log.warn((Object)sm.getString("cgiServlet.runStdErr", new Object[]{string}));
                    ++n;
                }
            }
            catch (IOException iOException) {
                log.warn((Object)sm.getString("cgiServlet.runStdErrFail"), (Throwable)iOException);
            }
            finally {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    log.warn((Object)sm.getString("cgiServlet.runStdErrFail"), (Throwable)iOException);
                }
            }
            if (n > 0) {
                log.warn((Object)sm.getString("cgiServlet.runStdErrCount", new Object[]{n}));
            }
        }
    }

    protected class CGIEnvironment {
        private ServletContext context = null;
        private String contextPath = null;
        private String servletPath = null;
        private String pathInfo = null;
        private String webAppRootDir = null;
        private File tmpDir = null;
        private Hashtable<String, String> env = null;
        private String command = null;
        private final File workingDirectory;
        private final ArrayList<String> cmdLineParameters = new ArrayList();
        private final boolean valid;

        protected CGIEnvironment(HttpServletRequest httpServletRequest, ServletContext servletContext) throws IOException {
            this.setupFromContext(servletContext);
            boolean bl = this.setupFromRequest(httpServletRequest);
            if (bl) {
                bl = this.setCGIEnvironment(httpServletRequest);
            }
            this.workingDirectory = bl ? new File(this.command.substring(0, this.command.lastIndexOf(File.separator))) : null;
            this.valid = bl;
        }

        protected void setupFromContext(ServletContext servletContext) {
            this.context = servletContext;
            this.webAppRootDir = servletContext.getRealPath("/");
            this.tmpDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
        }

        protected boolean setupFromRequest(HttpServletRequest httpServletRequest) throws UnsupportedEncodingException {
            String string;
            boolean bl = false;
            if (httpServletRequest.getAttribute("javax.servlet.include.request_uri") != null) {
                bl = true;
            }
            if (bl) {
                this.contextPath = (String)httpServletRequest.getAttribute("javax.servlet.include.context_path");
                this.servletPath = (String)httpServletRequest.getAttribute("javax.servlet.include.servlet_path");
                this.pathInfo = (String)httpServletRequest.getAttribute("javax.servlet.include.path_info");
            } else {
                this.contextPath = httpServletRequest.getContextPath();
                this.servletPath = httpServletRequest.getServletPath();
                this.pathInfo = httpServletRequest.getPathInfo();
            }
            if (this.pathInfo == null) {
                this.pathInfo = this.servletPath;
            }
            if (CGIServlet.this.enableCmdLineArguments && (httpServletRequest.getMethod().equals("GET") || httpServletRequest.getMethod().equals("POST") || httpServletRequest.getMethod().equals("HEAD")) && (string = bl ? (String)httpServletRequest.getAttribute("javax.servlet.include.query_string") : httpServletRequest.getQueryString()) != null && string.indexOf(61) == -1) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "+");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (!CGIServlet.this.cmdLineArgumentsEncodedPattern.matcher(string2).matches()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)sm.getString("cgiServlet.invalidArgumentEncoded", new Object[]{string2, CGIServlet.this.cmdLineArgumentsEncodedPattern.toString()}));
                        }
                        return false;
                    }
                    String string3 = URLDecoder.decode(string2, CGIServlet.this.parameterEncoding);
                    if (CGIServlet.this.cmdLineArgumentsDecodedPattern != null && !CGIServlet.this.cmdLineArgumentsDecodedPattern.matcher(string3).matches()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)sm.getString("cgiServlet.invalidArgumentDecoded", new Object[]{string3, CGIServlet.this.cmdLineArgumentsDecodedPattern.toString()}));
                        }
                        return false;
                    }
                    this.cmdLineParameters.add(string3);
                }
            }
            return true;
        }

        protected String[] findCGI(String string, String string2, String string3, String string4, String string5) {
            String string6;
            String string7 = null;
            String string8 = null;
            String string9 = null;
            if (string2 != null && string2.lastIndexOf(File.separator) == string2.length() - 1) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (string5 != null) {
                string2 = string2 + File.separator + string5;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("cgiServlet.find.path", new Object[]{string, string2}));
            }
            File file = new File(string2);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("cgiServlet.find.location", new Object[]{file.getAbsolutePath()}));
            }
            StringBuilder stringBuilder = new StringBuilder();
            while (!file.isFile() && stringTokenizer.hasMoreElements()) {
                string6 = (String)stringTokenizer.nextElement();
                file = new File(file, string6);
                stringBuilder.append('/').append(string6);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)sm.getString("cgiServlet.find.location", new Object[]{file.getAbsolutePath()}));
            }
            string6 = stringBuilder.toString();
            if (!file.isFile()) {
                return new String[]{null, null, null, null};
            }
            string7 = file.getAbsolutePath();
            string8 = file.getName();
            string9 = string4.startsWith(string6) ? string3 + string6 : string3 + string4 + string6;
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("cgiServlet.find.found", new Object[]{string8, string7, string9, string6}));
            }
            return new String[]{string7, string9, string6, string8};
        }

        protected boolean setCGIEnvironment(HttpServletRequest httpServletRequest) throws IOException {
            Hashtable<String, String> hashtable = new Hashtable<String, String>(CGIServlet.this.shellEnv);
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            string = this.pathInfo;
            String string8 = string = string == null ? "" : string;
            if (this.webAppRootDir == null) {
                this.webAppRootDir = this.tmpDir.toString();
                this.expandCGIScript();
            }
            String[] stringArray = this.findCGI(string, this.webAppRootDir, this.contextPath, this.servletPath, CGIServlet.this.cgiPathPrefix);
            string4 = stringArray[0];
            string5 = stringArray[1];
            string6 = stringArray[2];
            string7 = stringArray[3];
            if (string4 == null || string5 == null || string6 == null || string7 == null) {
                return false;
            }
            hashtable.put("SERVER_SOFTWARE", "TOMCAT");
            hashtable.put("SERVER_NAME", this.nullsToBlanks(httpServletRequest.getServerName()));
            hashtable.put("GATEWAY_INTERFACE", "CGI/1.1");
            hashtable.put("SERVER_PROTOCOL", this.nullsToBlanks(httpServletRequest.getProtocol()));
            int n = httpServletRequest.getServerPort();
            Integer n2 = n == 0 ? Integer.valueOf(-1) : Integer.valueOf(n);
            hashtable.put("SERVER_PORT", n2.toString());
            hashtable.put("REQUEST_METHOD", this.nullsToBlanks(httpServletRequest.getMethod()));
            hashtable.put("REQUEST_URI", this.nullsToBlanks(httpServletRequest.getRequestURI()));
            string2 = this.pathInfo == null || this.pathInfo.substring(string6.length()).length() <= 0 ? "" : this.pathInfo.substring(string6.length());
            hashtable.put("PATH_INFO", string2);
            if (!string2.isEmpty()) {
                string3 = this.context.getRealPath(string2);
            }
            if (string3 != null && !"".equals(string3)) {
                hashtable.put("PATH_TRANSLATED", this.nullsToBlanks(string3));
            }
            hashtable.put("SCRIPT_NAME", this.nullsToBlanks(string5));
            hashtable.put("QUERY_STRING", this.nullsToBlanks(httpServletRequest.getQueryString()));
            hashtable.put("REMOTE_HOST", this.nullsToBlanks(httpServletRequest.getRemoteHost()));
            hashtable.put("REMOTE_ADDR", this.nullsToBlanks(httpServletRequest.getRemoteAddr()));
            hashtable.put("AUTH_TYPE", this.nullsToBlanks(httpServletRequest.getAuthType()));
            hashtable.put("REMOTE_USER", this.nullsToBlanks(httpServletRequest.getRemoteUser()));
            hashtable.put("REMOTE_IDENT", "");
            hashtable.put("CONTENT_TYPE", this.nullsToBlanks(httpServletRequest.getContentType()));
            long l = httpServletRequest.getContentLengthLong();
            String string9 = l <= 0L ? "" : Long.toString(l);
            hashtable.put("CONTENT_LENGTH", string9);
            Enumeration enumeration = httpServletRequest.getHeaderNames();
            String string10 = null;
            while (enumeration.hasMoreElements()) {
                string10 = null;
                string10 = ((String)enumeration.nextElement()).toUpperCase(Locale.ENGLISH);
                if (!CGIServlet.this.envHttpHeadersPattern.matcher(string10).matches()) continue;
                hashtable.put("HTTP_" + string10.replace('-', '_'), httpServletRequest.getHeader(string10));
            }
            File file = new File(string4);
            this.command = file.getCanonicalPath();
            hashtable.put("X_TOMCAT_SCRIPT_PATH", this.command);
            hashtable.put("SCRIPT_FILENAME", this.command);
            this.env = hashtable;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        protected void expandCGIScript() {
            InputStream inputStream;
            StringBuilder stringBuilder;
            block32: {
                Object object;
                StringBuilder stringBuilder2;
                block31: {
                    block30: {
                        block29: {
                            block28: {
                                stringBuilder = new StringBuilder();
                                stringBuilder2 = new StringBuilder();
                                inputStream = null;
                                if (CGIServlet.this.cgiPathPrefix == null) {
                                    stringBuilder.append(this.pathInfo);
                                    inputStream = this.context.getResourceAsStream(stringBuilder.toString());
                                    stringBuilder2.append(this.tmpDir);
                                    stringBuilder2.append(this.pathInfo);
                                } else {
                                    stringBuilder.append(CGIServlet.this.cgiPathPrefix);
                                    object = new StringTokenizer(this.pathInfo, "/");
                                    while (((StringTokenizer)object).hasMoreElements() && inputStream == null) {
                                        stringBuilder.append('/');
                                        stringBuilder.append(((StringTokenizer)object).nextElement());
                                        inputStream = this.context.getResourceAsStream(stringBuilder.toString());
                                    }
                                    stringBuilder2.append(this.tmpDir);
                                    stringBuilder2.append('/');
                                    stringBuilder2.append((CharSequence)stringBuilder);
                                }
                                if (inputStream == null) {
                                    log.warn((Object)sm.getString("cgiServlet.expandNotFound", new Object[]{stringBuilder}));
                                    return;
                                }
                                object = new File(stringBuilder2.toString());
                                if (!((File)object).exists()) break block28;
                                try {
                                    inputStream.close();
                                    return;
                                }
                                catch (IOException iOException) {
                                    log.warn((Object)sm.getString("cgiServlet.expandCloseFail", new Object[]{stringBuilder}), (Throwable)iOException);
                                }
                                return;
                            }
                            File file = ((File)object).getParentFile();
                            if (file.mkdirs() || file.isDirectory()) break block29;
                            log.warn((Object)sm.getString("cgiServlet.expandCreateDirFail", new Object[]{file.getAbsolutePath()}));
                            try {
                                inputStream.close();
                                return;
                            }
                            catch (IOException iOException) {
                                log.warn((Object)sm.getString("cgiServlet.expandCloseFail", new Object[]{stringBuilder}), (Throwable)iOException);
                            }
                            return;
                        }
                        Object object2 = expandFileLock;
                        // MONITORENTER : object2
                        if (!((File)object).exists()) break block30;
                        // MONITOREXIT : object2
                        try {
                            inputStream.close();
                            return;
                        }
                        catch (IOException iOException) {
                            log.warn((Object)sm.getString("cgiServlet.expandCloseFail", new Object[]{stringBuilder}), (Throwable)iOException);
                        }
                        return;
                    }
                    if (((File)object).createNewFile()) break block31;
                    // MONITOREXIT : object2
                    {
                        catch (IOException iOException) {
                            log.warn((Object)sm.getString("cgiServlet.expandFail", new Object[]{stringBuilder, stringBuilder2}), (Throwable)iOException);
                            if (!((File)object).exists() || ((File)object).delete()) break block32;
                            log.warn((Object)sm.getString("cgiServlet.expandDeleteFail", new Object[]{((File)object).getAbsolutePath()}));
                        }
                    }
                    try {
                        inputStream.close();
                        return;
                    }
                    catch (IOException iOException) {
                        log.warn((Object)sm.getString("cgiServlet.expandCloseFail", new Object[]{stringBuilder}), (Throwable)iOException);
                    }
                    return;
                }
                try {
                    Files.copy(inputStream, ((File)object).toPath(), new CopyOption[0]);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("cgiServlet.expandOk", new Object[]{stringBuilder, stringBuilder2}));
                    }
                    // MONITOREXIT : object2
                }
                catch (Throwable throwable) {
                    try {
                        inputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        log.warn((Object)sm.getString("cgiServlet.expandCloseFail", new Object[]{stringBuilder}), (Throwable)iOException);
                    }
                    throw throwable;
                }
            }
            try {
                inputStream.close();
                return;
            }
            catch (IOException iOException) {
                log.warn((Object)sm.getString("cgiServlet.expandCloseFail", new Object[]{stringBuilder}), (Throwable)iOException);
                return;
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("CGIEnvironment Info:");
            stringBuilder.append(System.lineSeparator());
            if (this.isValid()) {
                stringBuilder.append("Validity: [true]");
                stringBuilder.append(System.lineSeparator());
                stringBuilder.append("Environment values:");
                stringBuilder.append(System.lineSeparator());
                for (Map.Entry<String, String> object : this.env.entrySet()) {
                    stringBuilder.append("  ");
                    stringBuilder.append(object.getKey());
                    stringBuilder.append(": [");
                    stringBuilder.append(this.blanksToString(object.getValue(), "will be set to blank"));
                    stringBuilder.append(']');
                    stringBuilder.append(System.lineSeparator());
                }
                stringBuilder.append("Derived Command :[");
                stringBuilder.append(this.nullsToBlanks(this.command));
                stringBuilder.append(']');
                stringBuilder.append(System.lineSeparator());
                stringBuilder.append("Working Directory: [");
                if (this.workingDirectory != null) {
                    stringBuilder.append(this.workingDirectory.toString());
                }
                stringBuilder.append(']');
                stringBuilder.append(System.lineSeparator());
                stringBuilder.append("Command Line Params:");
                stringBuilder.append(System.lineSeparator());
                for (String string : this.cmdLineParameters) {
                    stringBuilder.append("  [");
                    stringBuilder.append(string);
                    stringBuilder.append(']');
                    stringBuilder.append(System.lineSeparator());
                }
            } else {
                stringBuilder.append("Validity: [false]");
                stringBuilder.append(System.lineSeparator());
                stringBuilder.append("CGI script not found or not specified.");
                stringBuilder.append(System.lineSeparator());
                stringBuilder.append("Check the HttpServletRequest pathInfo property to see if it is what ");
                stringBuilder.append(System.lineSeparator());
                stringBuilder.append("you meant it to be. You must specify an existent and executable file ");
                stringBuilder.append(System.lineSeparator());
                stringBuilder.append("as part of the path-info.");
                stringBuilder.append(System.lineSeparator());
            }
            return stringBuilder.toString();
        }

        protected String getCommand() {
            return this.command;
        }

        protected File getWorkingDirectory() {
            return this.workingDirectory;
        }

        protected Hashtable<String, String> getEnvironment() {
            return this.env;
        }

        protected ArrayList<String> getParameters() {
            return this.cmdLineParameters;
        }

        protected boolean isValid() {
            return this.valid;
        }

        protected String nullsToBlanks(String string) {
            return this.nullsToString(string, "");
        }

        protected String nullsToString(String string, String string2) {
            return string == null ? string2 : string;
        }

        protected String blanksToString(String string, String string2) {
            return string == null || string.isEmpty() ? string2 : string;
        }
    }
}

