'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
var replaceStringTransformer = function replaceStringTransformer(replaceWhat, replaceWith) {
  return {
    onString: function onString(str) {
      if (replaceWhat == null || replaceWith == null) {
        throw new Error('replaceStringTransformer requires at least 2 arguments.');
      }

      return str.replace(replaceWhat, replaceWith);
    }
  };
};

exports.default = replaceStringTransformer;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9yZXBsYWNlU3RyaW5nVHJhbnNmb3JtZXIvcmVwbGFjZVN0cmluZ1RyYW5zZm9ybWVyLmpzIl0sIm5hbWVzIjpbInJlcGxhY2VTdHJpbmdUcmFuc2Zvcm1lciIsInJlcGxhY2VXaGF0IiwicmVwbGFjZVdpdGgiLCJvblN0cmluZyIsInN0ciIsIkVycm9yIiwicmVwbGFjZSJdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSxJQUFNQSwyQkFBMkIsU0FBM0JBLHdCQUEyQixDQUFDQyxXQUFELEVBQWNDLFdBQWQ7QUFBQSxTQUErQjtBQUM5REMsWUFEOEQsb0JBQ3JEQyxHQURxRCxFQUNoRDtBQUNaLFVBQUlILGVBQWUsSUFBZixJQUF1QkMsZUFBZSxJQUExQyxFQUFnRDtBQUM5QyxjQUFNLElBQUlHLEtBQUosQ0FDSix5REFESSxDQUFOO0FBR0Q7O0FBRUQsYUFBT0QsSUFBSUUsT0FBSixDQUFZTCxXQUFaLEVBQXlCQyxXQUF6QixDQUFQO0FBQ0Q7QUFUNkQsR0FBL0I7QUFBQSxDQUFqQzs7a0JBWWVGLHdCIiwiZmlsZSI6InJlcGxhY2VTdHJpbmdUcmFuc2Zvcm1lci5qcyIsInNvdXJjZXNDb250ZW50IjpbImNvbnN0IHJlcGxhY2VTdHJpbmdUcmFuc2Zvcm1lciA9IChyZXBsYWNlV2hhdCwgcmVwbGFjZVdpdGgpID0+ICh7XG4gIG9uU3RyaW5nKHN0cikge1xuICAgIGlmIChyZXBsYWNlV2hhdCA9PSBudWxsIHx8IHJlcGxhY2VXaXRoID09IG51bGwpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihcbiAgICAgICAgJ3JlcGxhY2VTdHJpbmdUcmFuc2Zvcm1lciByZXF1aXJlcyBhdCBsZWFzdCAyIGFyZ3VtZW50cy4nLFxuICAgICAgKTtcbiAgICB9XG5cbiAgICByZXR1cm4gc3RyLnJlcGxhY2UocmVwbGFjZVdoYXQsIHJlcGxhY2VXaXRoKTtcbiAgfSxcbn0pO1xuXG5leHBvcnQgZGVmYXVsdCByZXBsYWNlU3RyaW5nVHJhbnNmb3JtZXI7XG4iXX0=