declare const _exports: ({
    fingerprint: ({
        manufacturerName: string;
    } | {
        modelID: string;
        manufacturerName: string;
    })[];
    model: string;
    vendor: string;
    description: string;
    extend: {
        exposes: import("../lib/types").Expose[];
        fromZigbee: import("../lib/types").Fz.Converter[];
        toZigbee: import("../lib/types").Tz.Converter[];
    };
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    ota: typeof ota.zigbeeOTA;
    extend: {
        exposes: import("../lib/types").Expose[];
        fromZigbee: import("../lib/types").Fz.Converter[];
        toZigbee: import("../lib/types").Tz.Converter[];
    };
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    options: exposes.Numeric[];
    onEvent: (type: any, data: any, device: any, options: any) => Promise<void>;
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    fromZigbee: ({
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            battery: number;
            voltage: number;
            battery_low: boolean;
        };
    } | {
        cluster: string;
        type: string;
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            action: string;
        };
    } | {
        cluster: string;
        type: string[];
        options: exposes.Composite[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            action: string;
        };
    })[];
    toZigbee: undefined[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    exposes: (exposes.Numeric | exposes.Enum)[];
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    fromZigbee: ({
        cluster: string;
        type: string;
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            action: any;
            tamper: boolean;
            battery_low: boolean;
        };
    } | {
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
    })[];
    toZigbee: undefined[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    exposes: (exposes.Numeric | exposes.Binary | exposes.Enum)[];
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    fromZigbee: ({
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            battery: number;
            voltage: number;
            battery_low: boolean;
        };
    } | {
        cluster: string;
        type: string;
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            occupancy: boolean;
            tamper: boolean;
            battery_low: boolean;
        };
    })[];
    toZigbee: undefined[];
    exposes: (exposes.Numeric | exposes.Binary)[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    fromZigbee: ({
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            battery: number;
            voltage: number;
            battery_low: boolean;
        };
    } | {
        cluster: string;
        type: string;
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            [x: string]: boolean;
        };
    } | {
        cluster: string;
        type: string;
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            contact: boolean;
            tamper: boolean;
            battery_low: boolean;
        };
    })[];
    toZigbee: undefined[];
    exposes: (exposes.Numeric | exposes.Binary)[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    exposes: exposes.Enum[];
    fromZigbee: ({
        cluster: string;
        type: string;
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            action: string;
        };
    } | {
        cluster: string;
        type: string[];
        options: exposes.Composite[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            action: string;
        };
    })[];
    toZigbee: undefined[];
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    extend: {
        exposes: import("../lib/types").Expose[];
        fromZigbee: import("../lib/types").Fz.Converter[];
        toZigbee: import("../lib/types").Tz.Converter[];
    };
    meta: {
        multiEndpoint: boolean;
    };
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    endpoint: (device: any) => {
        l1: number;
        l2: number;
        l3: number;
    };
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    toZigbee: (import("../lib/types").Tz.Converter | {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state?: undefined;
        } | {
            state: {
                state: any;
            };
        }>;
        convertGet: (entity: any, key: any, meta: any) => Promise<void>;
    })[];
    fromZigbee: (import("../lib/types").Fz.Converter | {
        cluster: string;
        type: string[];
        options: exposes.Binary[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {};
    })[];
    exposes: exposes.Light[];
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    fromZigbee: (import("../lib/types").Fz.Converter | {
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
    })[];
    toZigbee: import("../lib/types").Tz.Converter[];
    onEvent: (type: any, data: any, device: any) => Promise<void>;
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    exposes: any[];
    meta: {
        tuyaDatapoints: ((number | {
            from: (value: any, meta: any, options: any, publish: any) => {
                time_left?: number;
                state: string;
            };
        })[] | (string | number | {
            to: (v: string) => string | number | boolean | tuya.Enum;
            from: (v: number) => string;
        } | {
            optimistic: boolean;
        })[] | (string | number | {
            to: (v: string | number | boolean) => string | number | boolean;
            from: (v: string | number | boolean) => string | number | boolean;
        })[] | (string | number | {
            to: (value: any) => number;
        } | {
            optimistic: boolean;
        })[] | (number | {
            from: (value: any) => {
                schedule_mode: string;
                schedule_periodic: any;
                schedule_weekday: {};
            };
        })[] | (string | number | {
            to: (value: any) => any[];
        })[] | (string | number | {
            to: (value: any, meta: any) => unknown[];
        })[])[];
    };
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    extend: {
        meta: {
            applyRedFix: boolean;
            supportsEnhancedHue: boolean;
        };
        fromZigbee: import("../lib/types").Fz.Converter[];
        toZigbee: import("../lib/types").Tz.Converter[];
        exposes: import("../lib/types").Expose[];
        configure?: import("../lib/types").Configure;
    };
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    fromZigbee: (import("../lib/types").Fz.Converter | {
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
    })[];
    toZigbee: import("../lib/types").Tz.Converter[];
    onEvent: typeof tuya.onEventSetLocalTime;
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    exposes: any[];
})[];
export = _exports;
import ota = require("../lib/ota");
import exposes = require("../lib/exposes");
import tuya = require("../lib/tuya");
//# sourceMappingURL=lidl.d.ts.map