/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.util;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.rca.framework.api.AnalysisGraph;
import org.opensearch.performanceanalyzer.rca.framework.core.ConnectedComponent;
import org.opensearch.performanceanalyzer.rca.framework.core.Node;
import org.opensearch.performanceanalyzer.rca.framework.core.RcaConf;
import org.opensearch.performanceanalyzer.rca.framework.core.Stats;

public class RcaUtil {
    private static final Logger LOG = LogManager.getLogger(RcaUtil.class);

    private static AnalysisGraph getAnalysisGraphImplementor(RcaConf rcaConf) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        return (AnalysisGraph)Class.forName(rcaConf.getAnalysisGraphEntryPoint()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static List<ConnectedComponent> getAnalysisGraphComponents(RcaConf rcaConf) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        AnalysisGraph graph = RcaUtil.getAnalysisGraphImplementor(rcaConf);
        return RcaUtil.getAnalysisGraphComponents(graph);
    }

    public static List<ConnectedComponent> getAnalysisGraphComponents(String analysisGraphClass) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        AnalysisGraph graph = (AnalysisGraph)Class.forName(analysisGraphClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        graph.construct();
        graph.validateAndProcess();
        return Stats.getInstance().getConnectedComponents();
    }

    public static List<ConnectedComponent> getAnalysisGraphComponents(AnalysisGraph graph) {
        graph.construct();
        graph.validateAndProcess();
        return Stats.getInstance().getConnectedComponents();
    }

    public static boolean doTagsMatch(Node<?> node, RcaConf conf) {
        Map<String, String> rcaTagMap = conf.getTagMap();
        Iterator<Map.Entry<String, String>> iterator = node.getTags().entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<String, String> tag = iterator.next();
            String rcaConfTagvalue = rcaTagMap.get(tag.getKey());
            return tag.getValue() != null && Arrays.asList(tag.getValue().split(",")).contains(rcaConfTagvalue);
        }
        return true;
    }

    public static boolean shouldExecuteLocally(Node<?> node, RcaConf conf) {
        Map<String, String> confTagMap = conf.getTagMap();
        Map<String, String> nodeTagMap = node.getTags();
        if (confTagMap != null && nodeTagMap != null) {
            String hostLocus = confTagMap.get("locus");
            String nodeLoci = nodeTagMap.get("locus");
            if (nodeLoci != null && !nodeLoci.isEmpty()) {
                List<String> nodeLociStrings = Arrays.asList(nodeLoci.split(","));
                return nodeLociStrings.contains(hostLocus);
            }
        }
        return true;
    }
}

