"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const chai_1 = require("chai");
const helper_1 = require("../helper");
const hoverProvider_1 = require("../../src/providers/hoverProvider");
function testPlayKeywords(context, textDoc) {
    const tests = [
        {
            word: "name",
            position: { line: 0, character: 4 },
            doc: "Identifier. Can be used for documentation, or in tasks/handlers.",
        },
        {
            word: "host",
            position: { line: 1, character: 4 },
            doc: "A list of groups, hosts or host pattern that translates into a list of hosts that are the play’s target.",
        },
        {
            word: "tasks",
            position: { line: 3, character: 4 },
            doc: "Main list of tasks to execute in the play, they run after roles and before post_tasks.",
        },
    ];
    tests.forEach(({ word, position, doc }) => {
        it(`should provide hovering for '${word}'`, function () {
            return __awaiter(this, void 0, void 0, function* () {
                const actualHover = yield (0, hoverProvider_1.doHover)(textDoc, position, yield context.docsLibrary);
                (0, chai_1.expect)(actualHover.contents["value"]).includes(doc);
            });
        });
    });
}
function testTaskKeywords(context, textDoc) {
    const tests = [
        {
            word: "register",
            position: { line: 6, character: 8 },
            doc: "Name of variable that will contain task status and module return data.",
        },
    ];
    tests.forEach(({ word, position, doc }) => {
        it(`should provide hovering for '${word}'`, function () {
            return __awaiter(this, void 0, void 0, function* () {
                const actualHover = yield (0, hoverProvider_1.doHover)(textDoc, position, yield context.docsLibrary);
                (0, chai_1.expect)(actualHover.contents["value"]).includes(doc);
            });
        });
    });
}
function testBlockKeywords(context, textDoc) {
    const tests = [
        {
            word: "become",
            position: { line: 11, character: 8 },
            doc: "Boolean that controls if privilege escalation is used or not on Task execution. Implemented by the become plugin.",
        },
    ];
    tests.forEach(({ word, position, doc }) => {
        it(`should provide hovering for '${word}'`, function () {
            return __awaiter(this, void 0, void 0, function* () {
                const actualHover = yield (0, hoverProvider_1.doHover)(textDoc, position, yield context.docsLibrary);
                (0, chai_1.expect)(actualHover.contents["value"]).includes(doc);
            });
        });
    });
}
function testRoleKeywords(context, textDoc) {
    const tests = [
        {
            word: "tags",
            position: { line: 6, character: 8 },
            doc: "Tags applied to the task or included tasks, this allows selecting subsets of tasks from the command line.",
        },
    ];
    tests.forEach(({ word, position, doc }) => {
        it(`should provide hovering for '${word}'`, function () {
            return __awaiter(this, void 0, void 0, function* () {
                const actualHover = yield (0, hoverProvider_1.doHover)(textDoc, position, yield context.docsLibrary);
                (0, chai_1.expect)(actualHover.contents["value"]).includes(doc);
            });
        });
    });
}
function testModuleNames(context, textDoc) {
    const tests = [
        {
            word: "ansible.builtin.debug",
            position: { line: 4, character: 8 },
            doc: "Print statements during execution",
        },
        {
            word: "ansible.builtin.debug -> msg",
            position: { line: 5, character: 10 },
            doc: "The customized message that is printed\\. If omitted\\, prints a generic message\\.",
        },
    ];
    tests.forEach(({ word, position, doc }) => {
        it(`should provide hovering for '${word}'`, function () {
            return __awaiter(this, void 0, void 0, function* () {
                const actualHover = yield (0, hoverProvider_1.doHover)(textDoc, position, yield context.docsLibrary);
                (0, chai_1.expect)(actualHover.contents["value"]).includes(doc);
            });
        });
    });
}
function testNoHover(context, textDoc) {
    it("should not provide hovering for values", function () {
        return __awaiter(this, void 0, void 0, function* () {
            const actualHover = yield (0, hoverProvider_1.doHover)(textDoc, { line: 13, character: 24 }, yield context.docsLibrary);
            (0, chai_1.expect)(actualHover).to.be.null;
        });
    });
    it("should not provide hovering for improper module name and options", function () {
        return __awaiter(this, void 0, void 0, function* () {
            const actualHover = yield (0, hoverProvider_1.doHover)(textDoc, { line: 13, character: 8 }, yield context.docsLibrary);
            (0, chai_1.expect)(actualHover).to.be.null;
        });
    });
    it("should not provide hovering for improper module option", function () {
        return __awaiter(this, void 0, void 0, function* () {
            const actualHover = yield (0, hoverProvider_1.doHover)(textDoc, { line: 14, character: 10 }, yield context.docsLibrary);
            (0, chai_1.expect)(actualHover).to.be.null;
        });
    });
}
function testPlaybookAdjacentCollection(context, textDoc) {
    const tests = [
        {
            word: "playbook adjacent module name",
            position: { line: 5, character: 19 },
            doc: "This is a test module for playbook adjacent collection",
        },
        {
            word: "playbook adjacent module option",
            position: { line: 6, character: 11 },
            doc: "Option 1",
        },
        {
            word: "playbook adjacent module sub option",
            position: { line: 7, character: 19 },
            doc: "Sub option 1",
        },
    ];
    tests.forEach(({ word, position, doc }) => {
        it(`should provide hovering for '${word}'`, function () {
            return __awaiter(this, void 0, void 0, function* () {
                const actualHover = yield (0, hoverProvider_1.doHover)(textDoc, position, yield context.docsLibrary);
                (0, chai_1.expect)(actualHover.contents["value"]).includes(doc);
            });
        });
    });
}
function testNonPlaybookAdjacentCollection(context, textDoc) {
    const tests = [
        {
            word: "non playbook adjacent module name",
            position: { line: 5, character: 19 },
            doc: "",
        },
        {
            word: "non playbook adjacent module option",
            position: { line: 6, character: 11 },
            doc: "",
        },
    ];
    tests.forEach(({ word, position, doc }) => {
        it(`should not provide hovering for '${word}'`, function () {
            return __awaiter(this, void 0, void 0, function* () {
                const actualHover = yield (0, hoverProvider_1.doHover)(textDoc, position, yield context.docsLibrary);
                if (!doc) {
                    (0, chai_1.expect)(actualHover).to.be.null;
                }
                else {
                    console.log("actual hover -> ", actualHover);
                    (0, chai_1.expect)(actualHover.contents["value"]).includes(doc);
                }
            });
        });
    });
}
describe("doHover()", () => {
    const workspaceManager = (0, helper_1.createTestWorkspaceManager)();
    let fixtureFilePath = "hover/tasks.yml";
    let fixtureFileUri = (0, helper_1.resolveDocUri)(fixtureFilePath);
    let context = workspaceManager.getContext(fixtureFileUri);
    let textDoc = (0, helper_1.getDoc)(fixtureFilePath);
    let docSettings = context.documentSettings.get(textDoc.uri);
    describe("Play keywords hover", () => {
        describe("With EE enabled @ee", () => {
            before(() => __awaiter(void 0, void 0, void 0, function* () {
                (0, helper_1.setFixtureAnsibleCollectionPathEnv)("/home/runner/.ansible/collections:/usr/share/ansible");
                yield (0, helper_1.enableExecutionEnvironmentSettings)(docSettings);
            }));
            testPlayKeywords(context, textDoc);
            after(() => __awaiter(void 0, void 0, void 0, function* () {
                (0, helper_1.setFixtureAnsibleCollectionPathEnv)();
                yield (0, helper_1.disableExecutionEnvironmentSettings)(docSettings);
            }));
        });
        describe("With EE disabled", () => {
            before(() => __awaiter(void 0, void 0, void 0, function* () {
                (0, helper_1.setFixtureAnsibleCollectionPathEnv)();
                yield (0, helper_1.disableExecutionEnvironmentSettings)(docSettings);
            }));
            testPlayKeywords(context, textDoc);
        });
    });
    describe("Task keywords hover", () => {
        describe("With EE enabled @ee", () => {
            before(() => __awaiter(void 0, void 0, void 0, function* () {
                (0, helper_1.setFixtureAnsibleCollectionPathEnv)("/home/runner/.ansible/collections:/usr/share/ansible");
                yield (0, helper_1.enableExecutionEnvironmentSettings)(docSettings);
            }));
            testTaskKeywords(context, textDoc);
            after(() => __awaiter(void 0, void 0, void 0, function* () {
                (0, helper_1.setFixtureAnsibleCollectionPathEnv)();
                yield (0, helper_1.disableExecutionEnvironmentSettings)(docSettings);
            }));
        });
        describe("With EE disabled", () => {
            before(() => __awaiter(void 0, void 0, void 0, function* () {
                (0, helper_1.setFixtureAnsibleCollectionPathEnv)();
                yield (0, helper_1.disableExecutionEnvironmentSettings)(docSettings);
            }));
            testTaskKeywords(context, textDoc);
        });
    });
    describe("Block keywords hover", () => {
        describe("With EE enabled @ee", () => {
            before(() => __awaiter(void 0, void 0, void 0, function* () {
                (0, helper_1.setFixtureAnsibleCollectionPathEnv)("/home/runner/.ansible/collections:/usr/share/ansible");
                yield (0, helper_1.enableExecutionEnvironmentSettings)(docSettings);
            }));
            testBlockKeywords(context, textDoc);
            after(() => __awaiter(void 0, void 0, void 0, function* () {
                (0, helper_1.setFixtureAnsibleCollectionPathEnv)();
                yield (0, helper_1.disableExecutionEnvironmentSettings)(docSettings);
            }));
        });
        describe("With EE disabled", () => {
            before(() => __awaiter(void 0, void 0, void 0, function* () {
                (0, helper_1.setFixtureAnsibleCollectionPathEnv)();
                yield (0, helper_1.disableExecutionEnvironmentSettings)(docSettings);
            }));
            testBlockKeywords(context, textDoc);
        });
    });
    fixtureFilePath = "hover/roles.yml";
    fixtureFileUri = (0, helper_1.resolveDocUri)(fixtureFilePath);
    context = workspaceManager.getContext(fixtureFileUri);
    textDoc = (0, helper_1.getDoc)(fixtureFilePath);
    docSettings = context.documentSettings.get(textDoc.uri);
    describe("Role keywords hover", () => {
        describe("With EE enabled @ee", () => {
            before(() => __awaiter(void 0, void 0, void 0, function* () {
                (0, helper_1.setFixtureAnsibleCollectionPathEnv)("/home/runner/.ansible/collections:/usr/share/ansible");
                yield (0, helper_1.enableExecutionEnvironmentSettings)(docSettings);
            }));
            testRoleKeywords(context, textDoc);
            after(() => __awaiter(void 0, void 0, void 0, function* () {
                (0, helper_1.setFixtureAnsibleCollectionPathEnv)();
                yield (0, helper_1.disableExecutionEnvironmentSettings)(docSettings);
            }));
        });
        describe("With EE disabled", () => {
            before(() => __awaiter(void 0, void 0, void 0, function* () {
                (0, helper_1.setFixtureAnsibleCollectionPathEnv)();
                yield (0, helper_1.disableExecutionEnvironmentSettings)(docSettings);
            }));
            testRoleKeywords(context, textDoc);
        });
    });
    fixtureFilePath = "hover/tasks.yml";
    fixtureFileUri = (0, helper_1.resolveDocUri)(fixtureFilePath);
    context = workspaceManager.getContext(fixtureFileUri);
    textDoc = (0, helper_1.getDoc)(fixtureFilePath);
    docSettings = context.documentSettings.get(textDoc.uri);
    describe("Module name and options hover", () => {
        describe("With EE enabled @ee", () => {
            before(() => __awaiter(void 0, void 0, void 0, function* () {
                (0, helper_1.setFixtureAnsibleCollectionPathEnv)("/home/runner/.ansible/collections:/usr/share/ansible");
                yield (0, helper_1.enableExecutionEnvironmentSettings)(docSettings);
            }));
            testModuleNames(context, textDoc);
            after(() => __awaiter(void 0, void 0, void 0, function* () {
                (0, helper_1.setFixtureAnsibleCollectionPathEnv)();
                yield (0, helper_1.disableExecutionEnvironmentSettings)(docSettings);
            }));
        });
        describe("With EE disabled", () => {
            before(() => __awaiter(void 0, void 0, void 0, function* () {
                (0, helper_1.setFixtureAnsibleCollectionPathEnv)();
                yield (0, helper_1.disableExecutionEnvironmentSettings)(docSettings);
            }));
            testModuleNames(context, textDoc);
        });
    });
    describe("No hover", () => {
        describe("With EE enabled @ee", () => {
            before(() => __awaiter(void 0, void 0, void 0, function* () {
                (0, helper_1.setFixtureAnsibleCollectionPathEnv)("/home/runner/.ansible/collections:/usr/share/ansible");
                yield (0, helper_1.enableExecutionEnvironmentSettings)(docSettings);
            }));
            testNoHover(context, textDoc);
            after(() => __awaiter(void 0, void 0, void 0, function* () {
                (0, helper_1.setFixtureAnsibleCollectionPathEnv)();
                yield (0, helper_1.disableExecutionEnvironmentSettings)(docSettings);
            }));
        });
        describe("With EE disabled", () => {
            before(() => __awaiter(void 0, void 0, void 0, function* () {
                (0, helper_1.setFixtureAnsibleCollectionPathEnv)();
                yield (0, helper_1.disableExecutionEnvironmentSettings)(docSettings);
            }));
            testNoHover(context, textDoc);
        });
    });
    fixtureFilePath = "playbook_adjacent_collection/playbook.yml";
    fixtureFileUri = (0, helper_1.resolveDocUri)(fixtureFilePath);
    context = workspaceManager.getContext(fixtureFileUri);
    textDoc = (0, helper_1.getDoc)(fixtureFilePath);
    docSettings = context.documentSettings.get(textDoc.uri);
    describe("Hover for playbook adjacent collection", () => {
        describe("With EE enabled @ee", () => {
            before(() => __awaiter(void 0, void 0, void 0, function* () {
                (0, helper_1.setFixtureAnsibleCollectionPathEnv)("/home/runner/.ansible/collections:/usr/share/ansible");
                yield (0, helper_1.enableExecutionEnvironmentSettings)(docSettings);
            }));
            testPlaybookAdjacentCollection(context, textDoc);
            after(() => __awaiter(void 0, void 0, void 0, function* () {
                (0, helper_1.setFixtureAnsibleCollectionPathEnv)();
                yield (0, helper_1.disableExecutionEnvironmentSettings)(docSettings);
            }));
        });
        describe("With EE disabled", () => {
            before(() => __awaiter(void 0, void 0, void 0, function* () {
                (0, helper_1.setFixtureAnsibleCollectionPathEnv)();
                yield (0, helper_1.disableExecutionEnvironmentSettings)(docSettings);
            }));
            testPlaybookAdjacentCollection(context, textDoc);
        });
    });
    fixtureFilePath =
        "playbook_adjacent_collection/non_adjacent_playbooks/playbook2.yml";
    fixtureFileUri = (0, helper_1.resolveDocUri)(fixtureFilePath);
    context = workspaceManager.getContext(fixtureFileUri);
    textDoc = (0, helper_1.getDoc)(fixtureFilePath);
    docSettings = context.documentSettings.get(textDoc.uri);
    describe("Negate hover for non playbook adjacent collection", () => {
        describe("With EE enabled @ee", () => {
            before(() => __awaiter(void 0, void 0, void 0, function* () {
                (0, helper_1.setFixtureAnsibleCollectionPathEnv)("/home/runner/.ansible/collections:/usr/share/ansible");
                yield (0, helper_1.enableExecutionEnvironmentSettings)(docSettings);
            }));
            testNonPlaybookAdjacentCollection(context, textDoc);
            after(() => __awaiter(void 0, void 0, void 0, function* () {
                (0, helper_1.setFixtureAnsibleCollectionPathEnv)();
                yield (0, helper_1.disableExecutionEnvironmentSettings)(docSettings);
            }));
        });
        describe("With EE disabled", () => {
            before(() => __awaiter(void 0, void 0, void 0, function* () {
                (0, helper_1.setFixtureAnsibleCollectionPathEnv)();
                yield (0, helper_1.disableExecutionEnvironmentSettings)(docSettings);
            }));
            testNonPlaybookAdjacentCollection(context, textDoc);
        });
    });
});
//# sourceMappingURL=hoverProvider.test.js.map