/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions;

import cc.arduino.UpdatableBoardsLibsFakeURLsHandler;
import cc.arduino.contributions.NoopProgressListener;
import cc.arduino.contributions.ProgressListener;
import cc.arduino.contributions.libraries.LibraryInstaller;
import cc.arduino.contributions.libraries.filters.UpdatableLibraryPredicate;
import cc.arduino.contributions.packages.ContributionInstaller;
import cc.arduino.contributions.packages.filters.UpdatablePlatformPredicate;
import cc.arduino.view.NotificationPopup;
import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.net.URL;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkListener;
import processing.app.Base;
import processing.app.BaseNoGui;
import processing.app.Editor;
import processing.app.I18n;
import processing.app.PreferencesData;

public class ContributionsSelfCheck
extends TimerTask
implements NotificationPopup.OptionalButtonCallbacks {
    private final Base base;
    private final HyperlinkListener hyperlinkListener;
    private final ContributionInstaller contributionInstaller;
    private final LibraryInstaller libraryInstaller;
    private final ProgressListener progressListener;
    private final String boardsManagerURL = "http://boardsmanager/DropdownUpdatableCoresItem";
    private final String libraryManagerURL = "http://librarymanager/DropdownUpdatableLibrariesItem";
    private volatile boolean cancelled;
    private volatile NotificationPopup notificationPopup;

    public ContributionsSelfCheck(Base base, HyperlinkListener hyperlinkListener, ContributionInstaller contributionInstaller, LibraryInstaller libraryInstaller) {
        this.base = base;
        this.hyperlinkListener = hyperlinkListener;
        this.contributionInstaller = contributionInstaller;
        this.libraryInstaller = libraryInstaller;
        this.progressListener = new NoopProgressListener();
        this.cancelled = false;
    }

    @Override
    public void run() {
        String button2Name;
        String button1Name;
        this.updateContributionIndex();
        this.updateLibrariesIndex();
        boolean updatablePlatforms = ContributionsSelfCheck.checkForUpdatablePlatforms();
        boolean updatableLibraries = ContributionsSelfCheck.checkForUpdatableLibraries();
        if (!updatableLibraries && !updatablePlatforms) {
            return;
        }
        boolean setAccessible = PreferencesData.getBoolean((String)"ide.accessible");
        String openAnchorBoards = "<a href=\"http://boardsmanager/DropdownUpdatableCoresItem\">";
        String closeAnchorBoards = "</a>";
        String openAnchorLibraries = "<a href=\"http://librarymanager/DropdownUpdatableLibrariesItem\">";
        String closeAnchorLibraries = "</a>";
        if (setAccessible && updatablePlatforms) {
            button1Name = I18n.tr((String)"Boards");
            openAnchorBoards = "";
            closeAnchorBoards = "";
        } else {
            button1Name = null;
        }
        if (setAccessible && updatableLibraries) {
            button2Name = I18n.tr((String)"Libraries");
            openAnchorLibraries = "";
            closeAnchorLibraries = "";
        } else {
            button2Name = null;
        }
        String text = updatableLibraries && !updatablePlatforms ? I18n.format((String)I18n.tr((String)"Updates available for some of your {0}libraries{1}"), (Object[])new Object[]{openAnchorLibraries, closeAnchorLibraries}) : (!updatableLibraries && updatablePlatforms ? I18n.format((String)I18n.tr((String)"Updates available for some of your {0}boards{1}"), (Object[])new Object[]{openAnchorBoards, closeAnchorBoards}) : I18n.format((String)I18n.tr((String)"Updates available for some of your {0}boards{1} and {2}libraries{3}"), (Object[])new Object[]{openAnchorBoards, closeAnchorBoards, openAnchorLibraries, closeAnchorLibraries}));
        if (this.cancelled) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            Editor ed = this.base.getActiveEditor();
            boolean accessibleIde = PreferencesData.getBoolean((String)"ide.accessible");
            this.notificationPopup = accessibleIde ? new NotificationPopup(ed, this.hyperlinkListener, text, false, this, button1Name, button2Name) : new NotificationPopup((Frame)ed, this.hyperlinkListener, text);
            if (ed.isFocused()) {
                this.notificationPopup.begin();
                return;
            }
            WindowFocusListener wfl = new WindowFocusListener(){

                @Override
                public void windowLostFocus(WindowEvent evt) {
                }

                @Override
                public void windowGainedFocus(WindowEvent evt) {
                    ContributionsSelfCheck.this.notificationPopup.begin();
                    for (Editor e : ContributionsSelfCheck.this.base.getEditors()) {
                        e.removeWindowFocusListener(this);
                    }
                }
            };
            for (Editor e : this.base.getEditors()) {
                e.addWindowFocusListener(wfl);
            }
        });
    }

    private void goToManager(String link) {
        try {
            ((UpdatableBoardsLibsFakeURLsHandler)this.hyperlinkListener).openBoardLibManager(new URL(link));
        }
        catch (Exception e) {
            System.err.println("Error while attempting to open board manager: " + e.getMessage());
        }
    }

    @Override
    public void onOptionalButton1Callback() {
        this.goToManager("http://boardsmanager/DropdownUpdatableCoresItem");
    }

    @Override
    public void onOptionalButton2Callback() {
        this.goToManager("http://librarymanager/DropdownUpdatableLibrariesItem");
    }

    static boolean checkForUpdatablePlatforms() {
        return BaseNoGui.indexer.getPackages().stream().flatMap(pack -> pack.getPlatforms().stream()).anyMatch(new UpdatablePlatformPredicate());
    }

    static boolean checkForUpdatableLibraries() {
        return BaseNoGui.librariesIndexer.getIndex().getLibraries().stream().anyMatch(new UpdatableLibraryPredicate());
    }

    @Override
    public boolean cancel() {
        this.cancelled = true;
        if (this.notificationPopup != null) {
            this.notificationPopup.close();
        }
        return super.cancel();
    }

    private void updateLibrariesIndex() {
        if (this.cancelled) {
            return;
        }
        try {
            this.libraryInstaller.updateIndex(this.progressListener);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateContributionIndex() {
        if (this.cancelled) {
            return;
        }
        try {
            this.contributionInstaller.updateIndex(this.progressListener);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

