/*
 * Decompiled with CFR 0.152.
 */
package bt747.j2se_view;

import bt747.j2se_view.J2SEAppController;
import bt747.j2se_view.helpers.TaggedFilePathFactory;
import bt747.model.Model;
import bt747.model.ModelEvent;
import bt747.model.ModelListener;
import bt747.sys.interfaces.BT747Int;
import gps.log.out.CommonOut;
import gps.mvc.MtkModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;

public final class AgpsPanel
extends JPanel
implements ModelListener {
    private J2SEAppController c;
    private Model m;
    private JPanel agpsPanel;
    private JButton btClearAgpsData;
    private JButton btDownloadAgpsData;
    private JButton btUploadAgpsData;
    private JLabel lbAgpsUrl;
    private JLabel txtAgpsInfo1;
    private JLabel txtAgpsInfo2;
    private JTextField txtAgpsUrl;

    public AgpsPanel() {
        AgpsPanel agpsPanel = this;
        this.agpsPanel = new JPanel();
        agpsPanel.txtAgpsUrl = new JTextField();
        agpsPanel.lbAgpsUrl = new JLabel();
        agpsPanel.btUploadAgpsData = new JButton();
        agpsPanel.btDownloadAgpsData = new JButton();
        agpsPanel.txtAgpsInfo1 = new JLabel();
        agpsPanel.txtAgpsInfo2 = new JLabel();
        agpsPanel.btClearAgpsData = new JButton();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("bt747/j2se_view/Bundle");
        agpsPanel.agpsPanel.setBorder(BorderFactory.createTitledBorder(resourceBundle.getString("AgpsPanel.agpsPanel.border.title")));
        agpsPanel.txtAgpsUrl.setText(resourceBundle.getString("AgpsPanel.txtAgpsUrl.text"));
        agpsPanel.txtAgpsUrl.setToolTipText(resourceBundle.getString("AgpsPanel.txtAgpsUrl.toolTipText"));
        agpsPanel.txtAgpsUrl.addFocusListener(new FocusAdapter(agpsPanel){
            private /* synthetic */ AgpsPanel this$0;
            {
                this.this$0 = agpsPanel;
            }

            @Override
            public final void focusLost(FocusEvent focusEvent) {
                this.this$0.c.setStringOpt(53, this.this$0.txtAgpsUrl.getText());
            }
        });
        agpsPanel.lbAgpsUrl.setText(resourceBundle.getString("AgpsPanel.lbAgpsUrl.text"));
        agpsPanel.btUploadAgpsData.setText(resourceBundle.getString("AgpsPanel.btUploadAgpsData.text"));
        agpsPanel.btUploadAgpsData.addActionListener(new ActionListener(agpsPanel){
            private /* synthetic */ AgpsPanel this$0;
            {
                this.this$0 = agpsPanel;
            }

            @Override
            public final void actionPerformed(ActionEvent actionEvent) {
                this.this$0.c.downloadAndUploadAgpsData();
            }
        });
        agpsPanel.btDownloadAgpsData.setText(resourceBundle.getString("AgpsPanel.btDownloadAgpsData.text"));
        agpsPanel.txtAgpsInfo1.setText(resourceBundle.getString("AgpsPanel.txtAgpsInfo1.text"));
        agpsPanel.txtAgpsInfo2.setText(resourceBundle.getString("AgpsPanel.txtAgpsInfo2.text"));
        agpsPanel.btClearAgpsData.setText(resourceBundle.getString("AgpsPanel.btClearAgpsData.text"));
        agpsPanel.btClearAgpsData.addActionListener(new ActionListener(agpsPanel){
            private /* synthetic */ AgpsPanel this$0;
            {
                this.this$0 = agpsPanel;
            }

            @Override
            public final void actionPerformed(ActionEvent actionEvent) {
                this.this$0.c.gpsCmd(20);
            }
        });
        resourceBundle = new GroupLayout((Container)agpsPanel.agpsPanel);
        agpsPanel.agpsPanel.setLayout((LayoutManager)((Object)resourceBundle));
        resourceBundle.setHorizontalGroup((GroupLayout.Group)resourceBundle.createParallelGroup(1).add((GroupLayout.Group)resourceBundle.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)resourceBundle.createParallelGroup(1).add((GroupLayout.Group)resourceBundle.createSequentialGroup().add((Component)agpsPanel.lbAgpsUrl).addPreferredGap(1).add((Component)agpsPanel.txtAgpsUrl, -2, 351, -2)).add((GroupLayout.Group)resourceBundle.createSequentialGroup().add((Component)agpsPanel.btUploadAgpsData).addPreferredGap(0).add((Component)agpsPanel.btClearAgpsData).addPreferredGap(0).add((Component)agpsPanel.btDownloadAgpsData)).add((Component)agpsPanel.txtAgpsInfo1).add((Component)agpsPanel.txtAgpsInfo2))));
        resourceBundle.setVerticalGroup((GroupLayout.Group)resourceBundle.createParallelGroup(1).add((GroupLayout.Group)resourceBundle.createSequentialGroup().add((GroupLayout.Group)resourceBundle.createParallelGroup(3).add((Component)agpsPanel.lbAgpsUrl).add((Component)agpsPanel.txtAgpsUrl, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)resourceBundle.createParallelGroup(3).add((Component)agpsPanel.btUploadAgpsData).add((Component)agpsPanel.btClearAgpsData).add((Component)agpsPanel.btDownloadAgpsData)).addPreferredGap(0).add((Component)agpsPanel.txtAgpsInfo1).addPreferredGap(0).add((Component)agpsPanel.txtAgpsInfo2)));
        resourceBundle = new GroupLayout((Container)agpsPanel);
        agpsPanel.setLayout((LayoutManager)((Object)resourceBundle));
        resourceBundle.setHorizontalGroup((GroupLayout.Group)resourceBundle.createParallelGroup(1).add((Component)agpsPanel.agpsPanel, -2, -1, -2));
        resourceBundle.setVerticalGroup((GroupLayout.Group)resourceBundle.createParallelGroup(1).add((Component)agpsPanel.agpsPanel, -2, -1, -2));
    }

    public final void init(J2SEAppController modelListener) {
        this.c = modelListener;
        this.m = this.c.getModel();
        this.m.addListener(this);
        this.txtAgpsUrl.setVisible(false);
        this.updateAgps();
        modelListener = this;
        ((AgpsPanel)modelListener).txtAgpsUrl.setText(((AgpsPanel)modelListener).m.getStringOpt(53));
    }

    @Override
    public final void modelEvent(ModelEvent modelEvent) {
        switch (modelEvent.getType()) {
            case 266: 
            case 267: {
                this.updateAgps();
                return;
            }
            case 269: {
                switch (Integer.parseInt((String)modelEvent.getArg())) {
                    case 53: {
                        this.txtAgpsUrl.setText(this.m.getStringOpt(53));
                        return;
                    }
                }
                return;
            }
            case 37: {
                switch (((BT747Int)modelEvent.getArg()).getValue()) {
                    case 17: {
                        this.updateAgps();
                    }
                }
            }
        }
    }

    private final void updateAgps() {
        Object object = new Component[]{this.lbAgpsUrl, this.txtAgpsUrl, this.btClearAgpsData};
        MtkModel mtkModel = this.m.mtkModel();
        boolean bl = mtkModel.hasAgps();
        for (int i = 0; i < 3; ++i) {
            J2SEAppController.enableComponentHierarchy(object[i], bl);
        }
        this.btUploadAgpsData.setEnabled(bl && this.m.isConnected());
        if (mtkModel.hasAgps()) {
            object = TaggedFilePathFactory.format(J2SEAppController.getString("AGPSINFO1"), mtkModel.getAgpsDataCount(), CommonOut.getDateTimeStr(mtkModel.getAgpsStartTime()), CommonOut.getDateTimeStr(mtkModel.getAgpsEndTime()));
            String string = TaggedFilePathFactory.format(J2SEAppController.getString("AGPSINFO2"), CommonOut.getDateTimeStr(mtkModel.getAgpsStart2Time()), CommonOut.getDateTimeStr(mtkModel.getAgpsEnd2Time()));
            this.txtAgpsInfo1.setText((String)object);
            this.txtAgpsInfo2.setText(string);
        }
        this.txtAgpsInfo1.setVisible(mtkModel.hasAgps());
        this.txtAgpsInfo2.setVisible(mtkModel.hasAgps());
        this.btDownloadAgpsData.setVisible(false);
    }
}

