/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class ToStringStyle
implements Serializable {
    private static final long serialVersionUID = -2587890625525655916L;
    public static final ToStringStyle DEFAULT_STYLE = new DefaultToStringStyle();
    public static final ToStringStyle MULTI_LINE_STYLE = new MultiLineToStringStyle();
    public static final ToStringStyle NO_FIELD_NAMES_STYLE = new NoFieldNameToStringStyle();
    public static final ToStringStyle SHORT_PREFIX_STYLE = new ShortPrefixToStringStyle();
    public static final ToStringStyle SIMPLE_STYLE = new SimpleToStringStyle();
    public static final ToStringStyle NO_CLASS_NAME_STYLE = new NoClassNameToStringStyle();
    public static final ToStringStyle JSON_STYLE = new JsonToStringStyle();
    private static final ThreadLocal<WeakHashMap<Object, Object>> REGISTRY = new ThreadLocal();
    private boolean useFieldNames = true;
    private boolean useClassName = true;
    private boolean useShortClassName;
    private boolean useIdentityHashCode = true;
    private String contentStart = "[";
    private String contentEnd = "]";
    private String fieldNameValueSeparator = "=";
    private boolean fieldSeparatorAtStart;
    private boolean fieldSeparatorAtEnd;
    private String fieldSeparator = ",";
    private String arrayStart = "{";
    private String arraySeparator = ",";
    private boolean arrayContentDetail = true;
    private String arrayEnd = "}";
    private boolean defaultFullDetail = true;
    private String nullText = "<null>";
    private String sizeStartText = "<size=";
    private String sizeEndText = ">";
    private String summaryObjectStartText = "<";
    private String summaryObjectEndText = ">";

    static Map<Object, Object> getRegistry() {
        return REGISTRY.get();
    }

    static boolean isRegistered(Object value) {
        Map<Object, Object> m3 = ToStringStyle.getRegistry();
        return m3 != null && m3.containsKey(value);
    }

    static void register(Object value) {
        if (value != null) {
            Map<Object, Object> m3 = ToStringStyle.getRegistry();
            if (m3 == null) {
                REGISTRY.set(new WeakHashMap());
            }
            ToStringStyle.getRegistry().put(value, null);
        }
    }

    static void unregister(Object value) {
        Map<Object, Object> m3;
        if (value != null && (m3 = ToStringStyle.getRegistry()) != null) {
            m3.remove(value);
            if (m3.isEmpty()) {
                REGISTRY.remove();
            }
        }
    }

    protected ToStringStyle() {
    }

    public void appendSuper(StringBuffer buffer2, String superToString) {
        this.appendToString(buffer2, superToString);
    }

    public void appendToString(StringBuffer buffer2, String toString) {
        int pos2;
        int pos1;
        if (toString != null && (pos1 = toString.indexOf(this.contentStart) + this.contentStart.length()) != (pos2 = toString.lastIndexOf(this.contentEnd)) && pos1 >= 0 && pos2 >= 0) {
            if (this.fieldSeparatorAtStart) {
                this.removeLastFieldSeparator(buffer2);
            }
            buffer2.append(toString, pos1, pos2);
            this.appendFieldSeparator(buffer2);
        }
    }

    public void appendStart(StringBuffer buffer2, Object object) {
        if (object != null) {
            this.appendClassName(buffer2, object);
            this.appendIdentityHashCode(buffer2, object);
            this.appendContentStart(buffer2);
            if (this.fieldSeparatorAtStart) {
                this.appendFieldSeparator(buffer2);
            }
        }
    }

    public void appendEnd(StringBuffer buffer2, Object object) {
        if (!this.fieldSeparatorAtEnd) {
            this.removeLastFieldSeparator(buffer2);
        }
        this.appendContentEnd(buffer2);
        ToStringStyle.unregister(object);
    }

    protected void removeLastFieldSeparator(StringBuffer buffer2) {
        if (StringUtils.endsWith(buffer2, this.fieldSeparator)) {
            buffer2.setLength(buffer2.length() - this.fieldSeparator.length());
        }
    }

    public void append(StringBuffer buffer2, String fieldName, Object value, Boolean fullDetail) {
        this.appendFieldStart(buffer2, fieldName);
        if (value == null) {
            this.appendNullText(buffer2, fieldName);
        } else {
            this.appendInternal(buffer2, fieldName, value, this.isFullDetail(fullDetail));
        }
        this.appendFieldEnd(buffer2, fieldName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void appendInternal(StringBuffer buffer2, String fieldName, Object value, boolean detail) {
        if (ToStringStyle.isRegistered(value) && !(value instanceof Number) && !(value instanceof Boolean) && !(value instanceof Character)) {
            this.appendCyclicObject(buffer2, fieldName, value);
            return;
        }
        ToStringStyle.register(value);
        try {
            if (value instanceof Collection) {
                if (detail) {
                    this.appendDetail(buffer2, fieldName, (Collection)value);
                } else {
                    this.appendSummarySize(buffer2, fieldName, ((Collection)value).size());
                }
            } else if (value instanceof Map) {
                if (detail) {
                    this.appendDetail(buffer2, fieldName, (Map)value);
                } else {
                    this.appendSummarySize(buffer2, fieldName, ((Map)value).size());
                }
            } else if (value instanceof long[]) {
                if (detail) {
                    this.appendDetail(buffer2, fieldName, (long[])value);
                } else {
                    this.appendSummary(buffer2, fieldName, (long[])value);
                }
            } else if (value instanceof int[]) {
                if (detail) {
                    this.appendDetail(buffer2, fieldName, (int[])value);
                } else {
                    this.appendSummary(buffer2, fieldName, (int[])value);
                }
            } else if (value instanceof short[]) {
                if (detail) {
                    this.appendDetail(buffer2, fieldName, (short[])value);
                } else {
                    this.appendSummary(buffer2, fieldName, (short[])value);
                }
            } else if (value instanceof byte[]) {
                if (detail) {
                    this.appendDetail(buffer2, fieldName, (byte[])value);
                } else {
                    this.appendSummary(buffer2, fieldName, (byte[])value);
                }
            } else if (value instanceof char[]) {
                if (detail) {
                    this.appendDetail(buffer2, fieldName, (char[])value);
                } else {
                    this.appendSummary(buffer2, fieldName, (char[])value);
                }
            } else if (value instanceof double[]) {
                if (detail) {
                    this.appendDetail(buffer2, fieldName, (double[])value);
                } else {
                    this.appendSummary(buffer2, fieldName, (double[])value);
                }
            } else if (value instanceof float[]) {
                if (detail) {
                    this.appendDetail(buffer2, fieldName, (float[])value);
                } else {
                    this.appendSummary(buffer2, fieldName, (float[])value);
                }
            } else if (value instanceof boolean[]) {
                if (detail) {
                    this.appendDetail(buffer2, fieldName, (boolean[])value);
                } else {
                    this.appendSummary(buffer2, fieldName, (boolean[])value);
                }
            } else if (value.getClass().isArray()) {
                if (detail) {
                    this.appendDetail(buffer2, fieldName, (Object[])value);
                } else {
                    this.appendSummary(buffer2, fieldName, (Object[])value);
                }
            } else if (detail) {
                this.appendDetail(buffer2, fieldName, value);
            } else {
                this.appendSummary(buffer2, fieldName, value);
            }
        }
        finally {
            ToStringStyle.unregister(value);
        }
    }

    protected void appendCyclicObject(StringBuffer buffer2, String fieldName, Object value) {
        ObjectUtils.identityToString(buffer2, value);
    }

    protected void appendDetail(StringBuffer buffer2, String fieldName, Object value) {
        buffer2.append(value);
    }

    protected void appendDetail(StringBuffer buffer2, String fieldName, Collection<?> coll) {
        buffer2.append(coll);
    }

    protected void appendDetail(StringBuffer buffer2, String fieldName, Map<?, ?> map2) {
        buffer2.append(map2);
    }

    protected void appendSummary(StringBuffer buffer2, String fieldName, Object value) {
        buffer2.append(this.summaryObjectStartText);
        buffer2.append(this.getShortClassName(value.getClass()));
        buffer2.append(this.summaryObjectEndText);
    }

    public void append(StringBuffer buffer2, String fieldName, long value) {
        this.appendFieldStart(buffer2, fieldName);
        this.appendDetail(buffer2, fieldName, value);
        this.appendFieldEnd(buffer2, fieldName);
    }

    protected void appendDetail(StringBuffer buffer2, String fieldName, long value) {
        buffer2.append(value);
    }

    public void append(StringBuffer buffer2, String fieldName, int value) {
        this.appendFieldStart(buffer2, fieldName);
        this.appendDetail(buffer2, fieldName, value);
        this.appendFieldEnd(buffer2, fieldName);
    }

    protected void appendDetail(StringBuffer buffer2, String fieldName, int value) {
        buffer2.append(value);
    }

    public void append(StringBuffer buffer2, String fieldName, short value) {
        this.appendFieldStart(buffer2, fieldName);
        this.appendDetail(buffer2, fieldName, value);
        this.appendFieldEnd(buffer2, fieldName);
    }

    protected void appendDetail(StringBuffer buffer2, String fieldName, short value) {
        buffer2.append(value);
    }

    public void append(StringBuffer buffer2, String fieldName, byte value) {
        this.appendFieldStart(buffer2, fieldName);
        this.appendDetail(buffer2, fieldName, value);
        this.appendFieldEnd(buffer2, fieldName);
    }

    protected void appendDetail(StringBuffer buffer2, String fieldName, byte value) {
        buffer2.append(value);
    }

    public void append(StringBuffer buffer2, String fieldName, char value) {
        this.appendFieldStart(buffer2, fieldName);
        this.appendDetail(buffer2, fieldName, value);
        this.appendFieldEnd(buffer2, fieldName);
    }

    protected void appendDetail(StringBuffer buffer2, String fieldName, char value) {
        buffer2.append(value);
    }

    public void append(StringBuffer buffer2, String fieldName, double value) {
        this.appendFieldStart(buffer2, fieldName);
        this.appendDetail(buffer2, fieldName, value);
        this.appendFieldEnd(buffer2, fieldName);
    }

    protected void appendDetail(StringBuffer buffer2, String fieldName, double value) {
        buffer2.append(value);
    }

    public void append(StringBuffer buffer2, String fieldName, float value) {
        this.appendFieldStart(buffer2, fieldName);
        this.appendDetail(buffer2, fieldName, value);
        this.appendFieldEnd(buffer2, fieldName);
    }

    protected void appendDetail(StringBuffer buffer2, String fieldName, float value) {
        buffer2.append(value);
    }

    public void append(StringBuffer buffer2, String fieldName, boolean value) {
        this.appendFieldStart(buffer2, fieldName);
        this.appendDetail(buffer2, fieldName, value);
        this.appendFieldEnd(buffer2, fieldName);
    }

    protected void appendDetail(StringBuffer buffer2, String fieldName, boolean value) {
        buffer2.append(value);
    }

    public void append(StringBuffer buffer2, String fieldName, Object[] array2, Boolean fullDetail) {
        this.appendFieldStart(buffer2, fieldName);
        if (array2 == null) {
            this.appendNullText(buffer2, fieldName);
        } else if (this.isFullDetail(fullDetail)) {
            this.appendDetail(buffer2, fieldName, array2);
        } else {
            this.appendSummary(buffer2, fieldName, array2);
        }
        this.appendFieldEnd(buffer2, fieldName);
    }

    protected void appendDetail(StringBuffer buffer2, String fieldName, Object[] array2) {
        buffer2.append(this.arrayStart);
        for (int i = 0; i < array2.length; ++i) {
            Object item = array2[i];
            this.appendDetail(buffer2, fieldName, i, item);
        }
        buffer2.append(this.arrayEnd);
    }

    protected void appendDetail(StringBuffer buffer2, String fieldName, int i, Object item) {
        if (i > 0) {
            buffer2.append(this.arraySeparator);
        }
        if (item == null) {
            this.appendNullText(buffer2, fieldName);
        } else {
            this.appendInternal(buffer2, fieldName, item, this.arrayContentDetail);
        }
    }

    protected void reflectionAppendArrayDetail(StringBuffer buffer2, String fieldName, Object array2) {
        buffer2.append(this.arrayStart);
        int length = Array.getLength(array2);
        for (int i = 0; i < length; ++i) {
            Object item = Array.get(array2, i);
            this.appendDetail(buffer2, fieldName, i, item);
        }
        buffer2.append(this.arrayEnd);
    }

    protected void appendSummary(StringBuffer buffer2, String fieldName, Object[] array2) {
        this.appendSummarySize(buffer2, fieldName, array2.length);
    }

    public void append(StringBuffer buffer2, String fieldName, long[] array2, Boolean fullDetail) {
        this.appendFieldStart(buffer2, fieldName);
        if (array2 == null) {
            this.appendNullText(buffer2, fieldName);
        } else if (this.isFullDetail(fullDetail)) {
            this.appendDetail(buffer2, fieldName, array2);
        } else {
            this.appendSummary(buffer2, fieldName, array2);
        }
        this.appendFieldEnd(buffer2, fieldName);
    }

    protected void appendDetail(StringBuffer buffer2, String fieldName, long[] array2) {
        buffer2.append(this.arrayStart);
        for (int i = 0; i < array2.length; ++i) {
            if (i > 0) {
                buffer2.append(this.arraySeparator);
            }
            this.appendDetail(buffer2, fieldName, array2[i]);
        }
        buffer2.append(this.arrayEnd);
    }

    protected void appendSummary(StringBuffer buffer2, String fieldName, long[] array2) {
        this.appendSummarySize(buffer2, fieldName, array2.length);
    }

    public void append(StringBuffer buffer2, String fieldName, int[] array2, Boolean fullDetail) {
        this.appendFieldStart(buffer2, fieldName);
        if (array2 == null) {
            this.appendNullText(buffer2, fieldName);
        } else if (this.isFullDetail(fullDetail)) {
            this.appendDetail(buffer2, fieldName, array2);
        } else {
            this.appendSummary(buffer2, fieldName, array2);
        }
        this.appendFieldEnd(buffer2, fieldName);
    }

    protected void appendDetail(StringBuffer buffer2, String fieldName, int[] array2) {
        buffer2.append(this.arrayStart);
        for (int i = 0; i < array2.length; ++i) {
            if (i > 0) {
                buffer2.append(this.arraySeparator);
            }
            this.appendDetail(buffer2, fieldName, array2[i]);
        }
        buffer2.append(this.arrayEnd);
    }

    protected void appendSummary(StringBuffer buffer2, String fieldName, int[] array2) {
        this.appendSummarySize(buffer2, fieldName, array2.length);
    }

    public void append(StringBuffer buffer2, String fieldName, short[] array2, Boolean fullDetail) {
        this.appendFieldStart(buffer2, fieldName);
        if (array2 == null) {
            this.appendNullText(buffer2, fieldName);
        } else if (this.isFullDetail(fullDetail)) {
            this.appendDetail(buffer2, fieldName, array2);
        } else {
            this.appendSummary(buffer2, fieldName, array2);
        }
        this.appendFieldEnd(buffer2, fieldName);
    }

    protected void appendDetail(StringBuffer buffer2, String fieldName, short[] array2) {
        buffer2.append(this.arrayStart);
        for (int i = 0; i < array2.length; ++i) {
            if (i > 0) {
                buffer2.append(this.arraySeparator);
            }
            this.appendDetail(buffer2, fieldName, array2[i]);
        }
        buffer2.append(this.arrayEnd);
    }

    protected void appendSummary(StringBuffer buffer2, String fieldName, short[] array2) {
        this.appendSummarySize(buffer2, fieldName, array2.length);
    }

    public void append(StringBuffer buffer2, String fieldName, byte[] array2, Boolean fullDetail) {
        this.appendFieldStart(buffer2, fieldName);
        if (array2 == null) {
            this.appendNullText(buffer2, fieldName);
        } else if (this.isFullDetail(fullDetail)) {
            this.appendDetail(buffer2, fieldName, array2);
        } else {
            this.appendSummary(buffer2, fieldName, array2);
        }
        this.appendFieldEnd(buffer2, fieldName);
    }

    protected void appendDetail(StringBuffer buffer2, String fieldName, byte[] array2) {
        buffer2.append(this.arrayStart);
        for (int i = 0; i < array2.length; ++i) {
            if (i > 0) {
                buffer2.append(this.arraySeparator);
            }
            this.appendDetail(buffer2, fieldName, array2[i]);
        }
        buffer2.append(this.arrayEnd);
    }

    protected void appendSummary(StringBuffer buffer2, String fieldName, byte[] array2) {
        this.appendSummarySize(buffer2, fieldName, array2.length);
    }

    public void append(StringBuffer buffer2, String fieldName, char[] array2, Boolean fullDetail) {
        this.appendFieldStart(buffer2, fieldName);
        if (array2 == null) {
            this.appendNullText(buffer2, fieldName);
        } else if (this.isFullDetail(fullDetail)) {
            this.appendDetail(buffer2, fieldName, array2);
        } else {
            this.appendSummary(buffer2, fieldName, array2);
        }
        this.appendFieldEnd(buffer2, fieldName);
    }

    protected void appendDetail(StringBuffer buffer2, String fieldName, char[] array2) {
        buffer2.append(this.arrayStart);
        for (int i = 0; i < array2.length; ++i) {
            if (i > 0) {
                buffer2.append(this.arraySeparator);
            }
            this.appendDetail(buffer2, fieldName, array2[i]);
        }
        buffer2.append(this.arrayEnd);
    }

    protected void appendSummary(StringBuffer buffer2, String fieldName, char[] array2) {
        this.appendSummarySize(buffer2, fieldName, array2.length);
    }

    public void append(StringBuffer buffer2, String fieldName, double[] array2, Boolean fullDetail) {
        this.appendFieldStart(buffer2, fieldName);
        if (array2 == null) {
            this.appendNullText(buffer2, fieldName);
        } else if (this.isFullDetail(fullDetail)) {
            this.appendDetail(buffer2, fieldName, array2);
        } else {
            this.appendSummary(buffer2, fieldName, array2);
        }
        this.appendFieldEnd(buffer2, fieldName);
    }

    protected void appendDetail(StringBuffer buffer2, String fieldName, double[] array2) {
        buffer2.append(this.arrayStart);
        for (int i = 0; i < array2.length; ++i) {
            if (i > 0) {
                buffer2.append(this.arraySeparator);
            }
            this.appendDetail(buffer2, fieldName, array2[i]);
        }
        buffer2.append(this.arrayEnd);
    }

    protected void appendSummary(StringBuffer buffer2, String fieldName, double[] array2) {
        this.appendSummarySize(buffer2, fieldName, array2.length);
    }

    public void append(StringBuffer buffer2, String fieldName, float[] array2, Boolean fullDetail) {
        this.appendFieldStart(buffer2, fieldName);
        if (array2 == null) {
            this.appendNullText(buffer2, fieldName);
        } else if (this.isFullDetail(fullDetail)) {
            this.appendDetail(buffer2, fieldName, array2);
        } else {
            this.appendSummary(buffer2, fieldName, array2);
        }
        this.appendFieldEnd(buffer2, fieldName);
    }

    protected void appendDetail(StringBuffer buffer2, String fieldName, float[] array2) {
        buffer2.append(this.arrayStart);
        for (int i = 0; i < array2.length; ++i) {
            if (i > 0) {
                buffer2.append(this.arraySeparator);
            }
            this.appendDetail(buffer2, fieldName, array2[i]);
        }
        buffer2.append(this.arrayEnd);
    }

    protected void appendSummary(StringBuffer buffer2, String fieldName, float[] array2) {
        this.appendSummarySize(buffer2, fieldName, array2.length);
    }

    public void append(StringBuffer buffer2, String fieldName, boolean[] array2, Boolean fullDetail) {
        this.appendFieldStart(buffer2, fieldName);
        if (array2 == null) {
            this.appendNullText(buffer2, fieldName);
        } else if (this.isFullDetail(fullDetail)) {
            this.appendDetail(buffer2, fieldName, array2);
        } else {
            this.appendSummary(buffer2, fieldName, array2);
        }
        this.appendFieldEnd(buffer2, fieldName);
    }

    protected void appendDetail(StringBuffer buffer2, String fieldName, boolean[] array2) {
        buffer2.append(this.arrayStart);
        for (int i = 0; i < array2.length; ++i) {
            if (i > 0) {
                buffer2.append(this.arraySeparator);
            }
            this.appendDetail(buffer2, fieldName, array2[i]);
        }
        buffer2.append(this.arrayEnd);
    }

    protected void appendSummary(StringBuffer buffer2, String fieldName, boolean[] array2) {
        this.appendSummarySize(buffer2, fieldName, array2.length);
    }

    protected void appendClassName(StringBuffer buffer2, Object object) {
        if (this.useClassName && object != null) {
            ToStringStyle.register(object);
            if (this.useShortClassName) {
                buffer2.append(this.getShortClassName(object.getClass()));
            } else {
                buffer2.append(object.getClass().getName());
            }
        }
    }

    protected void appendIdentityHashCode(StringBuffer buffer2, Object object) {
        if (this.isUseIdentityHashCode() && object != null) {
            ToStringStyle.register(object);
            buffer2.append('@');
            buffer2.append(Integer.toHexString(System.identityHashCode(object)));
        }
    }

    protected void appendContentStart(StringBuffer buffer2) {
        buffer2.append(this.contentStart);
    }

    protected void appendContentEnd(StringBuffer buffer2) {
        buffer2.append(this.contentEnd);
    }

    protected void appendNullText(StringBuffer buffer2, String fieldName) {
        buffer2.append(this.nullText);
    }

    protected void appendFieldSeparator(StringBuffer buffer2) {
        buffer2.append(this.fieldSeparator);
    }

    protected void appendFieldStart(StringBuffer buffer2, String fieldName) {
        if (this.useFieldNames && fieldName != null) {
            buffer2.append(fieldName);
            buffer2.append(this.fieldNameValueSeparator);
        }
    }

    protected void appendFieldEnd(StringBuffer buffer2, String fieldName) {
        this.appendFieldSeparator(buffer2);
    }

    protected void appendSummarySize(StringBuffer buffer2, String fieldName, int size) {
        buffer2.append(this.sizeStartText);
        buffer2.append(size);
        buffer2.append(this.sizeEndText);
    }

    protected boolean isFullDetail(Boolean fullDetailRequest) {
        if (fullDetailRequest == null) {
            return this.defaultFullDetail;
        }
        return fullDetailRequest;
    }

    protected String getShortClassName(Class<?> cls) {
        return ClassUtils.getShortClassName(cls);
    }

    protected boolean isUseClassName() {
        return this.useClassName;
    }

    protected void setUseClassName(boolean useClassName) {
        this.useClassName = useClassName;
    }

    protected boolean isUseShortClassName() {
        return this.useShortClassName;
    }

    protected void setUseShortClassName(boolean useShortClassName) {
        this.useShortClassName = useShortClassName;
    }

    protected boolean isUseIdentityHashCode() {
        return this.useIdentityHashCode;
    }

    protected void setUseIdentityHashCode(boolean useIdentityHashCode) {
        this.useIdentityHashCode = useIdentityHashCode;
    }

    protected boolean isUseFieldNames() {
        return this.useFieldNames;
    }

    protected void setUseFieldNames(boolean useFieldNames) {
        this.useFieldNames = useFieldNames;
    }

    protected boolean isDefaultFullDetail() {
        return this.defaultFullDetail;
    }

    protected void setDefaultFullDetail(boolean defaultFullDetail) {
        this.defaultFullDetail = defaultFullDetail;
    }

    protected boolean isArrayContentDetail() {
        return this.arrayContentDetail;
    }

    protected void setArrayContentDetail(boolean arrayContentDetail) {
        this.arrayContentDetail = arrayContentDetail;
    }

    protected String getArrayStart() {
        return this.arrayStart;
    }

    protected void setArrayStart(String arrayStart) {
        if (arrayStart == null) {
            arrayStart = "";
        }
        this.arrayStart = arrayStart;
    }

    protected String getArrayEnd() {
        return this.arrayEnd;
    }

    protected void setArrayEnd(String arrayEnd) {
        if (arrayEnd == null) {
            arrayEnd = "";
        }
        this.arrayEnd = arrayEnd;
    }

    protected String getArraySeparator() {
        return this.arraySeparator;
    }

    protected void setArraySeparator(String arraySeparator) {
        if (arraySeparator == null) {
            arraySeparator = "";
        }
        this.arraySeparator = arraySeparator;
    }

    protected String getContentStart() {
        return this.contentStart;
    }

    protected void setContentStart(String contentStart) {
        if (contentStart == null) {
            contentStart = "";
        }
        this.contentStart = contentStart;
    }

    protected String getContentEnd() {
        return this.contentEnd;
    }

    protected void setContentEnd(String contentEnd) {
        if (contentEnd == null) {
            contentEnd = "";
        }
        this.contentEnd = contentEnd;
    }

    protected String getFieldNameValueSeparator() {
        return this.fieldNameValueSeparator;
    }

    protected void setFieldNameValueSeparator(String fieldNameValueSeparator) {
        if (fieldNameValueSeparator == null) {
            fieldNameValueSeparator = "";
        }
        this.fieldNameValueSeparator = fieldNameValueSeparator;
    }

    protected String getFieldSeparator() {
        return this.fieldSeparator;
    }

    protected void setFieldSeparator(String fieldSeparator) {
        if (fieldSeparator == null) {
            fieldSeparator = "";
        }
        this.fieldSeparator = fieldSeparator;
    }

    protected boolean isFieldSeparatorAtStart() {
        return this.fieldSeparatorAtStart;
    }

    protected void setFieldSeparatorAtStart(boolean fieldSeparatorAtStart) {
        this.fieldSeparatorAtStart = fieldSeparatorAtStart;
    }

    protected boolean isFieldSeparatorAtEnd() {
        return this.fieldSeparatorAtEnd;
    }

    protected void setFieldSeparatorAtEnd(boolean fieldSeparatorAtEnd) {
        this.fieldSeparatorAtEnd = fieldSeparatorAtEnd;
    }

    protected String getNullText() {
        return this.nullText;
    }

    protected void setNullText(String nullText) {
        if (nullText == null) {
            nullText = "";
        }
        this.nullText = nullText;
    }

    protected String getSizeStartText() {
        return this.sizeStartText;
    }

    protected void setSizeStartText(String sizeStartText) {
        if (sizeStartText == null) {
            sizeStartText = "";
        }
        this.sizeStartText = sizeStartText;
    }

    protected String getSizeEndText() {
        return this.sizeEndText;
    }

    protected void setSizeEndText(String sizeEndText) {
        if (sizeEndText == null) {
            sizeEndText = "";
        }
        this.sizeEndText = sizeEndText;
    }

    protected String getSummaryObjectStartText() {
        return this.summaryObjectStartText;
    }

    protected void setSummaryObjectStartText(String summaryObjectStartText) {
        if (summaryObjectStartText == null) {
            summaryObjectStartText = "";
        }
        this.summaryObjectStartText = summaryObjectStartText;
    }

    protected String getSummaryObjectEndText() {
        return this.summaryObjectEndText;
    }

    protected void setSummaryObjectEndText(String summaryObjectEndText) {
        if (summaryObjectEndText == null) {
            summaryObjectEndText = "";
        }
        this.summaryObjectEndText = summaryObjectEndText;
    }

    private static final class JsonToStringStyle
    extends ToStringStyle {
        private static final long serialVersionUID = 1L;
        private static final String FIELD_NAME_QUOTE = "\"";

        JsonToStringStyle() {
            this.setUseClassName(false);
            this.setUseIdentityHashCode(false);
            this.setContentStart("{");
            this.setContentEnd("}");
            this.setArrayStart("[");
            this.setArrayEnd("]");
            this.setFieldSeparator(",");
            this.setFieldNameValueSeparator(":");
            this.setNullText("null");
            this.setSummaryObjectStartText("\"<");
            this.setSummaryObjectEndText(">\"");
            this.setSizeStartText("\"<size=");
            this.setSizeEndText(">\"");
        }

        @Override
        public void append(StringBuffer buffer2, String fieldName, Object[] array2, Boolean fullDetail) {
            if (fieldName == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(fullDetail)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append(buffer2, fieldName, array2, fullDetail);
        }

        @Override
        public void append(StringBuffer buffer2, String fieldName, long[] array2, Boolean fullDetail) {
            if (fieldName == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(fullDetail)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append(buffer2, fieldName, array2, fullDetail);
        }

        @Override
        public void append(StringBuffer buffer2, String fieldName, int[] array2, Boolean fullDetail) {
            if (fieldName == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(fullDetail)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append(buffer2, fieldName, array2, fullDetail);
        }

        @Override
        public void append(StringBuffer buffer2, String fieldName, short[] array2, Boolean fullDetail) {
            if (fieldName == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(fullDetail)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append(buffer2, fieldName, array2, fullDetail);
        }

        @Override
        public void append(StringBuffer buffer2, String fieldName, byte[] array2, Boolean fullDetail) {
            if (fieldName == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(fullDetail)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append(buffer2, fieldName, array2, fullDetail);
        }

        @Override
        public void append(StringBuffer buffer2, String fieldName, char[] array2, Boolean fullDetail) {
            if (fieldName == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(fullDetail)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append(buffer2, fieldName, array2, fullDetail);
        }

        @Override
        public void append(StringBuffer buffer2, String fieldName, double[] array2, Boolean fullDetail) {
            if (fieldName == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(fullDetail)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append(buffer2, fieldName, array2, fullDetail);
        }

        @Override
        public void append(StringBuffer buffer2, String fieldName, float[] array2, Boolean fullDetail) {
            if (fieldName == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(fullDetail)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append(buffer2, fieldName, array2, fullDetail);
        }

        @Override
        public void append(StringBuffer buffer2, String fieldName, boolean[] array2, Boolean fullDetail) {
            if (fieldName == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(fullDetail)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append(buffer2, fieldName, array2, fullDetail);
        }

        @Override
        public void append(StringBuffer buffer2, String fieldName, Object value, Boolean fullDetail) {
            if (fieldName == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(fullDetail)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append(buffer2, fieldName, value, fullDetail);
        }

        @Override
        protected void appendDetail(StringBuffer buffer2, String fieldName, char value) {
            this.appendValueAsString(buffer2, String.valueOf(value));
        }

        @Override
        protected void appendDetail(StringBuffer buffer2, String fieldName, Object value) {
            if (value == null) {
                this.appendNullText(buffer2, fieldName);
                return;
            }
            if (value instanceof String || value instanceof Character) {
                this.appendValueAsString(buffer2, value.toString());
                return;
            }
            if (value instanceof Number || value instanceof Boolean) {
                buffer2.append(value);
                return;
            }
            String valueAsString = value.toString();
            if (this.isJsonObject(valueAsString) || this.isJsonArray(valueAsString)) {
                buffer2.append(value);
                return;
            }
            this.appendDetail(buffer2, fieldName, valueAsString);
        }

        @Override
        protected void appendDetail(StringBuffer buffer2, String fieldName, Collection<?> coll) {
            if (coll != null && !coll.isEmpty()) {
                buffer2.append(this.getArrayStart());
                int i = 0;
                for (Object item : coll) {
                    this.appendDetail(buffer2, fieldName, i++, item);
                }
                buffer2.append(this.getArrayEnd());
                return;
            }
            buffer2.append(coll);
        }

        @Override
        protected void appendDetail(StringBuffer buffer2, String fieldName, Map<?, ?> map2) {
            if (map2 != null && !map2.isEmpty()) {
                buffer2.append(this.getContentStart());
                boolean firstItem = true;
                for (Map.Entry<?, ?> entry : map2.entrySet()) {
                    String keyStr = Objects.toString(entry.getKey(), null);
                    if (keyStr == null) continue;
                    if (firstItem) {
                        firstItem = false;
                    } else {
                        this.appendFieldEnd(buffer2, keyStr);
                    }
                    this.appendFieldStart(buffer2, keyStr);
                    Object value = entry.getValue();
                    if (value == null) {
                        this.appendNullText(buffer2, keyStr);
                        continue;
                    }
                    this.appendInternal(buffer2, keyStr, value, true);
                }
                buffer2.append(this.getContentEnd());
                return;
            }
            buffer2.append(map2);
        }

        private boolean isJsonArray(String valueAsString) {
            return valueAsString.startsWith(this.getArrayStart()) && valueAsString.endsWith(this.getArrayEnd());
        }

        private boolean isJsonObject(String valueAsString) {
            return valueAsString.startsWith(this.getContentStart()) && valueAsString.endsWith(this.getContentEnd());
        }

        private void appendValueAsString(StringBuffer buffer2, String value) {
            buffer2.append('\"').append(StringEscapeUtils.escapeJson(value)).append('\"');
        }

        @Override
        protected void appendFieldStart(StringBuffer buffer2, String fieldName) {
            if (fieldName == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            super.appendFieldStart(buffer2, FIELD_NAME_QUOTE + StringEscapeUtils.escapeJson(fieldName) + FIELD_NAME_QUOTE);
        }

        private Object readResolve() {
            return JSON_STYLE;
        }
    }

    private static final class NoClassNameToStringStyle
    extends ToStringStyle {
        private static final long serialVersionUID = 1L;

        NoClassNameToStringStyle() {
            this.setUseClassName(false);
            this.setUseIdentityHashCode(false);
        }

        private Object readResolve() {
            return NO_CLASS_NAME_STYLE;
        }
    }

    private static final class MultiLineToStringStyle
    extends ToStringStyle {
        private static final long serialVersionUID = 1L;

        MultiLineToStringStyle() {
            this.setContentStart("[");
            this.setFieldSeparator(System.lineSeparator() + "  ");
            this.setFieldSeparatorAtStart(true);
            this.setContentEnd(System.lineSeparator() + "]");
        }

        private Object readResolve() {
            return MULTI_LINE_STYLE;
        }
    }

    private static final class SimpleToStringStyle
    extends ToStringStyle {
        private static final long serialVersionUID = 1L;

        SimpleToStringStyle() {
            this.setUseClassName(false);
            this.setUseIdentityHashCode(false);
            this.setUseFieldNames(false);
            this.setContentStart("");
            this.setContentEnd("");
        }

        private Object readResolve() {
            return SIMPLE_STYLE;
        }
    }

    private static final class ShortPrefixToStringStyle
    extends ToStringStyle {
        private static final long serialVersionUID = 1L;

        ShortPrefixToStringStyle() {
            this.setUseShortClassName(true);
            this.setUseIdentityHashCode(false);
        }

        private Object readResolve() {
            return SHORT_PREFIX_STYLE;
        }
    }

    private static final class NoFieldNameToStringStyle
    extends ToStringStyle {
        private static final long serialVersionUID = 1L;

        NoFieldNameToStringStyle() {
            this.setUseFieldNames(false);
        }

        private Object readResolve() {
            return NO_FIELD_NAMES_STYLE;
        }
    }

    private static final class DefaultToStringStyle
    extends ToStringStyle {
        private static final long serialVersionUID = 1L;

        DefaultToStringStyle() {
        }

        private Object readResolve() {
            return DEFAULT_STYLE;
        }
    }
}

