/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.type1;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PostscriptParser {
    protected static final Log LOG = LogFactory.getLog(PostscriptParser.class);
    private static final String DICTIONARY = "dict";
    private static final String FIXED_ARRAY = "array";
    private static final String VARIABLE_ARRAY = "[";
    private static final String SUBROUTINE = "{";
    private HashMap<String, PSSubroutine> subroutines = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PSElement> parse(byte[] segment) throws IOException {
        ArrayList<PSElement> parsedElements = new ArrayList<PSElement>();
        PSElement foundElement = null;
        String operator = null;
        StringBuilder token = new StringBuilder();
        ArrayList<String> tokens = new ArrayList<String>();
        int startPoint = -1;
        boolean specialDelimiter = false;
        boolean lastWasSpecial = false;
        for (int i = 0; i < segment.length; ++i) {
            byte cur = segment[i];
            if (foundElement != null && foundElement.hasMore()) {
                foundElement.parse(cur, i);
                continue;
            }
            char c = (char)cur;
            if (!lastWasSpecial) {
                boolean isNotBreak;
                specialDelimiter = c == '{' || c == '}' || c == '[' || c == ']' || !token.toString().equals("") && c == '/';
                boolean bl = isNotBreak = c != ' ' && c != '\r' && cur != 15 && cur != 12 && cur != 10;
                if (isNotBreak && !specialDelimiter) {
                    token.append(c);
                    continue;
                }
            } else {
                lastWasSpecial = false;
                token.append(c);
                if (token.toString().equals("/")) continue;
            }
            try {
                boolean setOp = false;
                if ((foundElement == null || !foundElement.hasMore()) && token.length() > 1 && token.charAt(0) == '/' && tokens.size() != 1 || this.hasEndToken(token.toString())) {
                    operator = token.toString();
                    setOp = true;
                    if (tokens.size() > 2 && ((String)tokens.get(tokens.size() - 1)).equals("def")) {
                        PSVariable newVar = new PSVariable((String)tokens.get(0), startPoint);
                        newVar.setValue((String)tokens.get(1));
                        newVar.setEndPoint(i - operator.length());
                        parsedElements.add(newVar);
                    }
                    tokens.clear();
                    startPoint = i - token.length();
                }
                if (operator == null) continue;
                if (foundElement instanceof PSSubroutine) {
                    PSSubroutine sub = (PSSubroutine)foundElement;
                    this.subroutines.put(sub.getOperator(), sub);
                    parsedElements.add(sub);
                    if (!setOp) {
                        operator = "";
                    }
                } else if (foundElement != null) {
                    if (!this.hasMatch(foundElement.getOperator(), parsedElements)) {
                        parsedElements.add(foundElement);
                    } else {
                        LOG.warn((Object)("Duplicate " + foundElement.getOperator() + " in font file, Ignoring."));
                    }
                }
                foundElement = this.createElement(operator, token.toString(), startPoint);
                continue;
            }
            finally {
                tokens.add(token.toString());
                token = new StringBuilder();
                if (specialDelimiter) {
                    specialDelimiter = false;
                    lastWasSpecial = true;
                    --i;
                }
            }
        }
        return parsedElements;
    }

    private boolean hasEndToken(String token) {
        return token.equals("currentdict");
    }

    private boolean hasMatch(String operator, List<PSElement> elements) {
        for (PSElement element : elements) {
            if (!element.getOperator().equals(operator)) continue;
            return true;
        }
        return false;
    }

    public PSElement createElement(String operator, String elementID, int startPoint) {
        if (operator.equals("")) {
            return null;
        }
        if (elementID.equals(FIXED_ARRAY)) {
            return new PSFixedArray(operator, startPoint);
        }
        if (elementID.equals(VARIABLE_ARRAY)) {
            return new PSVariableArray(operator, startPoint);
        }
        if (elementID.equals(SUBROUTINE)) {
            return new PSSubroutine(operator, startPoint);
        }
        if (!operator.equals("/Private") && elementID.equals(DICTIONARY)) {
            return new PSDictionary(operator, startPoint);
        }
        return null;
    }

    public abstract class PSElement {
        protected String operator;
        private List<Byte> token;
        protected boolean hasMore = true;
        protected LinkedHashMap<String, int[]> binaryEntries;
        protected List<String> tokens;
        protected boolean readBinary;
        private int startPoint = -1;
        protected int endPoint = -1;
        private boolean foundUnexpected;

        public PSElement(String operator, int startPoint) {
            this.operator = operator;
            this.startPoint = startPoint;
            this.token = new ArrayList<Byte>();
            this.binaryEntries = new LinkedHashMap();
            this.tokens = new ArrayList<String>();
        }

        public String getOperator() {
            return this.operator;
        }

        public int getStartPoint() {
            return this.startPoint;
        }

        public int getEndPoint() {
            return this.endPoint;
        }

        public void parse(byte cur, int pos) throws UnsupportedEncodingException {
            if (!this.readBinary) {
                boolean isNotValidBreak;
                char c = (char)cur;
                boolean specialDelimiter = c == '{' || c == '}' || c == '[' || c == ']' || c == '(' || c == ')';
                boolean bl = isNotValidBreak = c != ' ' && cur != 15 && cur != 12 && c != '\r' && c != '\n';
                if (isNotValidBreak && !specialDelimiter) {
                    this.token.add(cur);
                } else {
                    this.parseToken(pos);
                }
                if (specialDelimiter) {
                    this.token.add(cur);
                    this.parseToken(pos);
                }
            } else {
                this.parseByte(cur, pos);
            }
        }

        private void parseToken(int pos) throws UnsupportedEncodingException {
            byte[] bytesToken = new byte[this.token.size()];
            for (int i = 0; i < this.token.size(); ++i) {
                bytesToken[i] = this.token.get(i);
            }
            this.parseToken(new String(bytesToken, "ASCII"), pos);
            this.token.clear();
        }

        public abstract void parseByte(byte var1, int var2);

        public abstract void parseToken(String var1, int var2);

        protected boolean isInteger(String intValue) {
            try {
                Integer.parseInt(intValue);
                return true;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }

        public LinkedHashMap<String, int[]> getBinaryEntries() {
            return this.binaryEntries;
        }

        public int[] getBinaryEntryByIndex(int index) {
            int count = 0;
            for (Map.Entry<String, int[]> entry : this.binaryEntries.entrySet()) {
                if (count == index) {
                    return entry.getValue();
                }
                ++count;
            }
            return new int[0];
        }

        public boolean hasMore() {
            return this.hasMore;
        }

        protected void setFoundUnexpected(boolean foundUnexpected) {
            this.foundUnexpected = foundUnexpected;
        }

        public boolean getFoundUnexpected() {
            return this.foundUnexpected;
        }
    }

    public class PSVariable
    extends PSElement {
        private String value;

        public PSVariable(String operator, int startPoint) {
            super(operator, startPoint);
            this.value = "";
        }

        @Override
        public void parseToken(String token, int curPos) {
            if (token.equals("def")) {
                this.hasMore = false;
                this.endPoint = curPos;
                return;
            }
        }

        @Override
        public void parseByte(byte cur, int pos) {
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setEndPoint(int endPoint) {
            this.endPoint = endPoint;
        }
    }

    public class PSSubroutine
    extends PSElement {
        private int level;
        private String entry;

        public PSSubroutine(String operator, int startPoint) {
            super(operator, startPoint);
            this.level = 1;
            this.entry = "";
        }

        @Override
        public void parseToken(String token, int curPos) {
            if (this.level == 0 && token.length() > 0 && (token.equals("def") || token.equals("ifelse") || token.charAt(0) == '}')) {
                this.hasMore = false;
                this.endPoint = curPos;
                return;
            }
            if (token.equals(PostscriptParser.SUBROUTINE)) {
                ++this.level;
            } else if (token.equals("}")) {
                --this.level;
            }
            this.entry = this.entry + token + " ";
        }

        public String getSubroutine() {
            return this.entry.trim();
        }

        @Override
        public void parseByte(byte cur, int pos) {
        }
    }

    public class PSFixedArray
    extends PSElement {
        private String entry;
        private String token;
        private boolean finished;
        protected int binaryLength;
        private HashMap<Integer, String> entries;
        private static final String READ_ONLY = "readonly";

        public PSFixedArray(String operator, int startPoint) {
            super(operator, startPoint);
            this.entry = "";
            this.token = "";
            this.entries = new HashMap();
        }

        @Override
        public void parseToken(String token, int curPos) {
            if (!this.checkForEnd(token) || token.equals("def")) {
                this.hasMore = false;
                this.endPoint = curPos;
                return;
            }
            if (token.equals("dup")) {
                if (this.entry.startsWith("dup")) {
                    this.addEntry(this.entry);
                }
                this.entry = "";
                this.tokens.clear();
            }
            if (!token.equals(READ_ONLY)) {
                this.entry = this.entry + token + " ";
            }
            if (!token.trim().equals("")) {
                this.tokens.add(token);
            }
            if (this.tokens.size() == 4 && ((String)this.tokens.get(0)).equals("dup") && this.isInteger((String)this.tokens.get(2))) {
                this.binaryLength = Integer.parseInt((String)this.tokens.get(2));
                this.readBinary = true;
            }
        }

        private boolean checkForEnd(String checkToken) {
            boolean subFound = false;
            PSSubroutine sub = (PSSubroutine)PostscriptParser.this.subroutines.get("/" + checkToken);
            if (sub != null && sub.getSubroutine().contains("def")) {
                subFound = true;
            }
            if (!this.finished && (subFound || checkToken.equals("def"))) {
                this.finished = true;
                this.addEntry(this.entry);
                return false;
            }
            return !this.finished;
        }

        public HashMap<Integer, String> getEntries() {
            return this.entries;
        }

        private void addEntry(String entry) {
            if (!entry.equals("")) {
                int entryLen;
                if (entry.indexOf(47) != -1 && entry.charAt(entry.indexOf(47) - 1) != ' ') {
                    entry = entry.replace("/", " /");
                }
                do {
                    entryLen = entry.length();
                } while ((entry = entry.replace("  ", " ")).length() != entryLen);
                Scanner s = new Scanner(entry).useDelimiter(" ");
                boolean valid = false;
                s.next();
                if (s.hasNext()) {
                    int id = s.nextInt();
                    this.entries.put(id, entry);
                    valid = true;
                }
                if (!valid) {
                    this.setFoundUnexpected(true);
                }
            }
        }

        @Override
        public void parseByte(byte cur, int pos) {
            if (this.binaryLength > 0) {
                this.token = this.token + (char)cur;
                --this.binaryLength;
            } else if (this.readBinary) {
                int bLength = Integer.parseInt((String)this.tokens.get(2));
                int start = pos - bLength;
                int end = start + bLength;
                this.binaryEntries.put((String)this.tokens.get(1), new int[]{start, end});
                this.token = "";
                this.readBinary = false;
            } else {
                this.tokens.add(this.token);
                this.parseToken(this.token, pos);
                this.token = "";
            }
        }
    }

    public class PSVariableArray
    extends PSElement {
        private int level;
        private List<String> arrayItems;
        private String entry;

        public PSVariableArray(String operator, int startPoint) {
            super(operator, startPoint);
            this.entry = "";
            this.arrayItems = new ArrayList<String>();
        }

        @Override
        public void parseToken(String token, int curPos) {
            this.entry = this.entry + token + " ";
            if (this.level <= 0 && token.length() > 0 && token.charAt(0) == ']') {
                this.hasMore = false;
                this.endPoint = curPos;
                return;
            }
            if (token.equals(PostscriptParser.SUBROUTINE)) {
                ++this.level;
            } else if (token.equals("}")) {
                --this.level;
                if (!this.entry.equals("") && this.level == 0) {
                    this.arrayItems.add(this.entry);
                    this.entry = "";
                }
            }
        }

        public List<String> getEntries() {
            return this.arrayItems;
        }

        @Override
        public void parseByte(byte cur, int pos) {
        }
    }

    public class PSDictionary
    extends PSElement {
        private HashMap<String, String> entries;
        private String entry;
        private String token;
        protected int binaryLength;

        public PSDictionary(String operator, int startPoint) {
            super(operator, startPoint);
            this.entry = "";
            this.token = "";
            this.entries = new HashMap();
        }

        @Override
        public void parseToken(String token, int curPos) {
            if (token.equals("end")) {
                this.addEntry(this.entry);
                this.hasMore = false;
                this.endPoint = curPos;
                return;
            }
            if (token.startsWith("/")) {
                if (this.entry.trim().startsWith("/")) {
                    this.tokens.clear();
                    this.addEntry(this.entry);
                }
                this.entry = "";
            }
            if (this.tokens.size() >= 1 || token.startsWith("/")) {
                this.tokens.add(token);
            }
            this.entry = this.entry + token + " ";
            if (this.tokens.size() == 3 && ((String)this.tokens.get(0)).startsWith("/") && !((String)this.tokens.get(2)).equals("def") && this.isInteger((String)this.tokens.get(1))) {
                this.binaryLength = Integer.parseInt((String)this.tokens.get(1));
                this.readBinary = true;
            }
        }

        public HashMap<String, String> getEntries() {
            return this.entries;
        }

        private void addEntry(String entry) {
            Scanner s = new Scanner(entry).useDelimiter(" ");
            String id = s.next();
            this.entries.put(id, entry);
        }

        @Override
        public void parseByte(byte cur, int pos) {
            if (this.binaryLength > 0) {
                --this.binaryLength;
            } else if (this.readBinary) {
                int start = pos - Integer.parseInt((String)this.tokens.get(1));
                int end = pos;
                this.binaryEntries.put((String)this.tokens.get(0), new int[]{start, end});
                this.readBinary = false;
            } else {
                this.tokens.add(this.token);
                this.parseToken(this.token, pos);
            }
        }
    }
}

