/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public final class Stopwatch {
    private final long start;

    private Stopwatch(long start) {
        this.start = start;
    }

    public static Stopwatch createStarted() {
        return new Stopwatch(System.nanoTime());
    }

    public long elapsed() {
        return (System.nanoTime() - this.start) / 1000000L;
    }

    public String toString() {
        return Utils.getDurationString(Math.max(0L, this.elapsed()));
    }

    public String toString(String taskName) {
        return I18n.tr("{0} completed in {1}", taskName, this.toString());
    }
}

