/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.Collection;
import org.apache.maven.lifecycle.MojoExecutionConfigurator;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Component(role=MojoExecutionConfigurator.class)
public class DefaultMojoExecutionConfigurator
implements MojoExecutionConfigurator {
    @Override
    public void configure(MavenProject project, MojoExecution mojoExecution, boolean allowPluginLevelConfig) {
        String a;
        String g = mojoExecution.getPlugin().getGroupId();
        Plugin plugin = this.findPlugin(g, a = mojoExecution.getPlugin().getArtifactId(), project.getBuildPlugins());
        if (plugin == null && project.getPluginManagement() != null) {
            plugin = this.findPlugin(g, a, project.getPluginManagement().getPlugins());
        }
        if (plugin != null) {
            PluginExecution pluginExecution = this.findPluginExecution(mojoExecution.getExecutionId(), plugin.getExecutions());
            Xpp3Dom pomConfiguration = null;
            if (pluginExecution != null) {
                pomConfiguration = (Xpp3Dom)pluginExecution.getConfiguration();
            } else if (allowPluginLevelConfig) {
                pomConfiguration = (Xpp3Dom)plugin.getConfiguration();
            }
            Xpp3Dom mojoConfiguration = pomConfiguration != null ? new Xpp3Dom(pomConfiguration) : null;
            mojoConfiguration = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)mojoExecution.getConfiguration(), (Xpp3Dom)mojoConfiguration);
            mojoExecution.setConfiguration(mojoConfiguration);
        }
    }

    private Plugin findPlugin(String groupId, String artifactId, Collection<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            if (!artifactId.equals(plugin.getArtifactId()) || !groupId.equals(plugin.getGroupId())) continue;
            return plugin;
        }
        return null;
    }

    private PluginExecution findPluginExecution(String executionId, Collection<PluginExecution> executions) {
        if (StringUtils.isNotEmpty((String)executionId)) {
            for (PluginExecution execution : executions) {
                if (!executionId.equals(execution.getId())) continue;
                return execution;
            }
        }
        return null;
    }
}

