/*
 * Copyright (c) 2012, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.brx;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_brx extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "\u092e\u0927\u094d\u092f \u0905\u092b\u094d\u0930\u0940\u0915\u093e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "CAT",
               "Central Africa Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "\u092e\u0949\u0938\u094d\u0915\u094b \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "MST",
               "\u092e\u0949\u0938\u094d\u0915\u094b \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "MST",
               "\u092e\u0949\u0938\u094d\u0915\u094b \u091f\u093e\u0908\u092e",
               "MT",
            };
        final String[] Japan = new String[] {
               "\u091c\u092a\u093e\u0928 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "JST",
               "\u091c\u092a\u093e\u0928 \u0921\u0947\u0932\u093e\u0908\u091f \u091f\u093e\u0908\u092e",
               "JDT",
               "\u091c\u092a\u093e\u0928 \u091f\u093e\u0908\u092e",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "\u092a\u093e\u0915\u093f\u0938\u094d\u0924\u093e\u0928 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "PST",
               "\u092a\u093e\u0915\u093f\u0938\u094d\u0924\u093e\u0928 \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "PST",
               "\u092a\u093e\u0915\u093f\u0938\u094d\u0924\u093e\u0928 \u091f\u093e\u0908\u092e",
               "PT",
            };
        final String[] Hovd = new String[] {
               "\u0939\u094b\u0935\u094d\u0921 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "HST",
               "\u0939\u094b\u0935\u094d\u0921 \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "HST",
               "\u0939\u094b\u0935\u094d\u0921 \u091f\u093e\u0908\u092e",
               "HT",
            };
        final String[] Magadan = new String[] {
               "\u092e\u0917\u0926\u0928 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "MST",
               "\u092e\u0917\u0926\u0928 \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "MST",
               "\u092e\u0917\u0926\u0928 \u091f\u093e\u0908\u092e",
               "MT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "\u092e\u0927\u094d\u092f-\u092a\u0936\u094d\u091a\u0940\u092e \u0913\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "ACWST",
               "\u092e\u0927\u094d\u092f-\u092a\u0936\u094d\u091a\u0940\u092e \u0913\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e \u0921\u0947\u0932\u093e\u0908\u091f \u091f\u093e\u0908\u092e",
               "ACWDT",
               "\u092e\u0927\u094d\u092f-\u092a\u0936\u094d\u091a\u0940\u092e \u0913\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e \u091f\u093e\u0908\u092e",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "\u092e\u0927\u094d\u092f \u092f\u0942\u0930\u094b\u092a \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "CEST",
               "\u092e\u0927\u094d\u092f \u092f\u0942\u0930\u094b\u092a \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "CEST",
               "\u092e\u0927\u094d\u092f \u092f\u0942\u0930\u094b\u092a \u091f\u093e\u0908\u092e",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "\u0938\u0916\u093c\u093e\u0932\u0940\u0928 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "SST",
               "\u0938\u0916\u093c\u093e\u0932\u0940\u0928 \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "SST",
               "\u0938\u0916\u093c\u093e\u0932\u0940\u0928 \u091f\u093e\u0908\u092e",
               "ST",
            };
        final String[] Paraguay = new String[] {
               "\u092a\u093e\u0930\u093e\u0917\u0941\u090f \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "PST",
               "\u092a\u093e\u0930\u093e\u0917\u0941\u090f \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "PST",
               "\u092a\u093e\u0930\u093e\u0917\u0941\u090f \u091f\u093e\u0908\u092e",
               "PT",
            };
        final String[] Malaysia = new String[] {
               "\u092e\u0932\u0947\u0936\u093f\u092f\u093e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "MT",
               "Malaysia Summer Time",
               "MST",
               "Malaysia Time",
               "MT",
            };
        final String[] America_Eastern = new String[] {
               "\u0908\u0938\u094d\u091f\u0930\u094d\u0928 \u0905\u092e\u0930\u093f\u0915\u093e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "EST",
               "\u0908\u0938\u094d\u091f\u0930\u094d\u0928 \u0905\u092e\u0930\u093f\u0915\u093e \u0921\u0947\u0932\u093e\u0908\u091f \u091f\u093e\u0908\u092e",
               "EDT",
               "\u0908\u0938\u094d\u091f\u0930\u094d\u0928 \u0905\u092e\u0930\u093f\u0915\u093e \u091f\u093e\u0908\u092e",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "\u0932\u093e\u0930\u094d\u0921\u093c \u0939\u094b\u0935 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "LHST",
               "\u0932\u093e\u0930\u094d\u0921\u093c \u0939\u094b\u0935 \u0921\u0947\u0932\u093e\u0908\u091f \u091f\u093e\u0908\u092e",
               "LHDT",
               "\u0932\u093e\u0930\u094d\u0921\u093c \u0939\u094b\u0935 \u091f\u093e\u0908\u092e",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "\u0928\u094d\u092f\u0941\u091c\u093c\u0940\u0932\u0948\u0923\u094d\u0921 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "NZST",
               "\u0928\u094d\u092f\u0941\u091c\u093c\u0940\u0932\u0948\u0923\u094d\u0921 \u0921\u0947\u0932\u093e\u0908\u091f \u091f\u093e\u0908\u092e",
               "NZDT",
               "\u0928\u094d\u092f\u0941\u091c\u093c\u0940\u0932\u0948\u0923\u094d\u0921 \u091f\u093e\u0908\u092e",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "\u092d\u093e\u0930\u0924\u0940\u092f \u092e\u0939\u093e\u0938\u0917\u0930 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "IOT",
               "Indian Ocean Summer Time",
               "IOST",
               "Indian Ocean Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "\u092f\u093e\u0915\u0941\u091f\u094d\u0938\u094d\u0915 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "YST",
               "\u092f\u093e\u0915\u0941\u091f\u094d\u0938\u094d\u0915 \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "YST",
               "\u092f\u093e\u0915\u0941\u091f\u094d\u0938\u094d\u0915 \u091f\u093e\u0908\u092e",
               "YT",
            };
        final String[] Mauritius = new String[] {
               "\u092e\u0949\u0930\u093f\u0936\u0940\u092f\u0938 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "MST",
               "Mauritius Summer Time",
               "MST",
               "Mauritius Time",
               "MT",
            };
        final String[] Africa_Eastern = new String[] {
               "\u092a\u0942\u0930\u094d\u0935\u0940 \u0905\u092b\u094d\u0930\u0940\u0915\u093e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "\u0908\u0938\u094d\u091f \u091f\u0940\u092e\u094b\u0930 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "ETT",
               "East Timor Summer Time",
               "ETST",
               "East Timor Time",
               "ETT",
            };
        final String[] Solomon = new String[] {
               "\u0938\u0949\u0932\u0949\u092e\u0928 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "SIT",
               "Solomon Islands Summer Time",
               "SIST",
               "Solomon Islands Time",
               "SIT",
            };
        final String[] Kosrae = new String[] {
               "\u0915\u094b\u0938\u0930\u0940 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "KT",
               "Kosrae Summer Time",
               "KST",
               "Kosrae Time",
               "KT",
            };
        final String[] Marshall_Islands = new String[] {
               "\u092e\u093e\u0930\u094d\u0936\u0932 \u0930\u094d\u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "MIT",
               "Marshall Islands Summer Time",
               "MIST",
               "Marshall Islands Time",
               "MIT",
            };
        final String[] Europe_Eastern = new String[] {
               "\u0908\u0938\u094d\u091f\u0930\u094d\u0928 \u092f\u0942\u0930\u094b\u092a \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "EEST",
               "\u0908\u0938\u094d\u091f\u0930\u094d\u0928 \u092f\u0942\u0930\u094b\u092a \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "EEST",
               "\u0908\u0938\u094d\u091f\u0930\u094d\u0928 \u092f\u0942\u0930\u094b\u092a \u091f\u093e\u0908\u092e",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "\u0928\u094d\u092f\u0941\u092b\u093e\u090a\u0902\u0921\u0932\u0948\u0923\u094d\u0921 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "NST",
               "\u0928\u094d\u092f\u0941\u092b\u093e\u090a\u0902\u0921\u0932\u0948\u0923\u094d\u0921 \u0921\u0947\u0932\u093e\u0908\u091f \u091f\u093e\u0908\u092e",
               "NDT",
               "\u0928\u094d\u092f\u0941\u092b\u093e\u090a\u0902\u0921\u0932\u0948\u0923\u094d\u0921 \u091f\u093e\u0908\u092e",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "\u0905\u092b\u093c\u0917\u093e\u0928\u0940 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "AT",
               "Afghanistan Summer Time",
               "AST",
               "Afghanistan Time",
               "AT",
            };
        final String[] Hong_Kong = new String[] {
               "\u0939\u093e\u0901\u0917\u0915\u0949\u0902\u0917 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "HKST",
               "\u0939\u093e\u0901\u0917\u0915\u0949\u0902\u0917 \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "HKST",
               "\u0939\u093e\u0901\u0917\u0915\u0949\u0902\u0917 \u091f\u093e\u0908\u092e",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "\u092a\u0936\u094d\u091a\u0940\u092e \u0905\u0930\u094d\u091c\u0923\u094d\u091f\u093f\u0928\u093e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "WAST",
               "\u092a\u0936\u094d\u091a\u0940\u092e \u0905\u0930\u094d\u091c\u0923\u094d\u091f\u093f\u0928\u093e \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "WAST",
               "\u092a\u0936\u094d\u091a\u0940\u092e \u0905\u0930\u094d\u091c\u0923\u094d\u091f\u093f\u0928\u093e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "WAT",
            };
        final String[] Atlantic = new String[] {
               "\u0905\u091f\u0932\u093e\u0902\u091f\u0940\u0915 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "AST",
               "\u0905\u091f\u0932\u093e\u0902\u091f\u0940\u0915 \u0921\u0947\u0932\u093e\u0908\u091f \u091f\u093e\u0908\u092e",
               "ADT",
               "\u0905\u091f\u0932\u093e\u0902\u091f\u0940\u0915 \u091f\u093e\u0908\u092e",
               "AT",
            };
        final String[] Ponape = new String[] {
               "\u092a\u094b\u0928\u093e\u092a\u0947 (\u092a\u094b\u0939\u094d\u0928\u092a\u0947\u0908) \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "PT",
               "Ponape Summer Time",
               "PST",
               "Ponape Time",
               "PT",
            };
        final String[] Bolivia = new String[] {
               "\u092c\u094b\u0932\u093f\u0935\u093f\u092f\u093e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "BT",
               "Bolivia Summer Time",
               "BST",
               "Bolivia Time",
               "BT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "\u092a\u0940\u092f\u0945\u0930 \u090f\u0935\u0902 \u092e\u0940\u0915\u0932\u094b\u0902 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "PMST",
               "\u092a\u0940\u092f\u0945\u0930 \u090f\u0935\u0902 \u092e\u0940\u0915\u0932\u094b\u0902 \u0921\u0947\u0932\u093e\u0908\u091f \u091f\u093e\u0908\u092e",
               "PMDT",
               "\u092a\u0940\u092f\u0945\u0930 \u090f\u0935\u0902 \u092e\u0940\u0915\u0932\u094b\u0902 \u091f\u093e\u0908\u092e",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "\u0908\u0902\u0921\u094b \u091a\u0907\u0928\u093e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "IT",
               "Indochina Summer Time",
               "IST",
               "Indochina Time",
               "IT",
            };
        final String[] Yekaterinburg = new String[] {
               "\u092f\u0947\u0915\u093e\u0924\u0947\u0930\u0940\u0928\u093e\u092c\u0941\u0930\u094d\u0917 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "YST",
               "\u092f\u0947\u0915\u093e\u0924\u0947\u0930\u0940\u0928\u093e\u092c\u0941\u0930\u094d\u0917 \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "YST",
               "\u092f\u0947\u0915\u093e\u0924\u0947\u0930\u0940\u0928\u093e\u092c\u0941\u0930\u094d\u0917 \u091f\u093e\u0908\u092e",
               "YT",
            };
        final String[] Maldives = new String[] {
               "\u092e\u093e\u0932\u0926\u0940\u0935 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "MT",
               "Maldives Summer Time",
               "MST",
               "Maldives Time",
               "MT",
            };
        final String[] Tahiti = new String[] {
               "\u091f\u093e\u0939\u093f\u091f\u0940 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "TT",
               "Tahiti Summer Time",
               "TST",
               "Tahiti Time",
               "TT",
            };
        final String[] Israel = new String[] {
               "\u0908\u0938\u094d\u0930\u093e\u0907\u0932 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "IST",
               "\u0908\u0938\u094d\u0930\u093e\u0907\u0932 \u0921\u0947\u0932\u093e\u0908\u091f \u091f\u093e\u0908\u092e",
               "IDT",
               "\u0908\u0938\u094d\u0930\u093e\u0907\u0932 \u091f\u093e\u0908\u092e",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "\u0908\u0902\u0921\u094b\u0928\u0940\u0936\u093f\u092f\u093e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] Wallis = new String[] {
               "\u0935\u093e\u0932\u0940\u0938 \u090f\u0935\u0902 \u092b\u093c\u0941\u0924\u0941\u0928\u093e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "WFT",
               "Wallis and Futuna Summer Time",
               "WFST",
               "Wallis and Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "\u0926\u0915\u094d\u0937\u093f\u0923 \u0905\u092b\u094d\u0930\u0940\u0915\u093e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "SAST",
               "South Africa Daylight Time",
               "SADT",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "\u0938\u0940\u0913\u0935\u093e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "ST",
               "Syowa Summer Time",
               "SST",
               "Syowa Time",
               "ST",
            };
        final String[] Line_Islands = new String[] {
               "\u0932\u093e\u0908\u0928 \u0926\u094d\u0935\u0940\u092a \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "LIT",
               "Line Islands Summer Time",
               "LIST",
               "Line Islands Time",
               "LIT",
            };
        final String[] Uzbekistan = new String[] {
               "\u090a\u091c\u093c\u094d\u092c\u0947\u0915\u093f\u0938\u094d\u0924\u093e\u0928 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "UST",
               "\u090a\u091c\u093c\u094d\u092c\u0947\u0915\u093f\u0938\u094d\u0924\u093e\u0928 \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "UST",
               "\u090a\u091c\u093c\u094d\u092c\u0947\u0915\u093f\u0938\u094d\u0924\u093e\u0928 \u091f\u093e\u0908\u092e",
               "UT",
            };
        final String[] Omsk = new String[] {
               "\u0913\u092e\u094d\u0938\u094d\u0915 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "OST",
               "\u0913\u092e\u094d\u0938\u094d\u0915 \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "OST",
               "\u0913\u092e\u094d\u0938\u094d\u0915 \u091f\u093e\u0908\u092e",
               "OT",
            };
        final String[] Seychelles = new String[] {
               "\u0938\u0947\u0936\u0947\u0932\u094d\u0938 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "ST",
               "Seychelles Summer Time",
               "SST",
               "Seychelles Time",
               "ST",
            };
        final String[] Uruguay = new String[] {
               "\u090a\u0930\u0941\u0917\u0941\u090f \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "UST",
               "\u090a\u0930\u0941\u0917\u0941\u090f \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "UST",
               "\u090a\u0930\u0941\u0917\u0941\u090f \u091f\u093e\u0908\u092e",
               "UT",
            };
        final String[] Nepal = new String[] {
               "\u0928\u0947\u092a\u093e\u0932 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "NT",
               "Nepal Summer Time",
               "NST",
               "Nepal Time",
               "NT",
            };
        final String[] Mongolia = new String[] {
               "\u092e\u0901\u0917\u094b\u0932\u093f\u092f\u093e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "UBST",
               "\u092e\u0901\u0917\u094b\u0932\u093f\u092f\u093e \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "UBST",
               "\u092e\u0901\u0917\u094b\u0932\u093f\u092f\u093e \u091f\u093e\u0908\u092e",
               "UBT",
            };
        final String[] America_Central = new String[] {
               "\u0938\u0948\u0902\u091f\u094d\u0930\u0932 \u0905\u092e\u0930\u093f\u0915\u093e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "CST",
               "\u0938\u0948\u0902\u091f\u094d\u0930\u0932 \u0905\u092e\u0930\u093f\u0915\u093e \u0921\u0947\u0932\u093e\u0908\u091f \u091f\u093e\u0908\u092e",
               "CDT",
               "\u0938\u0948\u0902\u091f\u094d\u0930\u0932 \u0905\u092e\u0930\u093f\u0915\u093e \u091f\u093e\u0908\u092e",
               "CT",
            };
        final String[] Truk = new String[] {
               "\u091f\u094d\u0930\u0941\u0915 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "CT",
               "Chuuk Summer Time",
               "CST",
               "Chuuk Time",
               "CT",
            };
        final String[] Niue = new String[] {
               "\u0928\u0940\u090a\u0908 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "NT",
               "Niue Summer Time",
               "NST",
               "Niue Time",
               "NT",
            };
        final String[] Wake = new String[] {
               "\u0935\u093e\u0915\u0947 \u0926\u094d\u0935\u0940\u092a \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "WIT",
               "Wake Island Summer Time",
               "WIST",
               "Wake Island Time",
               "WIT",
            };
        final String[] Falkland = new String[] {
               "\u092b\u093c\u093e\u0932\u094d\u0915\u0932\u0948\u0923\u094d\u0921 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "FIST",
               "\u092b\u093c\u093e\u0932\u094d\u0915\u0932\u0948\u0923\u094d\u0921 \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "FIST",
               "\u092b\u093c\u093e\u0932\u094d\u0915\u0932\u0948\u0923\u094d\u0921 \u091f\u093e\u0908\u092e",
               "FIT",
            };
        final String[] Vanuatu = new String[] {
               "\u0935\u0928\u0941\u0906\u091f\u0941 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "VST",
               "\u0935\u0928\u0941\u0906\u091f\u0941 \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "VST",
               "\u0935\u0928\u0941\u0906\u091f\u0941 \u091f\u093e\u0908\u092e",
               "VT",
            };
        final String[] Novosibirsk = new String[] {
               "\u0928\u094b\u0935\u094b\u0938\u0940\u092c\u0940\u0930\u094d\u0938\u094d\u0915 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "NST",
               "\u0928\u094b\u0935\u094b\u0938\u0940\u092c\u0940\u0930\u094d\u0938\u094d\u0915 \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "NST",
               "\u0928\u094b\u0935\u094b\u0938\u0940\u092c\u0940\u0930\u094d\u0938\u094d\u0915 \u091f\u093e\u0908\u092e",
               "NT",
            };
        final String[] Singapore = new String[] {
               "\u0938\u0940\u0902\u0917\u093e\u092a\u0941\u0930 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "SST",
               "Singapore Daylight Time",
               "SDT",
               "Singapore Time",
               "ST",
            };
        final String[] Azores = new String[] {
               "\u0906\u091c\u093c\u094b\u0930 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "AST",
               "\u0906\u091c\u093c\u094b\u0930 \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "AST",
               "\u0906\u091c\u093c\u094b\u0930 \u091f\u093e\u0908\u092e",
               "AT",
            };
        final String[] Bhutan = new String[] {
               "\u092d\u0941\u091f\u093e\u0928 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "BT",
               "Bhutan Summer Time",
               "BST",
               "Bhutan Time",
               "BT",
            };
        final String[] Suriname = new String[] {
               "\u0938\u0941\u0930\u0940\u0928\u093e\u092e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "ST",
               "Suriname Summer Time",
               "SST",
               "Suriname Time",
               "ST",
            };
        final String[] Nauru = new String[] {
               "\u0928\u093e\u090a\u0930\u0941 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "NT",
               "Nauru Summer Time",
               "NST",
               "Nauru Time",
               "NT",
            };
        final String[] Krasnoyarsk = new String[] {
               "\u0915\u094d\u0930\u093e\u0938\u0928\u094b\u092f\u093e\u0930\u094d\u0938\u094d\u0915 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "KST",
               "\u0915\u094d\u0930\u093e\u0938\u0928\u094b\u092f\u093e\u0930\u094d\u0938\u094d\u0915 \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "KST",
               "\u0915\u094d\u0930\u093e\u0938\u0928\u094b\u092f\u093e\u0930\u094d\u0938\u094d\u0915 \u091f\u093e\u0908\u092e",
               "KT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "\u0935\u0947\u0938\u094d\u091f\u0930\u094d\u0928 \u0915\u093c\u091c\u093c\u093e\u0916\u093c\u0938\u094d\u0924\u093e\u0928 \u091f\u093e\u0908\u092e",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] Myanmar = new String[] {
               "\u092e\u094d\u092f\u093e\u0928\u092e\u093e\u0930 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "MT",
               "Myanmar Summer Time",
               "MST",
               "Myanmar Time",
               "MT",
            };
        final String[] Christmas = new String[] {
               "\u0915\u094d\u0930\u0940\u0938\u092e\u0938 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "CIT",
               "Christmas Island Summer Time",
               "CIST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "\u0905\u092e\u093e\u091c\u093c\u094b\u0928 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "AST",
               "\u0905\u092e\u093e\u091c\u093c\u094b\u0928 \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "AST",
               "\u0905\u092e\u093e\u091c\u093c\u094b\u0928 \u091f\u093e\u0908\u092e",
               "AT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "\u0915\u093c\u091c\u093c\u093e\u0916\u093c\u0938\u094d\u0924\u093e\u0928 \u091f\u093e\u0908\u092e",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final String[] Fiji = new String[] {
               "\u092b\u0940\u091c\u0940 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "FST",
               "\u092b\u0940\u091c\u0940 \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "FST",
               "\u092b\u0940\u091c\u0940 \u091f\u093e\u0908\u092e",
               "FT",
            };
        final String[] Reunion = new String[] {
               "\u0930\u093f\u092f\u0942\u0928\u093f\u092f\u0928 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "RT",
               "Reunion Summer Time",
               "RST",
               "Reunion Time",
               "RT",
            };
        final String[] Cocos = new String[] {
               "\u0915\u094b\u0915\u094b \u0926\u094d\u0935\u0940\u092a \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "CIT",
               "Cocos Islands Summer Time",
               "CIST",
               "Cocos Islands Time",
               "CIT",
            };
        final String[] Chatham = new String[] {
               "\u091a\u0948\u0925\u092e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "CST",
               "\u091a\u0948\u0925\u092e \u0921\u0947\u0932\u093e\u0908\u091f \u091f\u093e\u0908\u092e",
               "CDT",
               "\u091a\u0948\u0925\u092e \u091f\u093e\u0908\u092e",
               "CT",
            };
        final String[] Vostok = new String[] {
               "\u0935\u0949\u0938\u094d\u0924\u0949\u0915 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "VT",
               "Vostok Summer Time",
               "VST",
               "Vostok Time",
               "VT",
            };
        final String[] Argentina = new String[] {
               "\u0905\u0930\u094d\u091c\u0928\u091f\u093f\u0928\u093e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "AST",
               "\u0905\u0930\u094d\u091c\u0923\u094d\u091f\u093f\u0928\u093e \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "AST",
               "\u0905\u0930\u094d\u091c\u0928\u091f\u093f\u0928\u093e \u091f\u093e\u0908\u092e",
               "AT",
            };
        final String[] Gambier = new String[] {
               "\u0917\u093e\u0902\u092c\u093f\u092f\u0947 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "GT",
               "Gambier Summer Time",
               "GST",
               "Gambier Time",
               "GT",
            };
        final String[] Tuvalu = new String[] {
               "\u0924\u0941\u0935\u093e\u0932\u0941 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "TT",
               "Tuvalu Summer Time",
               "TST",
               "Tuvalu Time",
               "TT",
            };
        final String[] Galapagos = new String[] {
               "\u0917\u093e\u0932\u093e\u092a\u093e\u0917\u094b\u0938 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "GT",
               "Galapagos Summer Time",
               "GST",
               "Galapagos Time",
               "GT",
            };
        final String[] Venezuela = new String[] {
               "\u0935\u0947\u0928\u0947\u091c\u093c\u0941\u090f\u0932\u093e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "VT",
               "Venezuela Summer Time",
               "VST",
               "Venezuela Time",
               "VT",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "\u0939\u0935\u093e\u0908 \u0906\u0932\u091f\u0928 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "HAST",
               "\u0939\u0935\u093e\u0908 \u0906\u0932\u091f\u0928 \u0921\u0947\u0932\u093e\u0908\u091f \u091f\u093e\u0908\u092e",
               "HADT",
               "\u0939\u0935\u093e\u0908 \u0906\u0932\u091f\u0928 \u091f\u093e\u0908\u092e",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "\u092e\u0927\u094d\u092f \u0913\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "ACST",
               "\u092e\u0927\u094d\u092f \u0913\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e \u0921\u0947\u0932\u093e\u0908\u091f \u091f\u093e\u0908\u092e",
               "ACDT",
               "\u0913\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e \u091f\u093e\u0908\u092e",
               "CAT",
            };
        final String[] America_Pacific = new String[] {
               "\u092a\u0948\u0938\u0940\u092b\u0940\u0915 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "PST",
               "\u092a\u0948\u0938\u0940\u092b\u0940\u0915 \u0921\u0947\u0932\u093e\u0908\u091f \u091f\u093e\u0908\u092e",
               "PDT",
               "\u092a\u0948\u0938\u0940\u092b\u0940\u0915 \u091f\u093e\u0908\u092e",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "\u092b\u0940\u0928\u0940\u0915\u094d\u0938 \u0926\u094d\u0935\u0940\u092a \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "PIT",
               "Phoenix Islands Summer Time",
               "PIST",
               "Phoenix Islands Time",
               "PIT",
            };
        final String[] Turkmenistan = new String[] {
               "\u0924\u0941\u0930\u094d\u0915\u092e\u0947\u0928\u0940\u0938\u094d\u0924\u093e\u0928 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "TST",
               "\u0924\u0941\u0930\u094d\u0915\u092e\u0947\u0928\u0940\u0938\u094d\u0924\u093e\u0928 \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "TST",
               "\u0924\u0941\u0930\u094d\u0915\u092e\u0947\u0928\u0940\u0938\u094d\u0924\u093e\u0928 \u091f\u093e\u0908\u092e",
               "TT",
            };
        final String[] Europe_Western = new String[] {
               "\u0935\u0947\u0938\u094d\u091f\u0930\u094d\u0928 \u092f\u0942\u0930\u094b\u092a \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "WEST",
               "\u0935\u0947\u0938\u094d\u091f\u0930\u094d\u0928 \u092f\u0942\u0930\u094b\u092a \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "WEST",
               "\u0935\u0947\u0938\u094d\u091f\u0930\u094d\u0928 \u092f\u0942\u0930\u094b\u092a \u091f\u093e\u0908\u092e",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "\u0915\u093e\u092a \u0935\u0947\u0930\u094d\u0926\u0947 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "CVST",
               "\u0915\u093e\u092a \u0935\u0947\u0930\u094d\u0926\u0947 \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "CVST",
               "\u0915\u093e\u092a \u0935\u0947\u0930\u094d\u0926\u0947 \u091f\u093e\u0908\u092e",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "\u0928\u0949\u0930\u092b\u094b\u0915 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "NIT",
               "Norfolk Islands Summer Time",
               "NIST",
               "Norfolk Islands Time",
               "NIT",
            };
        final String[] Guyana = new String[] {
               "\u0917\u0941\u092f\u093e\u0928\u093e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "GT",
               "Guyana Summer Time",
               "GST",
               "Guyana Time",
               "GT",
            };
        final String[] Pitcairn = new String[] {
               "\u092a\u0940\u091f\u0915\u0948\u0930\u094d\u0928 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "PT",
               "Pitcairn Summer Time",
               "PST",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "\u0930\u094b\u0925\u0947\u0930\u093e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "RT",
               "Rothera Summer Time",
               "RST",
               "Rothera Time",
               "RT",
            };
        final String[] Samoa = new String[] {
               "\u0938\u092e\u094b\u0906 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "SST",
               "Samoa Daylight Time",
               "SDT",
               "Samoa Time",
               "ST",
            };
        final String[] Palau = new String[] {
               "\u092a\u0932\u093e\u090a \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "PT",
               "Palau Summer Time",
               "PST",
               "Palau Time",
               "PT",
            };
        final String[] Azerbaijan = new String[] {
               "\u0906\u091c\u093c\u0930\u092c\u0948\u091c\u093e\u0928 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "AST",
               "\u0906\u091c\u093c\u0930\u092c\u0948\u091c\u093e\u0928 \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "AST",
               "\u0906\u091c\u093c\u0930\u092c\u0948\u091c\u093e\u0928 \u091f\u093e\u0908\u092e",
               "AT",
            };
        final String[] Mawson = new String[] {
               "\u092e\u0949\u0938\u0928 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "MT",
               "Mawson Summer Time",
               "MST",
               "Mawson Time",
               "MT",
            };
        final String[] Davis = new String[] {
               "\u0921\u0947\u0935\u0940\u0938 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "DT",
               "Davis Summer Time",
               "DST",
               "Davis Time",
               "DT",
            };
        final String[] Cuba = new String[] {
               "\u0915\u094d\u092f\u0941\u092c\u093e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "CST",
               "\u0915\u094d\u092f\u0941\u092c\u093e \u0921\u0947\u0932\u093e\u0908\u091f \u091f\u093e\u0908\u092e",
               "CDT",
               "\u0915\u094d\u092f\u0941\u092c\u093e \u091f\u093e\u0908\u092e",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "\u092a\u0936\u094d\u091a\u0940\u092e \u0905\u092b\u094d\u0930\u0940\u0915\u093e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "WAST",
               "\u092a\u0936\u094d\u091a\u0940\u092e \u0905\u092b\u094d\u0930\u0940\u0915\u093e \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "WAST",
               "\u092a\u0936\u094d\u091a\u0940\u092e \u0905\u092b\u094d\u0930\u0940\u0915\u093e \u091f\u093e\u0908\u092e",
               "WAT",
            };
        final String[] GMT = new String[] {
               "\u0917\u094d\u0930\u0940\u0928\u0940\u091a \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "GMT",
               "Greenwich Summer Time",
               "GST",
               "Greenwich Time",
               "GT",
            };
        final String[] Philippines = new String[] {
               "\u092b\u0940\u0932\u0940\u092a\u0940\u0928\u094d\u0938 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "PST",
               "\u092b\u0940\u0932\u0940\u092a\u0940\u0928\u094d\u0938 \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "PST",
               "\u092b\u0940\u0932\u0940\u092a\u0940\u0928\u094d\u0938 \u091f\u093e\u0908\u092e",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "\u0926\u0915\u094d\u0937\u093f\u0923 \u092b\u094d\u0930\u093e\u0928\u094d\u0938\u0940\u0938\u0940 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "FSAT",
               "French Southern and Antarctic Summer Time",
               "FSAST",
               "French Southern and Antarctic Time",
               "FSAT",
            };
        final String[] South_Georgia = new String[] {
               "\u0938\u093e\u090a\u0925 \u091c\u0949\u0930\u094d\u091c\u093f\u092f\u093e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "SGT",
               "South Georgia Summer Time",
               "SGST",
               "South Georgia Time",
               "SGT",
            };
        final String[] New_Caledonia = new String[] {
               "\u0928\u094d\u092f\u0941 \u0915\u0948\u0932\u0947\u0921\u094b\u0928\u093f\u092f\u093e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "NCST",
               "\u0928\u094d\u092f\u0941 \u0915\u0948\u0932\u0947\u0921\u094b\u0928\u093f\u092f\u093e \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "NCST",
               "\u0928\u094d\u092f\u0941 \u0915\u0948\u0932\u0947\u0921\u094b\u0928\u093f\u092f\u093e \u091f\u093e\u0908\u092e",
               "NCT",
            };
        final String[] Volgograd = new String[] {
               "\u0935\u0949\u0932\u0917\u094b\u0917\u094d\u0930\u093e\u0926 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "VST",
               "\u0935\u0949\u0932\u0917\u094b\u0917\u094d\u0930\u093e\u0926 \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "VST",
               "\u0935\u0949\u0932\u0917\u094b\u0917\u094d\u0930\u093e\u0926 \u091f\u093e\u0908\u092e",
               "VT",
            };
        final String[] Brunei = new String[] {
               "\u092c\u094d\u0930\u0941\u0928\u0947\u0908 \u0926\u0930 \u0909\u0938 \u0938\u0932\u093e\u092e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "BDT",
               "Brunei Darussalam Summer Time",
               "BDST",
               "Brunei Darussalam Time",
               "BDT",
            };
        final String[] Iran = new String[] {
               "\u0908\u0930\u093e\u0928 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "IST",
               "\u0908\u0930\u093e\u0928 \u0921\u0947\u0932\u093e\u0908\u091f \u091f\u093e\u0908\u092e",
               "IDT",
               "\u0908\u0930\u093e\u0928 \u091f\u093e\u0908\u092e",
               "IT",
            };
        final String[] Easter = new String[] {
               "\u0908\u0938\u094d\u091f\u0930 \u0906\u0908\u0932\u0902\u0921 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "EIST",
               "\u0908\u0938\u094d\u091f\u0930 \u0906\u0908\u0932\u0902\u0921 \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "EIST",
               "\u0908\u0938\u094d\u091f\u0930 \u0906\u0908\u0932\u0902\u0921 \u091f\u093e\u0908\u092e",
               "EIT",
            };
        final String[] DumontDUrville = new String[] {
               "\u0921\u094d\u092f\u0941\u092e\u094b\u0902 \u0921\u094d\u092f\u0941\u0930\u0935\u0940\u0932 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "DT",
               "Dumont-d\u2019Urville Summer Time",
               "DST",
               "Dumont-d\u2019Urville Time",
               "DT",
            };
        final String[] Tajikistan = new String[] {
               "\u0924\u093e\u091c\u0940\u0915\u093c\u0940\u0938\u094d\u0924\u093e\u0928 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "TT",
               "Tajikistan Summer Time",
               "TST",
               "Tajikistan Time",
               "TT",
            };
        final String[] Tonga = new String[] {
               "\u091f\u0949\u0902\u0917\u093e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "TST",
               "\u091f\u0949\u0902\u0917\u093e \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "TST",
               "\u091f\u0949\u0902\u0917\u093e \u091f\u093e\u0908\u092e",
               "TT",
            };
        final String[] Bangladesh = new String[] {
               "\u092c\u093e\u0902\u0917\u0932\u093e\u0926\u0947\u0936 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "BST",
               "\u092c\u093e\u0902\u0917\u0932\u093e\u0926\u0947\u0936 \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "BST",
               "\u092c\u093e\u0902\u0917\u0932\u093e\u0926\u0947\u0936 \u091f\u093e\u0908\u092e",
               "BT",
            };
        final String[] Peru = new String[] {
               "\u092a\u0947\u0930\u0941 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "PST",
               "\u092a\u0947\u0930\u0941 \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "PST",
               "\u092a\u0947\u0930\u0941 \u091f\u093e\u0908\u092e",
               "PT",
            };
        final String[] Greenland_Western = new String[] {
               "\u0917\u094d\u0930\u0940\u0928\u0932\u0948\u0923\u094d\u0921 \u0935\u0947\u0938\u094d\u091f\u0930\u094d\u0928 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "WGST",
               "\u0917\u094d\u0930\u0940\u0928\u0932\u0948\u0923\u094d\u0921 \u0935\u0947\u0938\u094d\u091f\u0930\u094d\u0928 \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "WGST",
               "\u0917\u094d\u0930\u0940\u0928\u0932\u0948\u0923\u094d\u0921 \u0935\u0947\u0938\u094d\u091f\u0930\u094d\u0928 \u091f\u093e\u0908\u092e",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "\u090f\u0915\u094d\u0935\u093e\u0921\u094c\u0930 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "ET",
               "Ecuador Summer Time",
               "EST",
               "Ecuador Time",
               "ET",
            };
        final String[] Greenland_Eastern = new String[] {
               "\u0917\u094d\u0930\u0940\u0928\u0932\u0948\u0923\u094d\u0921 \u0908\u0938\u094d\u091f\u0930\u094d\u0928 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "EGST",
               "\u0917\u094d\u0930\u0940\u0928\u0932\u0948\u0923\u094d\u0921 \u0908\u0938\u094d\u091f\u0930\u094d\u0928 \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "EGST",
               "\u0917\u094d\u0930\u0940\u0928\u0932\u0948\u0923\u094d\u0921 \u0908\u0938\u094d\u091f\u0930\u094d\u0928 \u091f\u093e\u0908\u092e",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "\u0917\u0932\u094d\u092b\u093c \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "\u0908\u0938\u094d\u091f\u0930\u094d\u0928 \u0908\u0902\u0921\u094b\u0928\u0940\u0936\u093f\u092f\u093e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Korea = new String[] {
               "\u0915\u094b\u0930\u093f\u092f\u093e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "KST",
               "\u0915\u094b\u0930\u093f\u092f\u093e \u0921\u0947\u0932\u093e\u0908\u091f \u091f\u093e\u0908\u092e",
               "KDT",
               "\u0915\u094b\u0930\u093f\u092f\u093e \u091f\u093e\u0908\u092e",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "\u0926\u0915\u094d\u0937\u093f\u0923 \u0913\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "AWST",
               "\u0926\u0915\u094d\u0937\u093f\u0923 \u0913\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e \u0921\u0947\u0932\u093e\u0908\u091f \u091f\u093e\u0908\u092e",
               "AWDT",
               "\u0926\u0915\u094d\u0937\u093f\u0923 \u0913\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e \u091f\u093e\u0908\u092e",
               "WAT",
            };
        final String[] Kyrgystan = new String[] {
               "\u0915\u093c\u0940\u0930\u094d\u0917\u093c\u0938\u094d\u0924\u093e\u0928 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "KT",
               "Kyrgystan Summer Time",
               "KST",
               "Kyrgystan Time",
               "KT",
            };
        final String[] Indonesia_Western = new String[] {
               "\u0935\u0947\u0938\u094d\u091f\u0930\u094d\u0928 \u0908\u0902\u0921\u094b\u0928\u0940\u0936\u093f\u092f\u093e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Australia_Eastern = new String[] {
               "\u092a\u0942\u0930\u094d\u0935\u0940 \u0913\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "AEST",
               "\u092a\u0942\u0930\u094d\u0935\u0940 \u0913\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e \u0921\u0947\u0932\u093e\u0908\u091f \u091f\u093e\u0908\u092e",
               "AEDT",
               "\u092a\u0942\u0930\u094d\u0935\u0940 \u0913\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e \u091f\u093e\u0908\u092e",
               "EAT",
            };
        final String[] French_Guiana = new String[] {
               "\u092b\u094d\u0930\u093e\u0928\u094d\u0938\u0940\u0938\u0940 \u0917\u0941\u092f\u093e\u0928\u093e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "FGT",
               "French Guiana Summer Time",
               "FGST",
               "French Guiana Time",
               "FGT",
            };
        final String[] Colombia = new String[] {
               "\u0915\u094b\u0932\u0902\u092c\u093f\u092f\u093e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "CST",
               "\u0915\u094b\u0932\u0902\u092c\u093f\u092f\u093e \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "CST",
               "\u0915\u094b\u0932\u0902\u092c\u093f\u092f\u093e \u091f\u093e\u0908\u092e",
               "CT",
            };
        final String[] Chile = new String[] {
               "\u091a\u0940\u0932\u0940 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "CST",
               "\u091a\u0940\u0932\u0940 \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "CST",
               "\u091a\u0940\u0932\u0940 \u091f\u093e\u0908\u092e",
               "CT",
            };
        final String[] Gilbert_Islands = new String[] {
               "\u0917\u0940\u0932\u092c\u0930\u094d\u091f \u0926\u094d\u0935\u0940\u092a \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "GIT",
               "Gilbert Islands Summer Time",
               "GIST",
               "Gilbert Islands Time",
               "GIT",
            };
        final String[] America_Mountain = new String[] {
               "\u0905\u092e\u0930\u093f\u0915\u093e \u092e\u093e\u090a\u0928\u094d\u091f\u0928 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "MST",
               "\u0905\u092e\u0930\u093f\u0915\u093e \u092e\u093e\u090a\u0928\u094d\u091f\u0928 \u0921\u0947\u0932\u093e\u0908\u091f \u091f\u093e\u0908\u092e",
               "MDT",
               "\u0905\u092e\u0930\u093f\u0915\u093e \u092e\u093e\u090a\u0928\u094d\u091f\u0928 \u091f\u093e\u0908\u092e",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "\u092e\u093e\u0930\u094d\u0915\u0947\u091c\u093c\u093e\u0938 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "MT",
               "Marquesas Summer Time",
               "MST",
               "Marquesas Time",
               "MT",
            };
        final String[] Arabian = new String[] {
               "\u0905\u0930\u092c\u0940 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "AST",
               "\u0905\u0930\u092c\u0940 \u0921\u0947\u0932\u093e\u0908\u091f \u091f\u093e\u0908\u092e",
               "ADT",
               "\u0905\u0930\u092c\u0940 \u091f\u093e\u0908\u092e",
               "AT",
            };
        final String[] Alaska = new String[] {
               "\u0905\u0932\u093e\u0938\u094d\u0915\u093e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "AKST",
               "\u0905\u0932\u093e\u0938\u094d\u0915\u093e \u0921\u0947\u0932\u093e\u0908\u091f \u091f\u093e\u0908\u092e",
               "AKDT",
               "\u0905\u0932\u093e\u0938\u094d\u0915\u093e \u091f\u093e\u0908\u092e",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "\u0935\u094d\u0932\u093e\u0926\u0940\u0935\u0949\u0938\u094d\u0924\u0949\u0915 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "VST",
               "\u0935\u094d\u0932\u093e\u0926\u0940\u0935\u0949\u0938\u094d\u0924\u0949\u0915 \u0921\u0947\u0932\u093e\u0908\u091f \u091f\u093e\u0908\u092e",
               "VST",
               "\u0935\u094d\u0932\u093e\u0926\u0940\u0935\u0949\u0938\u094d\u0924\u0949\u0915 \u091f\u093e\u0908\u092e",
               "VT",
            };
        final String[] Chamorro = new String[] {
               "\u091a\u093e\u092e\u0930\u094b \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "CST",
               "Chamorro Daylight Time",
               "CDT",
               "Chamorro Time",
               "CT",
            };
        final String[] Irkutsk = new String[] {
               "\u0908\u0930\u0915\u0941\u0930\u094d\u0924\u094d\u0938\u094d\u0915 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "IST",
               "\u0908\u0930\u0915\u0941\u0930\u094d\u0924\u094d\u0938\u094d\u0915 \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "IST",
               "\u0908\u0930\u0915\u0941\u0930\u094d\u0924\u094d\u0938\u094d\u0915 \u091f\u093e\u0908\u092e",
               "IT",
            };
        final String[] Georgia = new String[] {
               "\u091c\u094b\u0930\u094d\u091c\u093f\u092f\u093e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "GST",
               "\u091c\u094b\u0930\u094d\u091c\u093f\u092f\u093e \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "GST",
               "\u091c\u094b\u0930\u094d\u091c\u093f\u092f\u093e \u091f\u093e\u0908\u092e",
               "GT",
            };
        final String[] Tokelau = new String[] {
               "\u091f\u094b\u0915\u0947\u0932\u094c \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "TT",
               "Tokelau Summer Time",
               "TST",
               "Tokelau Time",
               "TT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "\u092a\u093e\u092a\u0941\u0906 \u0928\u094d\u092f\u0941 \u0917\u0940\u0928\u0940 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "PNGT",
               "Papua New Guinea Summer Time",
               "PNGST",
               "Papua New Guinea Time",
               "PNGT",
            };
        final String[] Noronha = new String[] {
               "\u092b\u0947\u0930\u0928\u093e\u0928\u094d\u0926\u094b \u0926 \u0928\u094b\u0930\u094b\u0928\u094d\u0939\u093e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "FNST",
               "\u092b\u0947\u0930\u0928\u093e\u0928\u094d\u0926\u094b \u0926 \u0928\u094b\u0930\u094b\u0928\u094d\u0939\u093e \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "FNST",
               "\u092b\u0947\u0930\u0928\u093e\u0928\u094d\u0926\u094b \u0926 \u0928\u094b\u0930\u094b\u0928\u094d\u0939\u093e \u091f\u093e\u0908\u092e",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "\u091a\u094b\u0908\u092c\u093e\u0932\u0938\u093e\u0928 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "CST",
               "\u091a\u094b\u0908\u092c\u093e\u0932\u0938\u093e\u0928 \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "CST",
               "\u091a\u094b\u0908\u092c\u093e\u0932\u0938\u093e\u0928 \u091f\u093e\u0908\u092e",
               "CT",
            };
        final String[] Brasilia = new String[] {
               "\u092c\u094d\u0930\u093e\u091c\u093c\u0940\u0932\u093f\u092f\u093e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "BST",
               "\u092c\u094d\u0930\u093e\u091c\u093c\u0940\u0932\u093f\u092f\u093e \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "BST",
               "\u092c\u094d\u0930\u093e\u091c\u093c\u0940\u0932\u093f\u092f\u093e \u091f\u093e\u0908\u092e",
               "BT",
            };
        final String[] China = new String[] {
               "\u091a\u093e\u0908\u0928\u093e \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "CST",
               "\u091a\u093e\u0908\u0928\u093e \u0921\u0947\u0932\u093e\u0908\u091f \u091f\u093e\u0908\u092e",
               "CDT",
               "\u091a\u093e\u0908\u0928\u093e \u091f\u093e\u0908\u092e",
               "CT",
            };
        final String[] Armenia = new String[] {
               "\u0906\u0930\u092e\u0940\u0928\u0940 \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "AST",
               "\u0906\u0930\u092e\u0940\u0928\u0940 \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "AST",
               "\u0906\u0930\u092e\u0940\u0928\u0940 \u091f\u093e\u0908\u092e",
               "AT",
            };
        final String[] India = new String[] {
               "\u092d\u093e\u0930\u0924\u0940\u092f \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "\u0915\u0941\u0915 \u0926\u094d\u0935\u0940\u092a \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
               "CIST",
               "\u0915\u0941\u0915 \u0926\u094d\u0935\u0940\u092a \u0905\u0930\u094d\u0927 \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
               "CIHST",
               "\u0915\u0941\u0915 \u0926\u094d\u0935\u0940\u092a \u091f\u093e\u0908\u092e",
               "CIT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "\u0917\u094d\u0930\u0940\u0928\u0940\u091a \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
                    "GMT",
                    "\u092c\u094d\u0930\u0940\u091f\u0940\u0936 \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
                    "GST",
                    "Greenwich Time",
                    "GT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Asia/Kashgar", China },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Eirunepe", Amazon },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", GMT },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", America_Pacific },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Europe_Eastern },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Europe/Samara", Moscow },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Korea },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "America/Ciudad_Juarez", America_Mountain },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", America_Mountain },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Asia/Chongqing", China },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Samoa },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "\u0917\u094d\u0930\u0940\u0928\u0940\u091a \u0938\u094d\u091f\u0948\u0902\u0921\u0930\u094d\u0921 \u091f\u093e\u0908\u092e",
                    "GMT",
                    "\u0906\u0908\u0930\u0940\u0936 \u0938\u092e\u0930 \u091f\u093e\u0908\u092e",
                    "GST",
                    "Greenwich Time",
                    "GT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", America_Central },
            { "America/Ojinaga", America_Central },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", America_Mountain },
            { "America/Cancun", America_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", America_Pacific },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Asia/Urumqi", China },
            { "Europe/Volgograd", Volgograd },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Magadan },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "America/Montreal", America_Eastern },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
