/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond.FtileDimensionMemoize;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;

public class FtileSwitchNude
extends FtileDimensionMemoize {
    protected double xSeparation = 20.0;
    protected final List<Ftile> tiles;
    private final Swimlane in;

    public FtileSwitchNude(List<Ftile> tiles, Swimlane in) {
        super(tiles.get(0).skinParam());
        this.tiles = tiles;
        this.in = in;
    }

    @Override
    public Collection<Ftile> getMyChildren() {
        return Collections.unmodifiableCollection(this.tiles);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> result = new HashSet<Swimlane>();
        if (this.getSwimlaneIn() != null) {
            result.add(this.getSwimlaneIn());
        }
        for (Ftile tile : this.tiles) {
            result.addAll(tile.getSwimlanes());
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.in;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.getSwimlaneIn();
    }

    @Override
    public UTranslate getTranslateFor(Ftile child, StringBounder stringBounder) {
        if (this.tiles.contains(child)) {
            return this.getTranslateNude(child, stringBounder);
        }
        throw new UnsupportedOperationException();
    }

    protected UTranslate getTranslateNude(Ftile tile, StringBounder stringBounder) {
        double x1 = 0.0;
        for (Ftile candidate : this.tiles) {
            FtileGeometry dim1 = candidate.calculateDimension(stringBounder);
            if (candidate == tile) {
                return UTranslate.dx(x1);
            }
            x1 += dim1.getWidth() + this.xSeparation;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        for (Ftile tile : this.tiles) {
            ug.apply(this.getTranslateNude(tile, stringBounder)).draw(tile);
        }
    }

    @Override
    protected final FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        FtileGeometry dimTotal = this.calculateDimensionInternal(stringBounder);
        for (Ftile tile : this.tiles) {
            if (!tile.calculateDimension(stringBounder).hasPointOut()) continue;
            return dimTotal;
        }
        return dimTotal.withoutPointOut();
    }

    @Override
    protected FtileGeometry calculateDimensionInternalSlow(StringBounder stringBounder) {
        XDimension2D result = new XDimension2D(0.0, 0.0);
        for (Ftile couple : this.tiles) {
            result = result.mergeLR(couple.calculateDimension(stringBounder));
        }
        result = result.delta(this.xSeparation * (double)(this.tiles.size() - 1), 100.0);
        return new FtileGeometry(result, result.getWidth() / 2.0, 0.0);
    }
}

