/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class PreferenceManager {
    protected Properties internal = null;
    protected Map defaults = null;
    protected String prefFileName = null;
    protected String fullName = null;
    protected static final String USER_HOME = PreferenceManager.getSystemProperty("user.home");
    protected static final String USER_DIR = PreferenceManager.getSystemProperty("user.dir");
    protected static final String FILE_SEP = PreferenceManager.getSystemProperty("file.separator");
    private static String PREF_DIR = null;

    protected static String getSystemProperty(String string) {
        try {
            return System.getProperty(string);
        }
        catch (AccessControlException accessControlException) {
            return "";
        }
    }

    public PreferenceManager(String string) {
        this(string, null);
    }

    public PreferenceManager(String string, Map map) {
        this.prefFileName = string;
        this.defaults = map;
        this.internal = new Properties();
    }

    public static void setPreferenceDirectory(String string) {
        PREF_DIR = string;
    }

    public static String getPreferenceDirectory() {
        return PREF_DIR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        FileInputStream fileInputStream = null;
        if (this.fullName != null) {
            try {
                fileInputStream = new FileInputStream(this.fullName);
            }
            catch (IOException iOException) {
                this.fullName = null;
            }
        }
        if (this.fullName == null) {
            if (PREF_DIR != null) {
                try {
                    this.fullName = PREF_DIR + FILE_SEP + this.prefFileName;
                    fileInputStream = new FileInputStream(this.fullName);
                }
                catch (IOException iOException) {
                    this.fullName = null;
                }
            }
            if (this.fullName == null) {
                try {
                    this.fullName = USER_HOME + FILE_SEP + this.prefFileName;
                    fileInputStream = new FileInputStream(this.fullName);
                }
                catch (IOException iOException) {
                    try {
                        this.fullName = USER_DIR + FILE_SEP + this.prefFileName;
                        fileInputStream = new FileInputStream(this.fullName);
                    }
                    catch (IOException iOException2) {
                        this.fullName = null;
                    }
                }
            }
        }
        if (this.fullName != null) {
            try {
                this.internal.load(fileInputStream);
            }
            finally {
                fileInputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        FileOutputStream fileOutputStream = null;
        if (this.fullName != null) {
            try {
                fileOutputStream = new FileOutputStream(this.fullName);
            }
            catch (IOException iOException) {
                this.fullName = null;
            }
        }
        if (this.fullName == null) {
            if (PREF_DIR != null) {
                try {
                    this.fullName = PREF_DIR + FILE_SEP + this.prefFileName;
                    fileOutputStream = new FileOutputStream(this.fullName);
                }
                catch (IOException iOException) {
                    this.fullName = null;
                }
            }
            if (this.fullName == null) {
                try {
                    this.fullName = USER_HOME + FILE_SEP + this.prefFileName;
                    fileOutputStream = new FileOutputStream(this.fullName);
                }
                catch (IOException iOException) {
                    this.fullName = null;
                    throw iOException;
                }
            }
        }
        try {
            this.internal.store(fileOutputStream, this.prefFileName);
        }
        finally {
            fileOutputStream.close();
        }
    }

    private Object getDefault(String string) {
        if (this.defaults != null) {
            return this.defaults.get(string);
        }
        return null;
    }

    public Rectangle getRectangle(String string) {
        Rectangle rectangle = (Rectangle)this.getDefault(string);
        String string2 = this.internal.getProperty(string);
        if (string2 == null) {
            return rectangle;
        }
        Rectangle rectangle2 = new Rectangle();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ", false);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string);
                return rectangle;
            }
            String string3 = stringTokenizer.nextToken();
            int n = Integer.parseInt(string3);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string);
                return rectangle;
            }
            string3 = stringTokenizer.nextToken();
            int n2 = Integer.parseInt(string3);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string);
                return rectangle;
            }
            string3 = stringTokenizer.nextToken();
            int n3 = Integer.parseInt(string3);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string);
                return rectangle;
            }
            string3 = stringTokenizer.nextToken();
            int n4 = Integer.parseInt(string3);
            rectangle2.setBounds(n, n2, n3, n4);
            return rectangle2;
        }
        catch (NumberFormatException numberFormatException) {
            this.internal.remove(string);
            return rectangle;
        }
    }

    public Dimension getDimension(String string) {
        Dimension dimension = (Dimension)this.getDefault(string);
        String string2 = this.internal.getProperty(string);
        if (string2 == null) {
            return dimension;
        }
        Dimension dimension2 = new Dimension();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ", false);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string);
                return dimension;
            }
            String string3 = stringTokenizer.nextToken();
            int n = Integer.parseInt(string3);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string);
                return dimension;
            }
            string3 = stringTokenizer.nextToken();
            int n2 = Integer.parseInt(string3);
            dimension2.setSize(n, n2);
            return dimension2;
        }
        catch (NumberFormatException numberFormatException) {
            this.internal.remove(string);
            return dimension;
        }
    }

    public Point getPoint(String string) {
        Point point = (Point)this.getDefault(string);
        String string2 = this.internal.getProperty(string);
        if (string2 == null) {
            return point;
        }
        Point point2 = new Point();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ", false);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string);
                return point;
            }
            String string3 = stringTokenizer.nextToken();
            int n = Integer.parseInt(string3);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string);
                return point;
            }
            string3 = stringTokenizer.nextToken();
            int n2 = Integer.parseInt(string3);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string);
                return point;
            }
            point2.setLocation(n, n2);
            return point2;
        }
        catch (NumberFormatException numberFormatException) {
            this.internal.remove(string);
            return point;
        }
    }

    public Color getColor(String string) {
        Color color = (Color)this.getDefault(string);
        String string2 = this.internal.getProperty(string);
        if (string2 == null) {
            return color;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ", false);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string);
                return color;
            }
            String string3 = stringTokenizer.nextToken();
            int n = Integer.parseInt(string3);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string);
                return color;
            }
            string3 = stringTokenizer.nextToken();
            int n2 = Integer.parseInt(string3);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string);
                return color;
            }
            string3 = stringTokenizer.nextToken();
            int n3 = Integer.parseInt(string3);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string);
                return color;
            }
            string3 = stringTokenizer.nextToken();
            int n4 = Integer.parseInt(string3);
            return new Color(n, n2, n3, n4);
        }
        catch (NumberFormatException numberFormatException) {
            this.internal.remove(string);
            return color;
        }
    }

    public Font getFont(String string) {
        Font font = (Font)this.getDefault(string);
        String string2 = this.internal.getProperty(string);
        if (string2 == null) {
            return font;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ", false);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string);
                return font;
            }
            String string3 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string);
                return font;
            }
            String string4 = stringTokenizer.nextToken();
            int n = Integer.parseInt(string4);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string);
                return font;
            }
            string4 = stringTokenizer.nextToken();
            int n2 = Integer.parseInt(string4);
            return new Font(string3, n2, n);
        }
        catch (NumberFormatException numberFormatException) {
            this.internal.remove(string);
            return font;
        }
    }

    public String getString(String string) {
        String string2 = this.internal.getProperty(string);
        if (string2 == null) {
            string2 = (String)this.getDefault(string);
        }
        return string2;
    }

    public String[] getStrings(String string) {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (true) {
            String string2 = this.getString(string + n);
            ++n;
            if (string2 == null) break;
            arrayList.add(string2);
        }
        if (arrayList.size() != 0) {
            String[] stringArray = new String[arrayList.size()];
            return arrayList.toArray(stringArray);
        }
        return (String[])this.getDefault(string);
    }

    public URL getURL(String string) {
        URL uRL = (URL)this.getDefault(string);
        String string2 = this.internal.getProperty(string);
        if (string2 == null) {
            return uRL;
        }
        URL uRL2 = null;
        try {
            uRL2 = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            this.internal.remove(string);
            return uRL;
        }
        return uRL2;
    }

    public URL[] getURLs(String string) {
        int n = 0;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        while (true) {
            URL uRL = this.getURL(string + n);
            ++n;
            if (uRL == null) break;
            arrayList.add(uRL);
        }
        if (arrayList.size() != 0) {
            URL[] uRLArray = new URL[arrayList.size()];
            return arrayList.toArray(uRLArray);
        }
        return (URL[])this.getDefault(string);
    }

    public File getFile(String string) {
        File file = (File)this.getDefault(string);
        String string2 = this.internal.getProperty(string);
        if (string2 == null) {
            return file;
        }
        File file2 = new File(string2);
        if (file2.exists()) {
            return file2;
        }
        this.internal.remove(string);
        return file;
    }

    public File[] getFiles(String string) {
        int n = 0;
        ArrayList<File> arrayList = new ArrayList<File>();
        while (true) {
            File file = this.getFile(string + n);
            ++n;
            if (file == null) break;
            arrayList.add(file);
        }
        if (arrayList.size() != 0) {
            File[] fileArray = new File[arrayList.size()];
            return arrayList.toArray(fileArray);
        }
        return (File[])this.getDefault(string);
    }

    public int getInteger(String string) {
        int n;
        String string2;
        int n2 = 0;
        if (this.getDefault(string) != null) {
            n2 = (Integer)this.getDefault(string);
        }
        if ((string2 = this.internal.getProperty(string)) == null) {
            return n2;
        }
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.internal.remove(string);
            return n2;
        }
        return n;
    }

    public float getFloat(String string) {
        float f;
        String string2;
        float f2 = 0.0f;
        if (this.getDefault(string) != null) {
            f2 = ((Float)this.getDefault(string)).floatValue();
        }
        if ((string2 = this.internal.getProperty(string)) == null) {
            return f2;
        }
        try {
            f = Float.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.setFloat(string, f2);
            return f2;
        }
        return f;
    }

    public boolean getBoolean(String string) {
        if (this.internal.getProperty(string) != null) {
            return this.internal.getProperty(string).equals("true");
        }
        if (this.getDefault(string) != null) {
            return (Boolean)this.getDefault(string);
        }
        return false;
    }

    public void setRectangle(String string, Rectangle rectangle) {
        if (rectangle != null && !rectangle.equals(this.getDefault(string))) {
            this.internal.setProperty(string, rectangle.x + " " + rectangle.y + " " + rectangle.width + ' ' + rectangle.height);
        } else {
            this.internal.remove(string);
        }
    }

    public void setDimension(String string, Dimension dimension) {
        if (dimension != null && !dimension.equals(this.getDefault(string))) {
            this.internal.setProperty(string, dimension.width + " " + dimension.height);
        } else {
            this.internal.remove(string);
        }
    }

    public void setPoint(String string, Point point) {
        if (point != null && !point.equals(this.getDefault(string))) {
            this.internal.setProperty(string, point.x + " " + point.y);
        } else {
            this.internal.remove(string);
        }
    }

    public void setColor(String string, Color color) {
        if (color != null && !color.equals(this.getDefault(string))) {
            this.internal.setProperty(string, color.getRed() + " " + color.getGreen() + " " + color.getBlue() + " " + color.getAlpha());
        } else {
            this.internal.remove(string);
        }
    }

    public void setFont(String string, Font font) {
        if (font != null && !font.equals(this.getDefault(string))) {
            this.internal.setProperty(string, font.getName() + " " + font.getSize() + " " + font.getStyle());
        } else {
            this.internal.remove(string);
        }
    }

    public void setString(String string, String string2) {
        if (string2 != null && !string2.equals(this.getDefault(string))) {
            this.internal.setProperty(string, string2);
        } else {
            this.internal.remove(string);
        }
    }

    public void setStrings(String string, String[] stringArray) {
        String string2;
        int n = 0;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                this.setString(string + n, stringArray[i]);
                ++n;
            }
        }
        while ((string2 = this.getString(string + n)) != null) {
            this.setString(string + n, null);
            ++n;
        }
    }

    public void setURL(String string, URL uRL) {
        if (uRL != null && !uRL.equals(this.getDefault(string))) {
            this.internal.setProperty(string, uRL.toString());
        } else {
            this.internal.remove(string);
        }
    }

    public void setURLs(String string, URL[] uRLArray) {
        String string2;
        int n = 0;
        if (uRLArray != null) {
            for (int i = 0; i < uRLArray.length; ++i) {
                if (uRLArray[i] == null) continue;
                this.setURL(string + n, uRLArray[i]);
                ++n;
            }
        }
        while ((string2 = this.getString(string + n)) != null) {
            this.setString(string + n, null);
            ++n;
        }
    }

    public void setFile(String string, File file) {
        if (file != null && !file.equals(this.getDefault(string))) {
            this.internal.setProperty(string, file.getAbsolutePath());
        } else {
            this.internal.remove(string);
        }
    }

    public void setFiles(String string, File[] fileArray) {
        String string2;
        int n = 0;
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i] == null) continue;
                this.setFile(string + n, fileArray[i]);
                ++n;
            }
        }
        while ((string2 = this.getString(string + n)) != null) {
            this.setString(string + n, null);
            ++n;
        }
    }

    public void setInteger(String string, int n) {
        if (this.getDefault(string) != null && (Integer)this.getDefault(string) != n) {
            this.internal.setProperty(string, Integer.toString(n));
        } else {
            this.internal.remove(string);
        }
    }

    public void setFloat(String string, float f) {
        if (this.getDefault(string) != null && ((Float)this.getDefault(string)).floatValue() != f) {
            this.internal.setProperty(string, Float.toString(f));
        } else {
            this.internal.remove(string);
        }
    }

    public void setBoolean(String string, boolean bl) {
        if (this.getDefault(string) != null && (Boolean)this.getDefault(string) != bl) {
            this.internal.setProperty(string, bl ? "true" : "false");
        } else {
            this.internal.remove(string);
        }
    }
}

