from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.gp import *
from OCC.Core.TColgp import *
from OCC.Core.TColStd import *
from OCC.Core.Bnd import *
from OCC.Core.OSD import *
from OCC.Core.TShort import *

#the following typedef cannot be wrapped as is
Poly_BaseIteratorOfCoherentLink = NewType('Poly_BaseIteratorOfCoherentLink', Any)
#the following typedef cannot be wrapped as is
Poly_BaseIteratorOfCoherentNode = NewType('Poly_BaseIteratorOfCoherentNode', Any)
#the following typedef cannot be wrapped as is
Poly_BaseIteratorOfCoherentTriangle = NewType('Poly_BaseIteratorOfCoherentTriangle', Any)
Poly_MeshPurpose = NewType('Poly_MeshPurpose', int)

class Poly_Array1OfTriangle:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> Poly_Triangle: ...
    def __setitem__(self, index: int, value: Poly_Triangle) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[Poly_Triangle]: ...
    def next(self) -> Poly_Triangle: ...
    __next__ = next
    def Init(self, theValue: Poly_Triangle) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> Poly_Triangle: ...
    def Last(self) -> Poly_Triangle: ...
    def Value(self, theIndex: int) -> Poly_Triangle: ...
    def SetValue(self, theIndex: int, theValue: Poly_Triangle) -> None: ...

class Poly_ListOfTriangulation:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Append(self, theItem: False) -> False: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...


class poly:
    @staticmethod
    def Catenate(lstTri: Poly_ListOfTriangulation) -> Poly_Triangulation: ...
    @staticmethod
    def ComputeNormals(Tri: Poly_Triangulation) -> None: ...
    @staticmethod
    def Intersect(theTri: Poly_Triangulation, theAxis: gp_Ax1, theIsClosest: bool, theTriangle: Poly_Triangle) -> Tuple[bool, float]: ...
    @staticmethod
    def IntersectTriLine(theStart: gp_XYZ, theDir: gp_Dir, theV0: gp_XYZ, theV1: gp_XYZ, theV2: gp_XYZ) -> Tuple[int, float]: ...
    @staticmethod
    def PointOnTriangle(P1: gp_XY, P2: gp_XY, P3: gp_XY, P: gp_XY, UV: gp_XY) -> float: ...

class Poly_ArrayOfNodes():
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLength: int) -> None: ...
    @overload
    def __init__(self, theOther: Poly_ArrayOfNodes) -> None: ...
    @overload
    def __init__(self, theBegin: gp_Pnt, theLength: int) -> None: ...
    @overload
    def __init__(self, theBegin: gp_Vec3f, theLength: int) -> None: ...
    @overload
    def __init__(self, theOther: Poly_ArrayOfNodes) -> None: ...
    def Assign(self, theOther: Poly_ArrayOfNodes) -> Poly_ArrayOfNodes: ...
    def IsDoublePrecision(self) -> bool: ...
    def Move(self, theOther: Poly_ArrayOfNodes) -> Poly_ArrayOfNodes: ...
    def SetDoublePrecision(self, theIsDouble: bool) -> None: ...
    def SetValue(self, theIndex: int, theValue: gp_Pnt) -> None: ...
    def Value(self, theIndex: int) -> gp_Pnt: ...

class Poly_ArrayOfUVNodes():
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLength: int) -> None: ...
    @overload
    def __init__(self, theOther: Poly_ArrayOfUVNodes) -> None: ...
    @overload
    def __init__(self, theBegin: gp_Pnt2d, theLength: int) -> None: ...
    @overload
    def __init__(self, theBegin: gp_Vec2f, theLength: int) -> None: ...
    @overload
    def __init__(self, theOther: Poly_ArrayOfUVNodes) -> None: ...
    def Assign(self, theOther: Poly_ArrayOfUVNodes) -> Poly_ArrayOfUVNodes: ...
    def IsDoublePrecision(self) -> bool: ...
    def Move(self, theOther: Poly_ArrayOfUVNodes) -> Poly_ArrayOfUVNodes: ...
    def SetDoublePrecision(self, theIsDouble: bool) -> None: ...
    def SetValue(self, theIndex: int, theValue: gp_Pnt2d) -> None: ...
    def Value(self, theIndex: int) -> gp_Pnt2d: ...

class Poly_CoherentLink:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, iNode0: int, iNode1: int) -> None: ...
    @overload
    def __init__(self, theTri: Poly_CoherentTriangle, iSide: int) -> None: ...
    def GetAttribute(self) -> None: ...
    def IsEmpty(self) -> bool: ...
    def Node(self, ind: int) -> int: ...
    def Nullify(self) -> None: ...
    def OppositeNode(self, ind: int) -> int: ...
    def SetAttribute(self, theAtt: None) -> None: ...

class Poly_CoherentNode(gp_XYZ):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, thePnt: gp_XYZ) -> None: ...
    def AddTriangle(self, theTri: Poly_CoherentTriangle, theA: NCollection_BaseAllocator) -> None: ...
    def GetIndex(self) -> int: ...
    def GetNormal(self) -> gp_XYZ: ...
    def GetU(self) -> float: ...
    def GetV(self) -> float: ...
    def HasNormal(self) -> bool: ...
    def IsFreeNode(self) -> bool: ...
    def RemoveTriangle(self, theTri: Poly_CoherentTriangle, theA: NCollection_BaseAllocator) -> bool: ...
    def SetIndex(self, theIndex: int) -> None: ...
    def SetNormal(self, theVector: gp_XYZ) -> None: ...
    def SetUV(self, theU: float, theV: float) -> None: ...
    def TriangleIterator(self) -> False: ...

class Poly_CoherentTriangle:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, iNode0: int, iNode1: int, iNode2: int) -> None: ...
    def GetConnectedNode(self, iConn: int) -> int: ...
    def GetConnectedTri(self, iConn: int) -> Poly_CoherentTriangle: ...
    def GetLink(self, iLink: int) -> Poly_CoherentLink: ...
    def IsEmpty(self) -> bool: ...
    def NConnections(self) -> int: ...
    def Node(self, ind: int) -> int: ...
    @overload
    def RemoveConnection(self, iConn: int) -> None: ...
    @overload
    def RemoveConnection(self, theTri: Poly_CoherentTriangle) -> bool: ...
    @overload
    def SetConnection(self, iConn: int, theTr: Poly_CoherentTriangle) -> bool: ...
    @overload
    def SetConnection(self, theTri: Poly_CoherentTriangle) -> bool: ...

class Poly_Connect:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theTriangulation: Poly_Triangulation) -> None: ...
    def Initialize(self, N: int) -> None: ...
    def Load(self, theTriangulation: Poly_Triangulation) -> None: ...
    def More(self) -> bool: ...
    def Next(self) -> None: ...
    def Nodes(self, T: int) -> Tuple[int, int, int]: ...
    def Triangle(self, N: int) -> int: ...
    def Triangles(self, T: int) -> Tuple[int, int, int]: ...
    def Triangulation(self) -> Poly_Triangulation: ...
    def Value(self) -> int: ...

class Poly_MergeNodesTool(Standard_Transient):
    def AddQuad(self, theElemNodes_list: List[gp_XYZ]) -> None: ...
    def AddTriangle(self, theElemNodes_list: List[gp_XYZ]) -> None: ...
    def AddTriangulation(self, theTris: Poly_Triangulation, theTrsf: Optional[gp_Trsf] = gp_Trsf(), theToReverse: Optional[bool] = false) -> None: ...
    def ChangeOutput(self) -> Poly_Triangulation: ...
    def MergeAngle(self) -> False: ...
    def MergeTolerance(self) -> False: ...
    def NbDegenerativeElems(self) -> False: ...
    def NbElements(self) -> False: ...
    def NbMergedElems(self) -> False: ...
    def NbNodes(self) -> False: ...
    def PushLastQuad(self) -> None: ...
    def PushLastTriangle(self) -> None: ...
    def Result(self) -> Poly_Triangulation: ...
    def SetDropDegenerative(self, theToDrop: bool) -> None: ...
    def SetMergeElems(self, theToMerge: bool) -> None: ...
    def SetMergeOpposite(self, theToMerge: bool) -> None: ...
    def ToDropDegenerative(self) -> bool: ...
    def ToMergeElems(self) -> bool: ...
    def ToMergeOpposite(self) -> bool: ...
    def computeTriNormal(self) -> float: ...

class Poly_Polygon2D(Standard_Transient):
    @overload
    def __init__(self, theNbNodes: int) -> None: ...
    @overload
    def __init__(self, Nodes: TColgp_Array1OfPnt2d) -> None: ...
    def ChangeNodes(self) -> TColgp_Array1OfPnt2d: ...
    @overload
    def Deflection(self) -> float: ...
    @overload
    def Deflection(self, theDefl: float) -> None: ...
    def NbNodes(self) -> int: ...
    def Nodes(self) -> TColgp_Array1OfPnt2d: ...

class Poly_Polygon3D(Standard_Transient):
    @overload
    def __init__(self, theNbNodes: int, theHasParams: bool) -> None: ...
    @overload
    def __init__(self, Nodes: TColgp_Array1OfPnt) -> None: ...
    @overload
    def __init__(self, Nodes: TColgp_Array1OfPnt, Parameters: TColStd_Array1OfReal) -> None: ...
    def ChangeNodes(self) -> TColgp_Array1OfPnt: ...
    def ChangeParameters(self) -> TColStd_Array1OfReal: ...
    def Copy(self) -> Poly_Polygon3D: ...
    @overload
    def Deflection(self) -> float: ...
    @overload
    def Deflection(self, theDefl: float) -> None: ...
    def HasParameters(self) -> bool: ...
    def NbNodes(self) -> int: ...
    def Nodes(self) -> TColgp_Array1OfPnt: ...
    def Parameters(self) -> TColStd_Array1OfReal: ...

class Poly_PolygonOnTriangulation(Standard_Transient):
    @overload
    def __init__(self, theNbNodes: int, theHasParams: bool) -> None: ...
    @overload
    def __init__(self, Nodes: TColStd_Array1OfInteger) -> None: ...
    @overload
    def __init__(self, Nodes: TColStd_Array1OfInteger, Parameters: TColStd_Array1OfReal) -> None: ...
    def ChangeNodes(self) -> TColStd_Array1OfInteger: ...
    def ChangeParameters(self) -> TColStd_Array1OfReal: ...
    def Copy(self) -> Poly_PolygonOnTriangulation: ...
    @overload
    def Deflection(self) -> float: ...
    @overload
    def Deflection(self, theDefl: float) -> None: ...
    def HasParameters(self) -> bool: ...
    def NbNodes(self) -> int: ...
    def Node(self, theIndex: int) -> int: ...
    def Nodes(self) -> TColStd_Array1OfInteger: ...
    def Parameter(self, theIndex: int) -> float: ...
    def Parameters(self) -> TColStd_HArray1OfReal: ...
    def SetNode(self, theIndex: int, theNode: int) -> None: ...
    def SetParameter(self, theIndex: int, theValue: float) -> None: ...
    def SetParameters(self, theParameters: TColStd_HArray1OfReal) -> None: ...

class Poly_Triangle:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theN1: int, theN2: int, theN3: int) -> None: ...
    def GetChangeValue(self, theIndex: int) -> int: ...
    def SetChangeValue(self, theIndex: int, value: int) -> None: ...
    def Get(self) -> Tuple[int, int, int]: ...
    @overload
    def Set(self, theN1: int, theN2: int, theN3: int) -> None: ...
    @overload
    def Set(self, theIndex: int, theNode: int) -> None: ...
    def Value(self, theIndex: int) -> int: ...

class Poly_Triangulation(Standard_Transient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theNbNodes: int, theNbTriangles: int, theHasUVNodes: bool, theHasNormals: Optional[bool] = false) -> None: ...
    @overload
    def __init__(self, Nodes: TColgp_Array1OfPnt, Triangles: Poly_Array1OfTriangle) -> None: ...
    @overload
    def __init__(self, Nodes: TColgp_Array1OfPnt, UVNodes: TColgp_Array1OfPnt2d, Triangles: Poly_Array1OfTriangle) -> None: ...
    @overload
    def __init__(self, theTriangulation: Poly_Triangulation) -> None: ...
    def AddNormals(self) -> None: ...
    def AddUVNodes(self) -> None: ...
    def CachedMinMax(self) -> Bnd_Box: ...
    def ChangeTriangle(self, theIndex: int) -> Poly_Triangle: ...
    def ChangeTriangles(self) -> Poly_Array1OfTriangle: ...
    def Clear(self) -> None: ...
    def ComputeNormals(self) -> None: ...
    def Copy(self) -> Poly_Triangulation: ...
    @overload
    def Deflection(self) -> float: ...
    @overload
    def Deflection(self, theDeflection: float) -> None: ...
    def DetachedLoadDeferredData(self, theFileSystem: Optional[OSD_FileSystem] = OSD_FileSystem()) -> Poly_Triangulation: ...
    def HasCachedMinMax(self) -> bool: ...
    def HasDeferredData(self) -> bool: ...
    def HasGeometry(self) -> bool: ...
    def HasNormals(self) -> bool: ...
    def HasUVNodes(self) -> bool: ...
    def InternalNodes(self) -> Poly_ArrayOfNodes: ...
    def InternalNormals(self) -> False: ...
    def InternalTriangles(self) -> Poly_Array1OfTriangle: ...
    def InternalUVNodes(self) -> Poly_ArrayOfUVNodes: ...
    def IsDoublePrecision(self) -> bool: ...
    def LoadDeferredData(self, theFileSystem: Optional[OSD_FileSystem] = OSD_FileSystem()) -> bool: ...
    def MapNodeArray(self) -> TColgp_HArray1OfPnt: ...
    def MapNormalArray(self) -> TShort_HArray1OfShortReal: ...
    def MapTriangleArray(self) -> Poly_HArray1OfTriangle: ...
    def MapUVNodeArray(self) -> TColgp_HArray1OfPnt2d: ...
    def MeshPurpose(self) -> Poly_MeshPurpose: ...
    def MinMax(self, theBox: Bnd_Box, theTrsf: gp_Trsf, theIsAccurate: Optional[bool] = false) -> bool: ...
    def NbDeferredNodes(self) -> int: ...
    def NbDeferredTriangles(self) -> int: ...
    def NbNodes(self) -> int: ...
    def NbTriangles(self) -> int: ...
    def Node(self, theIndex: int) -> gp_Pnt: ...
    @overload
    def Normal(self, theIndex: int) -> gp_Dir: ...
    @overload
    def Normal(self, theIndex: int, theVec3: gp_Vec3f) -> None: ...
    @overload
    def Parameters(self) -> Poly_TriangulationParameters: ...
    @overload
    def Parameters(self, theParams: Poly_TriangulationParameters) -> None: ...
    def RemoveNormals(self) -> None: ...
    def RemoveUVNodes(self) -> None: ...
    def ResizeNodes(self, theNbNodes: int, theToCopyOld: bool) -> None: ...
    def ResizeTriangles(self, theNbTriangles: int, theToCopyOld: bool) -> None: ...
    def SetCachedMinMax(self, theBox: Bnd_Box) -> None: ...
    def SetDoublePrecision(self, theIsDouble: bool) -> None: ...
    def SetMeshPurpose(self, thePurpose: Poly_MeshPurpose) -> None: ...
    def SetNode(self, theIndex: int, thePnt: gp_Pnt) -> None: ...
    @overload
    def SetNormal(self, theIndex: int, theNormal: gp_Vec3f) -> None: ...
    @overload
    def SetNormal(self, theIndex: int, theNormal: gp_Dir) -> None: ...
    def SetNormals(self, theNormals: TShort_HArray1OfShortReal) -> None: ...
    def SetTriangle(self, theIndex: int, theTriangle: Poly_Triangle) -> None: ...
    def SetUVNode(self, theIndex: int, thePnt: gp_Pnt2d) -> None: ...
    def Triangle(self, theIndex: int) -> Poly_Triangle: ...
    def Triangles(self) -> Poly_Array1OfTriangle: ...
    def UVNode(self, theIndex: int) -> gp_Pnt2d: ...
    def UnloadDeferredData(self) -> bool: ...
    def UpdateCachedMinMax(self) -> None: ...

class Poly_TriangulationParameters(Standard_Transient):
    def __init__(self, theDeflection: Optional[float] = -1, theAngle: Optional[float] = -1, theMinSize: Optional[float] = -1) -> None: ...
    def Angle(self) -> float: ...
    def Deflection(self) -> float: ...
    def HasAngle(self) -> bool: ...
    def HasDeflection(self) -> bool: ...
    def HasMinSize(self) -> bool: ...
    def MinSize(self) -> float: ...

#classnotwrapped
class Poly_CoherentTriPtr: ...

#classnotwrapped
class Poly_CoherentTriangulation: ...

#classnotwrapped
class Poly_MakeLoops: ...

#classnotwrapped
class Poly_MakeLoops3D: ...

#classnotwrapped
class Poly_MakeLoops2D: ...

# harray1 classes

class Poly_HArray1OfTriangle(Poly_Array1OfTriangle, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> Poly_Array1OfTriangle: ...

# harray2 classes
# hsequence classes

poly_Catenate = poly.Catenate
poly_ComputeNormals = poly.ComputeNormals
poly_Dump = poly.Dump
poly_Dump = poly.Dump
poly_Dump = poly.Dump
poly_Intersect = poly.Intersect
poly_IntersectTriLine = poly.IntersectTriLine
poly_PointOnTriangle = poly.PointOnTriangle
poly_Write = poly.Write
poly_Write = poly.Write
poly_Write = poly.Write
Poly_MergeNodesTool_MergeNodes = Poly_MergeNodesTool.MergeNodes
