# coding: utf-8

"""
    NetHSM

    All endpoints expect exactly the specified JSON. Additional properties will cause a Bad Request Error (400). All HTTP errors contain a JSON structure with an explanation of type string. All <a href=\"https://tools.ietf.org/html/rfc4648#section-4\">base64</a> encoded values are Big Endian.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from pynitrokey.nethsm.client import schemas  # noqa: F401


class SystemInfo(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """


    class MetaOapg:
        required = {
            "buildTag",
            "hardwareVersion",
            "firmwareVersion",
            "softwareVersion",
        }
        
        class properties:
            firmwareVersion = schemas.StrSchema
            softwareVersion = schemas.StrSchema
            hardwareVersion = schemas.StrSchema
            buildTag = schemas.StrSchema
            __annotations__ = {
                "firmwareVersion": firmwareVersion,
                "softwareVersion": softwareVersion,
                "hardwareVersion": hardwareVersion,
                "buildTag": buildTag,
            }
    
    buildTag: MetaOapg.properties.buildTag
    hardwareVersion: MetaOapg.properties.hardwareVersion
    firmwareVersion: MetaOapg.properties.firmwareVersion
    softwareVersion: MetaOapg.properties.softwareVersion
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["firmwareVersion"]) -> MetaOapg.properties.firmwareVersion: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["softwareVersion"]) -> MetaOapg.properties.softwareVersion: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["hardwareVersion"]) -> MetaOapg.properties.hardwareVersion: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["buildTag"]) -> MetaOapg.properties.buildTag: ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["firmwareVersion", "softwareVersion", "hardwareVersion", "buildTag", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["firmwareVersion"]) -> MetaOapg.properties.firmwareVersion: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["softwareVersion"]) -> MetaOapg.properties.softwareVersion: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["hardwareVersion"]) -> MetaOapg.properties.hardwareVersion: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["buildTag"]) -> MetaOapg.properties.buildTag: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["firmwareVersion", "softwareVersion", "hardwareVersion", "buildTag", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *args: typing.Union[dict, frozendict.frozendict, ],
        buildTag: typing.Union[MetaOapg.properties.buildTag, str, ],
        hardwareVersion: typing.Union[MetaOapg.properties.hardwareVersion, str, ],
        firmwareVersion: typing.Union[MetaOapg.properties.firmwareVersion, str, ],
        softwareVersion: typing.Union[MetaOapg.properties.softwareVersion, str, ],
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'SystemInfo':
        return super().__new__(
            cls,
            *args,
            buildTag=buildTag,
            hardwareVersion=hardwareVersion,
            firmwareVersion=firmwareVersion,
            softwareVersion=softwareVersion,
            _configuration=_configuration,
            **kwargs,
        )
