/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.ast;

import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.ast.ASTNode;
import org.mvel2.ast.Assignment;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.util.ParseTools;

public class TypedVarNode
extends ASTNode
implements Assignment {
    private String name;
    private ExecutableStatement statement;

    public TypedVarNode(char[] expr, int start, int offset, int fields2, Class type2, ParserContext pCtx) {
        super(pCtx);
        this.egressType = type2;
        this.fields = fields2;
        this.expr = expr;
        this.start = start;
        this.offset = offset;
        this.expr = expr;
        int assignStart = ParseTools.find(expr, start, offset, '=');
        if (assignStart != -1) {
            this.name = ParseTools.createStringTrimmed(expr, start, assignStart - start);
            ParseTools.checkNameSafety(this.name);
            this.offset -= assignStart - start;
            this.start = assignStart + 1;
            if (((fields2 |= 0x80) & 0x10) != 0) {
                this.statement = (ExecutableStatement)ParseTools.subCompileExpression(expr, this.start, this.offset, pCtx);
            }
        } else {
            this.name = new String(expr, start, offset);
            ParseTools.checkNameSafety(this.name);
        }
        if ((fields2 & 0x10) != 0) {
            Class x = pCtx.getVarOrInputType(this.name);
            if (x != null && x != Object.class && !x.isAssignableFrom(this.egressType)) {
                throw new RuntimeException("statically-typed variable already defined in scope: " + this.name);
            }
            pCtx.addVariable(this.name, this.egressType, false);
        }
    }

    @Override
    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.statement == null) {
            this.statement = (ExecutableStatement)ParseTools.subCompileExpression(this.expr, this.start, this.offset, this.pCtx);
        }
        ctx = this.statement.getValue(ctx, thisValue, factory);
        factory.createVariable(this.name, ctx, this.egressType);
        return ctx;
    }

    @Override
    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        ctx = MVEL.eval(this.expr, this.start, this.offset, thisValue, factory);
        factory.createVariable(this.name, ctx, this.egressType);
        return ctx;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAssignmentVar() {
        return this.name;
    }

    @Override
    public char[] getExpression() {
        return this.expr;
    }

    @Override
    public boolean isNewDeclaration() {
        return true;
    }

    @Override
    public void setValueStatement(ExecutableStatement stmt) {
        this.statement = stmt;
    }
}

