/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Objects;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import org.apache.catalina.connector.InputBuffer;
import org.apache.catalina.security.SecurityUtil;
import org.apache.tomcat.util.res.StringManager;

public class CoyoteInputStream
extends ServletInputStream {
    protected static final StringManager sm = StringManager.getManager(CoyoteInputStream.class);
    protected InputBuffer ib;

    protected CoyoteInputStream(InputBuffer inputBuffer) {
        this.ib = inputBuffer;
    }

    void clear() {
        this.ib = null;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public int read() throws IOException {
        this.checkNonBlockingRead();
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                Integer n = AccessController.doPrivileged(new PrivilegedRead(this.ib));
                return n;
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception.getMessage(), exception);
            }
        }
        return this.ib.readByte();
    }

    public int available() throws IOException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                Integer n = AccessController.doPrivileged(new PrivilegedAvailable(this.ib));
                return n;
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception.getMessage(), exception);
            }
        }
        return this.ib.available();
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.checkNonBlockingRead();
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                Integer n3 = AccessController.doPrivileged(new PrivilegedReadArray(this.ib, byArray, n, n2));
                return n3;
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception.getMessage(), exception);
            }
        }
        return this.ib.read(byArray, n, n2);
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        Objects.requireNonNull(byteBuffer);
        this.checkNonBlockingRead();
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                Integer n = AccessController.doPrivileged(new PrivilegedReadBuffer(this.ib, byteBuffer));
                return n;
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception.getMessage(), exception);
            }
        }
        return this.ib.read(byteBuffer);
    }

    public void close() throws IOException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                AccessController.doPrivileged(new PrivilegedClose(this.ib));
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception.getMessage(), exception);
            }
        } else {
            this.ib.close();
        }
    }

    public boolean isFinished() {
        return this.ib.isFinished();
    }

    public boolean isReady() {
        if (this.ib == null) {
            throw new IllegalStateException(sm.getString("coyoteInputStream.null"));
        }
        return this.ib.isReady();
    }

    public void setReadListener(ReadListener readListener) {
        this.ib.setReadListener(readListener);
    }

    private void checkNonBlockingRead() {
        if (!this.ib.isBlocking() && !this.ib.isReady()) {
            throw new IllegalStateException(sm.getString("coyoteInputStream.nbNotready"));
        }
    }

    private static class PrivilegedReadBuffer
    implements PrivilegedExceptionAction<Integer> {
        private final InputBuffer inputBuffer;
        private final ByteBuffer bb;

        PrivilegedReadBuffer(InputBuffer inputBuffer, ByteBuffer byteBuffer) {
            this.inputBuffer = inputBuffer;
            this.bb = byteBuffer;
        }

        @Override
        public Integer run() throws IOException {
            Integer n = this.inputBuffer.read(this.bb);
            return n;
        }
    }

    private static class PrivilegedReadArray
    implements PrivilegedExceptionAction<Integer> {
        private final InputBuffer inputBuffer;
        private final byte[] buf;
        private final int off;
        private final int len;

        PrivilegedReadArray(InputBuffer inputBuffer, byte[] byArray, int n, int n2) {
            this.inputBuffer = inputBuffer;
            this.buf = byArray;
            this.off = n;
            this.len = n2;
        }

        @Override
        public Integer run() throws IOException {
            Integer n = this.inputBuffer.read(this.buf, this.off, this.len);
            return n;
        }
    }

    private static class PrivilegedRead
    implements PrivilegedExceptionAction<Integer> {
        private final InputBuffer inputBuffer;

        PrivilegedRead(InputBuffer inputBuffer) {
            this.inputBuffer = inputBuffer;
        }

        @Override
        public Integer run() throws IOException {
            Integer n = this.inputBuffer.readByte();
            return n;
        }
    }

    private static class PrivilegedClose
    implements PrivilegedExceptionAction<Void> {
        private final InputBuffer inputBuffer;

        PrivilegedClose(InputBuffer inputBuffer) {
            this.inputBuffer = inputBuffer;
        }

        @Override
        public Void run() throws IOException {
            this.inputBuffer.close();
            return null;
        }
    }

    private static class PrivilegedAvailable
    implements PrivilegedExceptionAction<Integer> {
        private final InputBuffer inputBuffer;

        PrivilegedAvailable(InputBuffer inputBuffer) {
            this.inputBuffer = inputBuffer;
        }

        @Override
        public Integer run() throws IOException {
            return this.inputBuffer.available();
        }
    }
}

