/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.MemoryRuleSet;
import org.apache.catalina.realm.RealmBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.RuleSet;
import org.apache.tomcat.util.file.ConfigFileLoader;

public class MemoryRealm
extends RealmBase {
    private static final Log log = LogFactory.getLog(MemoryRealm.class);
    private static Digester digester = null;
    private static final Object digesterLock = new Object();
    private String pathname = "conf/tomcat-users.xml";
    private final Map<String, GenericPrincipal> principals = new HashMap<String, GenericPrincipal>();

    public String getPathname() {
        return this.pathname;
    }

    public void setPathname(String string) {
        this.pathname = string;
    }

    @Override
    public Principal authenticate(String string, String string2) {
        if (string == null || string2 == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("memoryRealm.authenticateFailure", new Object[]{string}));
            }
            return null;
        }
        GenericPrincipal genericPrincipal = this.principals.get(string);
        if (genericPrincipal == null || genericPrincipal.getPassword() == null) {
            this.getCredentialHandler().mutate(string2);
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("memoryRealm.authenticateFailure", new Object[]{string}));
            }
            return null;
        }
        boolean bl = this.getCredentialHandler().matches(string2, genericPrincipal.getPassword());
        if (bl) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("memoryRealm.authenticateSuccess", new Object[]{string}));
            }
            return genericPrincipal;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("memoryRealm.authenticateFailure", new Object[]{string}));
        }
        return null;
    }

    void addUser(String string, String string2, String string3) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        string3 = string3 + ",";
        while ((n = string3.indexOf(44)) >= 0) {
            String string4 = string3.substring(0, n).trim();
            arrayList.add(string4);
            string3 = string3.substring(n + 1);
        }
        GenericPrincipal genericPrincipal = new GenericPrincipal(string, string2, arrayList);
        this.principals.put(string, genericPrincipal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Digester getDigester() {
        Object object = digesterLock;
        synchronized (object) {
            if (digester == null) {
                digester = new Digester();
                digester.setValidating(false);
                try {
                    digester.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
                }
                catch (Exception exception) {
                    log.warn((Object)sm.getString("memoryRealm.xmlFeatureEncoding"), (Throwable)exception);
                }
                digester.addRuleSet((RuleSet)new MemoryRuleSet());
            }
        }
        return digester;
    }

    @Override
    protected String getPassword(String string) {
        GenericPrincipal genericPrincipal = this.principals.get(string);
        if (genericPrincipal != null) {
            return genericPrincipal.getPassword();
        }
        return null;
    }

    @Override
    protected Principal getPrincipal(String string) {
        return this.principals.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void startInternal() throws LifecycleException {
        String string = this.getPathname();
        try (InputStream inputStream = ConfigFileLoader.getSource().getResource(string).getInputStream();){
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("memoryRealm.loadPath", new Object[]{string}));
            }
            Digester digester = this.getDigester();
            try {
                Digester digester2 = digester;
                synchronized (digester2) {
                    digester.push((Object)this);
                    digester.parse(inputStream);
                }
            }
            catch (Exception exception) {
                throw new LifecycleException(sm.getString("memoryRealm.readXml"), exception);
            }
            finally {
                digester.reset();
            }
        }
        catch (IOException iOException) {
            throw new LifecycleException(sm.getString("memoryRealm.loadExist", new Object[]{string}), iOException);
        }
        super.startInternal();
    }
}

