/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.environment;

import org.graalvm.visualvm.jfr.JFRSnapshot;
import org.graalvm.visualvm.jfr.model.JFREventChecker;
import org.graalvm.visualvm.jfr.view.JFRViewTab;
import org.graalvm.visualvm.jfr.view.JFRViewTabProvider;
import org.graalvm.visualvm.jfr.views.environment.JFRSnapshotEnvironmentView;

public class JFRSnapshotEnvironmentViewProvider
extends JFRViewTabProvider {
    static final String EVENT_CPU_INFO = "jdk.CPUInformation";
    static final String EVENT_PHYSICAL_MEMORY = "jdk.PhysicalMemory";
    static final String EVENT_OS_INFO = "jdk.OSInformation";
    static final String EVENT_CPU_LOAD = "jdk.CPULoad";
    static final String EVENT_NETWORK_UTILIZATION = "jdk.NetworkUtilization";
    static final String EVENT_ENVIRONMENT_VARIABLE = "jdk.InitialEnvironmentVariable";
    static final String EVENT_SYSTEM_PROCESS = "jdk.SystemProcess";

    @Override
    protected JFRViewTab createView(JFRSnapshot jfrSnapshot) {
        return new JFRSnapshotEnvironmentView(jfrSnapshot);
    }

    public static final class EventChecker
    extends JFREventChecker {
        public EventChecker() {
            super(EventChecker.checkedTypes());
        }

        static String[] checkedTypes() {
            return new String[]{JFRSnapshotEnvironmentViewProvider.EVENT_CPU_INFO, JFRSnapshotEnvironmentViewProvider.EVENT_PHYSICAL_MEMORY, JFRSnapshotEnvironmentViewProvider.EVENT_OS_INFO, JFRSnapshotEnvironmentViewProvider.EVENT_CPU_LOAD, JFRSnapshotEnvironmentViewProvider.EVENT_NETWORK_UTILIZATION, JFRSnapshotEnvironmentViewProvider.EVENT_ENVIRONMENT_VARIABLE, JFRSnapshotEnvironmentViewProvider.EVENT_SYSTEM_PROCESS};
        }
    }
}

