/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.v2.features;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import org.graalvm.visualvm.lib.common.Profiler;
import org.graalvm.visualvm.lib.common.ProfilingSettings;
import org.graalvm.visualvm.lib.jfluid.ProfilerClient;
import org.graalvm.visualvm.lib.jfluid.client.ClientUtils;
import org.graalvm.visualvm.lib.profiler.ResultsListener;
import org.graalvm.visualvm.lib.profiler.ResultsManager;
import org.graalvm.visualvm.lib.profiler.api.ProjectUtilities;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.profiler.v2.ProfilerFeature;
import org.graalvm.visualvm.lib.profiler.v2.ProfilerSession;
import org.graalvm.visualvm.lib.profiler.v2.features.Bundle;
import org.graalvm.visualvm.lib.profiler.v2.features.FeatureMode;
import org.graalvm.visualvm.lib.profiler.v2.features.SQLFeatureModes;
import org.graalvm.visualvm.lib.profiler.v2.features.SQLFeatureUI;
import org.graalvm.visualvm.lib.profiler.v2.impl.WeakProcessor;
import org.graalvm.visualvm.lib.profiler.v2.ui.SettingsPanel;
import org.graalvm.visualvm.lib.ui.components.ProfilerToolbar;
import org.graalvm.visualvm.lib.ui.swing.PopupButton;
import org.graalvm.visualvm.lib.ui.swing.SmallButton;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

final class SQLFeature
extends ProfilerFeature.Basic {
    private final WeakProcessor processor;
    private FeatureMode currentMode;
    private FeatureMode appliedMode;
    private SQLFeatureModes.AllQueriesMode allQueriesMode;
    private SQLFeatureModes.FilteredQueriesMode filteredQueriesMode;
    private static final String MODE_FLAG = "MODE_FLAG";
    private static final String SETTINGS_FLAG = "SETTINGS_FLAG";
    private JPanel settingsUI;
    private JButton modeButton;
    private JPanel settingsContainer;
    private JButton applyButton;
    private SQLFeatureUI ui;
    private Runnable refresher;
    private volatile boolean running;
    private SQLResetter resetter;

    private SQLFeature(ProfilerSession session) {
        super(Icons.getIcon((String)"ProfilerIcons.WindowSql"), Bundle.SQLFeature_name(), Bundle.SQLFeature_description(), 20, session);
        Lookup.Provider project = session.getProject();
        String projectName = project == null ? "External Process" : ProjectUtilities.getDisplayName((Lookup.Provider)project);
        this.processor = new WeakProcessor("SQLFeature Processor for " + projectName);
        this.initModes();
    }

    private void initModes() {
        this.allQueriesMode = new SQLFeatureModes.AllQueriesMode(){

            @Override
            String readFlag(String flag, String defaultValue) {
                return SQLFeature.this.readFlag(this.getID() + "_" + flag, defaultValue);
            }

            @Override
            void storeFlag(String flag, String value) {
                SQLFeature.this.storeFlag(this.getID() + "_" + flag, value);
            }

            @Override
            void settingsChanged() {
                SQLFeature.this.settingsChanged();
            }
        };
        this.filteredQueriesMode = new SQLFeatureModes.FilteredQueriesMode(){

            @Override
            String readFlag(String flag, String defaultValue) {
                return SQLFeature.this.readFlag(this.getID() + "_" + flag, defaultValue);
            }

            @Override
            void storeFlag(String flag, String value) {
                SQLFeature.this.storeFlag(this.getID() + "_" + flag, value);
            }

            @Override
            void settingsChanged() {
                SQLFeature.this.settingsChanged();
            }
        };
        String _currentMode = this.readFlag(MODE_FLAG, this.allQueriesMode.getID());
        this.currentMode = _currentMode.equals(this.filteredQueriesMode.getID()) ? this.filteredQueriesMode : this.allQueriesMode;
        this.appliedMode = this.currentMode;
    }

    private void saveMode() {
        this.storeFlag(MODE_FLAG, this.currentMode.getID());
    }

    private void setMode(FeatureMode newMode) {
        if (this.currentMode == newMode) {
            return;
        }
        this.currentMode = newMode;
        this.modeChanged();
    }

    private void confirmMode() {
        this.appliedMode = this.currentMode;
    }

    private void modeChanged() {
        this.updateModeName();
        this.updateModeUI();
        this.configurationChanged();
        this.saveMode();
    }

    @Override
    public boolean supportsSettings(ProfilingSettings psettings) {
        return !ProfilingSettings.isCPUSettings((ProfilingSettings)psettings) && !ProfilingSettings.isMemorySettings((ProfilingSettings)psettings);
    }

    @Override
    public void configureSettings(ProfilingSettings psettings) {
        this.currentMode.configureSettings(psettings);
    }

    @Override
    public boolean currentSettingsValid() {
        return this.currentMode.currentSettingsValid();
    }

    private void submitChanges() {
        this.confirmMode();
        this.confirmSettings();
        this.fireChange();
    }

    private boolean pendingChanges() {
        if (this.appliedMode != this.currentMode) {
            return true;
        }
        return this.currentMode.pendingChanges();
    }

    private void configurationChanged() {
        assert (this.isActivated());
        ProfilerSession session = this.getSession();
        if (!session.inProgress()) {
            this.submitChanges();
        } else {
            this.updateApplyButton(session.getState());
        }
    }

    private void confirmSettings() {
        this.currentMode.confirmSettings();
    }

    private void confirmAllSettings() {
        if (this.allQueriesMode != null) {
            this.allQueriesMode.confirmSettings();
        }
        if (this.filteredQueriesMode != null) {
            this.filteredQueriesMode.confirmSettings();
        }
    }

    private void settingsChanged() {
        this.configurationChanged();
    }

    private void selectionChanged() {
        this.configurationChanged();
    }

    @Override
    public JPanel getSettingsUI() {
        if (this.settingsUI == null) {
            this.settingsUI = new JPanel(new GridBagLayout()){

                @Override
                public void setVisible(boolean visible) {
                    if (visible && this.getComponentCount() == 0) {
                        SQLFeature.this.populateSettingsUI();
                    }
                    super.setVisible(visible);
                    SQLFeature.this.storeFlag(SQLFeature.SETTINGS_FLAG, visible ? Boolean.TRUE.toString() : null);
                }

                @Override
                public Dimension getPreferredSize() {
                    if (this.getComponentCount() == 0) {
                        return new Dimension();
                    }
                    return super.getPreferredSize();
                }
            };
            String _vis = this.readFlag(SETTINGS_FLAG, null);
            boolean vis = _vis == null ? false : Boolean.parseBoolean(_vis);
            this.settingsUI.setVisible(vis || this.currentMode != this.allQueriesMode);
        }
        return this.settingsUI;
    }

    private void populateSettingsUI() {
        this.settingsUI.setOpaque(false);
        this.settingsUI.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        SettingsPanel profilePanel = new SettingsPanel();
        profilePanel.add(new JLabel(Bundle.ObjectsFeature_profileMode()));
        profilePanel.add(Box.createHorizontalStrut(5));
        this.modeButton = new PopupButton(this.currentMode.getName()){

            protected void populatePopup(JPopupMenu popup) {
                popup.add(new JRadioButtonMenuItem(SQLFeature.this.allQueriesMode.getName(), SQLFeature.this.currentMode == SQLFeature.this.allQueriesMode){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        SQLFeature.this.setMode(SQLFeature.this.allQueriesMode);
                    }
                });
                popup.add(new JRadioButtonMenuItem(SQLFeature.this.filteredQueriesMode.getName(), SQLFeature.this.currentMode == SQLFeature.this.filteredQueriesMode){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        SQLFeature.this.setMode(SQLFeature.this.filteredQueriesMode);
                    }
                });
            }
        };
        profilePanel.add(this.modeButton);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 18;
        this.settingsUI.add((Component)profilePanel, c);
        this.settingsContainer = new JPanel(new BorderLayout());
        this.settingsContainer.setOpaque(false);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 3;
        c.insets = new Insets(0, 10, 0, 0);
        c.anchor = 18;
        this.settingsUI.add((Component)this.settingsContainer, c);
        SettingsPanel buttonsPanel = new SettingsPanel();
        final Component space = Box.createHorizontalStrut(10);
        buttonsPanel.add(space);
        this.applyButton = new SmallButton(Bundle.ObjectsFeature_applyButton()){

            protected void fireActionPerformed(ActionEvent e) {
                SQLFeature.this.stopResults();
                SQLFeature.this.resetResults();
                SQLFeature.this.submitChanges();
                SQLFeature.this.unpauseResults();
            }

            public void setVisible(boolean visible) {
                super.setVisible(visible);
                space.setVisible(visible);
            }
        };
        buttonsPanel.add(this.applyButton);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 0;
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 12;
        this.settingsUI.add((Component)buttonsPanel, c);
        this.updateModeUI();
        this.updateApplyButton(this.getSession().getState());
    }

    private void updateModeName() {
        if (this.modeButton != null) {
            this.modeButton.setText(this.currentMode.getName());
        }
    }

    private void updateModeUI() {
        if (this.settingsContainer != null) {
            this.settingsContainer.removeAll();
            JComponent modeUI = this.currentMode.getUI();
            if (modeUI != null) {
                this.settingsContainer.add(modeUI);
            }
            this.settingsContainer.doLayout();
            this.settingsContainer.repaint();
        }
    }

    private void updateApplyButton(int state) {
        if (this.applyButton != null) {
            boolean visible = state != 1;
            this.applyButton.setVisible(visible);
            if (visible) {
                this.applyButton.setEnabled(this.currentSettingsValid() && this.pendingChanges());
            }
        }
    }

    @Override
    public JPanel getResultsUI() {
        return this.getUI().getResultsUI();
    }

    @Override
    public ProfilerToolbar getToolbar() {
        return this.getUI().getToolbar();
    }

    private SQLFeatureUI getUI() {
        if (this.ui == null) {
            this.ui = new SQLFeatureUI(){

                @Override
                void selectForProfiling(final ClientUtils.SourceCodeSelection value) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            String name = "*".equals(value.getMethodName()) ? Bundle.SQLFeature_profileClass() : Bundle.SQLFeature_profileMethod();
                            ProfilerSession.findAndConfigure(Lookups.fixed((Object[])new Object[]{value}), this.getProject(), name);
                        }
                    });
                }

                @Override
                Lookup.Provider getProject() {
                    return SQLFeature.this.getSession().getProject();
                }

                @Override
                ProfilerClient getProfilerClient() {
                    Profiler profiler = SQLFeature.this.getSession().getProfiler();
                    return profiler.getTargetAppRunner().getProfilerClient();
                }

                @Override
                int getSessionState() {
                    return SQLFeature.this.getSessionState();
                }

                @Override
                void refreshResults() {
                    SQLFeature.this.refreshResults();
                }
            };
        }
        return this.ui;
    }

    private void startResults() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.refresher = new Runnable(){

            @Override
            public void run() {
                if (SQLFeature.this.running) {
                    SQLFeature.this.refreshView();
                    SQLFeature.this.refreshResults(1500);
                }
            }
        };
        this.refreshResults(1000);
    }

    private void refreshView() {
        if (this.ui != null && ResultsManager.getDefault().resultsAvailable()) {
            try {
                this.ui.refreshData();
            }
            catch (ClientUtils.TargetAppOrVMTerminated ex) {
                this.stopResults();
            }
        }
    }

    private void refreshResults() {
        if (this.running) {
            this.processor.post(new Runnable(){

                @Override
                public void run() {
                    if (SQLFeature.this.ui != null) {
                        SQLFeature.this.ui.setForceRefresh();
                    }
                    SQLFeature.this.refreshView();
                }
            });
        }
    }

    private void refreshResults(int delay) {
        if (this.running && this.refresher != null) {
            this.processor.post(this.refresher, delay);
        }
    }

    private void resetResults() {
        if (this.ui != null) {
            this.ui.resetData();
        }
    }

    private void stopResults() {
        if (this.refresher != null) {
            this.running = false;
            this.refresher = null;
        }
    }

    private void unpauseResults() {
        if (this.ui != null) {
            this.ui.resetPause();
        }
    }

    @Override
    public void notifyActivated() {
        this.resetResults();
        this.resetter = (SQLResetter)Lookup.getDefault().lookup(SQLResetter.class);
        this.resetter.controller = this;
    }

    @Override
    public void notifyDeactivated() {
        this.resetResults();
        if (this.resetter != null) {
            this.resetter.controller = null;
            this.resetter = null;
        }
        if (this.ui != null) {
            this.ui.cleanup();
            this.ui = null;
        }
    }

    @Override
    protected void profilingStateChanged(int oldState, int newState) {
        if (newState == 1 || newState == 128) {
            this.stopResults();
            this.confirmAllSettings();
        } else if (this.isActivated() && newState == 4) {
            this.startResults();
        } else if (newState == 2) {
            this.resetResults();
            this.unpauseResults();
        }
        if (this.ui != null) {
            this.ui.sessionStateChanged(this.getSessionState());
        }
        this.updateApplyButton(newState);
    }

    public static final class Provider
    extends ProfilerFeature.Provider {
        @Override
        public ProfilerFeature getFeature(ProfilerSession session) {
            return new SQLFeature(session);
        }
    }

    public static final class SQLResetter
    implements ResultsListener {
        private SQLFeature controller;

        @Override
        public void resultsAvailable() {
        }

        @Override
        public void resultsReset() {
            if (this.controller != null && this.controller.ui != null) {
                this.controller.ui.resetData();
            }
        }
    }
}

