"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDebugStateSelector = void 0;
var create_selector_1 = require("../../../../state/create_selector");
var geometry_1 = require("../../../../utils/geometry");
var axis_type_utils_1 = require("../../utils/axis_type_utils");
var compute_axes_geometries_1 = require("./compute_axes_geometries");
var compute_legend_1 = require("./compute_legend");
var compute_series_geometries_1 = require("./compute_series_geometries");
var get_grid_lines_1 = require("./get_grid_lines");
var get_specs_1 = require("./get_specs");
exports.getDebugStateSelector = create_selector_1.createCustomCachedSelector([
    compute_series_geometries_1.computeSeriesGeometriesSelector,
    compute_legend_1.computeLegendSelector,
    compute_axes_geometries_1.computeAxesGeometriesSelector,
    get_grid_lines_1.computeGridLinesSelector,
    get_specs_1.getAxisSpecsSelector,
], function (_a, legend, axes, gridLines, axesSpecs) {
    var geometries = _a.geometries;
    var seriesNameMap = getSeriesNameMap(legend);
    return {
        legend: getLegendState(legend),
        axes: getAxes(axes, axesSpecs, gridLines),
        areas: geometries.areas.map(getAreaState(seriesNameMap)),
        lines: geometries.lines.map(getLineState(seriesNameMap)),
        bars: getBarsState(seriesNameMap, geometries.bars),
    };
});
function getAxes(axesGeoms, axesSpecs, gridLines) {
    return axesSpecs.reduce(function (acc, _a) {
        var position = _a.position, title = _a.title, id = _a.id;
        var geom = axesGeoms.find(function (_a) {
            var axis = _a.axis;
            return axis.id === id;
        });
        if (!geom) {
            return acc;
        }
        var visibleTicks = geom.visibleTicks.filter(function (_a) {
            var label = _a.label;
            return label !== '';
        });
        var labels = visibleTicks.map(function (_a) {
            var label = _a.label;
            return label;
        });
        var values = visibleTicks.map(function (_a) {
            var value = _a.value;
            return value;
        });
        var gridlines = gridLines
            .flatMap(function (_a) {
            var _b, _c;
            var lineGroups = _a.lineGroups;
            return (_c = (_b = lineGroups.find(function (_a) {
                var axisId = _a.axisId;
                return axisId === geom.axis.id;
            })) === null || _b === void 0 ? void 0 : _b.lines) !== null && _c !== void 0 ? _c : [];
        })
            .map(function (_a) {
            var x = _a.x1, y = _a.y1;
            return ({ x: x, y: y });
        });
        acc[axis_type_utils_1.isHorizontalAxis(position) ? 'x' : 'y'].push(__assign({ id: id,
            title: title,
            position: position }, (axis_type_utils_1.isHorizontalAxis(position)
            ? { labels: labels, values: values, gridlines: gridlines }
            : { labels: labels.reverse(), values: values.reverse(), gridlines: gridlines.reverse() })));
        return acc;
    }, { x: [], y: [] });
}
function getBarsState(seriesNameMap, barGeometries) {
    var buckets = new Map();
    var bars = barGeometries.reduce(function (acc, bars) {
        return __spread(acc, bars.value);
    }, []);
    bars.forEach(function (_a) {
        var _b, _c;
        var color = _a.color, key = _a.seriesIdentifier.key, _d = _a.seriesStyle, rect = _d.rect, rectBorder = _d.rectBorder, _e = _a.value, x = _e.x, y = _e.y, mark = _e.mark, displayValue = _a.displayValue;
        var label = displayValue === null || displayValue === void 0 ? void 0 : displayValue.text;
        var name = (_b = seriesNameMap.get(key)) !== null && _b !== void 0 ? _b : '';
        var bucket = (_c = buckets.get(key)) !== null && _c !== void 0 ? _c : {
            key: key,
            name: name,
            color: color,
            bars: [],
            labels: [],
            visible: hasVisibleStyle(rect) || hasVisibleStyle(rectBorder),
        };
        bucket.bars.push({ x: x, y: y, mark: mark });
        if (label) {
            bucket.labels.push(label);
        }
        buckets.set(key, bucket);
        return buckets;
    });
    return __spread(buckets.values());
}
function getLineState(seriesNameMap) {
    return function (_a) {
        var _b;
        var _c = _a.value, path = _c.line, points = _c.points, color = _c.color, key = _c.seriesIdentifier.key, seriesLineStyle = _c.seriesLineStyle, seriesPointStyle = _c.seriesPointStyle;
        var name = (_b = seriesNameMap.get(key)) !== null && _b !== void 0 ? _b : '';
        return {
            path: path,
            color: color,
            key: key,
            name: name,
            visible: hasVisibleStyle(seriesLineStyle),
            visiblePoints: hasVisibleStyle(seriesPointStyle),
            points: points.map(function (_a) {
                var _b = _a.value, x = _b.x, y = _b.y, mark = _b.mark;
                return ({ x: x, y: y, mark: mark });
            }),
        };
    };
}
function getAreaState(seriesNameMap) {
    return function (_a) {
        var _b;
        var _c = _a.value, path = _c.area, lines = _c.lines, points = _c.points, color = _c.color, key = _c.seriesIdentifier.key, seriesAreaStyle = _c.seriesAreaStyle, seriesPointStyle = _c.seriesPointStyle, seriesAreaLineStyle = _c.seriesAreaLineStyle;
        var _d = __read(lines, 2), y1Path = _d[0], y0Path = _d[1];
        var linePoints = points.reduce(function (acc, _a) {
            var _b = _a.value, accessor = _b.accessor, value = __rest(_b, ["accessor"]);
            if (accessor === geometry_1.BandedAccessorType.Y0) {
                acc.y0.push(value);
            }
            else {
                acc.y1.push(value);
            }
            return acc;
        }, {
            y0: [],
            y1: [],
        });
        var lineVisible = hasVisibleStyle(seriesAreaLineStyle);
        var visiblePoints = hasVisibleStyle(seriesPointStyle);
        var name = (_b = seriesNameMap.get(key)) !== null && _b !== void 0 ? _b : '';
        return {
            path: path,
            color: color,
            key: key,
            name: name,
            visible: hasVisibleStyle(seriesAreaStyle),
            lines: {
                y0: y0Path
                    ? {
                        visible: lineVisible,
                        path: y0Path,
                        points: linePoints.y0,
                        visiblePoints: visiblePoints,
                    }
                    : undefined,
                y1: {
                    visible: lineVisible,
                    path: y1Path,
                    points: linePoints.y1,
                    visiblePoints: visiblePoints,
                },
            },
        };
    };
}
function getSeriesNameMap(legendItems) {
    return legendItems.reduce(function (acc, _a) {
        var name = _a.label, seriesIdentifiers = _a.seriesIdentifiers;
        seriesIdentifiers.forEach(function (_a) {
            var key = _a.key;
            acc.set(key, name);
        });
        return acc;
    }, new Map());
}
function getLegendState(legendItems) {
    var items = legendItems
        .filter(function (_a) {
        var isSeriesHidden = _a.isSeriesHidden;
        return !isSeriesHidden;
    })
        .map(function (_a) {
        var name = _a.label, color = _a.color, seriesIdentifiers = _a.seriesIdentifiers;
        return seriesIdentifiers.map(function (_a) {
            var key = _a.key;
            return ({
                key: key,
                name: name,
                color: color,
            });
        });
    })
        .flat();
    return { items: items };
}
function hasVisibleStyle(_a) {
    var _b = _a.visible, visible = _b === void 0 ? true : _b, _c = _a.fill, fill = _c === void 0 ? '#fff' : _c, _d = _a.stroke, stroke = _d === void 0 ? '#fff' : _d, _e = _a.strokeWidth, strokeWidth = _e === void 0 ? 1 : _e, _f = _a.opacity, opacity = _f === void 0 ? 1 : _f;
    return Boolean(visible && opacity > 0 && strokeWidth > 0 && fill && stroke);
}
//# sourceMappingURL=get_debug_state.js.map