/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cloud.gce.network;

import java.io.IOException;
import java.net.InetAddress;
import org.opensearch.cloud.gce.GceMetadataService;
import org.opensearch.cloud.gce.util.Access;
import org.opensearch.common.Strings;
import org.opensearch.common.network.NetworkService;

public class GceNameResolver
implements NetworkService.CustomNameResolver {
    private final GceMetadataService gceMetadataService;

    public GceNameResolver(GceMetadataService gceMetadataService) {
        this.gceMetadataService = gceMetadataService;
    }

    private InetAddress[] resolve(String value) throws IOException {
        String gceMetadataPath;
        if (value.equals(GceAddressResolverType.GCE.configName)) {
            gceMetadataPath = Strings.replace((String)GceAddressResolverType.GCE.gceName, (String)"{{network}}", (String)"0");
        } else if (value.equals(GceAddressResolverType.PRIVATE_DNS.configName)) {
            gceMetadataPath = GceAddressResolverType.PRIVATE_DNS.gceName;
        } else if (value.startsWith(GceAddressResolverType.PRIVATE_IP.configName)) {
            String network = "0";
            String[] privateIpConfig = value.split(":");
            if (privateIpConfig.length == 3) {
                network = privateIpConfig[2];
            }
            gceMetadataPath = Strings.replace((String)GceAddressResolverType.PRIVATE_IP.gceName, (String)"{{network}}", (String)network);
        } else {
            throw new IllegalArgumentException("[" + value + "] is not one of the supported GCE network.host setting. Expecting _gce_, _gce:privateIp:X_, _gce:hostname_");
        }
        try {
            String metadataResult = Access.doPrivilegedIOException(() -> this.gceMetadataService.metadata(gceMetadataPath));
            if (metadataResult == null || metadataResult.length() == 0) {
                throw new IOException("no gce metadata returned from [" + gceMetadataPath + "] for [" + value + "]");
            }
            return new InetAddress[]{InetAddress.getByName(metadataResult)};
        }
        catch (IOException e) {
            throw new IOException("IOException caught when fetching InetAddress from [" + gceMetadataPath + "]", e);
        }
    }

    public InetAddress[] resolveDefault() {
        return null;
    }

    public InetAddress[] resolveIfPossible(String value) throws IOException {
        if (value.startsWith("gce")) {
            return this.resolve(value);
        }
        return null;
    }

    private static enum GceAddressResolverType {
        PRIVATE_DNS("gce:hostname", "hostname"),
        PRIVATE_IP("gce:privateIp", "network-interfaces/{{network}}/ip"),
        GCE("gce", GceAddressResolverType.PRIVATE_IP.gceName);

        final String configName;
        final String gceName;

        private GceAddressResolverType(String configName, String gceName) {
            this.configName = configName;
            this.gceName = gceName;
        }
    }
}

