#
# fourcc are codes to specify the encoding method a audio or video string
# in RIFF file (.avi and .wav).
#
# The following lists come from mmpython project:
#    file: mmpython/video/fourcc.py
#    url:  http://sourceforge.net/projects/mmpython/
#

# List of codecs with no compression (compression rate=1.0)
UNCOMPRESSED_AUDIO = set((1, 3, 6))

audio_codec_name = {
    0x0000: 'Microsoft Unknown Wave Format',
    0x0001: 'Microsoft Pulse Code Modulation (PCM)',
    0x0002: 'Microsoft ADPCM',
    0x0003: 'IEEE Float',
    0x0004: 'Compaq Computer VSELP',
    0x0005: 'IBM CVSD',
    0x0006: 'Microsoft A-Law',
    0x0007: 'Microsoft mu-Law',
    0x0010: 'OKI ADPCM',
    0x0011: 'Intel DVI/IMA ADPCM',
    0x0012: 'Videologic MediaSpace ADPCM',
    0x0013: 'Sierra Semiconductor ADPCM',
    0x0014: 'Antex Electronics G.723 ADPCM',
    0x0015: 'DSP Solutions DigiSTD',
    0x0016: 'DSP Solutions DigiFIX',
    0x0017: 'Dialogic OKI ADPCM',
    0x0018: 'MediaVision ADPCM',
    0x0019: 'Hewlett-Packard CU',
    0x0020: 'Yamaha ADPCM',
    0x0021: 'Speech Compression Sonarc',
    0x0022: 'DSP Group TrueSpeech',
    0x0023: 'Echo Speech EchoSC1',
    0x0024: 'Audiofile AF36',
    0x0025: 'Audio Processing Technology APTX',
    0x0026: 'AudioFile AF10',
    0x0027: 'Prosody 1612',
    0x0028: 'LRC',
    0x0030: 'Dolby AC2',
    0x0031: 'Microsoft GSM 6.10',
    0x0032: 'MSNAudio',
    0x0033: 'Antex Electronics ADPCME',
    0x0034: 'Control Resources VQLPC',
    0x0035: 'DSP Solutions DigiREAL',
    0x0036: 'DSP Solutions DigiADPCM',
    0x0037: 'Control Resources CR10',
    0x0038: 'Natural MicroSystems VBXADPCM',
    0x0039: 'Crystal Semiconductor IMA ADPCM',
    0x003A: 'EchoSC3',
    0x003B: 'Rockwell ADPCM',
    0x003C: 'Rockwell Digit LK',
    0x003D: 'Xebec',
    0x0040: 'Antex Electronics G.721 ADPCM',
    0x0041: 'G.728 CELP',
    0x0042: 'MSG723',
    0x0050: 'Microsoft MPEG',
    0x0052: 'RT24',
    0x0053: 'PAC',
    0x0055: 'MPEG Layer 3',
    0x0059: 'Lucent G.723',
    0x0060: 'Cirrus',
    0x0061: 'ESPCM',
    0x0062: 'Voxware',
    0x0063: 'Canopus Atrac',
    0x0064: 'G.726 ADPCM',
    0x0065: 'G.722 ADPCM',
    0x0066: 'DSAT',
    0x0067: 'DSAT Display',
    0x0069: 'Voxware Byte Aligned',
    0x0070: 'Voxware AC8',
    0x0071: 'Voxware AC10',
    0x0072: 'Voxware AC16',
    0x0073: 'Voxware AC20',
    0x0074: 'Voxware MetaVoice',
    0x0075: 'Voxware MetaSound',
    0x0076: 'Voxware RT29HW',
    0x0077: 'Voxware VR12',
    0x0078: 'Voxware VR18',
    0x0079: 'Voxware TQ40',
    0x0080: 'Softsound',
    0x0081: 'Voxware TQ60',
    0x0082: 'MSRT24',
    0x0083: 'G.729A',
    0x0084: 'MVI MV12',
    0x0085: 'DF G.726',
    0x0086: 'DF GSM610',
    0x0088: 'ISIAudio',
    0x0089: 'Onlive',
    0x0091: 'SBC24',
    0x0092: 'Dolby AC3 SPDIF',
    0x0097: 'ZyXEL ADPCM',
    0x0098: 'Philips LPCBB',
    0x0099: 'Packed',
    0x0100: 'Rhetorex ADPCM',
    0x0101: 'IBM mu-law',
    0x0102: 'IBM A-law',
    0x0103: 'IBM AVC Adaptive Differential Pulse Code Modulation (ADPCM)',
    0x0111: 'Vivo G.723',
    0x0112: 'Vivo Siren',
    0x0123: 'Digital G.723',
    0x0140: 'Windows Media Video V8',
    0x0161: 'Windows Media Audio V7 / V8 / V9',
    0x0162: 'Windows Media Audio Professional V9',
    0x0163: 'Windows Media Audio Lossless V9',
    0x0200: 'Creative Labs ADPCM',
    0x0202: 'Creative Labs Fastspeech8',
    0x0203: 'Creative Labs Fastspeech10',
    0x0220: 'Quarterdeck',
    0x0300: 'Fujitsu FM Towns Snd',
    0x0400: 'BTV Digital',
    0x0680: 'VME VMPCM',
    0x1000: 'Olivetti GSM',
    0x1001: 'Olivetti ADPCM',
    0x1002: 'Olivetti CELP',
    0x1003: 'Olivetti SBC',
    0x1004: 'Olivetti OPR',
    0x1100: 'Lernout & Hauspie LH Codec',
    0x1400: 'Norris',
    0x1401: 'AT&T ISIAudio',
    0x1500: 'Soundspace Music Compression',
    0x2000: 'AC3',
    0x7A21: 'GSM-AMR (CBR, no SID)',
    0x7A22: 'GSM-AMR (VBR, including SID)',
    0xFFFF: 'Development codec'
}

video_fourcc_name = {
    '3IV1': '3ivx v1',
    '3IV2': '3ivx v2',
    'AASC': 'Autodesk Animator',
    'ABYR': 'Kensington ?ABYR?',
    'AEMI': 'Array VideoONE MPEG1-I Capture',
    'AFLC': 'Autodesk Animator FLC',
    'AFLI': 'Autodesk Animator FLI',
    'AMPG': 'Array VideoONE MPEG',
    'ANIM': 'Intel RDX (ANIM)',
    'AP41': 'AngelPotion Definitive',
    'ASV1': 'Asus Video v1',
    'ASV2': 'Asus Video v2',
    'ASVX': 'Asus Video 2.0 (audio)',
    'AUR2': 'Aura 2 Codec - YUV 4:2:2',
    'AURA': 'Aura 1 Codec - YUV 4:1:1',
    'BINK': 'RAD Game Tools Bink Video',
    'BT20': 'Conexant Prosumer Video',
    'BTCV': 'Conexant Composite Video Codec',
    'BW10': 'Data Translation Broadway MPEG Capture',
    'CC12': 'Intel YUV12',
    'CDVC': 'Canopus DV',
    'CFCC': 'Digital Processing Systems DPS Perception',
    'CGDI': 'Microsoft Office 97 Camcorder Video',
    'CHAM': 'Winnov Caviara Champagne',
    'CJPG': 'Creative WebCam JPEG',
    'CLJR': 'Cirrus Logic YUV 4 pixels',
    'CMYK': 'Common Data Format in Printing',
    'CPLA': 'Weitek 4:2:0 YUV Planar',
    'CRAM': 'Microsoft Video 1 (CRAM)',
    'CVID': 'Radius Cinepak',
    'CWLT': 'Microsoft Color WLT DIB',
    'CYUV': 'Creative Labs YUV',
    'CYUY': 'ATI YUV',
    'D261': 'H.261',
    'D263': 'H.263',
    'DIV3': 'DivX v3 MPEG-4 Low-Motion',
    'DIV4': 'DivX v3 MPEG-4 Fast-Motion',
    'DIV5': '?DIV5?',
    'DIVX': 'DivX v4',
    'divx': 'DivX',
    'DMB1': 'Matrox Rainbow Runner hardware MJPEG',
    'DMB2': 'Paradigm MJPEG',
    'DSVD': '?DSVD?',
    'DUCK': 'Duck True Motion 1.0',
    'DVAN': '?DVAN?',
    'DVE2': 'InSoft DVE-2 Videoconferencing',
    'dvsd': 'DV',
    'DVSD': 'DV',
    'DVX1': 'DVX1000SP Video Decoder',
    'DVX2': 'DVX2000S Video Decoder',
    'DVX3': 'DVX3000S Video Decoder',
    'DX50': 'DivX v5',
    'DXT1': 'Microsoft DirectX Compressed Texture (DXT1)',
    'DXT2': 'Microsoft DirectX Compressed Texture (DXT2)',
    'DXT3': 'Microsoft DirectX Compressed Texture (DXT3)',
    'DXT4': 'Microsoft DirectX Compressed Texture (DXT4)',
    'DXT5': 'Microsoft DirectX Compressed Texture (DXT5)',
    'DXTC': 'Microsoft DirectX Compressed Texture (DXTC)',
    'EKQ0': 'Elsa ?EKQ0?',
    'ELK0': 'Elsa ?ELK0?',
    'ESCP': 'Eidos Escape',
    'ETV1': 'eTreppid Video ETV1',
    'ETV2': 'eTreppid Video ETV2',
    'ETVC': 'eTreppid Video ETVC',
    'FLJP': 'D-Vision Field Encoded Motion JPEG',
    'FRWA': 'SoftLab-Nsk Forward Motion JPEG w/ alpha channel',
    'FRWD': 'SoftLab-Nsk Forward Motion JPEG',
    'FVF1': 'Iterated Systems Fractal Video Frame',
    'GLZW': 'Motion LZW (gabest@freemail.hu)',
    'GPEG': 'Motion JPEG (gabest@freemail.hu)',
    'GWLT': 'Microsoft Greyscale WLT DIB',
    'H260': 'Intel ITU H.260 Videoconferencing',
    'H261': 'Intel ITU H.261 Videoconferencing',
    'H262': 'Intel ITU H.262 Videoconferencing',
    'H263': 'Intel ITU H.263 Videoconferencing',
    'H264': 'Intel ITU H.264 Videoconferencing',
    'H265': 'Intel ITU H.265 Videoconferencing',
    'H266': 'Intel ITU H.266 Videoconferencing',
    'H267': 'Intel ITU H.267 Videoconferencing',
    'H268': 'Intel ITU H.268 Videoconferencing',
    'H269': 'Intel ITU H.269 Videoconferencing',
    'HFYU': 'Huffman Lossless Codec',
    'HMCR': 'Rendition Motion Compensation Format (HMCR)',
    'HMRR': 'Rendition Motion Compensation Format (HMRR)',
    'i263': 'Intel ITU H.263 Videoconferencing (i263)',
    'I420': 'Intel Indeo 4',
    'IAN ': 'Intel RDX',
    'ICLB': 'InSoft CellB Videoconferencing',
    'IGOR': 'Power DVD',
    'IJPG': 'Intergraph JPEG',
    'ILVC': 'Intel Layered Video',
    'ILVR': 'ITU-T H.263+',
    'IPDV': 'I-O Data Device Giga AVI DV Codec',
    'IR21': 'Intel Indeo 2.1',
    'IRAW': 'Intel YUV Uncompressed',
    'IV30': 'Ligos Indeo 3.0',
    'IV31': 'Ligos Indeo 3.1',
    'IV32': 'Ligos Indeo 3.2',
    'IV33': 'Ligos Indeo 3.3',
    'IV34': 'Ligos Indeo 3.4',
    'IV35': 'Ligos Indeo 3.5',
    'IV36': 'Ligos Indeo 3.6',
    'IV37': 'Ligos Indeo 3.7',
    'IV38': 'Ligos Indeo 3.8',
    'IV39': 'Ligos Indeo 3.9',
    'IV40': 'Ligos Indeo Interactive 4.0',
    'IV41': 'Ligos Indeo Interactive 4.1',
    'IV42': 'Ligos Indeo Interactive 4.2',
    'IV43': 'Ligos Indeo Interactive 4.3',
    'IV44': 'Ligos Indeo Interactive 4.4',
    'IV45': 'Ligos Indeo Interactive 4.5',
    'IV46': 'Ligos Indeo Interactive 4.6',
    'IV47': 'Ligos Indeo Interactive 4.7',
    'IV48': 'Ligos Indeo Interactive 4.8',
    'IV49': 'Ligos Indeo Interactive 4.9',
    'IV50': 'Ligos Indeo Interactive 5.0',
    'JBYR': 'Kensington ?JBYR?',
    'JPEG': 'Still Image JPEG DIB',
    'JPGL': 'Webcam JPEG Light?',
    'KMVC': 'Karl Morton\'s Video Codec',
    'LEAD': 'LEAD Video Codec',
    'Ljpg': 'LEAD MJPEG Codec',
    'M261': 'Microsoft H.261',
    'M263': 'Microsoft H.263',
    'M4S2': 'Microsoft MPEG-4 (M4S2)',
    'm4s2': 'Microsoft MPEG-4 (m4s2)',
    'MC12': 'ATI Motion Compensation Format (MC12)',
    'MCAM': 'ATI Motion Compensation Format (MCAM)',
    'MJ2C': 'Morgan Multimedia Motion JPEG2000',
    'mJPG': 'IBM Motion JPEG w/ Huffman Tables',
    'MJPG': 'Motion JPEG DIB',
    'MP42': 'Microsoft MPEG-4 (low-motion)',
    'MP43': 'Microsoft MPEG-4 (fast-motion)',
    'MP4S': 'Microsoft MPEG-4 (MP4S)',
    'mp4s': 'Microsoft MPEG-4 (mp4s)',
    'MPEG': 'MPEG 1 Video I-Frame',
    'MPG4': 'Microsoft MPEG-4 Video High Speed Compressor',
    'MPGI': 'Sigma Designs MPEG',
    'MRCA': 'FAST Multimedia Mrcodec',
    'MRLE': 'Microsoft Run Length Encoding (RLE)',
    'MSVC': 'Microsoft Video 1',
    'MTX1': 'Matrox ?MTX1?',
    'MTX2': 'Matrox ?MTX2?',
    'MTX3': 'Matrox ?MTX3?',
    'MTX4': 'Matrox ?MTX4?',
    'MTX5': 'Matrox ?MTX5?',
    'MTX6': 'Matrox ?MTX6?',
    'MTX7': 'Matrox ?MTX7?',
    'MTX8': 'Matrox ?MTX8?',
    'MTX9': 'Matrox ?MTX9?',
    'MV12': '?MV12?',
    'MWV1': 'Aware Motion Wavelets',
    'nAVI': '?nAVI?',
    'NTN1': 'Nogatech Video Compression 1',
    'NVS0': 'nVidia GeForce Texture (NVS0)',
    'NVS1': 'nVidia GeForce Texture (NVS1)',
    'NVS2': 'nVidia GeForce Texture (NVS2)',
    'NVS3': 'nVidia GeForce Texture (NVS3)',
    'NVS4': 'nVidia GeForce Texture (NVS4)',
    'NVS5': 'nVidia GeForce Texture (NVS5)',
    'NVT0': 'nVidia GeForce Texture (NVT0)',
    'NVT1': 'nVidia GeForce Texture (NVT1)',
    'NVT2': 'nVidia GeForce Texture (NVT2)',
    'NVT3': 'nVidia GeForce Texture (NVT3)',
    'NVT4': 'nVidia GeForce Texture (NVT4)',
    'NVT5': 'nVidia GeForce Texture (NVT5)',
    'PDVC': 'I-O Data Device Digital Video Capture DV codec',
    'PGVV': 'Radius Video Vision',
    'PHMO': 'IBM Photomotion',
    'PIM1': 'Pegasus Imaging ?PIM1?',
    'PIM2': 'Pegasus Imaging ?PIM2?',
    'PIMJ': 'Pegasus Imaging Lossless JPEG',
    'PVEZ': 'Horizons Technology PowerEZ',
    'PVMM': 'PacketVideo Corporation MPEG-4',
    'PVW2': 'Pegasus Imaging Wavelet Compression',
    'QPEG': 'Q-Team QPEG 1.0',
    'qpeq': 'Q-Team QPEG 1.1',
    'RGBT': 'Computer Concepts 32-bit support',
    'RLE ': 'Microsoft Run Length Encoder',
    'RLE4': 'Run Length Encoded 4',
    'RLE8': 'Run Length Encoded 8',
    'RT21': 'Intel Real Time Video 2.1',
    'rv20': 'RealVideo G2',
    'rv30': 'RealVideo 8',
    'RVX ': 'Intel RDX (RVX )',
    's422': 'Tekram VideoCap C210 YUV 4:2:2',
    'SDCC': 'Sun Communication Digital Camera Codec',
    'SFMC': 'CrystalNet Surface Fitting Method',
    'SMSC': 'Radius SMSC',
    'SMSD': 'Radius SMSD',
    'smsv': 'WorldConnect Wavelet Video',
    'SPIG': 'Radius Spigot',
    'SPLC': 'Splash Studios ACM Audio Codec',
    'SQZ2': 'Microsoft VXTreme Video Codec V2',
    'STVA': 'ST CMOS Imager Data (Bayer)',
    'STVB': 'ST CMOS Imager Data (Nudged Bayer)',
    'STVC': 'ST CMOS Imager Data (Bunched)',
    'STVX': 'ST CMOS Imager Data (Extended CODEC Data Format)',
    'STVY': 'ST CMOS Imager Data (Extended CODEC Data Format with Correction Data)',
    'SV10': 'Sorenson Video R1',
    'SVQ1': 'Sorenson Video R3',
    'TLMS': 'TeraLogic Motion Intraframe Codec (TLMS)',
    'TLST': 'TeraLogic Motion Intraframe Codec (TLST)',
    'TM20': 'Duck TrueMotion 2.0',
    'TM2X': 'Duck TrueMotion 2X',
    'TMIC': 'TeraLogic Motion Intraframe Codec (TMIC)',
    'TMOT': 'Horizons Technology TrueMotion S',
    'tmot': 'Horizons TrueMotion Video Compression',
    'TR20': 'Duck TrueMotion RealTime 2.0',
    'TSCC': 'TechSmith Screen Capture Codec',
    'TV10': 'Tecomac Low-Bit Rate Codec',
    'TY0N': 'Trident ?TY0N?',
    'TY2C': 'Trident ?TY2C?',
    'TY2N': 'Trident ?TY2N?',
    'UCOD': 'eMajix.com ClearVideo',
    'ULTI': 'IBM Ultimotion',
    'UYVY': 'UYVY 4:2:2 byte ordering',
    'V261': 'Lucent VX2000S',
    'V422': '24 bit YUV 4:2:2 Format',
    'V655': '16 bit YUV 4:2:2 Format',
    'VCR1': 'ATI VCR 1.0',
    'VCR2': 'ATI VCR 2.0',
    'VCR3': 'ATI VCR 3.0',
    'VCR4': 'ATI VCR 4.0',
    'VCR5': 'ATI VCR 5.0',
    'VCR6': 'ATI VCR 6.0',
    'VCR7': 'ATI VCR 7.0',
    'VCR8': 'ATI VCR 8.0',
    'VCR9': 'ATI VCR 9.0',
    'VDCT': 'Video Maker Pro DIB',
    'VDOM': 'VDOnet VDOWave',
    'VDOW': 'VDOnet VDOLive (H.263)',
    'VDTZ': 'Darim Vison VideoTizer YUV',
    'VGPX': 'VGPixel Codec',
    'VIDS': 'Vitec Multimedia YUV 4:2:2 CCIR 601 for V422',
    'VIFP': '?VIFP?',
    'VIVO': 'Vivo H.263 v2.00',
    'vivo': 'Vivo H.263',
    'VIXL': 'Miro Video XL',
    'VLV1': 'Videologic VLCAP.DRV',
    'VP30': 'On2 VP3.0',
    'VP31': 'On2 VP3.1',
    'VX1K': 'VX1000S Video Codec',
    'VX2K': 'VX2000S Video Codec',
    'VXSP': 'VX1000SP Video Codec',
    'WBVC': 'Winbond W9960',
    'WHAM': 'Microsoft Video 1 (WHAM)',
    'WINX': 'Winnov Software Compression',
    'WJPG': 'AverMedia Winbond JPEG',
    'WMV1': 'Windows Media Video V7',
    'WMV2': 'Windows Media Video V8',
    'WMV3': 'Windows Media Video V9',
    'WNV1': 'Winnov Hardware Compression',
    'x263': 'Xirlink H.263',
    'XLV0': 'NetXL Video Decoder',
    'XMPG': 'Xing MPEG (I-Frame only)',
    'XVID': 'XviD MPEG-4',
    'XXAN': '?XXAN?',
    'Y211': 'YUV 2:1:1 Packed',
    'Y411': 'YUV 4:1:1 Packed',
    'Y41B': 'YUV 4:1:1 Planar',
    'Y41P': 'PC1 4:1:1',
    'Y41T': 'PC1 4:1:1 with transparency',
    'Y42B': 'YUV 4:2:2 Planar',
    'Y42T': 'PCI 4:2:2 with transparency',
    'Y8  ': 'Grayscale video',
    'YC12': 'Intel YUV12 Codec',
    'YUV8': 'Winnov Caviar YUV8',
    'YUV9': 'Intel YUV9',
    'YUY2': 'Uncompressed YUV 4:2:2',
    'YUYV': 'Canopus YUV',
    'YV12': 'YVU12 Planar',
    'YVU9': 'Intel YVU9 Planar',
    'YVYU': 'YVYU 4:2:2 byte ordering',
    'ZLIB': '?ZLIB?',
    'ZPEG': 'Metheus Video Zipper'
}
