/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.FileNameUtils;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.cli.CLIModule;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.preferences.JosmBaseDirectories;
import org.openstreetmap.josm.data.preferences.JosmUrls;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.tests.MapCSSTagChecker;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.io.CustomConfigurator;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleSource;
import org.openstreetmap.josm.gui.mappaint.mapcss.parsergen.ParseException;
import org.openstreetmap.josm.gui.progress.CLIProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.GeoJSONMapRouletteWriter;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmChangeReader;
import org.openstreetmap.josm.spi.lifecycle.Lifecycle;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.IPreferences;
import org.openstreetmap.josm.spi.preferences.MemoryPreferences;
import org.openstreetmap.josm.tools.Http1Client;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.OptionParser;
import org.openstreetmap.josm.tools.Stopwatch;
import org.openstreetmap.josm.tools.Territories;
import org.openstreetmap.josm.tools.Utils;

public class ValidatorCLI
implements CLIModule {
    public static final ValidatorCLI INSTANCE = new ValidatorCLI();
    private final List<String> input = new ArrayList<String>();
    private final Map<String, List<String>> changeFiles = new HashMap<String, List<String>>();
    private final Map<String, String> output = new HashMap<String, String>();
    private static final Supplier<ProgressMonitor> progressMonitorFactory = CLIProgressMonitor::new;
    private Level logLevel;

    @Override
    public String getActionKeyword() {
        return "validate";
    }

    @Override
    public void processArguments(String[] argArray) {
        try {
            Config.setBaseDirectoriesProvider(JosmBaseDirectories.getInstance());
            Config.setPreferencesInstance(new MemoryPreferences());
            Logging.setLogLevel(Level.INFO);
            this.parseArguments(argArray);
            if (this.input.isEmpty()) {
                throw new IllegalArgumentException(I18n.tr("Missing argument - input data file ({0})", "--input|-i"));
            }
            this.initialize();
            ProgressMonitor fileMonitor = progressMonitorFactory.get();
            fileMonitor.beginTask(I18n.tr("Processing files...", new Object[0]), this.input.size());
            for (String inputFile : this.input) {
                if (inputFile.endsWith(".validator.mapcss")) {
                    this.processValidatorFile(inputFile);
                } else if (inputFile.endsWith(".mapcss")) {
                    this.processMapcssFile(inputFile);
                } else {
                    this.processFile(inputFile);
                }
                fileMonitor.worked(1);
            }
            fileMonitor.finishTask();
        }
        catch (Exception e) {
            Logging.info(e);
            Lifecycle.exitJosm(true, 1);
        }
        Lifecycle.exitJosm(true, 0);
    }

    private void processMapcssFile(String inputFile) throws ParseException {
        MapCSSStyleSource styleSource = new MapCSSStyleSource(new File(inputFile).toURI().getPath(), inputFile, inputFile);
        styleSource.loadStyleSource();
        if (!styleSource.getErrors().isEmpty()) {
            throw new ParseException(I18n.trn("{0} had {1} error", "{0} had {1} errors", styleSource.getErrors().size(), inputFile, styleSource.getErrors().size()));
        }
        Logging.info(I18n.tr("{0} had no errors", inputFile));
    }

    private void processValidatorFile(String inputFile) throws ParseException, IOException {
        Config.getPref().putBoolean("validator.check_assert_local_rules", true);
        MapCSSTagChecker mapCSSTagChecker = new MapCSSTagChecker();
        ArrayList assertionErrors = new ArrayList();
        MapCSSTagChecker.ParseResult result = mapCSSTagChecker.addMapCSS(new File(inputFile).toURI().getPath(), assertionErrors::add);
        if (!result.parseErrors.isEmpty() || !assertionErrors.isEmpty()) {
            for (Throwable throwable : result.parseErrors) {
                Logging.error(throwable);
            }
            for (String error : assertionErrors) {
                Logging.error(error);
            }
            throw new ParseException(I18n.trn("{0} had {1} error", "{0} had {1} errors", result.parseErrors.size() + assertionErrors.size(), inputFile, result.parseErrors.size() + assertionErrors.size()));
        }
        Logging.info(I18n.tr("{0} had no errors", new Object[0]), inputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processFile(String inputFile) throws IllegalDataException, IOException {
        String task;
        Stopwatch stopwatch;
        block19: {
            File inputFileFile = new File(inputFile);
            List inputFileImporters = ExtensionFileFilter.getImporters().stream().filter(importer -> importer.acceptFile(inputFileFile)).collect(Collectors.toList());
            stopwatch = Stopwatch.createStarted();
            if (inputFileImporters.stream().noneMatch(fileImporter -> fileImporter.importDataHandleExceptions(inputFileFile, progressMonitorFactory.get()))) {
                throw new IOException(I18n.tr("Could not load input file: {0}", inputFile));
            }
            String outputFile = Optional.ofNullable(this.output.get(inputFile)).orElseGet(() -> ValidatorCLI.getDefaultOutputName(inputFile));
            task = I18n.tr("Validating {0}, saving output to {1}", inputFile, outputFile);
            OsmDataLayer dataLayer = null;
            try {
                Logging.info(task);
                OsmValidator.initializeTests();
                dataLayer = MainApplication.getLayerManager().getLayersOfType(OsmDataLayer.class).stream().filter(layer -> inputFileFile.equals(layer.getAssociatedFile())).findFirst().orElseThrow(() -> new JosmRuntimeException(I18n.tr("Could not find a layer for {0}", inputFile)));
                DataSet dataSet = dataLayer.getDataSet();
                if (this.changeFiles.containsKey(inputFile)) {
                    ProgressMonitor changeFilesMonitor = progressMonitorFactory.get();
                    for (String changeFile : this.changeFiles.getOrDefault(inputFile, Collections.emptyList())) {
                        InputStream changeStream = Compression.getUncompressedFileInputStream(Paths.get(changeFile, new String[0]));
                        Throwable throwable = null;
                        try {
                            dataSet.mergeFrom(OsmChangeReader.parseDataSet(changeStream, changeFilesMonitor));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (changeStream == null) continue;
                            ValidatorCLI.$closeResource(throwable, changeStream);
                        }
                    }
                }
                Collection<Test> tests = OsmValidator.getEnabledTests(false);
                if (Files.isRegularFile(Paths.get(outputFile, new String[0]), new LinkOption[0]) && !Files.deleteIfExists(Paths.get(outputFile, new String[0]))) {
                    Logging.error("Could not delete {0}, attempting to append", outputFile);
                }
                GeoJSONMapRouletteWriter geoJSONMapRouletteWriter = new GeoJSONMapRouletteWriter(dataSet);
                try (OutputStream fileOutputStream = Files.newOutputStream(Paths.get(outputFile, new String[0]), new OpenOption[0]);){
                    tests.parallelStream().forEach(test -> this.runTest((Test)test, geoJSONMapRouletteWriter, fileOutputStream, dataSet));
                }
                if (dataLayer == null) break block19;
            }
            catch (Throwable throwable) {
                if (dataLayer != null) {
                    MainApplication.getLayerManager().removeLayer(dataLayer);
                }
                Logging.info(stopwatch.toString(task));
                throw throwable;
            }
            MainApplication.getLayerManager().removeLayer(dataLayer);
        }
        Logging.info(stopwatch.toString(task));
    }

    private static String getDefaultOutputName(String inputString) {
        String extension = FileNameUtils.getExtension(inputString);
        if (!Arrays.asList("zip", "bz", "xz", "geojson").contains(extension)) {
            return FileNameUtils.getBaseName(inputString) + ".geojson";
        }
        if ("geojson".equals(extension)) {
            return FileNameUtils.getBaseName(inputString) + ".validated.geojson";
        }
        return FileNameUtils.getBaseName(FileNameUtils.getBaseName(inputString)) + ".geojson";
    }

    private void runTest(Test test, GeoJSONMapRouletteWriter geoJSONMapRouletteWriter, OutputStream fileOutputStream, DataSet dataSet) {
        test.startTest(progressMonitorFactory.get());
        test.visit(dataSet.allPrimitives());
        test.endTest();
        test.getErrors().stream().map(geoJSONMapRouletteWriter::write).filter(Optional::isPresent).map(Optional::get).map(jsonObject -> jsonObject.toString().getBytes(StandardCharsets.UTF_8)).forEach(bytes -> {
            try {
                this.writeToFile(fileOutputStream, (byte[])bytes);
            }
            catch (IOException e) {
                throw new JosmRuntimeException(e);
            }
        });
        test.clear();
    }

    private synchronized void writeToFile(OutputStream fileOutputStream, byte[] bytes) throws IOException {
        fileOutputStream.write(30);
        fileOutputStream.write(bytes);
        fileOutputStream.write(10);
    }

    void initialize() {
        Logging.setLogLevel(this.logLevel);
        HttpClient.setFactory(Http1Client::new);
        Config.setUrlsProvider(JosmUrls.getInstance());
        ProjectionRegistry.setProjection(Projections.getProjectionByCode("epsg:3857".toUpperCase(Locale.ROOT)));
        Territories.initializeInternalData();
        OsmValidator.initialize();
        MapPaintStyles.readFromPreferences();
    }

    void parseArguments(String[] argArray) {
        Logging.setLogLevel(Level.INFO);
        OptionParser parser = new OptionParser("JOSM validate");
        AtomicReference<Object> currentInput = new AtomicReference<Object>(null);
        for (Option o : Option.values()) {
            if (o.requiresArgument()) {
                parser.addArgumentParameter(o.getName(), o.getOptionCount(), arg -> this.handleOption((String)currentInput.get(), o, (String)arg).ifPresent(currentInput::set));
            } else {
                parser.addFlagParameter(o.getName(), () -> this.handleOption(o));
            }
            if (o.getShortOption() == '*') continue;
            parser.addShortAlias(o.getName(), Character.toString(o.getShortOption()));
        }
        parser.parseOptionsOrExit(Arrays.asList(argArray));
    }

    private void handleOption(Option option) {
        switch (option) {
            case HELP: {
                ValidatorCLI.showHelp();
                Lifecycle.exitJosm(true, 0);
                break;
            }
            case DEBUG: {
                this.logLevel = Logging.LEVEL_DEBUG;
                break;
            }
            case TRACE: {
                this.logLevel = Logging.LEVEL_TRACE;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected option: " + (Object)((Object)option)));
            }
        }
    }

    private Optional<String> handleOption(String currentInput, Option option, String argument) {
        switch (option) {
            case INPUT: {
                this.input.add(argument);
                return Optional.of(argument);
            }
            case OUTPUT: {
                this.output.put(currentInput, argument);
                break;
            }
            case CHANGE_FILE: {
                this.changeFiles.computeIfAbsent(currentInput, key -> new ArrayList()).add(argument);
                break;
            }
            case LANGUAGE: {
                I18n.set(argument);
                break;
            }
            case LOAD_PREFERENCES: {
                Preferences tempPreferences = new Preferences();
                tempPreferences.enableSaveOnPut(false);
                CustomConfigurator.XMLCommandProcessor config = new CustomConfigurator.XMLCommandProcessor(tempPreferences);
                try (InputStream is = Utils.openStream(new File(argument).toURI().toURL());){
                    config.openAndReadXML(is);
                }
                catch (IOException e) {
                    throw new JosmRuntimeException(e);
                }
                IPreferences pref = Config.getPref();
                if (pref instanceof MemoryPreferences) {
                    MemoryPreferences memoryPreferences = (MemoryPreferences)pref;
                    tempPreferences.getAllSettings().forEach(memoryPreferences::putSetting);
                    break;
                }
                throw new JosmRuntimeException(I18n.tr("Preferences are not the expected type", new Object[0]));
            }
            default: {
                throw new AssertionError((Object)("Unexpected option: " + (Object)((Object)option)));
            }
        }
        return Optional.empty();
    }

    private static void showHelp() {
        System.out.println(ValidatorCLI.getHelp());
    }

    private static String getHelp() {
        String helpPadding = "\t                          ";
        return I18n.tr("JOSM Validation command line interface", new Object[0]) + "\n\n" + I18n.tr("Usage", new Object[0]) + ":\n\tjava -jar josm.jar validate <options>\n\n" + I18n.tr("Description", new Object[0]) + ":\n" + I18n.tr("Validates data and saves the result to a file.", new Object[0]) + "\n\n" + I18n.tr("Options", new Object[0]) + ":\n\t--help|-h                 " + I18n.tr("Show this help", new Object[0]) + "\n\t--input|-i <file>         " + I18n.tr("Input data file name (.osm, .validator.mapcss, .mapcss).", new Object[0]) + '\n' + "\t                          " + I18n.tr("OSM files can be specified multiple times. Required.", new Object[0]) + '\n' + "\t                          " + I18n.tr(".validator.mapcss and .mapcss files will stop processing on first error.", new Object[0]) + '\n' + "\t                          " + I18n.tr("Non-osm files do not use --output or --change-file", new Object[0]) + '\n' + "\t--output|-o <file>        " + I18n.tr("Output data file name (.geojson, line-by-line delimited for MapRoulette). Optional.", new Object[0]) + '\n' + "\t--change-file|-c <file>   " + I18n.tr("Change file name (.osc). Can be specified multiple times per input.", new Object[0]) + '\n' + "\t                          " + I18n.tr("Changes will be applied in the specified order. Optional.", new Object[0]);
    }

    private static enum Option {
        HELP(false, 'h'),
        INPUT(true, 'i', OptionParser.OptionCount.MULTIPLE),
        OUTPUT(true, 'o', OptionParser.OptionCount.MULTIPLE),
        CHANGE_FILE(true, 'c', OptionParser.OptionCount.MULTIPLE),
        DEBUG(false, '*'),
        TRACE(false, '*'),
        LANGUAGE(true, 'l'),
        LOAD_PREFERENCES(true, 'p'),
        SET(true, 's');

        private final String name = this.name().toLowerCase(Locale.ROOT).replace('_', '-');
        private final boolean requiresArgument;
        private final char shortOption;
        private final OptionParser.OptionCount optionCount;

        private Option(boolean requiresArgument, char shortOption) {
            this(requiresArgument, shortOption, OptionParser.OptionCount.OPTIONAL);
        }

        private Option(boolean requiresArgument, char shortOption, OptionParser.OptionCount optionCount) {
            this.requiresArgument = requiresArgument;
            this.shortOption = shortOption;
            this.optionCount = optionCount;
        }

        public String getName() {
            return this.name;
        }

        public OptionParser.OptionCount getOptionCount() {
            return this.optionCount;
        }

        public char getShortOption() {
            return this.shortOption;
        }

        public boolean requiresArgument() {
            return this.requiresArgument;
        }
    }
}

